/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.generators.rest;

import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.generators.BuildTool;
import io.quarkus.generators.ProjectGenerator;
import io.quarkus.generators.SourceType;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.platform.tools.config.QuarkusPlatformConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class BasicRestProjectGenerator
implements ProjectGenerator {
    public static final String NAME = "basic-rest";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void generate(ProjectWriter writer, Map<String, Object> parameters) throws IOException {
        BasicRestProject project = new BasicRestProject(writer, parameters);
        project.initProject();
        project.setupContext();
        project.createClasses();
        project.createIndexPage();
        project.createDockerFiles();
        project.createDockerIgnore();
        project.createApplicationConfig();
        project.createGitIgnore();
    }

    private class BasicRestProject {
        private Map<String, Object> context;
        private String path = "/hello";
        private ProjectWriter writer;
        private String srcMainPath;
        private String testMainPath;
        private String nativeTestMainPath;
        private SourceType type;

        private BasicRestProject(ProjectWriter writer, Map<String, Object> parameters) {
            this.writer = writer;
            this.context = new HashMap<String, Object>(parameters);
            this.type = (SourceType)((Object)this.context.get("source_type"));
        }

        private <T> T get(String key, T defaultValue) {
            return (T)this.context.getOrDefault(key, defaultValue);
        }

        private boolean initProject() throws IOException {
            boolean newProject = this.initBuildTool();
            this.path = this.get("path", this.path);
            this.srcMainPath = this.writer.mkdirs(this.type.getSrcDir());
            this.testMainPath = this.writer.mkdirs(this.type.getTestSrcDir());
            this.nativeTestMainPath = this.getBuildTool() == BuildTool.GRADLE ? this.writer.mkdirs(this.type.getTestSrcDir().replace("test", "native-test")) : this.testMainPath;
            return newProject;
        }

        private boolean initBuildTool() throws IOException {
            boolean newProject;
            BuildTool buildTool = this.getBuildTool();
            this.context.putIfAbsent("additional_gitignore_entries", buildTool.getGitIgnoreEntries());
            boolean bl = newProject = !this.writer.exists(buildTool.getDependenciesFile());
            if (newProject) {
                for (String buildFile : buildTool.getBuildFiles()) {
                    this.generate(this.type.getBuildFileResourceTemplate(BasicRestProjectGenerator.this.getName(), buildFile), this.context, buildFile, buildFile);
                }
            } else {
                String[] gav;
                if (BuildTool.MAVEN.equals((Object)buildTool)) {
                    ByteArrayInputStream buildFileInputStream = new ByteArrayInputStream(this.writer.getContent(buildTool.getDependenciesFile()));
                    gav = MojoUtils.readGavFromPom(buildFileInputStream);
                } else {
                    gav = new String[3];
                    for (String buildFile : buildTool.getBuildFiles()) {
                        if (!this.writer.exists(buildFile)) continue;
                        try (ByteArrayInputStream buildFileInputStream = new ByteArrayInputStream(this.writer.getContent(buildFile));){
                            gav = MojoUtils.readGavFromSettingsGradle(buildFileInputStream, gav);
                        }
                    }
                }
                this.context.put("project_groupId", gav[0]);
                this.context.put("project_artifactId", gav[1]);
            }
            return newProject;
        }

        private BuildTool getBuildTool() {
            BuildFile buildFileManager = this.get("build_file", null);
            return buildFileManager == null ? BuildTool.MAVEN : buildFileManager.getBuildTool();
        }

        private void generate(String templateName, Map<String, Object> context, String outputFilePath, String resourceType) throws IOException {
            if (!this.writer.exists(outputFilePath)) {
                String path = templateName;
                String template = QuarkusPlatformConfig.getGlobalDefault().getPlatformDescriptor().getTemplate(path);
                if (template == null) {
                    throw new IOException("Template resource is missing: " + path);
                }
                for (Map.Entry<String, Object> e : context.entrySet()) {
                    if (e.getValue() == null) continue;
                    template = template.replace(String.format("${%s}", e.getKey()), e.getValue().toString());
                }
                this.writer.write(outputFilePath, template);
            }
        }

        private void createIndexPage() throws IOException {
            String resources = "src/main/resources/META-INF/resources";
            String index = this.writer.mkdirs(resources) + "/index.html";
            if (!this.writer.exists(index)) {
                this.generate("templates/index.ftl", this.context, index, "welcome page");
            }
        }

        private void createDockerFiles() throws IOException {
            String dockerRoot = "src/main/docker";
            String dockerRootDir = this.writer.mkdirs(dockerRoot);
            this.generate("templates/dockerfile-native.ftl", this.context, dockerRootDir + "/Dockerfile.native", "native docker file");
            this.generate("templates/dockerfile-jvm.ftl", this.context, dockerRootDir + "/Dockerfile.jvm", "jvm docker file");
        }

        private void createDockerIgnore() throws IOException {
            String docker = this.writer.mkdirs("") + ".dockerignore";
            this.generate("templates/dockerignore.ftl", this.context, docker, "docker ignore");
        }

        private void createGitIgnore() throws IOException {
            String gitignore = this.writer.mkdirs("") + ".gitignore";
            this.generate("templates/gitignore.ftl", this.context, gitignore, "git ignore");
        }

        private void createApplicationConfig() throws IOException {
            String meta = "src/main/resources";
            String file = this.writer.mkdirs(meta) + "/application.properties";
            if (!this.writer.exists(file)) {
                this.writer.write(file, "# Configuration file" + System.lineSeparator() + "# key = value");
            }
        }

        private void setupContext() throws IOException {
            if (this.context.get("class_name") != null) {
                String packageName = (String)this.context.get("package_name");
                if (packageName != null) {
                    String packageDir = this.srcMainPath + '/' + packageName.replace('.', '/');
                    String originalTestMainPath = this.testMainPath;
                    String testPackageDir = this.testMainPath + '/' + packageName.replace('.', '/');
                    this.srcMainPath = this.writer.mkdirs(packageDir);
                    this.testMainPath = this.writer.mkdirs(testPackageDir);
                    if (!originalTestMainPath.equals(this.nativeTestMainPath)) {
                        String nativeTestPackageDir = this.nativeTestMainPath + '/' + packageName.replace('.', '/');
                        this.nativeTestMainPath = this.writer.mkdirs(nativeTestPackageDir);
                    } else {
                        this.nativeTestMainPath = this.testMainPath;
                    }
                } else {
                    throw new NullPointerException("Need a non-null package name");
                }
            }
        }

        private void createClasses() throws IOException {
            Object className = this.context.get("class_name");
            if (className != null) {
                String extension = this.type.getExtension();
                String classFile = this.srcMainPath + '/' + className + extension;
                String testClassFile = this.testMainPath + '/' + className + "Test" + extension;
                String itTestClassFile = this.nativeTestMainPath + '/' + "Native" + className + "IT" + extension;
                String name = BasicRestProjectGenerator.this.getName();
                String srcResourceTemplate = this.type.getSrcResourceTemplate(name);
                Object isSpring = this.context.get("is_spring");
                if (isSpring != null && Boolean.valueOf(this.context.get("is_spring").equals(Boolean.TRUE)).booleanValue()) {
                    srcResourceTemplate = this.type.getSrcSpringControllerTemplate(name);
                }
                this.generate(srcResourceTemplate, this.context, classFile, "resource code");
                this.generate(this.type.getTestResourceTemplate(name), this.context, testClassFile, "test code");
                this.generate(this.type.getNativeTestResourceTemplate(name), this.context, itTestClassFile, "IT code");
            }
        }
    }
}

