/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands.file;

import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.dependencies.Extension;
import io.quarkus.generators.BuildTool;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.Consumer;
import org.apache.maven.model.Dependency;

public class GradleBuildFile
extends BuildFile {
    private static final String BUILD_GRADLE_PATH = "build.gradle";
    private static final String SETTINGS_GRADLE_PATH = "settings.gradle";
    private static final String GRADLE_PROPERTIES_PATH = "gradle.properties";
    private Model model;

    public GradleBuildFile(ProjectWriter writer) {
        super(writer, BuildTool.GRADLE);
    }

    @Override
    public String getPlatformBomVersionExpression() {
        return MojoUtils.getBomVersion();
    }

    @Override
    public void close() throws IOException {
        this.write(SETTINGS_GRADLE_PATH, this.getModel().getSettingsContent());
        this.write(BUILD_GRADLE_PATH, this.getModel().getBuildContent());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.getModel().getPropertiesContent().store(out, "Gradle properties");
            this.write(GRADLE_PROPERTIES_PATH, out.toString(StandardCharsets.UTF_8.toString()));
        }
    }

    @Override
    public void completeFile(String groupId, String artifactId, String version) throws IOException {
        this.completeSettingsContent(artifactId);
        this.completeBuildContent(groupId, version);
        this.completeProperties();
    }

    private void completeBuildContent(String groupId, String version) throws IOException {
        String versionLine;
        String groupLine;
        String buildContent = this.getModel().getBuildContent();
        StringBuilder res = new StringBuilder(buildContent);
        if (!buildContent.contains("io.quarkus:quarkus-gradle-plugin")) {
            res.append(System.lineSeparator());
            res.append("buildscript {").append(System.lineSeparator());
            res.append("    repositories {").append(System.lineSeparator());
            res.append("        mavenLocal()").append(System.lineSeparator());
            res.append("    }").append(System.lineSeparator());
            res.append("    dependencies {").append(System.lineSeparator());
            res.append("        classpath \"io.quarkus:quarkus-gradle-plugin:").append(MojoUtils.getPluginVersion()).append("\"").append(System.lineSeparator());
            res.append("    }").append(System.lineSeparator());
            res.append("}").append(System.lineSeparator());
        }
        if (!buildContent.contains("apply plugin: 'io.quarkus'") && !buildContent.contains("id 'io.quarkus'")) {
            res.append(System.lineSeparator()).append("apply plugin: 'io.quarkus'").append(System.lineSeparator());
        }
        if (!this.containsBOM()) {
            res.append(System.lineSeparator());
            res.append("dependencies {").append(System.lineSeparator());
            res.append("    implementation enforcedPlatform(\"${quarkusPlatformGroupId}:${quarkusPlatformArtifactId}:${quarkusPlatformVersion}\")").append(System.lineSeparator());
            res.append("    implementation 'io.quarkus:quarkus-resteasy'").append(System.lineSeparator());
            res.append("    testImplementation 'io.quarkus:quarkus-junit5'").append(System.lineSeparator());
            res.append("    testImplementation 'io.rest-assured:rest-assured'").append(System.lineSeparator());
            res.append("}").append(System.lineSeparator());
        }
        if (!buildContent.contains(groupLine = "group '" + groupId + "'")) {
            res.append(System.lineSeparator()).append(groupLine).append(System.lineSeparator());
        }
        if (!buildContent.contains(versionLine = "version '" + version + "'")) {
            res.append(System.lineSeparator()).append(versionLine).append(System.lineSeparator());
        }
        this.getModel().setBuildContent(res.toString());
    }

    private void completeSettingsContent(String artifactId) throws IOException {
        String settingsContent = this.getModel().getSettingsContent();
        StringBuilder res = new StringBuilder(settingsContent);
        if (!settingsContent.contains("io.quarkus:quarkus-gradle-plugin")) {
            res.append(System.lineSeparator());
            res.append("pluginManagement {").append(System.lineSeparator());
            res.append("    repositories {").append(System.lineSeparator());
            res.append("        mavenLocal()").append(System.lineSeparator());
            res.append("        mavenCentral()").append(System.lineSeparator());
            res.append("        gradlePluginPortal()").append(System.lineSeparator());
            res.append("    }").append(System.lineSeparator());
            res.append("    resolutionStrategy {").append(System.lineSeparator());
            res.append("        eachPlugin {").append(System.lineSeparator());
            res.append("            if (requested.id.id == 'io.quarkus') {").append(System.lineSeparator());
            res.append("                useModule(\"io.quarkus:quarkus-gradle-plugin:${quarkusVersion}\")").append(System.lineSeparator());
            res.append("            }").append(System.lineSeparator());
            res.append("        }").append(System.lineSeparator());
            res.append("    }").append(System.lineSeparator());
            res.append("}").append(System.lineSeparator());
        }
        if (!settingsContent.contains("rootProject.name")) {
            res.append(System.lineSeparator()).append("rootProject.name='").append(artifactId).append("'").append(System.lineSeparator());
        }
        this.getModel().setSettingsContent(res.toString());
    }

    private void completeProperties() throws IOException {
        Properties props = this.getModel().getPropertiesContent();
        if (props.getProperty("quarkusVersion") == null) {
            props.setProperty("quarkusVersion", MojoUtils.getPluginVersion());
        }
        if (props.getProperty("quarkusPlatformGroupId") == null) {
            props.setProperty("quarkusPlatformGroupId", MojoUtils.getBomGroupId());
        }
        if (props.getProperty("quarkusPlatformArtifactId") == null) {
            props.setProperty("quarkusPlatformArtifactId", MojoUtils.getBomArtifactId());
        }
        if (props.getProperty("quarkusPlatformVersion") == null) {
            props.setProperty("quarkusPlatformVersion", MojoUtils.getBomVersion());
        }
    }

    @Override
    protected void addDependencyInBuildFile(Dependency dependency) throws IOException {
        StringBuilder newBuildContent = new StringBuilder();
        this.readLineByLine(this.getModel().getBuildContent(), new AppendDependency(newBuildContent, dependency));
        this.getModel().setBuildContent(newBuildContent.toString());
    }

    private void readLineByLine(String content, Consumer<String> lineConsumer) {
        try (Scanner scanner = new Scanner((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8.name());){
            while (scanner.hasNextLine()) {
                String currentLine = scanner.nextLine();
                lineConsumer.accept(currentLine);
            }
        }
    }

    @Override
    protected boolean hasDependency(Extension extension) throws IOException {
        return this.getDependencies().stream().anyMatch(d -> extension.getGroupId().equals(d.getGroupId()) && extension.getArtifactId().equals(d.getArtifactId()));
    }

    @Override
    protected boolean containsBOM() throws IOException {
        return this.getModel().getBuildContent().contains("enforcedPlatform(\"${quarkusPlatformGroupId}:${quarkusPlatformArtifactId}:");
    }

    @Override
    public List<Dependency> getDependencies() throws IOException {
        return Collections.emptyList();
    }

    @Override
    public String getProperty(String propertyName) throws IOException {
        return this.getModel().getPropertiesContent().getProperty(propertyName);
    }

    @Override
    protected List<Dependency> getManagedDependencies() {
        return Collections.emptyList();
    }

    private Model getModel() throws IOException {
        if (this.model == null) {
            this.initModel();
        }
        return this.model;
    }

    protected void initModel() throws IOException {
        String settingsContent = "";
        String buildContent = "";
        Properties propertiesContent = new Properties();
        if (this.getWriter().exists(SETTINGS_GRADLE_PATH)) {
            byte[] settings = this.getWriter().getContent(SETTINGS_GRADLE_PATH);
            settingsContent = new String(settings, StandardCharsets.UTF_8);
        }
        if (this.getWriter().exists(BUILD_GRADLE_PATH)) {
            byte[] build = this.getWriter().getContent(BUILD_GRADLE_PATH);
            buildContent = new String(build, StandardCharsets.UTF_8);
        }
        if (this.getWriter().exists(GRADLE_PROPERTIES_PATH)) {
            byte[] properties = this.getWriter().getContent(GRADLE_PROPERTIES_PATH);
            propertiesContent.load(new ByteArrayInputStream(properties));
        }
        this.model = new Model(settingsContent, buildContent, propertiesContent);
    }

    protected String getBuildContent() throws IOException {
        return this.getModel().getBuildContent();
    }

    private class Model {
        private String settingsContent;
        private String buildContent;
        private Properties propertiesContent;

        public Model(String settingsContent, String buildContent, Properties propertiesContent) {
            this.settingsContent = settingsContent;
            this.buildContent = buildContent;
            this.propertiesContent = propertiesContent;
        }

        public String getSettingsContent() {
            return this.settingsContent;
        }

        public String getBuildContent() {
            return this.buildContent;
        }

        public Properties getPropertiesContent() {
            return this.propertiesContent;
        }

        public void setSettingsContent(String settingsContent) {
            this.settingsContent = settingsContent;
        }

        public void setBuildContent(String buildContent) {
            this.buildContent = buildContent;
        }
    }

    private static class AppendDependency
    implements Consumer<String> {
        private StringBuilder newContent;
        private Dependency dependency;

        public AppendDependency(StringBuilder newContent, Dependency dependency) {
            this.newContent = newContent;
            this.dependency = dependency;
        }

        @Override
        public void accept(String currentLine) {
            this.newContent.append(currentLine).append(System.lineSeparator());
            if (currentLine.startsWith("dependencies {")) {
                this.newContent.append("    implementation '").append(this.dependency.getGroupId()).append(":").append(this.dependency.getArtifactId());
                if (this.dependency.getVersion() != null && !this.dependency.getVersion().isEmpty()) {
                    this.newContent.append(":").append(this.dependency.getVersion());
                }
                this.newContent.append("'").append(System.lineSeparator());
            }
        }
    }
}

