/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.generators;

import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.file.GradleBuildFile;
import io.quarkus.cli.commands.file.MavenBuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import java.io.IOException;

public enum BuildTool {
    MAVEN("\n# Maven\ntarget/\npom.xml.tag\npom.xml.releaseBackup\npom.xml.versionsBackup\nrelease.properties", new String[]{"pom.xml"}),
    GRADLE("\n# Gradle\n.gradle/\nbuild/", new String[]{"build.gradle", "settings.gradle", "gradle.properties"});

    private final String gitIgnoreEntries;
    private final String[] buildFiles;

    private BuildTool(String gitIgnoreEntries, String[] buildFiles) {
        this.gitIgnoreEntries = gitIgnoreEntries;
        this.buildFiles = buildFiles;
    }

    public String getGitIgnoreEntries() {
        return this.gitIgnoreEntries;
    }

    public String[] getBuildFiles() {
        return this.buildFiles;
    }

    public String getDependenciesFile() {
        return this.buildFiles[0];
    }

    public BuildFile createBuildFile(ProjectWriter writer) throws IOException {
        switch (this) {
            case GRADLE: {
                return new GradleBuildFile(writer);
            }
        }
        return new MavenBuildFile(writer);
    }
}

