/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands.file;

import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.dependencies.Extension;
import io.quarkus.generators.BuildTool;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;

public class MavenBuildFile
extends BuildFile {
    private Model model;

    public MavenBuildFile(ProjectWriter writer) throws IOException {
        super(writer);
        byte[] content = writer.getContent(BuildTool.MAVEN.getDependenciesFile());
        this.model = MojoUtils.readPom(new ByteArrayInputStream(content));
    }

    @Override
    public void write() throws IOException {
        ByteArrayOutputStream pomOutputStream = new ByteArrayOutputStream();
        MojoUtils.write(this.model, pomOutputStream);
        this.write(BuildTool.MAVEN.getDependenciesFile(), pomOutputStream.toString("UTF-8"));
    }

    @Override
    protected void addDependencyInBuildFile(Dependency dependency) {
        this.model.addDependency(dependency);
    }

    @Override
    protected boolean hasDependency(Extension extension) {
        return MojoUtils.hasDependency(this.model, extension.getGroupId(), extension.getArtifactId());
    }

    @Override
    public List<Dependency> getDependencies() {
        return this.model.getDependencies();
    }

    @Override
    protected boolean containsBOM() {
        if (this.model.getDependencyManagement() == null) {
            return false;
        }
        List dependencies = this.model.getDependencyManagement().getDependencies();
        return dependencies.stream().filter(dependency -> "import".equalsIgnoreCase(dependency.getScope())).filter(dependency -> "pom".equalsIgnoreCase(dependency.getType())).anyMatch(dependency -> dependency.getArtifactId().equalsIgnoreCase(MojoUtils.getBomArtifactId()));
    }

    public void completeFile() throws IOException {
        this.addVersionProperty();
        this.addBom();
        this.addMainPluginConfig();
        this.addNativeProfile();
        this.write();
    }

    private void addBom() {
        boolean hasBom = false;
        DependencyManagement dm = this.model.getDependencyManagement();
        if (dm == null) {
            dm = new DependencyManagement();
            this.model.setDependencyManagement(dm);
        } else {
            hasBom = dm.getDependencies().stream().anyMatch(d -> d.getGroupId().equals(MojoUtils.getPluginGroupId()) && d.getArtifactId().equals(MojoUtils.getBomArtifactId()));
        }
        if (!hasBom) {
            Dependency bom = new Dependency();
            bom.setGroupId(MojoUtils.getPluginGroupId());
            bom.setArtifactId(MojoUtils.getBomArtifactId());
            bom.setVersion("${quarkus.version}");
            bom.setType("pom");
            bom.setScope("import");
            dm.addDependency(bom);
        }
    }

    private void addNativeProfile() {
        boolean match = this.model.getProfiles().stream().anyMatch(p -> p.getId().equals("native"));
        if (!match) {
            PluginExecution exec = new PluginExecution();
            exec.addGoal("native-image");
            exec.setConfiguration((Object)MojoUtils.configuration(new MojoUtils.Element("enableHttpUrlHandler", "true", new MojoUtils.Element[0])));
            Plugin plg = MojoUtils.plugin(MojoUtils.getPluginGroupId(), MojoUtils.getPluginArtifactId(), "${quarkus.version}");
            plg.addExecution(exec);
            BuildBase buildBase = new BuildBase();
            buildBase.addPlugin(plg);
            Profile profile = new Profile();
            profile.setId("native");
            profile.setBuild(buildBase);
            Activation activation = new Activation();
            ActivationProperty property = new ActivationProperty();
            property.setName("native");
            activation.setProperty(property);
            profile.setActivation(activation);
            this.model.addProfile(profile);
        }
    }

    private void addMainPluginConfig() {
        if (!this.hasPlugin()) {
            Build build = this.createBuildSectionIfRequired();
            Plugin plugin = MojoUtils.plugin(MojoUtils.getPluginGroupId(), MojoUtils.getPluginArtifactId(), "${quarkus.version}");
            if (this.isParentPom()) {
                this.addPluginManagementSection(plugin);
                plugin = MojoUtils.plugin(MojoUtils.getPluginGroupId(), MojoUtils.getPluginArtifactId());
            }
            PluginExecution pluginExec = new PluginExecution();
            pluginExec.addGoal("build");
            plugin.addExecution(pluginExec);
            build.getPlugins().add(plugin);
        }
    }

    private boolean hasPlugin() {
        List plugins = null;
        Build build = this.model.getBuild();
        if (build != null) {
            if (this.isParentPom()) {
                PluginManagement management = build.getPluginManagement();
                if (management != null) {
                    plugins = management.getPlugins();
                }
            } else {
                plugins = build.getPlugins();
            }
        }
        return plugins != null && build.getPlugins().stream().anyMatch(p -> p.getGroupId().equalsIgnoreCase(MojoUtils.getPluginGroupId()) && p.getArtifactId().equalsIgnoreCase(MojoUtils.getPluginArtifactId()));
    }

    private void addPluginManagementSection(Plugin plugin) {
        if (this.model.getBuild() != null && this.model.getBuild().getPluginManagement() != null) {
            if (this.model.getBuild().getPluginManagement().getPlugins() == null) {
                this.model.getBuild().getPluginManagement().setPlugins(new ArrayList());
            }
            this.model.getBuild().getPluginManagement().getPlugins().add(plugin);
        }
    }

    private Build createBuildSectionIfRequired() {
        Build build = this.model.getBuild();
        if (build == null) {
            build = new Build();
            this.model.setBuild(build);
        }
        if (build.getPlugins() == null) {
            build.setPlugins(new ArrayList());
        }
        return build;
    }

    private void addVersionProperty() {
        Properties properties = this.model.getProperties();
        if (properties == null) {
            properties = new Properties();
            this.model.setProperties(properties);
        }
        properties.putIfAbsent("quarkus.version", MojoUtils.getPluginVersion());
    }

    private boolean isParentPom() {
        return "pom".equals(this.model.getPackaging());
    }

    @Override
    protected List<Dependency> getManagedDependencies() {
        DependencyManagement managed = this.model.getDependencyManagement();
        return managed != null ? managed.getDependencies() : Collections.emptyList();
    }

    @Override
    public String getProperty(String propertyName) {
        return this.model.getProperties().getProperty(propertyName);
    }
}

