/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.strategy;

import io.fabric8.maven.Maven;
import io.fabric8.maven.merge.SmartModelMerger;
import io.quarkus.devtools.codestarts.reader.CodestartFile;
import io.quarkus.devtools.codestarts.strategy.CodestartFileStrategyHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.maven.model.Model;

final class SmartPomMergeCodestartFileStrategyHandler
implements CodestartFileStrategyHandler {
    SmartPomMergeCodestartFileStrategyHandler() {
    }

    @Override
    public String name() {
        return "smart-pom-merge";
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<CodestartFile> codestartFiles, Map<String, Object> data) throws IOException {
        this.checkNotEmptyCodestartFiles(codestartFiles);
        this.checkTargetDoesNotExist(targetDirectory.resolve(relativePath));
        SmartModelMerger merger = new SmartModelMerger();
        Model targetModel = Maven.readModel((Reader)new StringReader(codestartFiles.get(0).getContent()));
        ListIterator<CodestartFile> iterator = codestartFiles.listIterator(1);
        while (iterator.hasNext()) {
            merger.merge(targetModel, Maven.readModel((Reader)new StringReader(iterator.next().getContent())), true, null);
        }
        Maven.writeModel((Model)targetModel, (Path)targetDirectory.resolve(relativePath));
    }
}

