/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartDefinitionException;
import io.quarkus.devtools.codestarts.CodestartInput;
import io.quarkus.devtools.codestarts.CodestartResourceLoader;
import io.quarkus.devtools.codestarts.CodestartSpec;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;

final class CodestartLoader {
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
    private static final String CODESTARTS_DIR_BUNDLED = "bundled-codestarts";
    private static final String CODESTARTS_DIR_FROM_EXTENSIONS = "codestarts";

    private CodestartLoader() {
    }

    public static List<Codestart> loadAllCodestarts(CodestartInput input) throws IOException {
        return Stream.concat(CodestartLoader.loadBundledCodestarts(input).stream(), CodestartLoader.loadCodestartsFromExtensions(input).stream()).collect(Collectors.toList());
    }

    public static Collection<Codestart> loadBundledCodestarts(CodestartInput input) throws IOException {
        return CodestartLoader.loadCodestarts(input.getResourceLoader(), CODESTARTS_DIR_BUNDLED);
    }

    public static Collection<Codestart> loadCodestartsFromExtensions(CodestartInput input) throws IOException {
        return CodestartLoader.loadCodestartsFromExtensions(input.getResourceLoader());
    }

    public static Collection<Codestart> loadCodestartsFromExtensions(CodestartResourceLoader resourceLoader) throws IOException {
        return CodestartLoader.loadCodestarts(resourceLoader, CODESTARTS_DIR_FROM_EXTENSIONS);
    }

    static Collection<Codestart> loadCodestarts(CodestartResourceLoader resourceLoader, String directoryName) throws IOException {
        return resourceLoader.loadResourceAsPath(directoryName, path -> Files.walk(path, new FileVisitOption[0]).filter(p -> p.getFileName().toString().matches("codestart\\.yml$")).map(p -> {
            String resourceName = CodestartLoader.resolveResourceName(directoryName, path, p);
            try {
                CodestartSpec spec = CodestartLoader.readCodestartSpec(new String(Files.readAllBytes(p)));
                String resourceCodestartDirectory = resourceName.replaceAll("/?codestart\\.yml", "");
                return new Codestart(resourceCodestartDirectory, spec);
            }
            catch (IOException e) {
                throw new CodestartDefinitionException("Failed to load codestart spec: " + resourceName, e);
            }
        }).collect(Collectors.toList()));
    }

    static CodestartSpec readCodestartSpec(String content) throws JsonProcessingException {
        return (CodestartSpec)YAML_MAPPER.readerFor(CodestartSpec.class).readValue(content);
    }

    private static String resolveResourceName(String dirName, Path dirPath, Path resourcePath) {
        return FilenameUtils.concat((String)dirName, (String)dirPath.relativize(resourcePath).toString()).replace('\\', '/');
    }
}

