/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.maven.ArtifactKey;
import java.io.Serializable;
import java.util.Objects;

public class ArtifactCoords
implements Serializable {
    public static final String TYPE_JAR = "jar";
    public static final String TYPE_POM = "pom";
    protected final String groupId;
    protected final String artifactId;
    protected final String classifier;
    protected final String type;
    protected final String version;
    protected transient ArtifactKey key;

    public static ArtifactCoords fromString(String str) {
        return new ArtifactCoords(ArtifactCoords.split(str, new String[5]));
    }

    public static ArtifactCoords pom(String groupId, String artifactId, String version) {
        return new ArtifactCoords(groupId, artifactId, null, TYPE_POM, version);
    }

    protected static String[] split(String str, String[] parts) {
        int versionSep = str.lastIndexOf(58);
        if (versionSep <= 0 || versionSep == str.length() - 1) {
            throw new IllegalArgumentException("One of type, version or separating them ':' is missing from '" + str + "'");
        }
        parts[4] = str.substring(versionSep + 1);
        ArtifactKey.split(str, parts, versionSep);
        return parts;
    }

    protected ArtifactCoords(String[] parts) {
        this.groupId = parts[0];
        this.artifactId = parts[1];
        this.classifier = parts[2];
        this.type = parts[3] == null ? TYPE_JAR : parts[3];
        this.version = parts[4];
    }

    public ArtifactCoords(ArtifactKey key, String version) {
        this.key = key;
        this.groupId = key.getGroupId();
        this.artifactId = key.getArtifactId();
        this.classifier = key.getClassifier();
        this.type = key.getType();
        this.version = version;
    }

    public ArtifactCoords(String groupId, String artifactId, String version) {
        this(groupId, artifactId, "", TYPE_JAR, version);
    }

    public ArtifactCoords(String groupId, String artifactId, String type, String version) {
        this(groupId, artifactId, "", type, version);
    }

    public ArtifactCoords(String groupId, String artifactId, String classifier, String type, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier == null ? "" : classifier;
        this.type = type == null ? TYPE_JAR : type;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public ArtifactKey getKey() {
        return this.key == null ? (this.key = new ArtifactKey(this.groupId, this.artifactId, this.classifier, this.type)) : this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactCoords that = (ArtifactCoords)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.type, that.type) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.classifier, this.type, this.version);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.append(buf);
        return buf.toString();
    }

    protected StringBuilder append(StringBuilder buf) {
        buf.append(this.groupId).append(':').append(this.artifactId).append(':');
        if (this.classifier != null && !this.classifier.isEmpty()) {
            buf.append(this.classifier);
        }
        return buf.append(':').append(this.type).append(':').append(this.version);
    }
}

