/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev.console;

import io.quarkus.dev.console.BasicConsole;
import io.quarkus.dev.console.StatusLine;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class QuarkusConsole {
    public static final int TEST_STATUS = 100;
    public static final int TEST_RESULTS = 200;
    public static final int COMPILE_ERROR = 300;
    public static final String FORCE_COLOR_SUPPORT = "io.quarkus.force-color-support";
    public static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    public static final boolean IS_CON_EMU_ANSI = IS_WINDOWS && "ON".equals(System.getenv("ConEmuANSI"));
    public static final boolean IS_CYGWIN = IS_WINDOWS && System.getenv("PWD") != null && System.getenv("PWD").startsWith("/") && !"cygwin".equals(System.getenv("TERM"));
    public static final boolean IS_MINGW_XTERM = IS_WINDOWS && System.getenv("MSYSTEM") != null && System.getenv("MSYSTEM").startsWith("MINGW") && "xterm".equals(System.getenv("TERM"));
    protected volatile Consumer<int[]> inputHandler;
    public static volatile QuarkusConsole INSTANCE = new BasicConsole(QuarkusConsole.hasColorSupport(), false, System.out::print);
    public static volatile boolean installed;
    protected volatile Predicate<String> outputFilter;
    private volatile boolean started = false;

    public static boolean hasColorSupport() {
        if (Boolean.getBoolean(FORCE_COLOR_SUPPORT)) {
            return true;
        }
        if (IS_WINDOWS) {
            return IS_CON_EMU_ANSI || IS_CYGWIN || IS_MINGW_XTERM;
        }
        return System.console() != null;
    }

    public static void start() {
        INSTANCE.startInternal();
    }

    private synchronized void startInternal() {
        if (this.started) {
            return;
        }
        this.started = true;
    }

    public void setInputHandler(Consumer<int[]> inputHandler) {
        this.inputHandler = inputHandler;
    }

    public abstract void doReadLine();

    public abstract StatusLine registerStatusLine(int var1);

    public abstract void setPromptMessage(String var1);

    public abstract void write(String var1);

    public abstract void write(byte[] var1, int var2, int var3);

    protected String stripAnsiCodes(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\u001B\\[(.*?)[a-zA-Z]", "");
        return s;
    }

    public void setOutputFilter(Predicate<String> logHandler) {
        this.outputFilter = logHandler;
    }
}

