/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.phase.nativeimage;

import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.creator.AppCreationPhase;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.config.reader.PropertiesHandler;
import io.quarkus.creator.config.reader.PropertyContext;
import io.quarkus.creator.outcome.OutcomeProviderRegistration;
import io.quarkus.creator.phase.augment.AugmentOutcome;
import io.quarkus.creator.phase.nativeimage.ErrorReplacingProcessReader;
import io.quarkus.creator.phase.nativeimage.NativeImageOutcome;
import io.quarkus.creator.phase.runnerjar.RunnerJarOutcome;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

public class NativeImagePhase
implements AppCreationPhase<NativeImagePhase>,
NativeImageOutcome {
    private static final Logger log = Logger.getLogger(NativeImagePhase.class);
    private static final String GRAALVM_HOME = "GRAALVM_HOME";
    private static final String JAVA_HOME_SYS = "java.home";
    private static final String JAVA_HOME_ENV = "JAVA_HOME";
    private static final String QUARKUS_PREFIX = "quarkus.";
    private static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("linux");
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    private static final String PATH = "PATH";
    private static final String DEBUG_BUILD_PROCESS_PORT = "5005";
    private Path outputDir;
    private boolean reportErrorsAtRuntime;
    private boolean debugSymbols;
    private boolean debugBuildProcess;
    private boolean publishDebugBuildProcessPort;
    private boolean cleanupServer;
    private boolean enableHttpUrlHandler;
    private boolean enableHttpsUrlHandler;
    private boolean enableAllSecurityServices;
    private boolean enableRetainedHeapReporting;
    private boolean enableCodeSizeReporting;
    private boolean enableIsolates;
    private boolean enableFallbackImages;
    private String graalvmHome;
    private File javaHome;
    private boolean enableServer;
    private boolean enableJni;
    private boolean autoServiceLoaderRegistration;
    private boolean dumpProxies;
    private String nativeImageXmx;
    private String builderImage = "quay.io/quarkus/ubi-quarkus-native-image:19.2.0.1";
    private String containerRuntime = "";
    private List<String> containerRuntimeOptions = new ArrayList<String>();
    private boolean enableVMInspection;
    private boolean fullStackTraces;
    private boolean disableReports;
    private List<String> additionalBuildArgs;
    private boolean addAllCharsets;
    private boolean reportExceptionStackTraces = true;

    public NativeImagePhase setAddAllCharsets(boolean addAllCharsets) {
        this.addAllCharsets = addAllCharsets;
        return this;
    }

    public NativeImagePhase setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
        return this;
    }

    public NativeImagePhase setReportErrorsAtRuntime(boolean reportErrorsAtRuntime) {
        this.reportErrorsAtRuntime = reportErrorsAtRuntime;
        return this;
    }

    public NativeImagePhase setDebugSymbols(boolean debugSymbols) {
        this.debugSymbols = debugSymbols;
        return this;
    }

    public NativeImagePhase setDebugBuildProcess(boolean debugBuildProcess) {
        this.debugBuildProcess = debugBuildProcess;
        return this;
    }

    public NativeImagePhase setPublishDebugBuildProcessPort(boolean publish) {
        this.publishDebugBuildProcessPort = publish;
        return this;
    }

    public NativeImagePhase setCleanupServer(boolean cleanupServer) {
        this.cleanupServer = cleanupServer;
        return this;
    }

    public NativeImagePhase setEnableHttpUrlHandler(boolean enableHttpUrlHandler) {
        this.enableHttpUrlHandler = enableHttpUrlHandler;
        return this;
    }

    public NativeImagePhase setEnableHttpsUrlHandler(boolean enableHttpsUrlHandler) {
        this.enableHttpsUrlHandler = enableHttpsUrlHandler;
        return this;
    }

    public NativeImagePhase setEnableAllSecurityServices(boolean enableAllSecurityServices) {
        this.enableAllSecurityServices = enableAllSecurityServices;
        return this;
    }

    public NativeImagePhase setEnableRetainedHeapReporting(boolean enableRetainedHeapReporting) {
        this.enableRetainedHeapReporting = enableRetainedHeapReporting;
        return this;
    }

    public NativeImagePhase setEnableCodeSizeReporting(boolean enableCodeSizeReporting) {
        this.enableCodeSizeReporting = enableCodeSizeReporting;
        return this;
    }

    public NativeImagePhase setEnableIsolates(boolean enableIsolates) {
        this.enableIsolates = enableIsolates;
        return this;
    }

    public NativeImagePhase setEnableFallbackImages(boolean enableFallbackImages) {
        this.enableFallbackImages = enableFallbackImages;
        return this;
    }

    public NativeImagePhase setGraalvmHome(String graalvmHome) {
        this.graalvmHome = graalvmHome;
        return this;
    }

    public NativeImagePhase setJavaHome(File javaHome) {
        this.javaHome = javaHome;
        return this;
    }

    public NativeImagePhase setEnableServer(boolean enableServer) {
        this.enableServer = enableServer;
        return this;
    }

    public NativeImagePhase setEnableJni(boolean enableJni) {
        this.enableJni = enableJni;
        return this;
    }

    public NativeImagePhase setAutoServiceLoaderRegistration(boolean autoServiceLoaderRegistration) {
        this.autoServiceLoaderRegistration = autoServiceLoaderRegistration;
        return this;
    }

    public NativeImagePhase setDumpProxies(boolean dumpProxies) {
        this.dumpProxies = dumpProxies;
        return this;
    }

    public NativeImagePhase setNativeImageXmx(String nativeImageXmx) {
        this.nativeImageXmx = nativeImageXmx;
        return this;
    }

    public NativeImagePhase setDockerBuild(String dockerBuild) {
        if (dockerBuild == null) {
            return this;
        }
        if ("false".equals(dockerBuild.toLowerCase())) {
            this.containerRuntime = "";
        } else {
            this.containerRuntime = "docker";
            if (!"true".equals(dockerBuild.toLowerCase())) {
                this.builderImage = dockerBuild;
            }
        }
        return this;
    }

    public NativeImagePhase setContainerRuntime(String containerRuntime) {
        if (containerRuntime == null) {
            return this;
        }
        if ("podman".equals(containerRuntime) || "docker".equals(containerRuntime)) {
            this.containerRuntime = containerRuntime;
        } else {
            log.warn((Object)"container runtime is not docker or podman. fallback to docker");
            this.containerRuntime = "docker";
        }
        return this;
    }

    public NativeImagePhase setContainerRuntimeOptions(String containerRuntimeOptions) {
        if (containerRuntimeOptions != null) {
            this.containerRuntimeOptions = Arrays.asList(containerRuntimeOptions.split(","));
        }
        return this;
    }

    public NativeImagePhase setEnableVMInspection(boolean enableVMInspection) {
        this.enableVMInspection = enableVMInspection;
        return this;
    }

    public NativeImagePhase setFullStackTraces(boolean fullStackTraces) {
        this.fullStackTraces = fullStackTraces;
        return this;
    }

    public NativeImagePhase setDisableReports(boolean disableReports) {
        this.disableReports = disableReports;
        return this;
    }

    public NativeImagePhase setAdditionalBuildArgs(List<String> additionalBuildArgs) {
        this.additionalBuildArgs = additionalBuildArgs;
        return this;
    }

    public NativeImagePhase setReportExceptionStackTraces(boolean reportExceptionStackTraces) {
        this.reportExceptionStackTraces = reportExceptionStackTraces;
        return this;
    }

    @Override
    public void register(OutcomeProviderRegistration registration) throws AppCreatorException {
        registration.provides(NativeImageOutcome.class);
    }

    @Override
    public void provideOutcome(AppCreator ctx) throws AppCreatorException {
        List<Object> nativeImage;
        this.outputDir = this.outputDir == null ? ctx.getWorkPath(new String[0]) : IoUtils.mkdirs((Path)this.outputDir);
        RunnerJarOutcome runnerJarOutcome = ctx.resolveOutcome(RunnerJarOutcome.class);
        Path runnerJar = runnerJarOutcome.getRunnerJar();
        boolean runnerJarCopied = false;
        if (!runnerJar.getParent().equals(this.outputDir)) {
            try {
                runnerJar = IoUtils.copy((Path)runnerJar, (Path)this.outputDir.resolve(runnerJar.getFileName()));
            }
            catch (IOException e) {
                throw new AppCreatorException("Failed to copy the runnable jar to the output dir", e);
            }
            runnerJarCopied = true;
        }
        String runnerJarName = runnerJar.getFileName().toString();
        Path outputLibDir = this.outputDir.resolve(runnerJarOutcome.getLibDir().getFileName());
        boolean outputLibDirCopied = false;
        if (Files.exists(outputLibDir, new LinkOption[0])) {
            outputLibDir = null;
        } else {
            try {
                IoUtils.copy((Path)runnerJarOutcome.getLibDir(), (Path)outputLibDir);
            }
            catch (IOException e) {
                throw new AppCreatorException("Failed to copy the runnable jar and the lib to the docker project dir", e);
            }
            outputLibDirCopied = true;
        }
        Config config = SmallRyeConfigProviderResolver.instance().getConfig();
        boolean vmVersionOutOfDate = this.isThisGraalVMVersionObsolete();
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        String noPIE = "";
        if (!"".equals(this.containerRuntime)) {
            nativeImage = new ArrayList();
            Collections.addAll(nativeImage, this.containerRuntime, "run", "-v", this.outputDir.toAbsolutePath() + ":/project:z", "--rm");
            if (IS_LINUX) {
                if ("docker".equals(this.containerRuntime)) {
                    String gid;
                    String uid = NativeImagePhase.getLinuxID("-ur");
                    if (uid != null & (gid = NativeImagePhase.getLinuxID("-gr")) != null & !"".equals(uid) & !"".equals(gid)) {
                        Collections.addAll(nativeImage, "--user", uid + ":" + gid);
                    }
                } else if ("podman".equals(this.containerRuntime)) {
                    nativeImage.add("--userns=keep-id");
                }
            }
            nativeImage.addAll(this.containerRuntimeOptions);
            if (this.debugBuildProcess && this.publishDebugBuildProcessPort) {
                nativeImage.add("--publish=5005:5005");
            }
            nativeImage.add(this.builderImage);
        } else {
            if (IS_LINUX) {
                noPIE = NativeImagePhase.detectNoPIE();
            }
            String graal = this.graalvmHome;
            File java = this.javaHome;
            if (graal != null) {
                env.put(GRAALVM_HOME, graal);
            } else {
                graal = env.get(GRAALVM_HOME);
            }
            if (java == null) {
                String home = System.getProperty(JAVA_HOME_SYS);
                if (home == null) {
                    home = env.get(JAVA_HOME_ENV);
                }
                if (home != null) {
                    java = new File(home);
                }
            }
            nativeImage = Collections.singletonList(NativeImagePhase.getNativeImageExecutable(graal, java, env).getAbsolutePath());
        }
        try {
            ArrayList<String> command = new ArrayList<String>(nativeImage);
            if (this.cleanupServer) {
                ArrayList<String> cleanup = new ArrayList<String>(nativeImage);
                cleanup.add("--server-shutdown");
                ProcessBuilder pb = new ProcessBuilder(cleanup.toArray(new String[0]));
                pb.directory(this.outputDir.toFile());
                pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
                pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                pb.redirectError(ProcessBuilder.Redirect.INHERIT);
                Process process = pb.start();
                process.waitFor();
            }
            Path propsFile = ctx.resolveOutcome(AugmentOutcome.class).getAppClassesDir().resolve("native-image.properties");
            boolean enableSslNative = false;
            if (Files.exists(propsFile, new LinkOption[0])) {
                Properties properties = new Properties();
                try (BufferedReader reader = Files.newBufferedReader(propsFile, StandardCharsets.UTF_8);){
                    properties.load(reader);
                }
                for (String propertyName : properties.stringPropertyNames()) {
                    if (propertyName.startsWith(QUARKUS_PREFIX)) continue;
                    String propertyValue = properties.getProperty(propertyName);
                    if (propertyValue == null) {
                        command.add("-J-D" + propertyName);
                        continue;
                    }
                    command.add("-J-D" + propertyName + "=" + propertyValue);
                }
                String enableSslNativeFromProperties = properties.getProperty("quarkus.ssl.native");
                boolean bl = enableSslNative = enableSslNativeFromProperties != null ? Boolean.parseBoolean(enableSslNativeFromProperties) : false;
                if (!this.enableJni) {
                    String enableJniFromProperties = properties.getProperty("quarkus.jni.enable");
                    boolean bl2 = this.enableJni = enableJniFromProperties != null ? Boolean.parseBoolean(enableJniFromProperties) : false;
                }
                if (!this.enableAllSecurityServices) {
                    String enableAllSecurityServicesFromProperties = properties.getProperty("quarkus.all-security-services.enable");
                    boolean bl3 = this.enableAllSecurityServices = enableAllSecurityServicesFromProperties != null ? Boolean.parseBoolean(enableAllSecurityServicesFromProperties) : false;
                }
                if (!this.addAllCharsets) {
                    String nativeEnableAllCharsetsProperty = properties.getProperty("quarkus.native.enable-all-charsets");
                    boolean bl4 = this.addAllCharsets = nativeEnableAllCharsetsProperty != null ? Boolean.parseBoolean(nativeEnableAllCharsetsProperty) : false;
                }
            }
            if (enableSslNative) {
                this.enableHttpsUrlHandler = true;
                this.enableJni = true;
                this.enableAllSecurityServices = true;
            }
            if (this.additionalBuildArgs != null) {
                command.addAll(this.additionalBuildArgs);
            }
            command.add("--initialize-at-build-time=");
            command.add("-H:InitialCollectionPolicy=com.oracle.svm.core.genscavenge.CollectionPolicy$BySpaceAndTime");
            command.add("-jar");
            command.add(runnerJarName);
            command.add("-J-Djava.util.concurrent.ForkJoinPool.common.parallelism=1");
            if (this.enableFallbackImages) {
                command.add("-H:FallbackThreshold=5");
            } else {
                command.add("-H:FallbackThreshold=0");
            }
            if (this.reportErrorsAtRuntime) {
                command.add("-H:+ReportUnsupportedElementsAtRuntime");
            }
            if (this.reportExceptionStackTraces) {
                command.add("-H:+ReportExceptionStackTraces");
            }
            if (this.debugSymbols) {
                command.add("-g");
            }
            if (this.debugBuildProcess) {
                command.add("-J-Xrunjdwp:transport=dt_socket,address=5005,server=y,suspend=y");
            }
            if (!this.disableReports) {
                command.add("-H:+PrintAnalysisCallTree");
            }
            if (this.dumpProxies) {
                command.add("-Dsun.misc.ProxyGenerator.saveGeneratedFiles=true");
                if (this.enableServer) {
                    log.warn((Object)"Options dumpProxies and enableServer are both enabled: this will get the proxies dumped in an unknown external working directory");
                }
            }
            if (this.nativeImageXmx != null) {
                command.add("-J-Xmx" + this.nativeImageXmx);
            }
            ArrayList<String> protocols = new ArrayList<String>(2);
            if (this.enableHttpUrlHandler) {
                protocols.add("http");
            }
            if (this.enableHttpsUrlHandler) {
                protocols.add("https");
            }
            if (this.addAllCharsets) {
                command.add("-H:+AddAllCharsets");
            } else {
                command.add("-H:-AddAllCharsets");
            }
            if (!protocols.isEmpty()) {
                command.add("-H:EnableURLProtocols=" + String.join((CharSequence)",", protocols));
            }
            if (this.enableAllSecurityServices) {
                command.add("--enable-all-security-services");
            }
            if (!noPIE.isEmpty()) {
                command.add("-H:NativeLinkerOption=" + noPIE);
            }
            if (this.enableRetainedHeapReporting) {
                command.add("-H:+PrintRetainedHeapHistogram");
            }
            if (this.enableCodeSizeReporting) {
                command.add("-H:+PrintCodeSizeReport");
            }
            if (!this.enableIsolates) {
                command.add("-H:-SpawnIsolates");
            }
            if (this.enableJni) {
                command.add("-H:+JNI");
            } else {
                command.add("-H:-JNI");
            }
            if (!this.enableServer && !IS_WINDOWS) {
                command.add("--no-server");
            }
            if (this.enableVMInspection) {
                command.add("-H:+AllowVMInspection");
            }
            if (this.autoServiceLoaderRegistration) {
                command.add("-H:+UseServiceLoaderFeature");
                command.add("-H:+TraceServiceLoaderFeature");
            } else {
                command.add("-H:-UseServiceLoaderFeature");
            }
            if (this.fullStackTraces) {
                command.add("-H:+StackTrace");
            } else {
                command.add("-H:-StackTrace");
            }
            log.info((Object)command.stream().collect(Collectors.joining(" ")));
            CountDownLatch errorReportLatch = new CountDownLatch(1);
            ProcessBuilder pb = new ProcessBuilder(command.toArray(new String[0]));
            pb.directory(this.outputDir.toFile());
            pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            Process process = pb.start();
            new Thread(new ErrorReplacingProcessReader(process.getErrorStream(), this.outputDir.resolve("reports").toFile(), errorReportLatch)).start();
            errorReportLatch.await();
            if (process.waitFor() != 0) {
                throw new RuntimeException("Image generation failed");
            }
            System.setProperty("native.image.path", runnerJarName.substring(0, runnerJarName.lastIndexOf(46)));
            ctx.pushOutcome(NativeImageOutcome.class, this);
        }
        catch (Exception e) {
            throw new AppCreatorException("Failed to build native image", e);
        }
        finally {
            if (runnerJarCopied) {
                IoUtils.recursiveDelete((Path)runnerJar);
            }
            if (outputLibDirCopied) {
                IoUtils.recursiveDelete((Path)outputLibDir);
            }
        }
    }

    private boolean isThisGraalVMVersionObsolete() {
        String vmName = System.getProperty("java.vm.name");
        log.info((Object)("Running Quarkus native-image plugin on " + vmName));
        List<String> obsoleteGraalVmVersions = Arrays.asList("1.0.0", "19.0.", "19.1.");
        boolean vmVersionIsObsolete = obsoleteGraalVmVersions.stream().anyMatch(vmName::contains);
        if (vmVersionIsObsolete) {
            log.error((Object)"Out of date build of GraalVM detected! Please upgrade to GraalVM 19.2.0.1.");
            return true;
        }
        return false;
    }

    private static File getNativeImageExecutable(String graalVmHome, File javaHome, Map<String, String> env) throws AppCreatorException {
        File file;
        String imageName;
        String string = imageName = IS_WINDOWS ? "native-image.cmd" : "native-image";
        if (graalVmHome != null && (file = Paths.get(graalVmHome, "bin", imageName).toFile()).exists()) {
            return file;
        }
        if (javaHome != null && (file = new File(javaHome, "bin/" + imageName)).exists()) {
            return file;
        }
        String systemPath = env.get(PATH);
        if (systemPath != null) {
            String[] pathDirs;
            for (String pathDir : pathDirs = systemPath.split(File.pathSeparator)) {
                File file2;
                File dir = new File(pathDir);
                if (!dir.isDirectory() || !(file2 = new File(dir, imageName)).exists()) continue;
                return file2;
            }
        }
        throw new AppCreatorException("Cannot find the `" + imageName + "` in the GRAALVM_HOME, JAVA_HOME and System PATH. Install it using `gu install native-image`");
    }

    /*
     * Exception decompiling
     */
    private static String getLinuxID(String option) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void safeWaitFor(Process process) {
        boolean intr = false;
        while (true) {
            try {
                process.waitFor();
                return;
            }
            catch (InterruptedException ex) {
                intr = true;
                continue;
            }
            break;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static String detectNoPIE() {
        String argument = NativeImagePhase.testGCCArgument("-no-pie");
        return argument.length() == 0 ? NativeImagePhase.testGCCArgument("-nopie") : argument;
    }

    private static String testGCCArgument(String argument) {
        try {
            Process gcc = new ProcessBuilder("cc", "-v", "-E", argument, "-").start();
            gcc.getOutputStream().close();
            if (gcc.waitFor() == 0) {
                return argument;
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public String getConfigPropertyName() {
        return "native-image";
    }

    @Override
    public PropertiesHandler<NativeImagePhase> getPropertiesHandler() {
        return new PropertiesHandler<NativeImagePhase>(){

            @Override
            public NativeImagePhase getTarget() {
                return NativeImagePhase.this;
            }

            @Override
            public boolean set(NativeImagePhase t, PropertyContext ctx) {
                String value = ctx.getValue();
                switch (ctx.getRelativeName()) {
                    case "output": {
                        t.setOutputDir(Paths.get(value, new String[0]));
                        break;
                    }
                    case "report-errors-at-runtime": {
                        t.setReportErrorsAtRuntime(Boolean.parseBoolean(value));
                        break;
                    }
                    case "debug-symbols": {
                        t.setDebugSymbols(Boolean.parseBoolean(value));
                        break;
                    }
                    case "debug-build-process": {
                        t.setDebugBuildProcess(Boolean.parseBoolean(value));
                        break;
                    }
                    case "publish-debug-build-process-port": {
                        t.setPublishDebugBuildProcessPort(Boolean.parseBoolean(value));
                        break;
                    }
                    case "cleanup-server": {
                        t.setCleanupServer(Boolean.parseBoolean(value));
                        break;
                    }
                    case "enable-http-url-handler": {
                        t.setEnableHttpUrlHandler(Boolean.parseBoolean(value));
                        break;
                    }
                    case "enable-https-url-handler": {
                        t.setEnableHttpsUrlHandler(Boolean.parseBoolean(value));
                        break;
                    }
                    case "enable-all-security-services": {
                        t.setEnableAllSecurityServices(Boolean.parseBoolean(value));
                        break;
                    }
                    case "enable-retained-heap-reporting": {
                        t.setEnableRetainedHeapReporting(Boolean.parseBoolean(value));
                        break;
                    }
                    case "enable-code-size-reporting": {
                        t.setEnableCodeSizeReporting(Boolean.parseBoolean(value));
                        break;
                    }
                    case "enable-isolates": {
                        t.setEnableIsolates(Boolean.parseBoolean(value));
                        break;
                    }
                    case "enable-fallback-images": {
                        t.setEnableFallbackImages(Boolean.parseBoolean(value));
                        break;
                    }
                    case "graalvm-home": {
                        t.setGraalvmHome(value);
                        break;
                    }
                    case "enable-server": {
                        t.setEnableServer(Boolean.parseBoolean(value));
                        break;
                    }
                    case "enable-jni": {
                        t.setEnableJni(Boolean.parseBoolean(value));
                        break;
                    }
                    case "auto-service-loader-registration": {
                        t.setAutoServiceLoaderRegistration(Boolean.parseBoolean(value));
                        break;
                    }
                    case "dump-proxies": {
                        t.setDumpProxies(Boolean.parseBoolean(value));
                        break;
                    }
                    case "native-image-xmx": {
                        t.setNativeImageXmx(value);
                        break;
                    }
                    case "docker-build": {
                        t.setDockerBuild(value);
                        break;
                    }
                    case "enable-vm-inspection": {
                        t.setEnableVMInspection(Boolean.parseBoolean(value));
                        break;
                    }
                    case "full-stack-traces": {
                        t.setFullStackTraces(Boolean.parseBoolean(value));
                        break;
                    }
                    case "disable-reports": {
                        t.setDisableReports(Boolean.parseBoolean(value));
                        break;
                    }
                    case "additional-build-args": {
                        t.setAdditionalBuildArgs(Arrays.asList(value.split(",")));
                        break;
                    }
                    case "report-exception-stack-traces": {
                        t.setReportExceptionStackTraces(Boolean.parseBoolean(value));
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        };
    }
}

