/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.outcome;

import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.outcome.OutcomeResolver;
import java.util.HashMap;
import java.util.Map;

public class OutcomeMap {
    protected final OutcomeResolver<OutcomeMap> router;
    protected Map<Class<?>, Object> outcomes = new HashMap();

    public OutcomeMap(OutcomeResolver<OutcomeMap> router) {
        this.router = router;
    }

    public <T> T resolveOutcome(Class<T> type) throws AppCreatorException {
        Object o = this.outcomes.get(type);
        if (o != null || this.outcomes.containsKey(type)) {
            return (T)o;
        }
        this.router.resolve(this, type);
        o = this.outcomes.get(type);
        if (o != null || this.outcomes.containsKey(type)) {
            return (T)o;
        }
        throw new AppCreatorException("Outcome of type " + type + " has not been provided");
    }

    public boolean isAvailable(Class<?> outcomeType) {
        return this.outcomes.containsKey(outcomeType);
    }

    public <T> T getOutcome(Class<T> type) {
        return (T)this.outcomes.get(type);
    }

    public <T> void pushOutcome(T outcome) throws AppCreatorException {
        this.pushOutcome(outcome.getClass(), outcome);
    }

    public <T> void pushOutcome(Class<T> type, T value) throws AppCreatorException {
        if (this.outcomes.containsKey(type)) {
            throw new AppCreatorException("Outcome of type " + type.getName() + " has already been provided");
        }
        this.outcomes.put(type, value);
    }
}

