/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.config.reader;

import io.quarkus.creator.config.reader.PropertiesConfigReaderException;
import io.quarkus.creator.config.reader.PropertiesHandler;
import io.quarkus.creator.config.reader.PropertyContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class MappedPropertiesHandler<T>
implements PropertiesHandler<T> {
    protected Map<String, PropertySetter<T>> setters = Collections.emptyMap();
    protected Map<String, NestedHandlerWithSetter<T, ?>> nestedHandlers = Collections.emptyMap();

    public MappedPropertiesHandler<T> map(String name, PropertySetter<T> setter) {
        if (this.setters.isEmpty()) {
            this.setters = new HashMap<String, PropertySetter<T>>(1);
        }
        this.setters.put(name, setter);
        return this;
    }

    public <C> MappedPropertiesHandler<T> map(String name, PropertiesHandler<C> nestedHandler, NestedSetter<T, C> setter) {
        return this.map(name, new NestedHandlerWithSetter<T, C>(nestedHandler, setter, null));
    }

    public <C> MappedPropertiesHandler<T> map(String name, PropertiesHandler<C> nestedHandler, RootSetter<C> setter) {
        return this.map(name, new NestedHandlerWithSetter(nestedHandler, null, setter));
    }

    protected <C> MappedPropertiesHandler<T> map(String name, NestedHandlerWithSetter<T, C> setter) {
        if (this.nestedHandlers.isEmpty()) {
            this.nestedHandlers = new HashMap(1);
        }
        this.nestedHandlers.put(name, setter);
        return this;
    }

    @Override
    public boolean set(T t, PropertyContext ctx) throws PropertiesConfigReaderException {
        String lastNameElement = ctx.getRelativeName();
        PropertySetter<T> setter = this.setters.get(lastNameElement);
        if (setter == null) {
            return false;
        }
        setter.setProperty(t, ctx.getValue());
        return true;
    }

    @Override
    public PropertiesHandler<?> getNestedHandler(String name) throws PropertiesConfigReaderException {
        PropertiesHandler childCallback = this.nestedHandlers.get(name);
        if (childCallback == null) {
            return null;
        }
        return childCallback;
    }

    @Override
    public void setNested(T t, String name, Object child) throws PropertiesConfigReaderException {
        NestedHandlerWithSetter<T, ?> nestedSetter = this.nestedHandlers.get(name);
        if (nestedSetter == null) {
            throw new PropertiesConfigReaderException("Failed to locate nested setter for " + name);
        }
        nestedSetter.setOnParent(t, child);
    }

    static class NestedHandlerWithSetter<P, C>
    implements PropertiesHandler<C> {
        private final PropertiesHandler<C> delegate;
        private final NestedSetter<P, C> nestedSetter;
        private final RootSetter<C> nestedNamedSetter;

        public NestedHandlerWithSetter(PropertiesHandler<C> delegate, NestedSetter<P, C> nestedSetter, RootSetter<C> rootSetter) {
            this.delegate = delegate;
            this.nestedSetter = nestedSetter;
            this.nestedNamedSetter = rootSetter;
        }

        @Override
        public C getTarget() throws PropertiesConfigReaderException {
            return this.delegate.getTarget();
        }

        @Override
        public boolean setOnObject(PropertyContext ctx) throws PropertiesConfigReaderException {
            return this.delegate.setOnObject(ctx);
        }

        @Override
        public boolean set(C t, PropertyContext ctx) throws PropertiesConfigReaderException {
            return this.delegate.set(t, ctx);
        }

        @Override
        public PropertiesHandler<?> getNestedHandler(String name) throws PropertiesConfigReaderException {
            return this.delegate.getNestedHandler(name);
        }

        @Override
        public void setNestedOnObject(Object o, String name, Object child) throws PropertiesConfigReaderException {
            this.delegate.setNestedOnObject(o, name, child);
        }

        @Override
        public void setNested(C t, String name, Object child) throws PropertiesConfigReaderException {
            this.delegate.setNested(t, name, child);
        }

        protected void setOnParent(P t, Object c) throws PropertiesConfigReaderException {
            if (this.nestedSetter == null) {
                this.nestedNamedSetter.setRoot(c);
            } else {
                this.nestedSetter.setNested(t, c);
            }
        }
    }

    public static interface RootSetter<C> {
        public void setRoot(C var1) throws PropertiesConfigReaderException;
    }

    public static interface NestedSetter<P, C> {
        public void setNested(P var1, C var2) throws PropertiesConfigReaderException;
    }

    public static interface PropertySetter<T> {
        public void setProperty(T var1, String var2) throws PropertiesConfigReaderException;
    }
}

