/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.MethodVisitor;

public class AsmUtil {
    public static final int ASM_API_VERSION = 589824;
    public static final List<org.objectweb.asm.Type> PRIMITIVES = Arrays.asList(org.objectweb.asm.Type.VOID_TYPE, org.objectweb.asm.Type.BOOLEAN_TYPE, org.objectweb.asm.Type.CHAR_TYPE, org.objectweb.asm.Type.BYTE_TYPE, org.objectweb.asm.Type.SHORT_TYPE, org.objectweb.asm.Type.INT_TYPE, org.objectweb.asm.Type.FLOAT_TYPE, org.objectweb.asm.Type.LONG_TYPE, org.objectweb.asm.Type.DOUBLE_TYPE);
    public static final List<org.objectweb.asm.Type> WRAPPERS = Arrays.asList(org.objectweb.asm.Type.getType(Void.class), org.objectweb.asm.Type.getType(Boolean.class), org.objectweb.asm.Type.getType(Character.class), org.objectweb.asm.Type.getType(Byte.class), org.objectweb.asm.Type.getType(Short.class), org.objectweb.asm.Type.getType(Integer.class), org.objectweb.asm.Type.getType(Float.class), org.objectweb.asm.Type.getType(Long.class), org.objectweb.asm.Type.getType(Double.class));
    public static final Map<org.objectweb.asm.Type, org.objectweb.asm.Type> WRAPPER_TO_PRIMITIVE = new HashMap<org.objectweb.asm.Type, org.objectweb.asm.Type>();
    public static final Map<Character, String> PRIMITIVE_DESCRIPTOR_TO_PRIMITIVE_CLASS_LITERAL;

    public static org.objectweb.asm.Type autobox(org.objectweb.asm.Type primitive) {
        return WRAPPERS.get(primitive.getSort());
    }

    private static boolean hasThrowsSignature(MethodInfo method) {
        for (Type type : method.exceptions()) {
            if (type.kind() != Type.Kind.TYPE_VARIABLE && type.kind() != Type.Kind.UNRESOLVED_TYPE_VARIABLE) continue;
            return true;
        }
        return false;
    }

    public static int getReturnInstruction(String typeDescriptor) {
        switch (typeDescriptor) {
            case "Z": 
            case "B": 
            case "C": 
            case "S": 
            case "I": {
                return 172;
            }
            case "J": {
                return 173;
            }
            case "F": {
                return 174;
            }
            case "D": {
                return 175;
            }
            case "V": {
                return 177;
            }
        }
        return 176;
    }

    public static int getReturnInstruction(Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case CHAR: {
                    return 172;
                }
                case DOUBLE: {
                    return 175;
                }
                case FLOAT: {
                    return 174;
                }
                case LONG: {
                    return 173;
                }
            }
            throw new IllegalArgumentException("Unknown primitive type: " + String.valueOf(jandexType));
        }
        if (jandexType.kind() == Type.Kind.VOID) {
            return 177;
        }
        return 176;
    }

    public static void visitLdc(MethodVisitor mv, Type jandexType) {
        block0 : switch (jandexType.kind()) {
            case ARRAY: {
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType((String)jandexType.name().toString('/').replace('.', '/')));
                break;
            }
            case CLASS: 
            case PARAMETERIZED_TYPE: {
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType((String)("L" + jandexType.name().toString('/') + ";")));
                break;
            }
            case PRIMITIVE: {
                switch (jandexType.asPrimitiveType().primitive()) {
                    case BOOLEAN: {
                        mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case BYTE: {
                        mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case CHAR: {
                        mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case DOUBLE: {
                        mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case FLOAT: {
                        mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case INT: {
                        mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case LONG: {
                        mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case SHORT: {
                        mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type: " + String.valueOf(jandexType));
            }
            case TYPE_VARIABLE: {
                List bounds = jandexType.asTypeVariable().bounds();
                if (bounds.isEmpty()) {
                    mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType(Object.class));
                    break;
                }
                AsmUtil.visitLdc(mv, (Type)bounds.get(0));
                break;
            }
            case UNRESOLVED_TYPE_VARIABLE: 
            case TYPE_VARIABLE_REFERENCE: {
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType(Object.class));
                break;
            }
            case VOID: {
                mv.visitFieldInsn(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case WILDCARD_TYPE: {
                AsmUtil.visitLdc(mv, jandexType.asWildcardType().extendsBound());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown jandex type: " + String.valueOf(jandexType));
            }
        }
    }

    public static void boxIfRequired(MethodVisitor mv, Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case BYTE: {
                    mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case CHAR: {
                    mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case DOUBLE: {
                    mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                    break;
                }
                case FLOAT: {
                    mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case INT: {
                    mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case LONG: {
                    mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case SHORT: {
                    mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown primitive type: " + String.valueOf(jandexType));
                }
            }
        }
    }

    public static int getLoadOpcode(Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case CHAR: {
                    return 21;
                }
                case DOUBLE: {
                    return 24;
                }
                case FLOAT: {
                    return 23;
                }
                case LONG: {
                    return 22;
                }
            }
            throw new IllegalArgumentException("Unknown primitive type: " + String.valueOf(jandexType));
        }
        return 25;
    }

    public static void unboxIfRequired(MethodVisitor mv, Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    AsmUtil.unbox(mv, "java/lang/Boolean", "booleanValue", "Z");
                    break;
                }
                case BYTE: {
                    AsmUtil.unbox(mv, "java/lang/Byte", "byteValue", "B");
                    break;
                }
                case CHAR: {
                    AsmUtil.unbox(mv, "java/lang/Character", "charValue", "C");
                    break;
                }
                case DOUBLE: {
                    AsmUtil.unbox(mv, "java/lang/Double", "doubleValue", "D");
                    break;
                }
                case FLOAT: {
                    AsmUtil.unbox(mv, "java/lang/Float", "floatValue", "F");
                    break;
                }
                case INT: {
                    AsmUtil.unbox(mv, "java/lang/Integer", "intValue", "I");
                    break;
                }
                case LONG: {
                    AsmUtil.unbox(mv, "java/lang/Long", "longValue", "J");
                    break;
                }
                case SHORT: {
                    AsmUtil.unbox(mv, "java/lang/Short", "shortValue", "S");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown primitive type: " + String.valueOf(jandexType));
                }
            }
        }
    }

    public static void unboxIfRequired(MethodVisitor mv, org.objectweb.asm.Type type) {
        if (type.getSort() <= 8) {
            switch (type.getSort()) {
                case 1: {
                    AsmUtil.unbox(mv, "java/lang/Boolean", "booleanValue", "Z");
                    break;
                }
                case 3: {
                    AsmUtil.unbox(mv, "java/lang/Byte", "byteValue", "B");
                    break;
                }
                case 2: {
                    AsmUtil.unbox(mv, "java/lang/Character", "charValue", "C");
                    break;
                }
                case 8: {
                    AsmUtil.unbox(mv, "java/lang/Double", "doubleValue", "D");
                    break;
                }
                case 6: {
                    AsmUtil.unbox(mv, "java/lang/Float", "floatValue", "F");
                    break;
                }
                case 5: {
                    AsmUtil.unbox(mv, "java/lang/Integer", "intValue", "I");
                    break;
                }
                case 7: {
                    AsmUtil.unbox(mv, "java/lang/Long", "longValue", "J");
                    break;
                }
                case 4: {
                    AsmUtil.unbox(mv, "java/lang/Short", "shortValue", "S");
                }
            }
        }
    }

    private static void unbox(MethodVisitor mv, String owner, String methodName, String returnTypeSignature) {
        mv.visitTypeInsn(192, owner);
        mv.visitMethodInsn(182, owner, methodName, "()" + returnTypeSignature, false);
    }

    public static Type[] getParameterTypes(String methodDescriptor) {
        String argsSignature = methodDescriptor.substring(methodDescriptor.indexOf(40) + 1, methodDescriptor.lastIndexOf(41));
        ArrayList<Type> args = new ArrayList<Type>();
        char[] chars = argsSignature.toCharArray();
        int dimensions = 0;
        int start = 0;
        block5: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    Type type;
                    if (dimensions == 0) {
                        type = Type.create((DotName)DotName.createSimple((String)PRIMITIVE_DESCRIPTOR_TO_PRIMITIVE_CLASS_LITERAL.get(Character.valueOf(c))), (Type.Kind)Type.Kind.PRIMITIVE);
                    } else {
                        DotName dotName = DotName.createSimple((String)("[".repeat(dimensions) + c));
                        type = Type.create((DotName)dotName, (Type.Kind)Type.Kind.ARRAY);
                    }
                    args.add(type);
                    dimensions = 0;
                    start = i + 1;
                    continue block5;
                }
                case 'L': {
                    int end = argsSignature.indexOf(59, i);
                    String binaryName = argsSignature.substring(i + 1, end);
                    if (dimensions > 0) {
                        args.add(Type.create((DotName)DotName.createSimple((String)argsSignature.substring(start, end + 1).replace('/', '.')), (Type.Kind)Type.Kind.ARRAY));
                        dimensions = 0;
                    } else {
                        args.add(Type.create((DotName)DotName.createSimple((String)binaryName.replace('/', '.')), (Type.Kind)Type.Kind.CLASS));
                    }
                    i = end;
                    start = i + 1;
                    continue block5;
                }
                case '[': {
                    ++dimensions;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Invalid signature char: " + c);
                }
            }
        }
        return args.toArray(new Type[0]);
    }

    public static int getParameterSize(Type paramType) {
        if (paramType.kind() == Type.Kind.PRIMITIVE) {
            switch (paramType.asPrimitiveType().primitive()) {
                case DOUBLE: 
                case LONG: {
                    return 2;
                }
            }
        }
        return 1;
    }

    public static void printValueOnStderr(MethodVisitor mv, Runnable valuePusher) {
        mv.visitFieldInsn(178, "java/lang/System", "err", "Ljava/io/PrintStream;");
        valuePusher.run();
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/Object;)V", false);
    }

    public static void copyParameterNames(MethodVisitor mv, MethodInfo method) {
        int parameterSize = method.parametersCount();
        if (parameterSize > 0) {
            if (method.parameterName(0) == null) {
                return;
            }
            for (int i = 0; i < parameterSize; ++i) {
                mv.visitParameter(method.parameterName(i), 0);
            }
        }
    }

    static {
        for (int i = 0; i < PRIMITIVES.size(); ++i) {
            WRAPPER_TO_PRIMITIVE.put(WRAPPERS.get(i), PRIMITIVES.get(i));
        }
        PRIMITIVE_DESCRIPTOR_TO_PRIMITIVE_CLASS_LITERAL = Map.of(Character.valueOf('Z'), "boolean", Character.valueOf('B'), "byte", Character.valueOf('C'), "char", Character.valueOf('D'), "double", Character.valueOf('F'), "float", Character.valueOf('I'), "int", Character.valueOf('J'), "long", Character.valueOf('S'), "short");
    }
}

