/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.QuarkusCompiler;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestController;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestRunner;
import io.quarkus.deployment.dev.testing.TestState;
import io.quarkus.deployment.dev.testing.TestType;
import io.quarkus.dev.spi.DevModeType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class TestSupport
implements TestController {
    private static final Logger log = Logger.getLogger(TestSupport.class);
    final CuratedApplication curatedApplication;
    final List<CompilationProvider> compilationProviders;
    final DevModeContext context;
    final List<TestListener> testListeners = new CopyOnWriteArrayList<TestListener>();
    final TestState testState = new TestState();
    final DevModeType devModeType;
    volatile CuratedApplication testCuratedApplication;
    volatile QuarkusCompiler compiler;
    volatile TestRunner testRunner;
    volatile boolean started;
    volatile TestRunResults testRunResults;
    volatile List<String> includeTags = Collections.emptyList();
    volatile List<String> excludeTags = Collections.emptyList();
    volatile Pattern include = null;
    volatile Pattern exclude = null;
    volatile boolean displayTestOutput;
    volatile Boolean explicitDisplayTestOutput;
    volatile boolean brokenOnlyMode;
    volatile TestType testType = TestType.ALL;

    public TestSupport(CuratedApplication curatedApplication, List<CompilationProvider> compilationProviders, DevModeContext context, DevModeType devModeType) {
        this.curatedApplication = curatedApplication;
        this.compilationProviders = compilationProviders;
        this.context = context;
        this.devModeType = devModeType;
    }

    public static Optional<TestSupport> instance() {
        if (RuntimeUpdatesProcessor.INSTANCE == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(RuntimeUpdatesProcessor.INSTANCE.getTestSupport());
    }

    public boolean isRunning() {
        if (this.testRunner == null) {
            return false;
        }
        return this.testRunner.isRunning();
    }

    public List<TestListener> getTestListeners() {
        return this.testListeners;
    }

    public RunStatus getStatus() {
        if (this.testRunner == null) {
            return new RunStatus(-1L, -1L);
        }
        long last = -1L;
        long runningTestRunId = this.testRunner.getRunningTestRunId();
        TestRunResults tr = this.testRunResults;
        if (tr != null) {
            last = tr.getId();
        }
        return new RunStatus(last, runningTestRunId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.started) {
            TestSupport testSupport = this;
            synchronized (testSupport) {
                if (!this.started) {
                    try {
                        if (this.context.getApplicationRoot().getTest().isPresent()) {
                            this.started = true;
                            this.init();
                            this.testRunner.enable();
                            for (TestListener i : this.testListeners) {
                                i.testsEnabled();
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to create compiler, runtime compilation will be unavailable", (Throwable)e);
                    }
                }
            }
        }
    }

    public void init() {
        if (!this.context.getApplicationRoot().getTest().isPresent()) {
            return;
        }
        if (this.testCuratedApplication == null) {
            try {
                LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
                paths.add(Paths.get(this.context.getApplicationRoot().getTest().get().getClassesPath(), new String[0]));
                if (this.context.getApplicationRoot().getTest().get().getResourcesOutputPath() != null) {
                    paths.add(Paths.get(this.context.getApplicationRoot().getTest().get().getResourcesOutputPath(), new String[0]));
                }
                paths.addAll(this.curatedApplication.getQuarkusBootstrap().getApplicationRoot().toList());
                this.testCuratedApplication = this.curatedApplication.getQuarkusBootstrap().clonedBuilder().setMode(QuarkusBootstrap.Mode.TEST).setAssertionsEnabled(true).setDisableClasspathCache(false).setIsolateDeployment(true).setBaseClassLoader(this.getClass().getClassLoader().getParent()).setTest(true).setAuxiliaryApplication(true).setHostApplicationIsTestOnly(this.devModeType == DevModeType.TEST_ONLY).setApplicationRoot(PathsCollection.from(paths)).build().bootstrap();
                this.compiler = new QuarkusCompiler(this.testCuratedApplication, this.compilationProviders, this.context);
                this.testRunner = new TestRunner(this, this.context, this.testCuratedApplication);
                QuarkusClassLoader cl = (QuarkusClassLoader)this.getClass().getClassLoader();
                cl.addCloseTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TestSupport.this.stop();
                        }
                        finally {
                            TestSupport.this.testCuratedApplication.close();
                        }
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            for (TestListener i : this.testListeners) {
                i.testsDisabled();
            }
        }
        if (this.testRunner != null) {
            this.testRunner.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TestListener listener) {
        boolean run = false;
        TestSupport testSupport = this;
        synchronized (testSupport) {
            this.testListeners.add(listener);
            if (this.started) {
                run = true;
            }
        }
        listener.listenerRegistered(this);
        if (run) {
            listener.testsEnabled();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public TestRunner getTestRunner() {
        return this.testRunner;
    }

    public CuratedApplication getCuratedApplication() {
        return this.curatedApplication;
    }

    public QuarkusCompiler getCompiler() {
        return this.compiler;
    }

    public TestRunResults getTestRunResults() {
        return this.testRunResults;
    }

    public void pause() {
        TestRunner tr = this.testRunner;
        if (tr != null) {
            tr.pause();
        }
    }

    public void resume() {
        TestRunner tr = this.testRunner;
        if (tr != null) {
            tr.resume();
        }
    }

    public TestRunResults getResults() {
        return this.testRunResults;
    }

    public void setTags(List<String> includeTags, List<String> excludeTags) {
        this.includeTags = includeTags;
        this.excludeTags = excludeTags;
    }

    public void setPatterns(String include, String exclude) {
        this.include = include == null ? null : Pattern.compile(include);
        this.exclude = exclude == null ? null : Pattern.compile(exclude);
    }

    public TestSupport setConfiguredDisplayTestOutput(boolean displayTestOutput) {
        if (this.explicitDisplayTestOutput != null) {
            this.displayTestOutput = displayTestOutput;
        }
        this.displayTestOutput = displayTestOutput;
        return this;
    }

    public TestSupport setTestType(TestType testType) {
        this.testType = testType;
        return this;
    }

    @Override
    public TestState currentState() {
        return this.testState;
    }

    @Override
    public void runAllTests() {
        this.getTestRunner().runTests();
    }

    @Override
    public void setDisplayTestOutput(boolean displayTestOutput) {
        this.explicitDisplayTestOutput = displayTestOutput;
        this.displayTestOutput = displayTestOutput;
    }

    @Override
    public void runFailedTests() {
        this.getTestRunner().runFailedTests();
    }

    @Override
    public boolean toggleBrokenOnlyMode() {
        boolean bl = this.brokenOnlyMode = !this.brokenOnlyMode;
        if (this.brokenOnlyMode) {
            log.info((Object)"Broken only mode enabled");
        } else {
            log.info((Object)"Broken only mode disabled");
        }
        for (TestListener i : this.testListeners) {
            i.setBrokenOnly(this.brokenOnlyMode);
        }
        return this.brokenOnlyMode;
    }

    @Override
    public boolean toggleTestOutput() {
        this.setDisplayTestOutput(!this.displayTestOutput);
        if (this.displayTestOutput) {
            log.info((Object)"Test output enabled");
        } else {
            log.info((Object)"Test output disabled");
        }
        for (TestListener i : this.testListeners) {
            i.setTestOutput(this.displayTestOutput);
        }
        return this.displayTestOutput;
    }

    @Override
    public boolean toggleInstrumentation() {
        boolean ibr = RuntimeUpdatesProcessor.INSTANCE.toggleInstrumentation();
        for (TestListener i : this.testListeners) {
            i.setInstrumentationBasedReload(ibr);
        }
        return ibr;
    }

    @Override
    public boolean toggleLiveReloadEnabled() {
        boolean lr = RuntimeUpdatesProcessor.INSTANCE.toggleLiveReloadEnabled();
        for (TestListener i : this.testListeners) {
            i.setLiveReloadEnabled(lr);
        }
        return lr;
    }

    @Override
    public void printFullResults() {
        if (this.currentState().getFailingClasses().isEmpty()) {
            log.info((Object)"All tests passed, no output to display");
        }
        for (TestClassResult i : this.currentState().getFailingClasses()) {
            for (TestResult failed : i.getFailing()) {
                log.error((Object)("Test " + failed.getDisplayName() + " failed " + failed.getTestExecutionResult().getStatus() + "\n"), (Throwable)failed.getTestExecutionResult().getThrowable().get());
            }
        }
    }

    @Override
    public boolean isBrokenOnlyMode() {
        return this.brokenOnlyMode;
    }

    @Override
    public boolean isDisplayTestOutput() {
        return this.displayTestOutput;
    }

    @Override
    public boolean isInstrumentationEnabled() {
        return RuntimeUpdatesProcessor.INSTANCE.instrumentationEnabled();
    }

    @Override
    public boolean isLiveReloadEnabled() {
        return RuntimeUpdatesProcessor.INSTANCE.isLiveReloadEnabled();
    }

    public static class RunStatus {
        final long lastRun;
        final long running;

        public RunStatus(long lastRun, long running) {
            this.lastRun = lastRun;
            this.running = running;
        }

        public long getLastRun() {
            return this.lastRun;
        }

        public long getRunning() {
            return this.running;
        }
    }
}

