/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.util.ExecUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class IsDockerWorking
implements BooleanSupplier {
    private static final Logger LOGGER = Logger.getLogger((String)IsDockerWorking.class.getName());
    private final List<Strategy> strategies;

    public IsDockerWorking() {
        this(false);
    }

    public IsDockerWorking(boolean silent) {
        this.strategies = List.of(new TestContainersStrategy(silent), new DockerHostStrategy(), new DockerBinaryStrategy(silent));
    }

    @Override
    public boolean getAsBoolean() {
        for (Strategy strategy : this.strategies) {
            Result result = (Result)((Object)strategy.get());
            if (result != Result.AVAILABLE) continue;
            return true;
        }
        return false;
    }

    private static enum Result {
        AVAILABLE,
        UNAVAILABLE,
        UNKNOWN;

    }

    private static class DockerBinaryStrategy
    implements Strategy {
        private final boolean silent;

        private DockerBinaryStrategy(boolean silent) {
            this.silent = silent;
        }

        @Override
        public Result get() {
            try {
                if (!ExecUtil.execSilent("docker", "-v")) {
                    LOGGER.warn((Object)"'docker -v' returned an error code. Make sure your Docker binary is correct");
                    return Result.UNKNOWN;
                }
            }
            catch (Exception e) {
                LOGGER.warnf("No Docker binary found or general error: %s", (Object)e);
                return Result.UNKNOWN;
            }
            try {
                OutputFilter filter = new OutputFilter();
                if (ExecUtil.exec(new File("."), filter, "docker", "version", "--format", "'{{.Server.Version}}'")) {
                    LOGGER.debugf("Docker daemon found. Version: %s", (Object)filter.getOutput());
                    return Result.AVAILABLE;
                }
                if (!this.silent) {
                    LOGGER.warn((Object)"Could not determine version of Docker daemon");
                }
                return Result.UNAVAILABLE;
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Unexpected error occurred while determining Docker daemon version", (Throwable)e);
                return Result.UNKNOWN;
            }
        }

        public static class OutputFilter
        implements Function<InputStream, Runnable> {
            private final StringBuilder builder = new StringBuilder();

            @Override
            public Runnable apply(InputStream is) {
                return () -> {
                    try (InputStreamReader isr = new InputStreamReader(is);
                         BufferedReader reader = new BufferedReader(isr);){
                        String line = reader.readLine();
                        while (line != null) {
                            this.builder.append(line);
                            line = reader.readLine();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error reading stream.", e);
                    }
                };
            }

            public String getOutput() {
                return this.builder.toString();
            }
        }
    }

    private static class DockerHostStrategy
    implements Strategy {
        private DockerHostStrategy() {
        }

        @Override
        public Result get() {
            String dockerHost = System.getenv("DOCKER_HOST");
            if (dockerHost != null && !dockerHost.startsWith("unix:")) {
                Result result;
                URI url = new URI(dockerHost);
                Socket s = new Socket(url.getHost(), url.getPort());
                try {
                    result = Result.AVAILABLE;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            LOGGER.warnf("Unable to connect to DOCKER_HOST URI %s, make sure docker is running on the specified host", (Object)dockerHost);
                        }
                    }
                    catch (URISyntaxException e) {
                        LOGGER.warnf("Unable to parse DOCKER_HOST URI %s, it will be ignored for working docker detection", (Object)dockerHost);
                    }
                }
                s.close();
                return result;
            }
            return Result.UNKNOWN;
        }
    }

    private static class TestContainersStrategy
    implements Strategy {
        private final boolean silent;

        private TestContainersStrategy(boolean silent) {
            this.silent = silent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result get() {
            try (StartupLogCompressor compressor = new StartupLogCompressor("Checking Docker Environment", Optional.empty(), null);){
                Class<?> dockerClientFactoryClass = Thread.currentThread().getContextClassLoader().loadClass("org.testcontainers.DockerClientFactory");
                Object dockerClientFactoryInstance = dockerClientFactoryClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
                boolean isAvailable = (Boolean)dockerClientFactoryClass.getMethod("isDockerAvailable", new Class[0]).invoke(dockerClientFactoryInstance, new Object[0]);
                Result result = isAvailable ? Result.AVAILABLE : Result.UNAVAILABLE;
                return result;
            }
        }
    }

    private static interface Strategy
    extends Supplier<Result> {
    }

    public static class IsDockerRunningSilent
    extends IsDockerWorking {
        public IsDockerRunningSilent() {
            super(true);
        }
    }
}

