/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStepBuilder;
import io.quarkus.builder.ConsumeFlag;
import io.quarkus.builder.ConsumeFlags;
import io.quarkus.builder.ProduceFlag;
import io.quarkus.builder.ProduceFlags;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.BooleanSupplierFactoryBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Overridable;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.ProduceWeak;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.annotations.Weak;
import io.quarkus.deployment.builditem.BootstrapConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.BytecodeRecorderObjectLoaderBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.MainBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationProxyBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.StaticBytecodeRecorderBuildItem;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.DefaultValuesConfigurationSource;
import io.quarkus.deployment.configuration.definition.RootDefinition;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.deployment.recording.ObjectLoader;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.smallrye.config.KeyMap;
import io.smallrye.config.KeyMapBackedConfigSource;
import io.smallrye.config.NameIterator;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;
import org.wildfly.common.function.Functions;

public final class ExtensionLoader {
    private static final Logger loadLog = Logger.getLogger((String)"io.quarkus.deployment");
    private static final Logger cfgLog = Logger.getLogger((String)"io.quarkus.configuration");
    private static final String CONFIG_ROOTS_LIST = "META-INF/quarkus-config-roots.list";

    private ExtensionLoader() {
    }

    private static boolean isRecorder(AnnotatedElement element) {
        return element.isAnnotationPresent(Recorder.class);
    }

    public static Consumer<BuildChainBuilder> loadStepsFrom(ClassLoader classLoader, Properties buildSystemProps, AppModel appModel, LaunchMode launchMode, DevModeType devModeType, Consumer<ConfigBuilder> configCustomizer) throws IOException, ClassNotFoundException {
        ArrayList roots = new ArrayList();
        for (Class<?> clazz : ServiceUtil.classesNamedIn(classLoader, CONFIG_ROOTS_LIST)) {
            ConfigRoot annotation = clazz.getAnnotation(ConfigRoot.class);
            if (annotation == null) {
                cfgLog.warnf("Ignoring configuration root %s because it has no annotation", clazz);
                continue;
            }
            roots.add(clazz);
        }
        BuildTimeConfigurationReader reader = new BuildTimeConfigurationReader(roots);
        SmallRyeConfigBuilder builder = ConfigUtils.configBuilder((boolean)false, (LaunchMode)launchMode);
        DefaultValuesConfigurationSource ds1 = new DefaultValuesConfigurationSource(reader.getBuildTimePatternMap());
        DefaultValuesConfigurationSource ds2 = new DefaultValuesConfigurationSource(reader.getBuildTimeRunTimePatternMap());
        PropertiesConfigSource pcs = new PropertiesConfigSource(buildSystemProps, "Build system");
        Map platformProperties = appModel.getPlatformProperties();
        if (platformProperties.isEmpty()) {
            builder.withSources(new ConfigSource[]{ds1, ds2, pcs});
        } else {
            KeyMap props = new KeyMap(platformProperties.size());
            for (Map.Entry prop : platformProperties.entrySet()) {
                props.findOrAdd(new NameIterator((String)prop.getKey())).putRootValue((Object)((String)prop.getValue()));
            }
            KeyMapBackedConfigSource platformConfigSource = new KeyMapBackedConfigSource("Quarkus platform", -2147482648, props);
            builder.withSources(new ConfigSource[]{ds1, ds2, platformConfigSource, pcs});
        }
        if (configCustomizer != null) {
            configCustomizer.accept((ConfigBuilder)builder);
        }
        SmallRyeConfig src = builder.build();
        QuarkusConfigFactory.setConfig((SmallRyeConfig)src);
        ConfigProviderResolver cpr = ConfigProviderResolver.instance();
        try {
            cpr.releaseConfig(cpr.getConfig());
        }
        catch (IllegalStateException prop) {
            // empty catch block
        }
        BuildTimeConfigurationReader.ReadResult readResult = reader.readConfiguration(src);
        BooleanSupplierFactoryBuildItem bsf = new BooleanSupplierFactoryBuildItem(readResult, launchMode, devModeType);
        Consumer<BuildChainBuilder> result = Functions.discardingConsumer();
        result = result.andThen(bcb -> bcb.addBuildStep(bc -> bc.produce((BuildItem)bsf)).produces(BooleanSupplierFactoryBuildItem.class).build());
        HashMap proxies = new HashMap();
        for (Class<?> clazz : ServiceUtil.classesNamedIn(classLoader, "META-INF/quarkus-build-steps.list")) {
            try {
                result = result.andThen(ExtensionLoader.loadStepsFromClass(clazz, readResult, proxies, bsf));
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to load steps from " + clazz, e);
            }
        }
        final IdentityHashMap proxyFields = new IdentityHashMap();
        for (Map.Entry entry : proxies.entrySet()) {
            RootDefinition def = readResult.requireRootDefinitionForClass((Class)entry.getKey());
            proxyFields.put(entry.getValue(), def.getDescriptor());
        }
        result = result.andThen(bcb -> bcb.addBuildStep(bc -> {
            bc.produce((BuildItem)new ConfigurationBuildItem(readResult));
            bc.produce((BuildItem)new RunTimeConfigurationProxyBuildItem(proxies));
            ObjectLoader loader = new ObjectLoader(){

                @Override
                public ResultHandle load(BytecodeCreator body, Object obj, boolean staticInit) {
                    return body.readStaticField((FieldDescriptor)proxyFields.get(obj));
                }

                @Override
                public boolean canHandleObject(Object obj, boolean staticInit) {
                    return proxyFields.containsKey(obj);
                }
            };
            bc.produce((BuildItem)new BytecodeRecorderObjectLoaderBuildItem(loader));
        }).produces(ConfigurationBuildItem.class).produces(RunTimeConfigurationProxyBuildItem.class).produces(BytecodeRecorderObjectLoaderBuildItem.class).build());
        return result;
    }

    private static Consumer<BuildChainBuilder> loadStepsFromClass(final Class<?> clazz, BuildTimeConfigurationReader.ReadResult readResult, Map<Class<?>, Object> runTimeProxies, BooleanSupplierFactoryBuildItem supplierFactory) {
        Field[] fields;
        List ctorParamFns;
        Parameter[] ctorParameters;
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Consumer<BuildChainBuilder> chainConfig = Functions.discardingConsumer();
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return chainConfig;
        }
        Consumer<BuildStepBuilder> stepConfig = Functions.discardingConsumer();
        BiConsumer<BuildContext, Object> stepInstanceSetup = Functions.discardingBiConsumer();
        if (constructors.length != 1) {
            throw ExtensionLoader.reportError(clazz, "Build step classes must have exactly one constructor");
        }
        EnumSet<ConfigPhase> consumingConfigPhases = EnumSet.noneOf(ConfigPhase.class);
        Constructor<?> constructor = constructors[0];
        if (!Modifier.isPublic(constructor.getModifiers())) {
            constructor.setAccessible(true);
        }
        if ((ctorParameters = constructor.getParameters()).length == 0) {
            ctorParamFns = Collections.emptyList();
        } else {
            ctorParamFns = new ArrayList(ctorParameters.length);
            for (Parameter parameter : ctorParameters) {
                Class<SimpleBuildItem> buildItemClass;
                Type parameterType = parameter.getParameterizedType();
                Class<?> parameterClass = parameter.getType();
                boolean weak = parameter.isAnnotationPresent(Weak.class);
                boolean overridable = parameter.isAnnotationPresent(Overridable.class);
                if (ReflectUtil.rawTypeExtends(parameterType, SimpleBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOf(parameterType).asSubclass(SimpleBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                    ctorParamFns.add(bc -> bc.consume(buildItemClass));
                    continue;
                }
                if (ReflectUtil.isListOf(parameterType, MultiBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(MultiBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                    ctorParamFns.add(bc -> bc.consumeMulti(buildItemClass));
                    continue;
                }
                if (ReflectUtil.isConsumerOf(parameterType, BuildItem.class)) {
                    ExtensionLoader.deprecatedProducer(parameter);
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(BuildItem.class);
                    stepConfig = overridable ? (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE))) : (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass)));
                    ctorParamFns.add(bc -> arg_0 -> ((BuildContext)bc).produce(arg_0));
                    continue;
                }
                if (ReflectUtil.isBuildProducerOf(parameterType, BuildItem.class)) {
                    ExtensionLoader.deprecatedProducer(parameter);
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(BuildItem.class);
                    stepConfig = overridable ? (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE))) : (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass)));
                    ctorParamFns.add(bc -> arg_0 -> ((BuildContext)bc).produce(arg_0));
                    continue;
                }
                if (ReflectUtil.isOptionalOf(parameterType, SimpleBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(SimpleBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                    ctorParamFns.add(bc -> Optional.ofNullable(bc.consume(buildItemClass)));
                    continue;
                }
                if (ReflectUtil.isSupplierOf(parameterType, SimpleBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(SimpleBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                    ctorParamFns.add(bc -> () -> bc.consume(buildItemClass));
                    continue;
                }
                if (ReflectUtil.isSupplierOfOptionalOf(parameterType, SimpleBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(ReflectUtil.rawTypeOfParameter(parameterType, 0), 0).asSubclass(SimpleBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                    ctorParamFns.add(bc -> () -> Optional.ofNullable(bc.consume(buildItemClass)));
                    continue;
                }
                if (ReflectUtil.rawTypeOf(parameterType) == Executor.class) {
                    ctorParamFns.add(BuildContext::getExecutor);
                    continue;
                }
                if (parameterClass.isAnnotationPresent(ConfigRoot.class)) {
                    ConfigRoot annotation = parameterClass.getAnnotation(ConfigRoot.class);
                    ConfigPhase phase = annotation.phase();
                    consumingConfigPhases.add(phase);
                    if (phase.isAvailableAtBuild()) {
                        ctorParamFns.add(bc -> ((ConfigurationBuildItem)bc.consume(ConfigurationBuildItem.class)).getReadResult().requireRootObjectForClass(parameterClass));
                        if (phase != ConfigPhase.BUILD_AND_RUN_TIME_FIXED) continue;
                        runTimeProxies.computeIfAbsent(parameterClass, readResult::requireRootObjectForClass);
                        continue;
                    }
                    if (phase.isReadAtMain()) {
                        throw ExtensionLoader.reportError(parameter, phase + " configuration cannot be consumed here");
                    }
                    throw ExtensionLoader.reportError(parameterClass, "Unknown value for ConfigPhase");
                }
                if (ExtensionLoader.isRecorder(parameterClass)) {
                    throw ExtensionLoader.reportError(parameter, "Bytecode recorders disallowed on constructor parameters");
                }
                throw ExtensionLoader.reportError(parameter, "Unsupported constructor parameter type " + parameterType);
            }
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            Class<SimpleBuildItem> buildItemClass;
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
            if (!Modifier.isPublic(mods) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
                field.setAccessible(true);
            }
            Type fieldType = field.getGenericType();
            Class<?> fieldClass = field.getType();
            boolean weak = field.isAnnotationPresent(Weak.class);
            boolean overridable = field.isAnnotationPresent(Overridable.class);
            if (ReflectUtil.rawTypeExtends(fieldType, SimpleBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOf(fieldType).asSubclass(SimpleBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, bc.consume(buildItemClass)));
                continue;
            }
            if (ReflectUtil.isListOf(fieldType, MultiBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(MultiBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, bc.consumeMulti(buildItemClass)));
                continue;
            }
            if (ReflectUtil.isConsumerOf(fieldType, BuildItem.class)) {
                ExtensionLoader.deprecatedProducer(field);
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(BuildItem.class);
                stepConfig = overridable ? (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE))) : (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass)));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, arg_0 -> ((BuildContext)bc).produce(arg_0)));
                continue;
            }
            if (ReflectUtil.isBuildProducerOf(fieldType, BuildItem.class)) {
                ExtensionLoader.deprecatedProducer(field);
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(BuildItem.class);
                stepConfig = overridable ? (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE))) : (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass)));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, arg_0 -> ((BuildContext)bc).produce(arg_0)));
                continue;
            }
            if (ReflectUtil.isOptionalOf(fieldType, SimpleBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(SimpleBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, Optional.ofNullable(bc.consume(buildItemClass))));
                continue;
            }
            if (ReflectUtil.isSupplierOf(fieldType, SimpleBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(SimpleBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, () -> bc.consume(buildItemClass)));
                continue;
            }
            if (ReflectUtil.isSupplierOfOptionalOf(fieldType, SimpleBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(ReflectUtil.rawTypeOfParameter(fieldType, 0), 0).asSubclass(SimpleBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, () -> Optional.ofNullable(bc.consume(buildItemClass))));
                continue;
            }
            if (fieldClass == Executor.class) {
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, bc.getExecutor()));
                continue;
            }
            if (fieldClass.isAnnotationPresent(ConfigRoot.class)) {
                ConfigRoot annotation = fieldClass.getAnnotation(ConfigRoot.class);
                ConfigPhase phase = annotation.phase();
                consumingConfigPhases.add(phase);
                if (phase.isAvailableAtBuild()) {
                    stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> {
                        ConfigurationBuildItem configurationBuildItem = (ConfigurationBuildItem)bc.consume(ConfigurationBuildItem.class);
                        ReflectUtil.setFieldVal(field, o, configurationBuildItem.getReadResult().requireRootObjectForClass(fieldClass));
                    });
                    if (phase != ConfigPhase.BUILD_AND_RUN_TIME_FIXED) continue;
                    runTimeProxies.computeIfAbsent(fieldClass, readResult::requireRootObjectForClass);
                    continue;
                }
                if (phase.isReadAtMain()) {
                    throw ExtensionLoader.reportError(field, phase + " configuration cannot be consumed here");
                }
                throw ExtensionLoader.reportError(fieldClass, "Unknown value for ConfigPhase");
            }
            if (ExtensionLoader.isRecorder(fieldClass)) {
                throw ExtensionLoader.reportError(field, "Bytecode recorders disallowed on fields");
            }
            throw ExtensionLoader.reportError(field, "Unsupported field type " + fieldType);
        }
        List<Method> methods = ExtensionLoader.getMethods(clazz);
        for (Method method : methods) {
            ProduceWeak[] produceWeaks;
            Produce[] produces;
            Consume[] consumes;
            BiConsumer<BuildContext, Object> resultConsumer;
            List methodParamFns;
            boolean isRecorder;
            int mods = method.getModifiers();
            if (Modifier.isStatic(mods) || !method.isAnnotationPresent(BuildStep.class)) continue;
            if (!Modifier.isPublic(mods) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                method.setAccessible(true);
            }
            BuildStep buildStep = method.getAnnotation(BuildStep.class);
            Class<? extends BooleanSupplier>[] onlyIf = buildStep.onlyIf();
            Class<? extends BooleanSupplier>[] onlyIfNot = buildStep.onlyIfNot();
            Parameter[] methodParameters = method.getParameters();
            Record recordAnnotation = method.getAnnotation(Record.class);
            boolean bl = isRecorder = recordAnnotation != null;
            if (isRecorder) {
                boolean recorderFound = false;
                for (Class<?> p : method.getParameterTypes()) {
                    if (!ExtensionLoader.isRecorder(p)) continue;
                    recorderFound = true;
                    break;
                }
                if (!recorderFound) {
                    throw new RuntimeException(method + " is marked @Record but does not inject an @Recorder object");
                }
            }
            Consumer<BuildStepBuilder> methodStepConfig = Functions.discardingConsumer();
            BooleanSupplier addStep = () -> true;
            for (boolean bl2 : new boolean[]{false, true}) {
                Class<? extends BooleanSupplier>[] testClasses;
                for (Class<? extends BooleanSupplier> testClass : testClasses = bl2 ? onlyIfNot : onlyIf) {
                    BooleanSupplier bs = supplierFactory.get(testClass);
                    addStep = bl2 ? ExtensionLoader.and(addStep, ExtensionLoader.not(bs)) : ExtensionLoader.and(addStep, bs);
                }
            }
            BooleanSupplier finalAddStep = addStep;
            if (isRecorder) {
                assert (recordAnnotation != null);
                ExecutionTime executionTime = recordAnnotation.value();
                boolean optional = recordAnnotation.optional();
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.produces(executionTime == ExecutionTime.STATIC_INIT ? StaticBytecodeRecorderBuildItem.class : MainBytecodeRecorderBuildItem.class, optional ? ProduceFlags.of((ProduceFlag)ProduceFlag.WEAK) : ProduceFlags.NONE));
            }
            Object methodConsumingConfigPhases = consumingConfigPhases.clone();
            if (methodParameters.length == 0) {
                methodParamFns = Collections.emptyList();
            } else {
                methodParamFns = new ArrayList(methodParameters.length);
                for (Parameter parameter : methodParameters) {
                    Class<SimpleBuildItem> buildItemClass;
                    boolean weak = parameter.isAnnotationPresent(Weak.class);
                    boolean overridable = parameter.isAnnotationPresent(Overridable.class);
                    Type parameterType = parameter.getParameterizedType();
                    Class<?> parameterClass = parameter.getType();
                    if (ReflectUtil.rawTypeExtends(parameterType, SimpleBuildItem.class)) {
                        buildItemClass = parameterClass.asSubclass(SimpleBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                        methodParamFns.add((bc, bri) -> bc.consume(buildItemClass));
                        continue;
                    }
                    if (ReflectUtil.isListOf(parameterType, MultiBuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(MultiBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                        methodParamFns.add((bc, bri) -> bc.consumeMulti(buildItemClass));
                        continue;
                    }
                    if (ReflectUtil.isConsumerOf(parameterType, BuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(BuildItem.class);
                        methodStepConfig = overridable ? (weak ? methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE))) : (weak ? methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass)));
                        methodParamFns.add((bc, bri) -> arg_0 -> ((BuildContext)bc).produce(arg_0));
                        continue;
                    }
                    if (ReflectUtil.isBuildProducerOf(parameterType, BuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(BuildItem.class);
                        methodStepConfig = overridable ? (weak ? methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE))) : (weak ? methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass)));
                        methodParamFns.add((bc, bri) -> arg_0 -> ((BuildContext)bc).produce(arg_0));
                        continue;
                    }
                    if (ReflectUtil.isOptionalOf(parameterType, SimpleBuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(SimpleBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                        methodParamFns.add((bc, bri) -> Optional.ofNullable(bc.consume(buildItemClass)));
                        continue;
                    }
                    if (ReflectUtil.isSupplierOf(parameterType, SimpleBuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(SimpleBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                        methodParamFns.add((bc, bri) -> () -> bc.consume(buildItemClass));
                        continue;
                    }
                    if (ReflectUtil.isSupplierOfOptionalOf(parameterType, SimpleBuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(ReflectUtil.rawTypeOfParameter(parameterType, 0), 0).asSubclass(SimpleBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                        methodParamFns.add((bc, bri) -> () -> Optional.ofNullable(bc.consume(buildItemClass)));
                        continue;
                    }
                    if (ReflectUtil.rawTypeOf(parameterType) == Executor.class) {
                        methodParamFns.add((bc, bri) -> bc.getExecutor());
                        continue;
                    }
                    if (parameterClass.isAnnotationPresent(ConfigRoot.class)) {
                        ConfigRoot annotation = parameterClass.getAnnotation(ConfigRoot.class);
                        ConfigPhase phase = annotation.phase();
                        ((AbstractCollection)methodConsumingConfigPhases).add(phase);
                        if (phase.isAvailableAtBuild()) {
                            methodParamFns.add((bc, bri) -> {
                                ConfigurationBuildItem configurationBuildItem = (ConfigurationBuildItem)bc.consume(ConfigurationBuildItem.class);
                                return configurationBuildItem.getReadResult().requireRootObjectForClass(parameterClass);
                            });
                            if (!isRecorder || phase != ConfigPhase.BUILD_AND_RUN_TIME_FIXED) continue;
                            runTimeProxies.computeIfAbsent(parameterClass, readResult::requireRootObjectForClass);
                            continue;
                        }
                        if (phase.isReadAtMain()) {
                            if (isRecorder) {
                                methodParamFns.add((bc, bri) -> {
                                    RunTimeConfigurationProxyBuildItem proxies = (RunTimeConfigurationProxyBuildItem)bc.consume(RunTimeConfigurationProxyBuildItem.class);
                                    return proxies.getProxyObjectFor(parameterClass);
                                });
                                runTimeProxies.computeIfAbsent(parameterClass, ReflectUtil::newInstance);
                                continue;
                            }
                            throw ExtensionLoader.reportError(parameter, phase + " configuration cannot be consumed here unless the method is a @Recorder");
                        }
                        throw ExtensionLoader.reportError(parameterClass, "Unknown value for ConfigPhase");
                    }
                    if (ExtensionLoader.isRecorder(parameter.getType())) {
                        if (!isRecorder) {
                            throw ExtensionLoader.reportError(parameter, "Cannot pass recorders to method which is not annotated with " + Record.class);
                        }
                        methodParamFns.add((bc, bri) -> {
                            assert (bri != null);
                            return bri.getRecordingProxy(parameterClass);
                        });
                        continue;
                    }
                    if (parameter.getType() == RecorderContext.class || parameter.getType() == BytecodeRecorderImpl.class) {
                        if (!isRecorder) {
                            throw ExtensionLoader.reportError(parameter, "Cannot pass recorder context to method which is not annotated with " + Record.class);
                        }
                        methodParamFns.add((bc, bri) -> bri);
                        continue;
                    }
                    throw ExtensionLoader.reportError(parameter, "Unsupported method parameter " + parameterType);
                }
            }
            Type type = method.getGenericReturnType();
            boolean weak = method.isAnnotationPresent(Weak.class);
            boolean overridable = method.isAnnotationPresent(Overridable.class);
            if (ReflectUtil.rawTypeIs(type, Void.TYPE)) {
                resultConsumer = Functions.discardingBiConsumer();
            } else if (ReflectUtil.rawTypeExtends(type, BuildItem.class)) {
                Class<BuildItem> type2 = method.getReturnType().asSubclass(BuildItem.class);
                methodStepConfig = overridable ? (weak ? methodStepConfig.andThen(bsb -> bsb.produces(type2, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(type2, ProduceFlag.OVERRIDABLE))) : (weak ? methodStepConfig.andThen(bsb -> bsb.produces(type2, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(type2)));
                resultConsumer = (bc, o) -> {
                    if (o != null) {
                        bc.produce((BuildItem)o);
                    }
                };
            } else if (ReflectUtil.isOptionalOf(type, BuildItem.class)) {
                Class<BuildItem> type3 = ReflectUtil.rawTypeOfParameter(type, 0).asSubclass(BuildItem.class);
                methodStepConfig = overridable ? (weak ? methodStepConfig.andThen(bsb -> bsb.produces(type3, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(type3, ProduceFlag.OVERRIDABLE))) : (weak ? methodStepConfig.andThen(bsb -> bsb.produces(type3, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(type3)));
                resultConsumer = (bc, o) -> ((Optional)o).ifPresent(arg_0 -> ((BuildContext)bc).produce(arg_0));
            } else if (ReflectUtil.isListOf(type, MultiBuildItem.class)) {
                Class<MultiBuildItem> type4 = ReflectUtil.rawTypeOfParameter(type, 0).asSubclass(MultiBuildItem.class);
                methodStepConfig = overridable ? (weak ? methodStepConfig.andThen(bsb -> bsb.produces(type4, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(type4, ProduceFlag.OVERRIDABLE))) : (weak ? methodStepConfig.andThen(bsb -> bsb.produces(type4, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(type4)));
                resultConsumer = (bc, o) -> {
                    if (o != null) {
                        bc.produce((List)o);
                    }
                };
            } else {
                throw ExtensionLoader.reportError(method, "Unsupported method return type " + type);
            }
            if (((AbstractCollection)methodConsumingConfigPhases).contains(ConfigPhase.BOOTSTRAP) || ((AbstractCollection)methodConsumingConfigPhases).contains(ConfigPhase.RUN_TIME)) {
                if (isRecorder && recordAnnotation.value() == ExecutionTime.STATIC_INIT) {
                    throw ExtensionLoader.reportError(method, "Bytecode recorder is static but an injected config object is declared as run time");
                }
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(RunTimeConfigurationProxyBuildItem.class));
                if (((AbstractCollection)methodConsumingConfigPhases).contains(ConfigPhase.BOOTSTRAP)) {
                    methodStepConfig = methodStepConfig.andThen(bsb -> bsb.afterProduce(BootstrapConfigSetupCompleteBuildItem.class));
                }
                if (((AbstractCollection)methodConsumingConfigPhases).contains(ConfigPhase.RUN_TIME)) {
                    methodStepConfig = methodStepConfig.andThen(bsb -> bsb.afterProduce(RuntimeConfigSetupCompleteBuildItem.class));
                }
            }
            if (((AbstractCollection)methodConsumingConfigPhases).contains(ConfigPhase.BUILD_AND_RUN_TIME_FIXED) || ((AbstractCollection)methodConsumingConfigPhases).contains(ConfigPhase.BUILD_TIME)) {
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(ConfigurationBuildItem.class));
            }
            if ((consumes = (Consume[])method.getAnnotationsByType(Consume.class)).length > 0) {
                methodStepConfig = methodStepConfig.andThen(bsb -> {
                    for (Consume consume : consumes) {
                        bsb.afterProduce(consume.value());
                    }
                });
            }
            if ((produces = (Produce[])method.getAnnotationsByType(Produce.class)).length > 0) {
                methodStepConfig = methodStepConfig.andThen(bsb -> {
                    for (Produce produce : produces) {
                        bsb.beforeConsume(produce.value());
                    }
                });
            }
            if ((produceWeaks = (ProduceWeak[])method.getAnnotationsByType(ProduceWeak.class)).length > 0) {
                methodStepConfig = methodStepConfig.andThen(bsb -> {
                    for (ProduceWeak produceWeak : produceWeaks) {
                        bsb.beforeConsume(produceWeak.value(), ProduceFlag.WEAK);
                    }
                });
            }
            Consumer<BuildStepBuilder> finalStepConfig = stepConfig.andThen(methodStepConfig).andThen(buildStepBuilder -> buildStepBuilder.buildIf(finalAddStep));
            BiConsumer<BuildContext, Object> finalStepInstanceSetup = stepInstanceSetup;
            String name = clazz.getName() + "#" + method.getName();
            chainConfig = chainConfig.andThen(bcb -> {
                BuildStepBuilder bsb = bcb.addBuildStep(new io.quarkus.builder.BuildStep(){

                    public void execute(BuildContext bc) {
                        Object result;
                        Object instance;
                        Object[] ctorArgs = new Object[ctorParamFns.size()];
                        for (int i = 0; i < ctorArgs.length; ++i) {
                            ctorArgs[i] = ((Function)ctorParamFns.get(i)).apply(bc);
                        }
                        try {
                            instance = constructor.newInstance(ctorArgs);
                        }
                        catch (InstantiationException e) {
                            throw ReflectUtil.toError(e);
                        }
                        catch (IllegalAccessException e) {
                            throw ReflectUtil.toError(e);
                        }
                        catch (InvocationTargetException e) {
                            try {
                                throw e.getCause();
                            }
                            catch (Error | RuntimeException e2) {
                                throw e2;
                            }
                            catch (Throwable t) {
                                throw new IllegalStateException(t);
                            }
                        }
                        finalStepInstanceSetup.accept(bc, instance);
                        Object[] methodArgs = new Object[methodParamFns.size()];
                        BytecodeRecorderImpl bri = isRecorder ? new BytecodeRecorderImpl(recordAnnotation.value() == ExecutionTime.STATIC_INIT, clazz.getSimpleName(), method.getName(), Integer.toString(method.toString().hashCode())) : null;
                        for (int i = 0; i < methodArgs.length; ++i) {
                            methodArgs[i] = ((BiFunction)methodParamFns.get(i)).apply(bc, bri);
                        }
                        try {
                            result = method.invoke(instance, methodArgs);
                        }
                        catch (IllegalAccessException e) {
                            throw ReflectUtil.toError(e);
                        }
                        catch (InvocationTargetException e) {
                            try {
                                throw e.getCause();
                            }
                            catch (Error | RuntimeException e2) {
                                throw e2;
                            }
                            catch (Throwable t) {
                                throw new IllegalStateException(t);
                            }
                        }
                        resultConsumer.accept(bc, result);
                        if (isRecorder) {
                            if (recordAnnotation.value() == ExecutionTime.STATIC_INIT) {
                                bc.produce((BuildItem)new StaticBytecodeRecorderBuildItem(bri));
                            } else {
                                bc.produce((BuildItem)new MainBytecodeRecorderBuildItem(bri));
                            }
                        }
                    }

                    public String toString() {
                        return name;
                    }
                });
                finalStepConfig.accept(bsb);
            });
        }
        return chainConfig;
    }

    private static void deprecatedProducer(Object element) {
        loadLog.warnf("Producing values from constructors and fields is no longer supported and will be removed in a future release: %s", element);
    }

    protected static List<Method> getMethods(Class<?> clazz) {
        ArrayList<Method> declaredMethods = new ArrayList<Method>();
        if (!clazz.getName().equals(Object.class.getName())) {
            declaredMethods.addAll(ExtensionLoader.getMethods(clazz.getSuperclass()));
            declaredMethods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        }
        return declaredMethods;
    }

    private static BooleanSupplier and(BooleanSupplier a, BooleanSupplier b) {
        return () -> a.getAsBoolean() && b.getAsBoolean();
    }

    private static BooleanSupplier not(BooleanSupplier x) {
        return () -> !x.getAsBoolean();
    }

    static IllegalArgumentException reportError(AnnotatedElement e, String msg) {
        if (e instanceof Member) {
            return new IllegalArgumentException(msg + " at " + e + " of " + ((Member)((Object)e)).getDeclaringClass());
        }
        if (e instanceof Parameter) {
            return new IllegalArgumentException(msg + " at " + e + " of " + ((Parameter)e).getDeclaringExecutable() + " of " + ((Parameter)e).getDeclaringExecutable().getDeclaringClass());
        }
        return new IllegalArgumentException(msg + " at " + e);
    }
}

