/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.BootstrapConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.MainBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationSourceValueBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.deployment.steps.ReflectiveHierarchyStep;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.StartupContext;
import io.quarkus.runtime.StartupTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

public class RuntimeConfigSetupBuildStep {
    private static final Logger log = Logger.getLogger(ReflectiveHierarchyStep.class);
    private static final String RUNTIME_CONFIG_STARTUP_TASK_CLASS_NAME = "io.quarkus.deployment.steps.RuntimeConfigSetup";

    @BuildStep
    @Consume(value=BootstrapConfigSetupCompleteBuildItem.class)
    @Produce(value=RuntimeConfigSetupCompleteBuildItem.class)
    void setupRuntimeConfig(List<RunTimeConfigurationSourceValueBuildItem> runTimeConfigurationSourceValues, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<MainBytecodeRecorderBuildItem> mainBytecodeRecorder) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        try (ClassCreator clazz = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(RUNTIME_CONFIG_STARTUP_TASK_CLASS_NAME).interfaces(new Class[]{StartupTask.class}).build();
             MethodCreator method = clazz.getMethodCreator("deploy", Void.TYPE, new Class[]{StartupContext.class});){
            method.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"setCurrentBuildStepName", Void.TYPE, (Class[])new Class[]{String.class}), method.getMethodParam(0), new ResultHandle[]{method.load("RuntimeConfigSetupBuildStep.setupRuntimeConfig")});
            ResultHandle config = method.readStaticField(RunTimeConfigurationGenerator.C_INSTANCE);
            if (runTimeConfigurationSourceValues.isEmpty()) {
                method.invokeVirtualMethod(RunTimeConfigurationGenerator.C_READ_CONFIG, config, new ResultHandle[]{method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptyList", List.class, (Class[])new Class[0]), new ResultHandle[0])});
            } else {
                ResultHandle startupContext = method.getMethodParam(0);
                ResultHandle configSourcesProvidersList = method.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{method.load(runTimeConfigurationSourceValues.size())});
                for (RunTimeConfigurationSourceValueBuildItem runTimeConfigurationSourceValue : runTimeConfigurationSourceValues) {
                    RuntimeValue<ConfigSourceProvider> runtimeValue = runTimeConfigurationSourceValue.getConfigSourcesValue();
                    if (runtimeValue instanceof BytecodeRecorderImpl.ReturnedProxy) {
                        String proxyId = ((BytecodeRecorderImpl.ReturnedProxy)runtimeValue).__returned$proxy$key();
                        ResultHandle value = method.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"getValue", Object.class, (Class[])new Class[]{String.class}), startupContext, new ResultHandle[]{method.load(proxyId)});
                        ResultHandle configSourceProvider = method.invokeVirtualMethod(MethodDescriptor.ofMethod(RuntimeValue.class, (String)"getValue", Object.class, (Class[])new Class[0]), method.checkCast(value, RuntimeValue.class), new ResultHandle[0]);
                        method.invokeVirtualMethod(MethodDescriptor.ofMethod(ArrayList.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), configSourcesProvidersList, new ResultHandle[]{method.checkCast(configSourceProvider, ConfigSourceProvider.class)});
                        continue;
                    }
                    log.warn((Object)("RuntimeValue " + runtimeValue + " was not produced by a recorder and it will thus be ignored"));
                }
                method.invokeVirtualMethod(RunTimeConfigurationGenerator.C_READ_CONFIG, config, new ResultHandle[]{configSourcesProvidersList});
            }
            method.returnValue(null);
        }
        mainBytecodeRecorder.produce(new MainBytecodeRecorderBuildItem(RUNTIME_CONFIG_STARTUP_TASK_CLASS_NAME));
    }
}

