/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.configuration.definition.ClassDefinition;
import io.quarkus.deployment.configuration.definition.GroupDefinition;
import io.quarkus.deployment.configuration.definition.RootDefinition;
import io.quarkus.deployment.configuration.matching.ConfigPatternMap;
import io.quarkus.deployment.configuration.matching.Container;
import io.quarkus.deployment.configuration.matching.FieldContainer;
import io.quarkus.deployment.configuration.matching.MapContainer;
import io.quarkus.deployment.configuration.matching.PatternMapBuilder;
import io.quarkus.deployment.configuration.type.ArrayOf;
import io.quarkus.deployment.configuration.type.CollectionOf;
import io.quarkus.deployment.configuration.type.ConverterType;
import io.quarkus.deployment.configuration.type.Leaf;
import io.quarkus.deployment.configuration.type.LowerBoundCheckOf;
import io.quarkus.deployment.configuration.type.MinMaxValidated;
import io.quarkus.deployment.configuration.type.OptionalOf;
import io.quarkus.deployment.configuration.type.PatternValidated;
import io.quarkus.deployment.configuration.type.UpperBoundCheckOf;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.Converters;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.Converter;
import org.jboss.logging.Logger;
import org.wildfly.common.Assert;

public final class BuildTimeConfigurationReader {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.config.build");
    final ConfigPatternMap<Container> buildTimePatternMap;
    final ConfigPatternMap<Container> buildTimeRunTimePatternMap;
    final ConfigPatternMap<Container> runTimePatternMap;
    final List<RootDefinition> buildTimeVisibleRoots;
    final List<RootDefinition> allRoots;

    public BuildTimeConfigurationReader(List<Class<?>> configRoots) {
        Assert.checkNotNullParam((String)"configRoots", configRoots);
        ArrayList<RootDefinition> runTimeRoots = new ArrayList<RootDefinition>();
        ArrayList<RootDefinition> buildTimeRunTimeRoots = new ArrayList<RootDefinition>();
        ArrayList<RootDefinition> buildTimeRoots = new ArrayList<RootDefinition>();
        HashMap groups = new HashMap();
        for (Class<?> configRoot : configRoots) {
            String name = "<<hyphenated element name>>";
            ConfigPhase phase = ConfigPhase.BUILD_TIME;
            ConfigRoot annotation = configRoot.getAnnotation(ConfigRoot.class);
            if (annotation != null) {
                name = annotation.name();
                phase = annotation.phase();
            }
            RootDefinition.Builder defBuilder = new RootDefinition.Builder();
            defBuilder.setConfigPhase(phase);
            defBuilder.setRootName(name);
            BuildTimeConfigurationReader.processClass(defBuilder, configRoot, groups);
            RootDefinition definition = defBuilder.build();
            if (phase == ConfigPhase.BUILD_TIME) {
                buildTimeRoots.add(definition);
                continue;
            }
            if (phase == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                buildTimeRunTimeRoots.add(definition);
                continue;
            }
            assert (phase == ConfigPhase.RUN_TIME);
            runTimeRoots.add(definition);
        }
        this.runTimePatternMap = PatternMapBuilder.makePatterns(runTimeRoots);
        this.buildTimeRunTimePatternMap = PatternMapBuilder.makePatterns(buildTimeRunTimeRoots);
        this.buildTimePatternMap = PatternMapBuilder.makePatterns(buildTimeRoots);
        this.buildTimeVisibleRoots = new ArrayList<RootDefinition>(buildTimeRoots.size() + buildTimeRunTimeRoots.size());
        this.buildTimeVisibleRoots.addAll(buildTimeRoots);
        this.buildTimeVisibleRoots.addAll(buildTimeRunTimeRoots);
        ArrayList<RootDefinition> allRoots = new ArrayList<RootDefinition>(this.buildTimeVisibleRoots.size() + runTimeRoots.size());
        allRoots.addAll(this.buildTimeVisibleRoots);
        allRoots.addAll(runTimeRoots);
        this.allRoots = allRoots;
    }

    private static void processClass(ClassDefinition.Builder builder, Class<?> clazz, Map<Class<?>, GroupDefinition> groups) {
        builder.setConfigurationClass(clazz);
        for (Field field : clazz.getDeclaredFields()) {
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
            if (Modifier.isPrivate(mods)) {
                throw ReflectUtil.reportError(field, "Configuration field may not be private", new Object[0]);
            }
            if (!Modifier.isPublic(mods) || !Modifier.isPublic(clazz.getModifiers())) {
                field.setAccessible(true);
            }
            builder.addMember(BuildTimeConfigurationReader.processValue(field, field.getGenericType(), groups));
        }
    }

    private static ClassDefinition.ClassMember.Specification processValue(Field field, Type valueType, Map<Class<?>, GroupDefinition> groups) {
        boolean isOptional;
        Class<?> valueClass = ReflectUtil.rawTypeOf(valueType);
        boolean bl = isOptional = valueClass == Optional.class;
        if (valueClass == Map.class) {
            if (!(valueType instanceof ParameterizedType)) {
                throw ReflectUtil.reportError(field, "Map values must be parameterized", new Object[0]);
            }
            Class<?> keyClass = ReflectUtil.rawTypeOfParameter(valueType, 0);
            if (keyClass != String.class) {
                throw ReflectUtil.reportError(field, "Map key types other than String are not yet supported", new Object[0]);
            }
            ClassDefinition.ClassMember.Specification nested = BuildTimeConfigurationReader.processValue(field, ReflectUtil.typeOfParameter(valueType, 1), groups);
            if (nested instanceof ClassDefinition.GroupMember.Specification && ((ClassDefinition.GroupMember.Specification)nested).isOptional()) {
                throw ReflectUtil.reportError(field, "Group map values may not be optional", new Object[0]);
            }
            return new ClassDefinition.MapMember.Specification(nested);
        }
        if (valueClass.getAnnotation(ConfigGroup.class) != null || isOptional && ReflectUtil.rawTypeOfParameter(valueType, 0).getAnnotation(ConfigGroup.class) != null) {
            Class<?> groupClass = isOptional ? ReflectUtil.rawTypeOfParameter(valueType, 0) : valueClass;
            GroupDefinition def = groups.get(groupClass);
            if (def == null) {
                GroupDefinition.Builder subBuilder = new GroupDefinition.Builder();
                BuildTimeConfigurationReader.processClass(subBuilder, groupClass, groups);
                def = subBuilder.build();
                groups.put(groupClass, def);
            }
            return new ClassDefinition.GroupMember.Specification(field, def, isOptional);
        }
        String defaultDefault = valueClass == Boolean.TYPE ? "false" : (valueClass.isPrimitive() && valueClass != Character.TYPE ? "0" : null);
        ConfigItem configItem = field.getAnnotation(ConfigItem.class);
        if (configItem != null) {
            String defaultVal = configItem.defaultValue();
            return new ClassDefinition.ItemMember.Specification(field, defaultVal.equals("<<no default>>") ? defaultDefault : defaultVal);
        }
        ConfigProperty configProperty = field.getAnnotation(ConfigProperty.class);
        if (configProperty != null) {
            log.warnf("Using @ConfigProperty for Quarkus configuration items is deprecated (use @ConfigItem instead) at %s#%s", (Object)field.getDeclaringClass().getName(), (Object)field.getName());
            String defaultVal = configProperty.defaultValue();
            return new ClassDefinition.ItemMember.Specification(field, defaultVal.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue") ? defaultDefault : defaultVal);
        }
        return new ClassDefinition.ItemMember.Specification(field, defaultDefault);
    }

    public ConfigPatternMap<Container> getBuildTimePatternMap() {
        return this.buildTimePatternMap;
    }

    public ConfigPatternMap<Container> getBuildTimeRunTimePatternMap() {
        return this.buildTimeRunTimePatternMap;
    }

    public ConfigPatternMap<Container> getRunTimePatternMap() {
        return this.runTimePatternMap;
    }

    public List<RootDefinition> getBuildTimeVisibleRoots() {
        return this.buildTimeVisibleRoots;
    }

    public List<RootDefinition> getAllRoots() {
        return this.allRoots;
    }

    public ReadResult readConfiguration(SmallRyeConfig config) {
        return new ReadOperation(config).run();
    }

    public static final class ReadResult {
        final Map<Class<?>, Object> objectsByRootClass;
        final Map<String, String> specifiedRunTimeDefaultValues;
        final Map<String, String> buildTimeRunTimeVisibleValues;
        final ConfigPatternMap<Container> buildTimePatternMap;
        final ConfigPatternMap<Container> buildTimeRunTimePatternMap;
        final ConfigPatternMap<Container> runTimePatternMap;
        final Map<Class<?>, RootDefinition> runTimeRootsByClass;
        final List<RootDefinition> allRoots;

        ReadResult(Map<Class<?>, Object> objectsByRootClass, Map<String, String> specifiedRunTimeDefaultValues, Map<String, String> buildTimeRunTimeVisibleValues, ConfigPatternMap<Container> buildTimePatternMap, ConfigPatternMap<Container> buildTimeRunTimePatternMap, ConfigPatternMap<Container> runTimePatternMap, List<RootDefinition> allRoots) {
            this.objectsByRootClass = objectsByRootClass;
            this.specifiedRunTimeDefaultValues = specifiedRunTimeDefaultValues;
            this.buildTimeRunTimeVisibleValues = buildTimeRunTimeVisibleValues;
            this.buildTimePatternMap = buildTimePatternMap;
            this.buildTimeRunTimePatternMap = buildTimeRunTimePatternMap;
            this.runTimePatternMap = runTimePatternMap;
            this.allRoots = allRoots;
            HashMap map = new HashMap();
            for (RootDefinition root : allRoots) {
                map.put(root.getConfigurationClass(), root);
            }
            this.runTimeRootsByClass = map;
        }

        public Map<Class<?>, Object> getObjectsByRootClass() {
            return this.objectsByRootClass;
        }

        public Object requireRootObjectForClass(Class<?> clazz) {
            Object obj = this.objectsByRootClass.get(clazz);
            if (obj == null) {
                throw new IllegalStateException("No root found for " + clazz);
            }
            return obj;
        }

        public Map<String, String> getSpecifiedRunTimeDefaultValues() {
            return this.specifiedRunTimeDefaultValues;
        }

        public Map<String, String> getBuildTimeRunTimeVisibleValues() {
            return this.buildTimeRunTimeVisibleValues;
        }

        public ConfigPatternMap<Container> getBuildTimePatternMap() {
            return this.buildTimePatternMap;
        }

        public ConfigPatternMap<Container> getBuildTimeRunTimePatternMap() {
            return this.buildTimeRunTimePatternMap;
        }

        public ConfigPatternMap<Container> getRunTimePatternMap() {
            return this.runTimePatternMap;
        }

        public List<RootDefinition> getAllRoots() {
            return this.allRoots;
        }

        public RootDefinition requireRootDefinitionForClass(Class<?> clazz) {
            RootDefinition def = this.runTimeRootsByClass.get(clazz);
            if (def == null) {
                throw new IllegalStateException("No root definition found for " + clazz);
            }
            return def;
        }
    }

    final class ReadOperation {
        final SmallRyeConfig config;
        final Set<String> processedNames = new HashSet<String>();
        final Map<Class<?>, Object> objectsByRootClass = new HashMap();
        final Map<String, String> specifiedRunTimeDefaultValues = new TreeMap<String, String>();
        final Map<String, String> buildTimeRunTimeVisibleValues = new TreeMap<String, String>();
        final Map<ConverterType, Converter<?>> convByType = new HashMap();

        ReadOperation(SmallRyeConfig config) {
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ReadResult run() {
            StringBuilder nameBuilder = new StringBuilder().append("quarkus");
            int len = nameBuilder.length();
            for (RootDefinition root : BuildTimeConfigurationReader.this.buildTimeVisibleRoots) {
                Object instance;
                Class<?> clazz = root.getConfigurationClass();
                try {
                    Constructor<?> cons = clazz.getDeclaredConstructor(new Class[0]);
                    cons.setAccessible(true);
                    instance = cons.newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    throw ReflectUtil.toError(e);
                }
                catch (IllegalAccessException e) {
                    throw ReflectUtil.toError(e);
                }
                catch (InvocationTargetException e) {
                    throw ReflectUtil.unwrapInvocationTargetException(e);
                }
                catch (NoSuchMethodException e) {
                    throw ReflectUtil.toError(e);
                }
                this.objectsByRootClass.put(clazz, instance);
                String rootName = root.getRootName();
                if (!rootName.isEmpty()) {
                    nameBuilder.append('.').append(rootName);
                }
                this.readConfigGroup(root, instance, nameBuilder);
                nameBuilder.setLength(len);
            }
            for (String propertyName : this.config.getPropertyNames()) {
                NameIterator ni = new NameIterator(propertyName);
                if (ni.hasNext() && ni.nextSegmentEquals("quarkus")) {
                    Converter<?> converter;
                    Field field;
                    Map<String, Object> map;
                    String key;
                    ni.next();
                    Container matched = BuildTimeConfigurationReader.this.buildTimePatternMap.match(ni);
                    if (matched instanceof FieldContainer) {
                        ni.goToEnd();
                        this.getGroup((FieldContainer)matched, ni);
                        continue;
                    }
                    if (matched != null) {
                        assert (matched instanceof MapContainer);
                        ni.goToEnd();
                        key = ni.getPreviousSegment();
                        map = this.getMap((MapContainer)matched, ni);
                        field = matched.findField();
                        converter = this.getConverter(this.config, field, ConverterType.of(field));
                        map.put(key, this.config.getValue(propertyName, converter));
                        continue;
                    }
                    ni.goToStart();
                    ni.next();
                    matched = BuildTimeConfigurationReader.this.buildTimeRunTimePatternMap.match(ni);
                    if (matched instanceof FieldContainer) {
                        ni.goToEnd();
                        this.getGroup((FieldContainer)matched, ni);
                        this.buildTimeRunTimeVisibleValues.put(propertyName, this.config.getOptionalValue(propertyName, String.class).orElse(""));
                        continue;
                    }
                    if (matched != null) {
                        assert (matched instanceof MapContainer);
                        ni.goToEnd();
                        key = ni.getPreviousSegment();
                        map = this.getMap((MapContainer)matched, ni);
                        field = matched.findField();
                        converter = this.getConverter(this.config, field, ConverterType.of(field));
                        map.put(key, this.config.getValue(propertyName, converter));
                        this.buildTimeRunTimeVisibleValues.put(propertyName, this.config.getOptionalValue(propertyName, String.class).orElse(""));
                        continue;
                    }
                    ni.goToStart();
                    ni.next();
                    matched = BuildTimeConfigurationReader.this.runTimePatternMap.match(ni);
                    if (matched == null) continue;
                    boolean old = ExpandingConfigSource.setExpanding((boolean)false);
                    try {
                        this.specifiedRunTimeDefaultValues.put(propertyName, this.config.getOptionalValue(propertyName, String.class).orElse(""));
                        continue;
                    }
                    finally {
                        ExpandingConfigSource.setExpanding((boolean)old);
                        continue;
                    }
                }
                boolean old = ExpandingConfigSource.setExpanding((boolean)false);
                try {
                    this.specifiedRunTimeDefaultValues.put(propertyName, this.config.getOptionalValue(propertyName, String.class).orElse(""));
                }
                finally {
                    ExpandingConfigSource.setExpanding((boolean)old);
                }
            }
            return new ReadResult(this.objectsByRootClass, this.specifiedRunTimeDefaultValues, this.buildTimeRunTimeVisibleValues, BuildTimeConfigurationReader.this.buildTimePatternMap, BuildTimeConfigurationReader.this.buildTimeRunTimePatternMap, BuildTimeConfigurationReader.this.runTimePatternMap, BuildTimeConfigurationReader.this.allRoots);
        }

        private Object getGroup(FieldContainer matched, NameIterator ni) {
            String key;
            boolean consume;
            ClassDefinition.ClassMember classMember = matched.getClassMember();
            ClassDefinition definition = matched.findEnclosingClass();
            Class<?> configurationClass = definition.getConfigurationClass();
            if (definition instanceof RootDefinition) {
                return this.objectsByRootClass.get(configurationClass);
            }
            Container parent = matched.getParent();
            boolean bl = consume = !classMember.getPropertyName().isEmpty();
            if (consume) {
                ni.previous();
            }
            if (parent instanceof FieldContainer) {
                FieldContainer parentClass = (FieldContainer)parent;
                Field field = parentClass.findField();
                Object enclosing = this.getGroup(parentClass, ni);
                if (consume) {
                    ni.next();
                }
                if (classMember instanceof ClassDefinition.GroupMember && ((ClassDefinition.GroupMember)classMember).isOptional()) {
                    Optional opt;
                    try {
                        opt = (Optional)field.get(enclosing);
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                    if (opt.isPresent()) {
                        return opt.get();
                    }
                    Object instance = this.recreateGroup(ni, definition, configurationClass);
                    try {
                        field.set(enclosing, Optional.of(instance));
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                    return instance;
                }
                try {
                    return field.get(enclosing);
                }
                catch (IllegalAccessException e) {
                    throw ReflectUtil.toError(e);
                }
            }
            assert (parent instanceof MapContainer);
            MapContainer parentMap = (MapContainer)parent;
            Map<String, Object> map = this.getMap(parentMap, ni);
            Object instance = map.get(key = ni.getPreviousSegment());
            if (instance == null) {
                instance = this.recreateGroup(ni, definition, configurationClass);
                map.put(key, instance);
            }
            if (consume) {
                ni.next();
            }
            return instance;
        }

        private Map<String, Object> getMap(MapContainer matched, NameIterator ni) {
            Container parent = matched.getParent();
            if (parent instanceof FieldContainer) {
                FieldContainer parentClass = (FieldContainer)parent;
                Field field = parentClass.findField();
                ni.previous();
                Object instance = this.getGroup(parentClass, ni);
                ni.next();
                try {
                    return this.getFieldAsMap(field, instance);
                }
                catch (IllegalAccessException e) {
                    throw ReflectUtil.toError(e);
                }
            }
            assert (parent instanceof MapContainer);
            ni.previous();
            Map<String, Object> map = this.getMap((MapContainer)parent, ni);
            String key = ni.getPreviousSegment();
            ni.next();
            Map<String, Object> instance = this.getAsMap(map, key);
            if (instance == null) {
                instance = new HashMap<String, Object>();
                map.put(key, instance);
            }
            return instance;
        }

        private Object recreateGroup(NameIterator ni, ClassDefinition definition, Class<?> configurationClass) {
            Object instance;
            try {
                instance = configurationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw ReflectUtil.toError(e);
            }
            catch (IllegalAccessException e) {
                throw ReflectUtil.toError(e);
            }
            catch (InvocationTargetException e) {
                throw ReflectUtil.unwrapInvocationTargetException(e);
            }
            catch (NoSuchMethodException e) {
                throw ReflectUtil.toError(e);
            }
            StringBuilder nameBuilder = new StringBuilder(ni.getAllPreviousSegments());
            this.readConfigGroup(definition, instance, nameBuilder);
            return instance;
        }

        private Map<String, Object> getAsMap(Map<String, Object> map, String key) {
            return (Map)map.get(key);
        }

        private Map<String, Object> getFieldAsMap(Field field, Object instance) throws IllegalAccessException {
            return (Map)field.get(instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readConfigGroup(ClassDefinition definition, Object instance, StringBuilder nameBuilder) {
            for (ClassDefinition.ClassMember member : definition.getMembers()) {
                Object nestedInstance;
                Field field = member.getField();
                if (member instanceof ClassDefinition.MapMember) {
                    try {
                        field.set(instance, new TreeMap());
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                }
                String propertyName = member.getPropertyName();
                if (member instanceof ClassDefinition.ItemMember) {
                    ClassDefinition.ItemMember leafMember = (ClassDefinition.ItemMember)member;
                    int len = nameBuilder.length();
                    try {
                        String fullName;
                        if (!propertyName.isEmpty()) {
                            nameBuilder.append('.').append(propertyName);
                        }
                        if (!this.processedNames.add(fullName = nameBuilder.toString())) continue;
                        this.readConfigValue(fullName, leafMember, instance);
                        continue;
                    }
                    finally {
                        nameBuilder.setLength(len);
                        continue;
                    }
                }
                assert (member instanceof ClassDefinition.GroupMember);
                ClassDefinition.GroupMember groupMember = (ClassDefinition.GroupMember)member;
                if (groupMember.isOptional()) {
                    try {
                        field.set(instance, Optional.empty());
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                }
                Class<?> clazz = groupMember.getGroupDefinition().getConfigurationClass();
                try {
                    nestedInstance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    throw ReflectUtil.toError(e);
                }
                catch (InvocationTargetException e) {
                    throw ReflectUtil.unwrapInvocationTargetException(e);
                }
                catch (NoSuchMethodException e) {
                    throw ReflectUtil.toError(e);
                }
                catch (IllegalAccessException e) {
                    throw ReflectUtil.toError(e);
                }
                try {
                    field.set(instance, nestedInstance);
                }
                catch (IllegalAccessException e) {
                    throw ReflectUtil.toError(e);
                }
                if (propertyName.isEmpty()) {
                    this.readConfigGroup(groupMember.getGroupDefinition(), nestedInstance, nameBuilder);
                    continue;
                }
                int len = nameBuilder.length();
                try {
                    nameBuilder.append('.').append(propertyName);
                    this.readConfigGroup(groupMember.getGroupDefinition(), nestedInstance, nameBuilder);
                }
                finally {
                    nameBuilder.setLength(len);
                }
            }
        }

        private void readConfigValue(String fullName, ClassDefinition.ItemMember member, Object instance) {
            Field field = member.getField();
            Converter<?> converter = this.getConverter(this.config, field, ConverterType.of(field));
            Object val = this.config.getValue(fullName, converter);
            try {
                field.set(instance, val);
            }
            catch (IllegalAccessException e) {
                throw ReflectUtil.toError(e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Converter<?> getConverter(SmallRyeConfig config, Field field, ConverterType valueType) {
            Converter converter = this.convByType.get(valueType);
            if (converter != null) {
                return converter;
            }
            if (valueType instanceof ArrayOf) {
                ArrayOf arrayOf = (ArrayOf)valueType;
                converter = Converters.newArrayConverter(this.getConverter(config, field, arrayOf.getElementType()), arrayOf.getArrayType());
            } else if (valueType instanceof CollectionOf) {
                CollectionOf collectionOf = (CollectionOf)valueType;
                Class<?> collectionClass = collectionOf.getCollectionClass();
                Converter<?> nested = this.getConverter(config, field, collectionOf.getElementType());
                if (collectionClass == List.class) {
                    converter = Converters.newCollectionConverter(nested, (IntFunction)ConfigUtils.listFactory());
                } else if (collectionClass == Set.class) {
                    converter = Converters.newCollectionConverter(nested, (IntFunction)ConfigUtils.setFactory());
                } else {
                    if (collectionClass != SortedSet.class) throw ReflectUtil.reportError(field, "Unsupported configuration collection type: %s", collectionClass);
                    converter = Converters.newCollectionConverter(nested, (IntFunction)ConfigUtils.sortedSetFactory());
                }
            } else if (valueType instanceof Leaf) {
                Leaf leaf = (Leaf)valueType;
                Class<Converter<?>> convertWith = leaf.getConvertWith();
                if (convertWith != null) {
                    try {
                        if (convertWith == HyphenateEnumConverter.class.asSubclass(Converter.class)) {
                            Constructor<Converter<?>> ctor = convertWith.getConstructor(Class.class);
                            converter = ctor.newInstance(valueType.getLeafType());
                        }
                        Constructor<Converter<?>> ctor = convertWith.getConstructor(new Class[0]);
                        converter = ctor.newInstance(new Object[0]);
                    }
                    catch (InstantiationException e) {
                        throw ReflectUtil.toError(e);
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                    catch (InvocationTargetException e) {
                        throw ReflectUtil.unwrapInvocationTargetException(e);
                    }
                    catch (NoSuchMethodException e) {
                        throw ReflectUtil.toError(e);
                    }
                } else {
                    converter = config.getConverter(leaf.getLeafType());
                }
            } else if (valueType instanceof LowerBoundCheckOf) {
                converter = this.getConverter(config, field, ((LowerBoundCheckOf)valueType).getClassConverterType());
            } else if (valueType instanceof UpperBoundCheckOf) {
                converter = this.getConverter(config, field, ((UpperBoundCheckOf)valueType).getClassConverterType());
            } else if (valueType instanceof MinMaxValidated) {
                MinMaxValidated minMaxValidated = (MinMaxValidated)valueType;
                String min = minMaxValidated.getMin();
                boolean minInclusive = minMaxValidated.isMinInclusive();
                String max = minMaxValidated.getMax();
                boolean maxInclusive = minMaxValidated.isMaxInclusive();
                Converter<?> nestedConverter = this.getConverter(config, field, minMaxValidated.getNestedType());
                if (min != null) {
                    converter = max != null ? Converters.rangeValueStringConverter(nestedConverter, (String)min, (boolean)minInclusive, (String)max, (boolean)maxInclusive) : Converters.minimumValueStringConverter(nestedConverter, (String)min, (boolean)minInclusive);
                } else {
                    assert (min == null && max != null);
                    converter = Converters.maximumValueStringConverter(nestedConverter, (String)max, (boolean)maxInclusive);
                }
            } else if (valueType instanceof OptionalOf) {
                OptionalOf optionalOf = (OptionalOf)valueType;
                converter = Converters.newOptionalConverter(this.getConverter(config, field, optionalOf.getNestedType()));
            } else {
                if (!(valueType instanceof PatternValidated)) throw Assert.unreachableCode();
                PatternValidated patternValidated = (PatternValidated)valueType;
                converter = Converters.patternValidatingConverter(this.getConverter(config, field, patternValidated.getNestedType()), (String)patternValidated.getPatternString());
            }
            this.convByType.put(valueType, converter);
            return converter;
        }
    }
}

