/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class CombinedIndexBuildStep {
    @BuildStep
    CombinedIndexBuildItem build(ApplicationArchivesBuildItem archives, List<AdditionalIndexedClassesBuildItem> additionalIndexedClassesItems) {
        ArrayList<IndexView> archiveIndexes = new ArrayList<IndexView>();
        for (ApplicationArchive i : archives.getAllApplicationArchives()) {
            archiveIndexes.add(i.getIndex());
        }
        CompositeIndex archivesIndex = CompositeIndex.create(archiveIndexes);
        Indexer indexer = new Indexer();
        HashSet<DotName> additionalIndex = new HashSet<DotName>();
        for (AdditionalIndexedClassesBuildItem additionalIndexedClasses : additionalIndexedClassesItems) {
            for (String classToIndex : additionalIndexedClasses.getClassesToIndex()) {
                IndexingUtil.indexClass(classToIndex, indexer, (IndexView)archivesIndex, additionalIndex, Thread.currentThread().getContextClassLoader());
            }
        }
        return new CombinedIndexBuildItem((IndexView)CompositeIndex.create((IndexView[])new IndexView[]{archivesIndex, indexer.complete()}));
    }
}

