/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.QuarkusAugmentor;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.runner.RuntimeClassLoader;
import io.quarkus.runner.TransformerTarget;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.runtime.logging.InitialConfigurator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Handler;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassVisitor;

public class RuntimeRunner
implements Runnable,
Closeable {
    private final Path target;
    private final ClassLoader loader;
    private final ClassOutput classOutput;
    private final TransformerTarget transformerTarget;
    private Closeable closeTask;
    private final List<Path> additionalArchives;
    private final Collection<Path> excludedFromIndexing;
    private final List<Consumer<BuildChainBuilder>> chainCustomizers;
    private final LaunchMode launchMode;
    private final LiveReloadBuildItem liveReloadState;
    private final Properties buildSystemProperties;

    public RuntimeRunner(Builder builder) {
        this.target = builder.target;
        this.additionalArchives = new ArrayList<Path>(builder.additionalArchives);
        this.excludedFromIndexing = builder.excludedFromIndexing;
        this.chainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>(builder.chainCustomizers);
        this.launchMode = builder.launchMode;
        this.liveReloadState = builder.liveReloadState;
        if (builder.classOutput == null) {
            ArrayList<Path> allPaths = new ArrayList<Path>();
            allPaths.add(this.target);
            allPaths.addAll(builder.additionalHotDeploymentPaths);
            RuntimeClassLoader runtimeClassLoader = new RuntimeClassLoader(builder.classLoader, allPaths, builder.getWiringClassesDir(), builder.transformerCache);
            this.loader = runtimeClassLoader;
            this.classOutput = runtimeClassLoader;
            this.transformerTarget = runtimeClassLoader;
        } else {
            this.classOutput = builder.classOutput;
            this.transformerTarget = builder.transformerTarget;
            this.loader = builder.classLoader;
        }
        this.buildSystemProperties = builder.buildSystemProperties;
    }

    @Override
    public void close() throws IOException {
        if (this.closeTask != null) {
            this.closeTask.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Thread.currentThread().setContextClassLoader(this.loader);
        ProfileManager.setLaunchMode((LaunchMode)this.launchMode);
        try {
            Application application;
            QuarkusAugmentor.Builder builder = QuarkusAugmentor.builder();
            builder.setRoot(this.target);
            builder.setClassLoader(this.loader);
            builder.setLaunchMode(this.launchMode);
            if (this.liveReloadState != null) {
                builder.setLiveReloadState(this.liveReloadState);
            }
            for (Path path : this.additionalArchives) {
                builder.addAdditionalApplicationArchive(path);
            }
            builder.excludeFromIndexing(this.excludedFromIndexing);
            for (Consumer consumer : this.chainCustomizers) {
                builder.addBuildChainCustomizer(consumer);
            }
            builder.addFinal(BytecodeTransformerBuildItem.class).addFinal(ApplicationClassNameBuildItem.class);
            BuildResult result = builder.build().run();
            List list = result.consumeMulti(BytecodeTransformerBuildItem.class);
            if (!list.isEmpty()) {
                HashMap<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> functions = new HashMap<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>>();
                for (BytecodeTransformerBuildItem i : list) {
                    functions.computeIfAbsent(i.getClassToTransform(), f -> new ArrayList()).add(i.getVisitorFunction());
                }
                this.transformerTarget.setTransformers(functions);
            }
            if (this.loader instanceof RuntimeClassLoader) {
                ApplicationArchivesBuildItem archives = (ApplicationArchivesBuildItem)result.consume(ApplicationArchivesBuildItem.class);
                ((RuntimeClassLoader)this.loader).setApplicationArchives(archives.getApplicationArchives().stream().map(ApplicationArchive::getArchiveRoot).collect(Collectors.toList()));
            }
            for (MultiBuildItem i : result.consumeMulti(GeneratedClassBuildItem.class)) {
                this.classOutput.writeClass(i.isApplicationClass(), i.getName(), i.getClassData());
            }
            for (MultiBuildItem i : result.consumeMulti(GeneratedResourceBuildItem.class)) {
                this.classOutput.writeResource(i.getName(), i.getClassData());
            }
            Class<Application> appClass = this.loader.loadClass(((ApplicationClassNameBuildItem)result.consume(ApplicationClassNameBuildItem.class)).getClassName()).asSubclass(Application.class);
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.loader);
                application = appClass.newInstance();
                application.start(null);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            this.closeTask = new Closeable(){

                @Override
                public void close() {
                    application.stop();
                }
            };
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                if (InitialConfigurator.DELAYED_HANDLER.isActivated()) throw throwable;
                InitialConfigurator.DELAYED_HANDLER.setHandlers(new Handler[]{InitialConfigurator.createDefaultHandler()});
                throw throwable;
            }
        }
        if (InitialConfigurator.DELAYED_HANDLER.isActivated()) return;
        InitialConfigurator.DELAYED_HANDLER.setHandlers(new Handler[]{InitialConfigurator.createDefaultHandler()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ClassLoader classLoader;
        private Path target;
        private Path frameworkClassesPath;
        private Path wiringClassesDir;
        private Path transformerCache;
        private LaunchMode launchMode = LaunchMode.NORMAL;
        private final List<Path> additionalArchives = new ArrayList<Path>();
        private Set<Path> excludedFromIndexing = Collections.emptySet();
        private final List<Path> additionalHotDeploymentPaths = new ArrayList<Path>();
        private final List<Consumer<BuildChainBuilder>> chainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>();
        private ClassOutput classOutput;
        private TransformerTarget transformerTarget;
        private LiveReloadBuildItem liveReloadState;
        private Properties buildSystemProperties;

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder setTarget(Path target) {
            this.target = target;
            return this;
        }

        public Builder setFrameworkClassesPath(Path frameworkClassesPath) {
            this.frameworkClassesPath = frameworkClassesPath;
            return this;
        }

        public Builder setWiringClassesDir(Path wiringClassesDir) {
            this.wiringClassesDir = wiringClassesDir;
            return this;
        }

        public Builder setTransformerCache(Path transformerCache) {
            this.transformerCache = transformerCache;
            return this;
        }

        public Builder addAdditionalArchive(Path additionalArchive) {
            this.additionalArchives.add(additionalArchive);
            return this;
        }

        public Builder addAdditionalHotDeploymentPath(Path additionalPath) {
            this.additionalHotDeploymentPaths.add(additionalPath);
            return this;
        }

        public Builder addAdditionalArchives(Collection<Path> additionalArchives) {
            this.additionalArchives.addAll(additionalArchives);
            return this;
        }

        public Builder addChainCustomizer(Consumer<BuildChainBuilder> chainCustomizer) {
            this.chainCustomizers.add(chainCustomizer);
            return this;
        }

        public Builder addChainCustomizers(Collection<Consumer<BuildChainBuilder>> chainCustomizer) {
            this.chainCustomizers.addAll(chainCustomizer);
            return this;
        }

        public Builder excludeFromIndexing(Path p) {
            if (this.excludedFromIndexing.isEmpty()) {
                this.excludedFromIndexing = new HashSet<Path>(1);
            }
            this.excludedFromIndexing.add(p);
            return this;
        }

        public Builder setLaunchMode(LaunchMode launchMode) {
            this.launchMode = launchMode;
            return this;
        }

        public Builder setClassOutput(ClassOutput classOutput) {
            this.classOutput = classOutput;
            return this;
        }

        public Builder setTransformerTarget(TransformerTarget transformerTarget) {
            this.transformerTarget = transformerTarget;
            return this;
        }

        public Builder setLiveReloadState(LiveReloadBuildItem liveReloadState) {
            this.liveReloadState = liveReloadState;
            return this;
        }

        public Builder setBuildSystemProperties(Properties buildSystemProperties) {
            this.buildSystemProperties = buildSystemProperties;
            return this;
        }

        Path getWiringClassesDir() {
            if (this.wiringClassesDir != null) {
                return this.wiringClassesDir;
            }
            if (this.frameworkClassesPath != null && Files.isDirectory(this.frameworkClassesPath, new LinkOption[0])) {
                return this.frameworkClassesPath;
            }
            return Paths.get("", new String[0]).normalize().resolve("target").resolve("test-classes");
        }

        public RuntimeRunner build() {
            RuntimeRunner runtimeRunner = new RuntimeRunner(this);
            this.excludedFromIndexing = Collections.emptySet();
            return runtimeRunner;
        }
    }
}

