/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.deployment.steps.ConfigurationSetup;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.microprofile.config.spi.Converter;

public class ObjectConfigType<T>
extends LeafConfigType {
    final String defaultValue;
    final Class<T> expectedType;
    Class<? extends Converter<T>> converterClass;

    public ObjectConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, String defaultValue, Class<T> expectedType, String javadocKey, String configKey, Class<? extends Converter<T>> converterClass) {
        super(containingName, container, consumeSegment, javadocKey, configKey);
        this.defaultValue = defaultValue;
        this.expectedType = expectedType;
        this.converterClass = converterClass;
    }

    public Class<T> getItemClass() {
        return this.expectedType;
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, ExpandingConfigSource.Cache cache, SmallRyeConfig config, Field field) {
        try {
            String value = ExpandingConfigSource.expandValue((String)this.defaultValue, (ExpandingConfigSource.Cache)cache);
            field.set(enclosing, ConfigUtils.convert((SmallRyeConfig)config, (String)value, this.expectedType, this.converterClass));
        }
        catch (IllegalAccessException e) {
            throw ObjectConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle cache, ResultHandle config) {
        ResultHandle resultHandle = this.getResultHandle(body, cache, config);
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, resultHandle});
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle cache, ResultHandle smallRyeConfig) {
        ResultHandle resultHandle = this.getResultHandle(body, cache, smallRyeConfig);
        return body.checkCast(resultHandle, this.expectedType);
    }

    private ResultHandle getResultHandle(BytecodeCreator body, ResultHandle cache, ResultHandle smallRyeConfig) {
        ResultHandle clazz = body.loadClass(this.expectedType);
        ResultHandle cacheResultHandle = cache == null ? body.load(this.defaultValue) : body.invokeStaticMethod(ConfigurationSetup.ECS_EXPAND_VALUE, new ResultHandle[]{body.load(this.defaultValue), cache});
        return body.invokeStaticMethod(CU_CONVERT, new ResultHandle[]{smallRyeConfig, cacheResultHandle, clazz, this.loadConverterClass(body)});
    }

    @Override
    public void acceptConfigurationValue(NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        if (this.isConsumeSegment()) {
            name.previous();
        }
        this.getContainer().acceptConfigurationValueIntoLeaf(this, name, cache, config);
    }

    @Override
    public void generateAcceptConfigurationValue(BytecodeCreator body, ResultHandle name, ResultHandle cache, ResultHandle config) {
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        this.getContainer().generateAcceptConfigurationValueIntoLeaf(body, this, name, cache, config);
    }

    @Override
    void acceptConfigurationValueIntoGroup(Object enclosing, Field field, NameIterator name, SmallRyeConfig config) {
        try {
            field.set(enclosing, ConfigUtils.getOptionalValue((SmallRyeConfig)config, (String)name.toString(), this.expectedType, this.converterClass).orElse(null));
        }
        catch (IllegalAccessException e) {
            throw ObjectConfigType.toError(e);
        }
    }

    @Override
    void generateAcceptConfigurationValueIntoGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle name, ResultHandle config) {
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, this.generateGetValue(body, name, config)});
    }

    @Override
    void acceptConfigurationValueIntoMap(Map<String, Object> enclosing, NameIterator name, SmallRyeConfig config) {
        enclosing.put(name.getNextSegment(), ConfigUtils.getOptionalValue((SmallRyeConfig)config, (String)name.toString(), this.expectedType, this.converterClass).orElse(null));
    }

    @Override
    void generateAcceptConfigurationValueIntoMap(BytecodeCreator body, ResultHandle enclosing, ResultHandle name, ResultHandle config) {
        body.invokeInterfaceMethod(MAP_PUT_METHOD, enclosing, new ResultHandle[]{body.invokeVirtualMethod(NI_GET_NEXT_SEGMENT, name, new ResultHandle[0]), this.generateGetValue(body, name, config)});
    }

    @Override
    public String getDefaultValueString() {
        return this.defaultValue;
    }

    private ResultHandle generateGetValue(BytecodeCreator body, ResultHandle name, ResultHandle config) {
        ResultHandle optionalValue = body.invokeStaticMethod(CU_GET_OPT_VALUE, new ResultHandle[]{config, body.invokeVirtualMethod(OBJ_TO_STRING_METHOD, name, new ResultHandle[0]), body.loadClass(this.expectedType), this.loadConverterClass(body)});
        return body.invokeVirtualMethod(OPT_OR_ELSE_METHOD, optionalValue, new ResultHandle[]{body.loadNull()});
    }

    public Class<? extends Converter<T>> getConverterClass() {
        return this.converterClass;
    }
}

