/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static boolean escape(int codePoint) {
        return codePoint == 35 || codePoint == 33 || codePoint == 61 || codePoint == 58;
    }

    public static boolean escapeForKey(int codePoint) {
        return Character.isSpaceChar(codePoint) || PropertiesUtil.escape(codePoint);
    }

    public static boolean escapeForValueFirst(int codePoint) {
        return PropertiesUtil.escapeForKey(codePoint);
    }

    public static boolean escapeForValueSubsequent(int codePoint) {
        return PropertiesUtil.escape(codePoint);
    }

    public static String quotePropertyName(String name) {
        int length = name.length();
        int i = 0;
        while (i < length) {
            int cp = name.codePointAt(i);
            if (PropertiesUtil.escapeForKey(cp)) {
                StringBuilder b = new StringBuilder(length + (length >> 2));
                b.append(name, 0, i);
                b.append('\\').appendCodePoint(cp);
                i = name.offsetByCodePoints(i, 1);
                while (i < length) {
                    cp = name.codePointAt(i);
                    if (PropertiesUtil.escapeForKey(cp)) {
                        b.append('\\');
                    }
                    b.appendCodePoint(cp);
                    i = name.offsetByCodePoints(i, 1);
                }
                return b.toString();
            }
            i = name.offsetByCodePoints(i, 1);
        }
        return name;
    }

    public static String quotePropertyValue(String value) {
        int length = value.length();
        int i = 0;
        while (i < length) {
            int cp = value.codePointAt(i);
            if (i == 0 ? PropertiesUtil.escapeForValueFirst(cp) : PropertiesUtil.escapeForValueSubsequent(cp)) {
                StringBuilder b = new StringBuilder(length + (length >> 2));
                b.append(value, 0, i);
                b.append('\\').appendCodePoint(cp);
                i = value.offsetByCodePoints(i, 1);
                while (i < length) {
                    cp = value.codePointAt(i);
                    if (PropertiesUtil.escapeForValueSubsequent(cp)) {
                        b.append('\\');
                    }
                    b.appendCodePoint(cp);
                    i = value.offsetByCodePoints(i, 1);
                }
                return b.toString();
            }
            i = value.offsetByCodePoints(i, 1);
        }
        return value;
    }
}

