/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.builder.Version;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.BytecodeRecorderObjectLoaderBuildItem;
import io.quarkus.deployment.builditem.ClassOutputBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.JavaLibraryPathAdditionalPathBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.MainBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.ObjectSubstitutionBuildItem;
import io.quarkus.deployment.builditem.SslTrustStoreSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.StaticBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.deployment.steps.ConfigurationSetup;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.StartupContext;
import io.quarkus.runtime.StartupTask;
import io.quarkus.runtime.SubstrateRuntimePropertiesRecorder;
import io.quarkus.runtime.Timing;
import io.quarkus.runtime.configuration.ProfileManager;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.ImageInfo;

class MainClassBuildStep {
    private static final String APP_CLASS = "io.quarkus.runner.ApplicationImpl";
    private static final String MAIN_CLASS = "io.quarkus.runner.GeneratedMain";
    private static final String STARTUP_CONTEXT = "STARTUP_CONTEXT";
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final AtomicInteger COUNT = new AtomicInteger();

    MainClassBuildStep() {
    }

    @BuildStep
    MainClassBuildItem build(List<StaticBytecodeRecorderBuildItem> staticInitTasks, List<ObjectSubstitutionBuildItem> substitutions, List<MainBytecodeRecorderBuildItem> mainMethod, List<SystemPropertyBuildItem> properties, List<JavaLibraryPathAdditionalPathBuildItem> javaLibraryPathAdditionalPaths, Optional<SslTrustStoreSystemPropertyBuildItem> sslTrustStoreSystemProperty, List<FeatureBuildItem> features, BuildProducer<ApplicationClassNameBuildItem> appClassNameProducer, List<BytecodeRecorderObjectLoaderBuildItem> loaders, ClassOutputBuildItem classOutput, LaunchModeBuildItem launchMode) {
        String appClassName = APP_CLASS + COUNT.incrementAndGet();
        appClassNameProducer.produce(new ApplicationClassNameBuildItem(appClassName));
        ClassCreator file = new ClassCreator(ClassOutput.gizmoAdaptor(classOutput.getClassOutput(), true), appClassName, null, Application.class.getName(), new String[0]);
        FieldCreator scField = file.getFieldCreator(STARTUP_CONTEXT, StartupContext.class);
        scField.setModifiers(8);
        MethodCreator mv = file.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
        mv.setModifiers(9);
        for (SystemPropertyBuildItem i : properties) {
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(i.getKey()), mv.load(i.getValue())});
        }
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(Timing.class, (String)"staticInitStarted", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle startupContext = mv.newInstance(MethodDescriptor.ofConstructor(StartupContext.class, (Class[])new Class[0]), new ResultHandle[0]);
        mv.writeStaticField(scField.getFieldDescriptor(), startupContext);
        TryBlock tryBlock = mv.tryBlock();
        for (Object holder : staticInitTasks) {
            BytecodeRecorderImpl bytecodeRecorderImpl = holder.getBytecodeRecorder();
            if (bytecodeRecorderImpl.isEmpty()) continue;
            for (ObjectSubstitutionBuildItem sub : substitutions) {
                ObjectSubstitutionBuildItem.Holder<?, ?> holder1 = sub.holder;
                bytecodeRecorderImpl.registerSubstitution(holder1.from, holder1.to, holder1.substitution);
            }
            for (BytecodeRecorderObjectLoaderBuildItem item : loaders) {
                bytecodeRecorderImpl.registerObjectLoader(item.getObjectLoader());
            }
            bytecodeRecorderImpl.writeBytecode(classOutput.getClassOutput());
            ResultHandle dup = tryBlock.newInstance(MethodDescriptor.ofConstructor((String)bytecodeRecorderImpl.getClassName(), (String[])new String[0]), new ResultHandle[0]);
            tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(StartupTask.class, (String)"deploy", Void.TYPE, (Class[])new Class[]{StartupContext.class}), dup, new ResultHandle[]{startupContext});
        }
        tryBlock.returnValue(null);
        CatchBlockCreator cb = tryBlock.addCatch(Throwable.class);
        cb.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        cb.throwException(RuntimeException.class, "Failed to start quarkus", cb.getCaughtException());
        mv = file.getMethodCreator("doStart", Void.TYPE, new Class[]{String[].class});
        mv.setModifiers(20);
        for (SystemPropertyBuildItem systemPropertyBuildItem : properties) {
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(systemPropertyBuildItem.getKey()), mv.load(systemPropertyBuildItem.getValue())});
        }
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(SubstrateRuntimePropertiesRecorder.class, (String)"doRuntime", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        if (!javaLibraryPathAdditionalPaths.isEmpty()) {
            ResultHandle javaLibraryPath = mv.newInstance(MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"getProperty", String.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.load(JAVA_LIBRARY_PATH)})});
            for (JavaLibraryPathAdditionalPathBuildItem javaLibraryPathAdditionalPath : javaLibraryPathAdditionalPaths) {
                Iterator<MultiBuildItem> javaLibraryPathLength = mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"length", Integer.TYPE, (Class[])new Class[0]), javaLibraryPath, new ResultHandle[0]);
                mv.ifNonZero(javaLibraryPathLength).trueBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{String.class}), javaLibraryPath, new ResultHandle[]{mv.load(File.pathSeparator)});
                mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{String.class}), javaLibraryPath, new ResultHandle[]{mv.load(javaLibraryPathAdditionalPath.getPath())});
            }
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(JAVA_LIBRARY_PATH), mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"toString", String.class, (Class[])new Class[0]), javaLibraryPath, new ResultHandle[0])});
        }
        if (sslTrustStoreSystemProperty.isPresent()) {
            ResultHandle alreadySetTrustStore = mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"getProperty", String.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.load(JAVAX_NET_SSL_TRUST_STORE)});
            BytecodeCreator bytecodeCreator = mv.ifNonZero(mv.invokeStaticMethod(MethodDescriptor.ofMethod(ImageInfo.class, (String)"inImageRuntimeCode", Boolean.TYPE, (Class[])new Class[0]), new ResultHandle[0])).trueBranch();
            bytecodeCreator.ifNull(alreadySetTrustStore).trueBranch().invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{bytecodeCreator.load(JAVAX_NET_SSL_TRUST_STORE), bytecodeCreator.load(sslTrustStoreSystemProperty.get().getPath())});
        }
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(Timing.class, (String)"mainStarted", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        startupContext = mv.readStaticField(scField.getFieldDescriptor());
        tryBlock = mv.tryBlock();
        tryBlock.invokeStaticMethod(ConfigurationSetup.CREATE_RUN_TIME_CONFIG, new ResultHandle[0]);
        for (MainBytecodeRecorderBuildItem mainBytecodeRecorderBuildItem : mainMethod) {
            BytecodeRecorderImpl recorder = mainBytecodeRecorderBuildItem.getBytecodeRecorder();
            if (recorder.isEmpty()) continue;
            for (ObjectSubstitutionBuildItem sub : substitutions) {
                ObjectSubstitutionBuildItem.Holder<?, ?> holder1 = sub.holder;
                recorder.registerSubstitution(holder1.from, holder1.to, holder1.substitution);
            }
            for (BytecodeRecorderObjectLoaderBuildItem item : loaders) {
                recorder.registerObjectLoader(item.getObjectLoader());
            }
            recorder.writeBytecode(classOutput.getClassOutput());
            ResultHandle dup = tryBlock.newInstance(MethodDescriptor.ofConstructor((String)recorder.getClassName(), (String[])new String[0]), new ResultHandle[0]);
            tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(StartupTask.class, (String)"deploy", Void.TYPE, (Class[])new Class[]{StartupContext.class}), dup, new ResultHandle[]{startupContext});
        }
        ResultHandle featuresHandle = tryBlock.load(features.stream().map(f -> f.getInfo()).sorted().collect(Collectors.joining(", ")));
        tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Timing.class, (String)"printStartupTime", Void.TYPE, (Class[])new Class[]{String.class, String.class, String.class, Boolean.TYPE}), new ResultHandle[]{tryBlock.load(Version.getVersion()), featuresHandle, tryBlock.load(ProfileManager.getActiveProfile()), tryBlock.load(LaunchMode.DEVELOPMENT.equals((Object)launchMode.getLaunchMode()))});
        cb = tryBlock.addCatch(Throwable.class);
        cb.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cb.getCaughtException(), new ResultHandle[0]);
        cb.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        cb.throwException(RuntimeException.class, "Failed to start quarkus", cb.getCaughtException());
        mv.returnValue(null);
        mv = file.getMethodCreator("doStop", Void.TYPE, new Class[0]);
        mv.setModifiers(20);
        startupContext = mv.readStaticField(scField.getFieldDescriptor());
        mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        mv.returnValue(null);
        file.close();
        file = new ClassCreator(ClassOutput.gizmoAdaptor(classOutput.getClassOutput(), true), MAIN_CLASS, null, Object.class.getName(), new String[0]);
        mv = file.getMethodCreator("main", Void.TYPE, new Class[]{String[].class});
        mv.setModifiers(9);
        ResultHandle resultHandle = mv.newInstance(MethodDescriptor.ofConstructor((String)appClassName, (String[])new String[0]), new ResultHandle[0]);
        mv.invokeVirtualMethod(MethodDescriptor.ofMethod(Application.class, (String)"run", Void.TYPE, (Class[])new Class[]{String[].class}), resultHandle, new ResultHandle[]{mv.getMethodParam(0)});
        mv.returnValue(null);
        file.close();
        return new MainClassBuildItem(MAIN_CLASS);
    }
}

