/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.BuildTimeRunTimeFixedConfigurationBuildItem;
import io.quarkus.deployment.builditem.BytecodeRecorderObjectLoaderBuildItem;
import io.quarkus.deployment.builditem.ConfigurationTypeBuildItem;
import io.quarkus.deployment.builditem.ExtensionClassLoaderBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationSourceBuildItem;
import io.quarkus.deployment.builditem.UnmatchedConfigBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ServiceProviderBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.deployment.configuration.ConfigDefinition;
import io.quarkus.deployment.configuration.ConfigPatternMap;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.deployment.recording.ObjectLoader;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.AbstractRawDefaultConfigSource;
import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSource;
import io.quarkus.runtime.configuration.BuildTimeConfigFactory;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ConverterSupport;
import io.quarkus.runtime.configuration.DefaultConfigSource;
import io.quarkus.runtime.configuration.DeploymentProfileConfigSource;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import io.quarkus.runtime.configuration.NameIterator;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.runtime.configuration.SimpleConfigurationProviderResolver;
import io.smallrye.config.Converters;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;

public class ConfigurationSetup {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.configuration");
    public static final String BUILD_TIME_CONFIG = "io.quarkus.runtime.generated.BuildTimeConfig";
    public static final String BUILD_TIME_CONFIG_ROOT = "io.quarkus.runtime.generated.BuildTimeConfigRoot";
    public static final String RUN_TIME_CONFIG = "io.quarkus.runtime.generated.RunTimeConfig";
    public static final String RUN_TIME_CONFIG_ROOT = "io.quarkus.runtime.generated.RunTimeConfigRoot";
    public static final String RUN_TIME_DEFAULTS = "io.quarkus.runtime.generated.RunTimeDefaultConfigSource";
    public static final MethodDescriptor CREATE_RUN_TIME_CONFIG = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.RunTimeConfig", (String)"getRunTimeConfiguration", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor ECS_EXPAND_VALUE = MethodDescriptor.ofMethod(ExpandingConfigSource.class, (String)"expandValue", String.class, (Class[])new Class[]{String.class, ExpandingConfigSource.Cache.class});
    private static final FieldDescriptor RUN_TIME_CONFIG_FIELD = FieldDescriptor.of((String)"io.quarkus.runtime.generated.RunTimeConfig", (String)"runConfig", (String)"io.quarkus.runtime.generated.RunTimeConfigRoot");
    private static final FieldDescriptor BUILD_TIME_CONFIG_FIELD = FieldDescriptor.of((String)"io.quarkus.runtime.generated.BuildTimeConfig", (String)"buildConfig", (String)"io.quarkus.runtime.generated.BuildTimeConfigRoot");
    private static final FieldDescriptor CONVERTERS_FIELD = FieldDescriptor.of((String)"io.quarkus.runtime.generated.BuildTimeConfig", (String)"converters", Converter[].class);
    private static final MethodDescriptor NI_HAS_NEXT = MethodDescriptor.ofMethod(NameIterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor NI_NEXT_EQUALS = MethodDescriptor.ofMethod(NameIterator.class, (String)"nextSegmentEquals", Boolean.TYPE, (Class[])new Class[]{String.class});
    private static final MethodDescriptor NI_NEXT = MethodDescriptor.ofMethod(NameIterator.class, (String)"next", Void.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor ITR_HAS_NEXT = MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor ITR_NEXT = MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor C_GET_IMPLICIT_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"getImplicitConverter", Converter.class, (Class[])new Class[]{Class.class});
    private static final MethodDescriptor CPR_SET_INSTANCE = MethodDescriptor.ofMethod(ConfigProviderResolver.class, (String)"setInstance", Void.TYPE, (Class[])new Class[]{ConfigProviderResolver.class});
    private static final MethodDescriptor CPR_REGISTER_CONFIG = MethodDescriptor.ofMethod(ConfigProviderResolver.class, (String)"registerConfig", Void.TYPE, (Class[])new Class[]{Config.class, ClassLoader.class});
    private static final MethodDescriptor CPR_INSTANCE = MethodDescriptor.ofMethod(ConfigProviderResolver.class, (String)"instance", ConfigProviderResolver.class, (Class[])new Class[0]);
    private static final MethodDescriptor SCPR_CONSTRUCT = MethodDescriptor.ofConstructor(SimpleConfigurationProviderResolver.class, (Class[])new Class[0]);
    private static final MethodDescriptor SRCB_BUILD = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"build", Config.class, (Class[])new Class[0]);
    private static final MethodDescriptor SRCB_WITH_CONVERTER = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withConverter", ConfigBuilder.class, (Class[])new Class[]{Class.class, Integer.TYPE, Converter.class});
    private static final MethodDescriptor SRCB_WITH_SOURCES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withSources", ConfigBuilder.class, (Class[])new Class[]{ConfigSource[].class});
    private static final MethodDescriptor SRCB_ADD_DEFAULT_SOURCES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"addDefaultSources", ConfigBuilder.class, (Class[])new Class[0]);
    private static final MethodDescriptor SRCB_ADD_DISCOVERED_SOURCES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"addDiscoveredSources", ConfigBuilder.class, (Class[])new Class[0]);
    private static final MethodDescriptor SRCB_CONSTRUCT = MethodDescriptor.ofConstructor(SmallRyeConfigBuilder.class, (Class[])new Class[0]);
    private static final MethodDescriptor II_IN_IMAGE_RUN = MethodDescriptor.ofMethod(ImageInfo.class, (String)"inImageRuntimeCode", Boolean.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor SRCB_WITH_WRAPPER = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withWrapper", SmallRyeConfigBuilder.class, (Class[])new Class[]{UnaryOperator.class});
    private static final MethodDescriptor BTCF_GET_CONFIG_SOURCE = MethodDescriptor.ofMethod(BuildTimeConfigFactory.class, (String)"getBuildTimeConfigSource", ConfigSource.class, (Class[])new Class[0]);
    private static final MethodDescriptor ECS_CACHE_CONSTRUCT = MethodDescriptor.ofConstructor(ExpandingConfigSource.Cache.class, (Class[])new Class[0]);
    private static final MethodDescriptor ECS_WRAPPER = MethodDescriptor.ofMethod(ExpandingConfigSource.class, (String)"wrapper", UnaryOperator.class, (Class[])new Class[]{ExpandingConfigSource.Cache.class});
    private static final MethodDescriptor PROFILE_WRAPPER = MethodDescriptor.ofMethod(DeploymentProfileConfigSource.class, (String)"wrapper", UnaryOperator.class, (Class[])new Class[0]);
    private static final MethodDescriptor RTD_CTOR = MethodDescriptor.ofConstructor((String)"io.quarkus.runtime.generated.RunTimeDefaultConfigSource", (String[])new String[0]);
    private static final MethodDescriptor RTD_GET_VALUE = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.RunTimeDefaultConfigSource", (String)"getValue", String.class, (Object[])new Object[]{NameIterator.class});
    private static final MethodDescriptor ARDCS_CTOR = MethodDescriptor.ofConstructor(AbstractRawDefaultConfigSource.class, (Class[])new Class[0]);
    private static final MethodDescriptor CS_POPULATE_CONVERTERS = MethodDescriptor.ofMethod(ConverterSupport.class, (String)"populateConverters", Void.TYPE, (Class[])new Class[]{ConfigBuilder.class});
    private static final MethodDescriptor SET_RUNTIME_DEFAULT_PROFILE = MethodDescriptor.ofMethod(ProfileManager.class, (String)"setRuntimeDefaultProfile", Void.TYPE, (Class[])new Class[]{String.class});
    private static final MethodDescriptor HYPHENATED_ENUM_CONVERTER_CTOR = MethodDescriptor.ofConstructor(HyphenateEnumConverter.class, (Class[])new Class[]{Class.class});
    private static final MethodDescriptor CU_EXPLICIT_RUNTIME_CONVERTER = MethodDescriptor.ofMethod(ConfigUtils.class, (String)"populateExplicitRuntimeConverter", Void.TYPE, (Class[])new Class[]{Class.class, Class.class, Converter.class});
    private static final String[] NO_STRINGS = new String[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BuildStep
    public void initializeConfiguration(RunTimeConfigurationBuildItem runTimeConfigItem, BuildTimeRunTimeFixedConfigurationBuildItem buildTimeRunTimeConfigItem, Consumer<GeneratedResourceBuildItem> resourceConsumer, Consumer<SubstrateResourceBuildItem> niResourceConsumer, Consumer<RunTimeConfigurationDefaultBuildItem> runTimeDefaultConsumer, UnmatchedConfigBuildItem unmatchedConfigBuildItem, ExtensionClassLoaderBuildItem extensionClassLoaderBuildItem, ArchiveRootBuildItem archiveRootBuildItem) throws IOException {
        byte[] bytes;
        SmallRyeConfig src = (SmallRyeConfig)ConfigProvider.getConfig();
        ConfigDefinition runTimeConfig = runTimeConfigItem.getConfigDefinition();
        ConfigDefinition buildTimeRunTimeConfig = buildTimeRunTimeConfigItem.getConfigDefinition();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)buildTimeRunTimeConfig.getLoadedProperties());
                properties.store(osw, "This file is generated from captured build-time values; do not edit this file manually");
            }
            os.flush();
            bytes = os.toByteArray();
        }
        resourceConsumer.accept(new GeneratedResourceBuildItem("META-INF/build-config.properties", bytes));
        niResourceConsumer.accept(new SubstrateResourceBuildItem("META-INF/build-config.properties"));
        HashSet<String> unmatched = new HashSet<String>();
        unmatched.addAll(unmatchedConfigBuildItem.getSet());
        unmatched.addAll(runTimeConfig.getLoadedProperties().keySet());
        boolean old = ExpandingConfigSource.setExpanding((boolean)false);
        try {
            for (String propName : unmatched) {
                runTimeDefaultConsumer.accept(new RunTimeConfigurationDefaultBuildItem(propName, src.getOptionalValue(propName, String.class).orElse("")));
            }
        }
        finally {
            ExpandingConfigSource.setExpanding((boolean)old);
        }
    }

    @BuildStep
    public void addDiscoveredSources(ApplicationArchivesBuildItem archives, Consumer<ServiceProviderBuildItem> providerConsumer) throws IOException {
        LinkedHashSet<String> sources = new LinkedHashSet<String>();
        LinkedHashSet<String> sourceProviders = new LinkedHashSet<String>();
        for (ApplicationArchive archive : archives.getAllApplicationArchives()) {
            Path childPath = archive.getChildPath("META-INF/services/" + ConfigSource.class.getName());
            if (childPath != null) {
                sources.addAll(ServiceUtil.classNamesNamedIn(childPath));
            }
            if ((childPath = archive.getChildPath("META-INF/services/" + ConfigSourceProvider.class.getName())) == null) continue;
            sourceProviders.addAll(ServiceUtil.classNamesNamedIn(childPath));
        }
        if (sources.size() > 0) {
            providerConsumer.accept(new ServiceProviderBuildItem(ConfigSource.class.getName(), sources.toArray(NO_STRINGS)));
        }
        if (sourceProviders.size() > 0) {
            providerConsumer.accept(new ServiceProviderBuildItem(ConfigSourceProvider.class.getName(), sourceProviders.toArray(NO_STRINGS)));
        }
    }

    @BuildStep
    void setUpConfigFile(BuildProducer<RunTimeConfigurationSourceBuildItem> configSourceConsumer) {
        configSourceConsumer.produce(new RunTimeConfigurationSourceBuildItem(ApplicationPropertiesConfigSource.InJar.class.getName(), OptionalInt.empty()));
        configSourceConsumer.produce(new RunTimeConfigurationSourceBuildItem(ApplicationPropertiesConfigSource.InFileSystem.class.getName(), OptionalInt.empty()));
    }

    @BuildStep
    RunTimeConfigurationSourceBuildItem writeDefaults(List<RunTimeConfigurationDefaultBuildItem> defaults, Consumer<GeneratedResourceBuildItem> resourceConsumer, Consumer<SubstrateResourceBuildItem> niResourceConsumer) throws IOException {
        Properties properties = new Properties();
        for (RunTimeConfigurationDefaultBuildItem item : defaults) {
            String key = item.getKey();
            String value = item.getValue();
            String existing = properties.getProperty(key);
            if (existing != null && !existing.equals(value)) {
                log.warnf("Two conflicting default values were specified for configuration key \"%s\": \"%s\" and \"%s\" (using \"%2$s\")", (Object)key, (Object)existing, (Object)value);
                continue;
            }
            properties.setProperty(key, value);
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
            properties.store(osw, "This is the generated set of default configuration values");
            osw.flush();
            resourceConsumer.accept(new GeneratedResourceBuildItem("META-INF/quarkus-default-config.properties", os.toByteArray()));
            niResourceConsumer.accept(new SubstrateResourceBuildItem("META-INF/quarkus-default-config.properties"));
        }
        return new RunTimeConfigurationSourceBuildItem(DefaultConfigSource.class.getName(), OptionalInt.empty());
    }

    @BuildStep
    void finalizeConfigLoader(RunTimeConfigurationBuildItem runTimeConfigItem, BuildTimeRunTimeFixedConfigurationBuildItem buildTimeRunTimeConfigItem, final Consumer<GeneratedClassBuildItem> classConsumer, Consumer<RuntimeInitializedClassBuildItem> runTimeInitConsumer, Consumer<BytecodeRecorderObjectLoaderBuildItem> objectLoaderConsumer, List<ConfigurationTypeBuildItem> configTypeItems, List<RunTimeConfigurationSourceBuildItem> runTimeSources) {
        Throwable throwable;
        ClassOutput classOutput = new ClassOutput(){

            public void write(String name, byte[] data) {
                classConsumer.accept(new GeneratedClassBuildItem(true, name, data));
            }
        };
        AccessorFinder accessorFinder = new AccessorFinder();
        final ConfigDefinition runTimeConfigDef = runTimeConfigItem.getConfigDefinition();
        ConfigPatternMap<LeafConfigType> runTimePatterns = runTimeConfigDef.getLeafPatterns();
        runTimeConfigDef.generateConfigRootClass(classOutput, accessorFinder);
        final ConfigDefinition buildTimeConfigDef = buildTimeRunTimeConfigItem.getConfigDefinition();
        ConfigPatternMap<LeafConfigType> buildTimePatterns = buildTimeConfigDef.getLeafPatterns();
        buildTimeConfigDef.generateConfigRootClass(classOutput, accessorFinder);
        HashSet encountered = new HashSet();
        ArrayList<Class> configTypes = new ArrayList<Class>();
        for (ConfigurationTypeBuildItem configurationTypeBuildItem : configTypeItems) {
            configTypes.add(configurationTypeBuildItem.getValueType());
        }
        for (LeafConfigType leafConfigType : runTimePatterns) {
            Class<?> typeClass = leafConfigType.getItemClass();
            if (typeClass.isPrimitive() || !encountered.add(typeClass) || Converters.getImplicitConverter(typeClass) == null) continue;
            configTypes.add(typeClass);
        }
        configTypes.sort(Comparator.comparing(Class::getName));
        int converterCnt = configTypes.size();
        try (ClassCreator classCreator = new ClassCreator(classOutput, BUILD_TIME_CONFIG, null, Object.class.getName(), new String[0]);){
            classCreator.getFieldCreator(CONVERTERS_FIELD).setModifiers(24);
            classCreator.getFieldCreator(BUILD_TIME_CONFIG_FIELD).setModifiers(73);
            throwable = null;
            try (MethodCreator clinit = classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);){
                clinit.setModifiers(8);
                clinit.invokeStaticMethod(SET_RUNTIME_DEFAULT_PROFILE, new ResultHandle[]{clinit.load(ProfileManager.getActiveProfile())});
                BranchResult inImageBuild = clinit.ifNonZero(clinit.invokeStaticMethod(MethodDescriptor.ofMethod(ImageInfo.class, (String)"inImageBuildtimeCode", Boolean.TYPE, (Class[])new Class[0]), new ResultHandle[0]));
                try (BytecodeCreator yes = inImageBuild.trueBranch();){
                    ResultHandle array = yes.newArray(Converter.class, yes.load(converterCnt));
                    for (int i = 0; i < converterCnt; ++i) {
                        yes.writeArrayValue(array, i, yes.invokeStaticMethod(C_GET_IMPLICIT_CONVERTER, new ResultHandle[]{yes.loadClass((Class)configTypes.get(i))}));
                    }
                    yes.writeStaticField(CONVERTERS_FIELD, array);
                }
                var23_44 = null;
                try (BytecodeCreator no = inImageBuild.falseBranch();){
                    no.writeStaticField(CONVERTERS_FIELD, no.loadNull());
                }
                catch (Throwable array) {
                    var23_44 = array;
                    throw array;
                }
                ResultHandle builder = clinit.newInstance(SRCB_CONSTRUCT, new ResultHandle[0]);
                ResultHandle array = clinit.newArray(ConfigSource[].class, clinit.load(1));
                clinit.writeArrayValue(array, 0, clinit.invokeStaticMethod(BTCF_GET_CONFIG_SOURCE, new ResultHandle[0]));
                clinit.invokeVirtualMethod(SRCB_WITH_SOURCES, builder, new ResultHandle[]{array});
                clinit.invokeVirtualMethod(SRCB_ADD_DEFAULT_SOURCES, builder, new ResultHandle[0]);
                ResultHandle config = clinit.checkCast(clinit.invokeVirtualMethod(SRCB_BUILD, builder, new ResultHandle[0]), SmallRyeConfig.class);
                clinit.writeStaticField(BUILD_TIME_CONFIG_FIELD, clinit.newInstance(MethodDescriptor.ofConstructor((Object)BUILD_TIME_CONFIG_ROOT, (Object[])new Object[]{SmallRyeConfig.class}), new ResultHandle[]{config}));
                this.writeParsing(classCreator, (BytecodeCreator)clinit, config, null, buildTimePatterns);
                clinit.returnValue(null);
            }
            catch (Throwable inImageBuild) {
                throwable = inImageBuild;
                throw inImageBuild;
            }
        }
        var18_24 = null;
        try (ClassCreator classCreator = new ClassCreator(classOutput, RUN_TIME_CONFIG, null, Object.class.getName(), new String[0]);){
            classCreator.getFieldCreator(RUN_TIME_CONFIG_FIELD).setModifiers(73);
            throwable = null;
            try (MethodCreator carc = classCreator.getMethodCreator(CREATE_RUN_TIME_CONFIG);){
                carc.setModifiers(9);
                ResultHandle builder = carc.newInstance(SRCB_CONSTRUCT, new ResultHandle[0]);
                carc.invokeVirtualMethod(SRCB_ADD_DEFAULT_SOURCES, builder, new ResultHandle[0]);
                carc.invokeVirtualMethod(SRCB_ADD_DISCOVERED_SOURCES, builder, new ResultHandle[0]);
                int size = runTimeSources.size();
                if (size > 0) {
                    ResultHandle arrayHandle = carc.newArray(ConfigSource[].class, carc.load(size));
                    for (int i = 0; i < size; ++i) {
                        RunTimeConfigurationSourceBuildItem source = runTimeSources.get(i);
                        OptionalInt priority = source.getPriority();
                        ResultHandle val = priority.isPresent() ? carc.newInstance(MethodDescriptor.ofConstructor((Object)source.getClassName(), (Object[])new Object[]{Integer.TYPE}), new ResultHandle[]{carc.load(priority.getAsInt())}) : carc.newInstance(MethodDescriptor.ofConstructor((String)source.getClassName(), (String[])new String[0]), new ResultHandle[0]);
                        carc.writeArrayValue(arrayHandle, i, val);
                    }
                    carc.invokeVirtualMethod(SRCB_WITH_SOURCES, builder, new ResultHandle[]{arrayHandle});
                }
                ResultHandle defaultSourceArray = carc.newArray(ConfigSource[].class, carc.load(1));
                carc.writeArrayValue(defaultSourceArray, 0, carc.newInstance(RTD_CTOR, new ResultHandle[0]));
                carc.invokeVirtualMethod(SRCB_WITH_SOURCES, builder, new ResultHandle[]{defaultSourceArray});
                carc.invokeStaticMethod(CS_POPULATE_CONVERTERS, new ResultHandle[]{builder});
                for (LeafConfigType item : runTimePatterns) {
                    Class<?> typeClass = item.getItemClass();
                    Class<? extends Converter<?>> itemConverterClass = item.getConverterClass();
                    if (itemConverterClass == null) continue;
                    ResultHandle typeClassHandle = carc.loadClass(typeClass);
                    ResultHandle converter = HyphenateEnumConverter.class.equals(itemConverterClass) ? carc.newInstance(HYPHENATED_ENUM_CONVERTER_CTOR, new ResultHandle[]{typeClassHandle}) : carc.newInstance(MethodDescriptor.ofConstructor(itemConverterClass, (Class[])new Class[0]), new ResultHandle[0]);
                    carc.invokeStaticMethod(CU_EXPLICIT_RUNTIME_CONVERTER, new ResultHandle[]{typeClassHandle, carc.loadClass(itemConverterClass), converter});
                }
                ResultHandle cache = carc.newInstance(ECS_CACHE_CONSTRUCT, new ResultHandle[0]);
                ResultHandle wrapper = carc.invokeStaticMethod(ECS_WRAPPER, new ResultHandle[]{cache});
                carc.invokeVirtualMethod(SRCB_WITH_WRAPPER, builder, new ResultHandle[]{wrapper});
                wrapper = carc.invokeStaticMethod(PROFILE_WRAPPER, new ResultHandle[0]);
                carc.invokeVirtualMethod(SRCB_WITH_WRAPPER, builder, new ResultHandle[]{wrapper});
                BranchResult imgRun = carc.ifNonZero(carc.invokeStaticMethod(II_IN_IMAGE_RUN, new ResultHandle[0]));
                try (BytecodeCreator inImageRun = imgRun.trueBranch();){
                    ResultHandle array = inImageRun.readStaticField(CONVERTERS_FIELD);
                    for (int i = 0; i < converterCnt; ++i) {
                        inImageRun.invokeVirtualMethod(SRCB_WITH_CONVERTER, builder, new ResultHandle[]{inImageRun.loadClass((Class)configTypes.get(i)), inImageRun.load(100), inImageRun.readArrayValue(array, i)});
                    }
                }
                ResultHandle config = carc.checkCast(carc.invokeVirtualMethod(SRCB_BUILD, builder, new ResultHandle[0]), SmallRyeConfig.class);
                carc.invokeStaticMethod(CPR_SET_INSTANCE, new ResultHandle[]{carc.newInstance(SCPR_CONSTRUCT, new ResultHandle[0])});
                carc.invokeVirtualMethod(CPR_REGISTER_CONFIG, carc.invokeStaticMethod(CPR_INSTANCE, new ResultHandle[0]), new ResultHandle[]{config, carc.loadNull()});
                carc.writeStaticField(RUN_TIME_CONFIG_FIELD, carc.newInstance(MethodDescriptor.ofConstructor((Object)RUN_TIME_CONFIG_ROOT, (Object[])new Object[]{SmallRyeConfig.class}), new ResultHandle[]{config}));
                this.writeParsing(classCreator, (BytecodeCreator)carc, config, cache, runTimePatterns);
                carc.returnValue(null);
            }
            catch (Throwable builder) {
                throwable = builder;
                throw builder;
            }
        }
        catch (Throwable carc) {
            var18_24 = carc;
            throw carc;
        }
        var18_24 = null;
        try (ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(RUN_TIME_DEFAULTS).superClass(AbstractRawDefaultConfigSource.class).build();){
            throwable = null;
            try (MethodCreator ctor = classCreator.getMethodCreator(RTD_CTOR);){
                ctor.setModifiers(1);
                ctor.invokeSpecialMethod(ARDCS_CTOR, ctor.getThis(), new ResultHandle[0]);
                ctor.returnValue(null);
            }
            catch (Throwable builder) {
                throwable = builder;
                throw builder;
            }
            throwable = null;
            try (MethodCreator gv = classCreator.getMethodCreator(RTD_GET_VALUE);){
                ResultHandle nameIter = gv.getMethodParam(0);
                gv.ifNonZero(gv.invokeVirtualMethod(NI_HAS_NEXT, nameIter, new ResultHandle[0])).falseBranch().returnValue(gv.loadNull());
                gv.ifNonZero(gv.invokeVirtualMethod(NI_NEXT_EQUALS, nameIter, new ResultHandle[]{gv.load("quarkus")})).falseBranch().returnValue(gv.loadNull());
                gv.invokeVirtualMethod(NI_NEXT, nameIter, new ResultHandle[0]);
                gv.returnValue(gv.invokeVirtualMethod(this.generateGetValue(classCreator, runTimePatterns, new StringBuilder("getValue"), new HashMap<String, MethodDescriptor>()), gv.getThis(), new ResultHandle[]{nameIter}));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var18_24 = throwable3;
            throw throwable3;
        }
        objectLoaderConsumer.accept(new BytecodeRecorderObjectLoaderBuildItem(new ObjectLoader(){

            @Override
            public ResultHandle load(BytecodeCreator body, Object obj, boolean staticInit) {
                if (!this.canHandleObject(obj, staticInit)) {
                    return null;
                }
                boolean buildTime = false;
                ConfigDefinition.RootInfo rootInfo = runTimeConfigDef.getInstanceInfo(obj);
                if (rootInfo == null) {
                    rootInfo = buildTimeConfigDef.getInstanceInfo(obj);
                    buildTime = true;
                }
                FieldDescriptor fieldDescriptor = rootInfo.getFieldDescriptor();
                ResultHandle configRoot = body.readStaticField(buildTime ? BUILD_TIME_CONFIG_FIELD : RUN_TIME_CONFIG_FIELD);
                return body.readInstanceField(fieldDescriptor, configRoot);
            }

            @Override
            public boolean canHandleObject(Object obj, boolean staticInit) {
                boolean buildTime = false;
                ConfigDefinition.RootInfo rootInfo = runTimeConfigDef.getInstanceInfo(obj);
                if (rootInfo == null) {
                    rootInfo = buildTimeConfigDef.getInstanceInfo(obj);
                    buildTime = true;
                }
                if (rootInfo == null || staticInit && !buildTime) {
                    Class<?> objClass = obj.getClass();
                    if (objClass.isAnnotationPresent(ConfigRoot.class)) {
                        String msg = String.format("You are trying to use a ConfigRoot[%s] at static initialization time", objClass.getName());
                        throw new IllegalStateException(msg);
                    }
                    return false;
                }
                return true;
            }
        }));
        runTimeInitConsumer.accept(new RuntimeInitializedClassBuildItem(RUN_TIME_CONFIG));
    }

    private MethodDescriptor generateGetValue(ClassCreator cc, ConfigPatternMap<LeafConfigType> keyMap, StringBuilder methodName, Map<String, MethodDescriptor> cache) {
        String methodNameStr = methodName.toString();
        MethodDescriptor existing = cache.get(methodNameStr);
        if (existing != null) {
            return existing;
        }
        try (MethodCreator body = cc.getMethodCreator(methodNameStr, String.class, new Class[]{NameIterator.class});){
            Object object;
            body.setModifiers(4);
            ResultHandle nameIter = body.getMethodParam(0);
            LeafConfigType matched = keyMap.getMatched();
            try (BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, nameIter, new ResultHandle[0])).falseBranch();){
                if (matched != null) {
                    matchedBody.returnValue(matchedBody.load(matched.getDefaultValueString()));
                } else {
                    matchedBody.returnValue(matchedBody.loadNull());
                }
            }
            boolean hasWildCard = false;
            Iterable<String> names = keyMap.childNames();
            for (String name : names) {
                if (name.equals("{*}")) {
                    hasWildCard = true;
                    continue;
                }
                BytecodeCreator nameMatched = body.ifNonZero(body.invokeVirtualMethod(NI_NEXT_EQUALS, nameIter, new ResultHandle[]{body.load(name)})).trueBranch();
                Throwable throwable = null;
                try {
                    nameMatched.invokeVirtualMethod(NI_NEXT, nameIter, new ResultHandle[0]);
                    int length = methodName.length();
                    methodName.append('_').append(name);
                    ResultHandle result = nameMatched.invokeVirtualMethod(this.generateGetValue(cc, keyMap.getChild(name), methodName, cache), nameMatched.getThis(), new ResultHandle[]{nameIter});
                    methodName.setLength(length);
                    nameMatched.returnValue(result);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (nameMatched == null) continue;
                    if (throwable != null) {
                        try {
                            nameMatched.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    nameMatched.close();
                }
            }
            if (hasWildCard) {
                BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, nameIter, new ResultHandle[0])).trueBranch();
                object = null;
                try {
                    matchedBody.invokeVirtualMethod(NI_NEXT, nameIter, new ResultHandle[0]);
                    int length = methodName.length();
                    methodName.append('_').append("wildcard");
                    ResultHandle result = matchedBody.invokeVirtualMethod(this.generateGetValue(cc, keyMap.getChild("{*}"), methodName, cache), matchedBody.getThis(), new ResultHandle[]{nameIter});
                    methodName.setLength(length);
                    matchedBody.returnValue(result);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (matchedBody != null) {
                        if (object != null) {
                            try {
                                matchedBody.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            matchedBody.close();
                        }
                    }
                }
            }
            body.returnValue(body.loadNull());
            MethodDescriptor md = body.getMethodDescriptor();
            cache.put(methodNameStr, md);
            object = md;
            return object;
        }
    }

    private void writeParsing(ClassCreator cc, BytecodeCreator body, ResultHandle config, ResultHandle cache, ConfigPatternMap<LeafConfigType> keyMap) {
        ResultHandle iterable = body.invokeVirtualMethod(MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getPropertyNames", Iterable.class, (Class[])new Class[0]), config, new ResultHandle[0]);
        ResultHandle iterator = body.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), iterable, new ResultHandle[0]);
        try (BytecodeCreator loop = body.createScope();){
            BranchResult ifHasNext = loop.ifNonZero(loop.invokeInterfaceMethod(ITR_HAS_NEXT, iterator, new ResultHandle[0]));
            try (BytecodeCreator hasNext = ifHasNext.trueBranch();){
                ResultHandle key = hasNext.checkCast(hasNext.invokeInterfaceMethod(ITR_NEXT, iterator, new ResultHandle[0]), String.class);
                ResultHandle keyIter = hasNext.newInstance(MethodDescriptor.ofConstructor(NameIterator.class, (Class[])new Class[]{String.class}), new ResultHandle[]{key});
                hasNext.ifNonZero(hasNext.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch().continueScope(loop);
                hasNext.ifNonZero(hasNext.invokeVirtualMethod(NI_NEXT_EQUALS, keyIter, new ResultHandle[]{hasNext.load("quarkus")})).falseBranch().continueScope(loop);
                hasNext.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                boolean expand = cache != null;
                ResultHandle[] args = expand ? new ResultHandle[]{config, cache, keyIter} : new ResultHandle[]{config, keyIter};
                hasNext.invokeStaticMethod(this.generateParserBody(cc, keyMap, new StringBuilder("parseKey"), new HashMap<String, MethodDescriptor>(), expand), args);
                hasNext.continueScope(loop);
            }
        }
        body.returnValue(body.loadNull());
    }

    private MethodDescriptor generateParserBody(ClassCreator cc, ConfigPatternMap<LeafConfigType> keyMap, StringBuilder methodName, Map<String, MethodDescriptor> parseMethodCache, boolean expand) {
        String methodNameStr = methodName.toString();
        MethodDescriptor existing = parseMethodCache.get(methodNameStr);
        if (existing != null) {
            return existing;
        }
        Class[] argTypes = expand ? new Class[]{SmallRyeConfig.class, ExpandingConfigSource.Cache.class, NameIterator.class} : new Class[]{SmallRyeConfig.class, NameIterator.class};
        try (MethodCreator body = cc.getMethodCreator(methodName.toString(), Void.TYPE, argTypes);){
            Object object;
            body.setModifiers(10);
            ResultHandle config = body.getMethodParam(0);
            ResultHandle cache = expand ? body.getMethodParam(1) : null;
            ResultHandle keyIter = expand ? body.getMethodParam(2) : body.getMethodParam(1);
            LeafConfigType matched = keyMap.getMatched();
            try (BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch();){
                if (matched != null) {
                    matched.generateAcceptConfigurationValue(matchedBody, keyIter, cache, config);
                }
                matchedBody.returnValue(null);
            }
            boolean hasWildCard = false;
            Iterable<String> names = keyMap.childNames();
            for (String name : names) {
                if (name.equals("{*}")) {
                    hasWildCard = true;
                    continue;
                }
                BytecodeCreator nameMatched = body.ifNonZero(body.invokeVirtualMethod(NI_NEXT_EQUALS, keyIter, new ResultHandle[]{body.load(name)})).trueBranch();
                Throwable throwable = null;
                try {
                    nameMatched.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                    int length = methodName.length();
                    methodName.append('_').append(name);
                    ResultHandle[] args = expand ? new ResultHandle[]{config, cache, keyIter} : new ResultHandle[]{config, keyIter};
                    nameMatched.invokeStaticMethod(this.generateParserBody(cc, keyMap.getChild(name), methodName, parseMethodCache, expand), args);
                    methodName.setLength(length);
                    nameMatched.returnValue(null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (nameMatched == null) continue;
                    if (throwable != null) {
                        try {
                            nameMatched.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    nameMatched.close();
                }
            }
            if (hasWildCard) {
                BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).trueBranch();
                object = null;
                try {
                    matchedBody.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                    int length = methodName.length();
                    methodName.append('_').append("wildcard");
                    ResultHandle[] args = expand ? new ResultHandle[]{config, cache, keyIter} : new ResultHandle[]{config, keyIter};
                    matchedBody.invokeStaticMethod(this.generateParserBody(cc, keyMap.getChild("{*}"), methodName, parseMethodCache, expand), args);
                    methodName.setLength(length);
                    matchedBody.returnValue(null);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (matchedBody != null) {
                        if (object != null) {
                            try {
                                matchedBody.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            matchedBody.close();
                        }
                    }
                }
            }
            body.returnValue(null);
            MethodDescriptor md = body.getMethodDescriptor();
            parseMethodCache.put(methodNameStr, md);
            object = md;
            return object;
        }
    }

    @BuildStep
    void writeDefaultConfiguration() {
    }
}

