/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheException;
import io.quarkus.cache.CacheInvalidateAll;
import io.quarkus.cache.runtime.CacheInterceptionContext;
import io.quarkus.cache.runtime.CacheInterceptor;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Function;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@CacheInvalidateAll(cacheName="")
@Interceptor
@Priority(value=0)
public class CacheInvalidateAllInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheInvalidateAllInterceptor.class);
    private static final String INTERCEPTOR_BINDINGS_ERROR_MSG = "The Quarkus cache extension is not working properly (CacheInvalidateAll interceptor bindings retrieval failed), please create a GitHub issue in the Quarkus repository to help the maintainers fix this bug";

    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        CacheInterceptionContext<CacheInvalidateAll> interceptionContext = this.getInterceptionContext(invocationContext, CacheInvalidateAll.class, false);
        if (interceptionContext.getInterceptorBindings().isEmpty()) {
            LOGGER.warn((Object)INTERCEPTOR_BINDINGS_ERROR_MSG);
            return invocationContext.proceed();
        }
        if (CacheInvalidateAllInterceptor.isUniReturnType(invocationContext)) {
            return this.invalidateAllNonBlocking(invocationContext, interceptionContext);
        }
        return this.invalidateAllBlocking(invocationContext, interceptionContext);
    }

    private Object invalidateAllNonBlocking(final InvocationContext invocationContext, CacheInterceptionContext<CacheInvalidateAll> interceptionContext) {
        LOGGER.trace((Object)"Invalidating all cache entries in a non-blocking way");
        return Multi.createFrom().iterable(interceptionContext.getInterceptorBindings()).onItem().transformToUniAndMerge((Function)new Function<CacheInvalidateAll, Uni<? extends Void>>(){

            @Override
            public Uni<Void> apply(CacheInvalidateAll binding) {
                return CacheInvalidateAllInterceptor.this.invalidateAll(binding);
            }
        }).onItem().ignoreAsUni().onItem().transformToUni(new Function<Object, Uni<?>>(){

            @Override
            public Uni<?> apply(Object ignored) {
                try {
                    return (Uni)invocationContext.proceed();
                }
                catch (Exception e) {
                    throw new CacheException(e);
                }
            }
        });
    }

    private Object invalidateAllBlocking(InvocationContext invocationContext, CacheInterceptionContext<CacheInvalidateAll> interceptionContext) throws Exception {
        LOGGER.trace((Object)"Invalidating all cache entries in a blocking way");
        for (CacheInvalidateAll binding : interceptionContext.getInterceptorBindings()) {
            this.invalidateAll(binding).await().indefinitely();
        }
        return invocationContext.proceed();
    }

    private Uni<Void> invalidateAll(CacheInvalidateAll binding) {
        Cache cache = this.cacheManager.getCache(binding.cacheName()).get();
        LOGGER.debugf("Invalidating all entries from cache [%s]", (Object)binding.cacheName());
        return cache.invalidateAll();
    }
}

