/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class ClassPathResourceIndex {
    private static final String IO_QUARKUS = "io/quarkus/";
    private static final String META_INF_MAVEN = "META-INF/maven/";
    private static final String META_INF_SERVICES = "META-INF/services/";
    private static final String META_INF_VERSIONS = "META-INF/versions/";
    private static final int MAX_SEGMENTS_DEFAULT = 3;
    private static final int MAX_SEGMENTS_IO_QUARKUS = 4;
    private static final int MAX_SEGMENTS_META_INF_VERSIONS = 6;
    private static final char SLASH = '/';
    private static final char DOT = '.';
    private final Map<String, ClassPathElement[]> resourceMapping;
    private final Map<String, ClassPathElement> transformedClasses;
    private final Set<String> relodableClasses;
    private final Set<String> parentFirstResources;
    private final Set<String> bannedResources;

    private ClassPathResourceIndex(Map<String, ClassPathElement[]> resourceMapping, Map<String, ClassPathElement> transformedClasses, Set<String> reloadableClasses, Set<String> parentFirstResources, Set<String> bannedResources) {
        this.resourceMapping = resourceMapping.isEmpty() ? Map.of() : Collections.unmodifiableMap(resourceMapping);
        this.transformedClasses = transformedClasses.isEmpty() ? Map.of() : transformedClasses;
        this.relodableClasses = reloadableClasses.isEmpty() ? Set.of() : Collections.unmodifiableSet(reloadableClasses);
        this.parentFirstResources = parentFirstResources.isEmpty() ? Set.of() : Collections.unmodifiableSet(parentFirstResources);
        this.bannedResources = bannedResources.isEmpty() ? Set.of() : Collections.unmodifiableSet(bannedResources);
    }

    public Set<String> getReloadableClasses() {
        return this.relodableClasses;
    }

    public boolean isParentFirst(String resource) {
        return this.parentFirstResources.contains(resource);
    }

    public boolean isBanned(String resource) {
        return this.bannedResources.contains(resource);
    }

    public ClassPathElement getFirstClassPathElement(String resource) {
        ClassPathElement transformedClassClassPathElement = this.transformedClasses.get(resource);
        if (transformedClassClassPathElement != null) {
            return transformedClassClassPathElement;
        }
        ClassPathElement[] candidates = this.resourceMapping.get(ClassPathResourceIndex.getResourceKey(resource));
        if (candidates == null) {
            return null;
        }
        for (int i = 0; i < candidates.length; ++i) {
            if (!candidates[i].getProvidedResources().contains(resource)) continue;
            return candidates[i];
        }
        return null;
    }

    public List<ClassPathElement> getClassPathElements(String resource) {
        ClassPathElement transformedClassClassPathElement = this.transformedClasses.get(resource);
        if (transformedClassClassPathElement != null) {
            return List.of(transformedClassClassPathElement);
        }
        ClassPathElement[] candidates = this.resourceMapping.get(ClassPathResourceIndex.getResourceKey(resource));
        if (candidates == null) {
            return List.of();
        }
        if (candidates.length == 1) {
            if (candidates[0].getProvidedResources().contains(resource)) {
                return List.of(candidates[0]);
            }
            return List.of();
        }
        ArrayList<ClassPathElement> classPathElements = new ArrayList<ClassPathElement>(candidates.length);
        for (int i = 0; i < candidates.length; ++i) {
            if (!candidates[i].getProvidedResources().contains(resource)) continue;
            classPathElements.add(candidates[i]);
        }
        return classPathElements;
    }

    public static Builder builder() {
        return new Builder();
    }

    static String getResourceKey(String resource) {
        if (resource.isEmpty()) {
            return resource;
        }
        if (resource.startsWith(META_INF_MAVEN)) {
            return META_INF_MAVEN;
        }
        if (resource.startsWith(META_INF_SERVICES)) {
            return resource;
        }
        int maxSegments = resource.startsWith(IO_QUARKUS) ? 4 : (resource.startsWith(META_INF_VERSIONS) ? 6 : 3);
        int position = 0;
        for (int i = 0; i < maxSegments; ++i) {
            int slashPosition = resource.indexOf(47, position);
            if (slashPosition <= 0) {
                if (i > 0 && resource.substring(position).indexOf(46) >= 0) break;
                return resource;
            }
            position = slashPosition + 1;
        }
        return resource.substring(0, position - 1);
    }

    public static class Builder {
        private static final String CLASS_SUFFIX = ".class";
        private static final ClassPathElement[] EMPTY_CLASSPATH_ELEMENT = new ClassPathElement[0];
        private final Map<String, ClassPathElement> transformedClassCandidates = new HashMap<String, ClassPathElement>();
        private final Map<String, ClassPathElement> transformedClasses = new HashMap<String, ClassPathElement>();
        private final Map<String, List<ClassPathElement>> resourceMapping = new HashMap<String, List<ClassPathElement>>();
        private final Set<String> reloadableClasses = new HashSet<String>();
        private final Set<String> parentFirstResources = new HashSet<String>();
        private final Set<String> bannedResources = new HashSet<String>();

        public void scanClassPathElement(ClassPathElement classPathElement, BiConsumer<ClassPathElement, String> consumer) {
            for (String resource : classPathElement.getProvidedResources()) {
                consumer.accept(classPathElement, resource);
            }
        }

        public void addTransformedClassCandidate(ClassPathElement classPathElement, String resource) {
            this.transformedClassCandidates.put(resource, classPathElement);
        }

        public void addResourceMapping(ClassPathElement classPathElement, String resource) {
            ClassPathElement transformedClassClassPathElement;
            if (classPathElement.containsReloadableResources() && resource.endsWith(CLASS_SUFFIX)) {
                this.reloadableClasses.add(resource);
            }
            if ((transformedClassClassPathElement = this.transformedClassCandidates.get(resource)) != null) {
                this.transformedClasses.put(resource, transformedClassClassPathElement);
                return;
            }
            String resourcePrefix = ClassPathResourceIndex.getResourceKey(resource);
            List<ClassPathElement> classPathElements = this.resourceMapping.get(resourcePrefix);
            if (classPathElements == null) {
                classPathElements = new ArrayList<ClassPathElement>(2);
                this.resourceMapping.put(resourcePrefix, classPathElements);
            }
            if (!classPathElements.contains(classPathElement)) {
                classPathElements.add(classPathElement);
            }
        }

        public void addParentFirstResource(String resource) {
            this.parentFirstResources.add(resource);
        }

        public void addBannedResource(String resource) {
            this.bannedResources.add(resource);
        }

        public ClassPathResourceIndex build() {
            HashMap<String, ClassPathElement[]> compactedResourceMapping = new HashMap<String, ClassPathElement[]>(this.resourceMapping.size());
            for (Map.Entry<String, List<ClassPathElement>> resourceMappingEntry : this.resourceMapping.entrySet()) {
                compactedResourceMapping.put(resourceMappingEntry.getKey(), resourceMappingEntry.getValue().toArray(EMPTY_CLASSPATH_ELEMENT));
            }
            return new ClassPathResourceIndex(compactedResourceMapping, this.transformedClasses, this.reloadableClasses, this.parentFirstResources, this.bannedResources);
        }
    }
}

