/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.Serializable;
import java.nio.file.Path;

public class AppArtifact
extends AppArtifactCoords
implements ResolvedDependency,
Serializable {
    protected PathsCollection paths;
    private final WorkspaceModule module;
    private final String scope;
    private final int flags;

    public AppArtifact(AppArtifactCoords coords) {
        this(coords, null);
    }

    public AppArtifact(AppArtifactCoords coords, WorkspaceModule module) {
        this(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion(), module, "compile", 0);
    }

    public AppArtifact(String groupId, String artifactId, String version) {
        super(groupId, artifactId, version);
        this.module = null;
        this.scope = "compile";
        this.flags = 0;
    }

    public AppArtifact(String groupId, String artifactId, String classifier, String type, String version) {
        super(groupId, artifactId, classifier, type, version);
        this.module = null;
        this.scope = "compile";
        this.flags = 0;
    }

    public AppArtifact(String groupId, String artifactId, String classifier, String type, String version, WorkspaceModule module, String scope, int flags) {
        super(groupId, artifactId, classifier, type, version);
        this.module = module;
        this.scope = scope;
        this.flags = flags;
    }

    @Deprecated
    public Path getPath() {
        return this.paths.getSinglePath();
    }

    public void setPath(Path path) {
        this.setPaths(PathsCollection.of(path));
    }

    public PathsCollection getPaths() {
        return this.paths;
    }

    public void setPaths(PathsCollection paths) {
        this.paths = paths;
    }

    @Override
    public boolean isResolved() {
        return this.paths != null && !this.paths.isEmpty();
    }

    @Override
    public PathCollection getResolvedPaths() {
        return this.paths == null ? null : PathList.from(this.paths);
    }

    @Override
    public WorkspaceModule getWorkspaceModule() {
        return this.module;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }
}

