/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.workspace;

import io.quarkus.bootstrap.workspace.ProcessedSources;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DefaultWorkspaceModule
implements WorkspaceModule,
Serializable {
    private final WorkspaceModuleId id;
    private final File moduleDir;
    private final File buildDir;
    private final Collection<ProcessedSources> mainSources = new ArrayList<ProcessedSources>(1);
    private final Collection<ProcessedSources> mainResources = new ArrayList<ProcessedSources>(1);
    private final Collection<ProcessedSources> testSources = new ArrayList<ProcessedSources>(1);
    private final Collection<ProcessedSources> testResources = new ArrayList<ProcessedSources>(1);
    private PathCollection buildFiles;

    public DefaultWorkspaceModule(WorkspaceModuleId id, File moduleDir, File buildDir) {
        this.id = id;
        this.moduleDir = moduleDir;
        this.buildDir = buildDir;
    }

    @Override
    public WorkspaceModuleId getId() {
        return this.id;
    }

    @Override
    public File getModuleDir() {
        return this.moduleDir;
    }

    @Override
    public File getBuildDir() {
        return this.buildDir;
    }

    @Override
    public Collection<ProcessedSources> getMainSources() {
        return this.mainSources;
    }

    public void addMainSources(ProcessedSources mainSources) {
        this.mainSources.add(mainSources);
    }

    @Override
    public Collection<ProcessedSources> getMainResources() {
        return this.mainResources;
    }

    public void addMainResources(ProcessedSources mainResources) {
        this.mainResources.add(mainResources);
    }

    @Override
    public Collection<ProcessedSources> getTestSources() {
        return this.testSources;
    }

    public void addTestSources(ProcessedSources testSources) {
        this.testSources.add(testSources);
    }

    @Override
    public Collection<ProcessedSources> getTestResources() {
        return this.testResources;
    }

    public void addTestResources(ProcessedSources testResources) {
        this.testResources.add(testResources);
    }

    public void setBuildFiles(PathCollection buildFiles) {
        this.buildFiles = buildFiles;
    }

    @Override
    public PathCollection getBuildFiles() {
        return this.buildFiles == null ? PathList.empty() : this.buildFiles;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.id);
        buf.append(" ").append(this.moduleDir);
        this.appendSources(buf, "sources", this.getMainSources());
        this.appendSources(buf, "resources", this.getMainResources());
        this.appendSources(buf, "test-sources", this.getTestSources());
        this.appendSources(buf, "test-resources", this.getTestResources());
        return buf.toString();
    }

    private void appendSources(StringBuilder buf, String name, Collection<ProcessedSources> sources) {
        if (!sources.isEmpty()) {
            buf.append(" ").append(name).append("[");
            Iterator<ProcessedSources> i = sources.iterator();
            buf.append(i.next());
            while (i.hasNext()) {
                buf.append(";").append(i.next());
            }
            buf.append("]");
        }
    }
}

