/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.runtime.annotations.Recorder;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

@Recorder
public class ConfigRecorder {
    public void validateConfigProperties(Map<String, Set<String>> properties) {
        Config config = ConfigProviderResolver.instance().getConfig();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ConfigRecorder.class.getClassLoader();
        }
        for (Map.Entry<String, Set<String>> entry : properties.entrySet()) {
            Set<String> propertyTypes = entry.getValue();
            for (String propertyType : propertyTypes) {
                Class<Object> propertyClass = this.load(propertyType, cl);
                if (propertyClass.isArray() || propertyClass.getTypeParameters().length > 0) {
                    propertyClass = String.class;
                }
                try {
                    if (config.getOptionalValue(entry.getKey(), propertyClass).isPresent()) continue;
                    throw new DeploymentException("No config value of type " + entry.getValue() + " exists for: " + entry.getKey());
                }
                catch (IllegalArgumentException e) {
                    throw new DeploymentException((Throwable)e);
                }
            }
        }
    }

    private Class<?> load(String className, ClassLoader cl) {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        try {
            return Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load the config property type: " + className, e);
        }
    }
}

