/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.Startup;
import io.quarkus.runtime.StartupEvent;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class StartupBuildSteps {
    static final DotName STARTUP_NAME = DotName.createSimple((String)Startup.class.getName());
    static final MethodDescriptor ARC_CONTAINER = MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]);
    static final MethodDescriptor ARC_CONTAINER_BEAN = MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor ARC_CONTAINER_INSTANCE = MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class});
    static final MethodDescriptor INSTANCE_HANDLE_GET = MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]);
    static final MethodDescriptor CLIENT_PROXY_CONTEXTUAL_INSTANCE = MethodDescriptor.ofMethod(ClientProxy.class, (String)"arc_contextualInstance", Object.class, (Class[])new Class[0]);
    static final MethodDescriptor CONTEXTUAL_CREATE = MethodDescriptor.ofMethod(Contextual.class, (String)"create", Object.class, (Class[])new Class[]{CreationalContext.class});
    static final MethodDescriptor CONTEXTUAL_DESTROY = MethodDescriptor.ofMethod(Contextual.class, (String)"destroy", Void.TYPE, (Class[])new Class[]{Object.class, CreationalContext.class});
    private static final Logger LOGGER = Logger.getLogger(StartupBuildSteps.class);

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformer(final CustomScopeAnnotationsBuildItem customScopes) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (context.isClass() && !customScopes.isScopeDeclaredOn(context.getTarget().asClass()) && Annotations.contains((Collection)context.getTarget().asClass().classAnnotations(), (DotName)STARTUP_NAME)) {
                    LOGGER.debugf("Found @Startup on a class %s with no scope annotations - adding @ApplicationScoped", (Object)context.getTarget());
                    ((Transformation)context.transform().add(ApplicationScoped.class, new AnnotationValue[0])).done();
                }
            }
        });
    }

    @BuildStep
    UnremovableBeanBuildItem unremovableBeans() {
        return UnremovableBeanBuildItem.targetWithAnnotation(STARTUP_NAME);
    }

    @BuildStep
    void registerStartupObservers(ObserverRegistrationPhaseBuildItem observerRegistrationPhase, BuildProducer<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> configurators) {
        AnnotationStore annotationStore = (AnnotationStore)observerRegistrationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : observerRegistrationPhase.getContext().beans().withTarget()) {
            AnnotationInstance startupAnnotation = annotationStore.getAnnotation((AnnotationTarget)bean.getTarget().get(), STARTUP_NAME);
            if (startupAnnotation == null) continue;
            this.registerStartupObserver(observerRegistrationPhase, bean, startupAnnotation);
        }
    }

    private void registerStartupObserver(ObserverRegistrationPhaseBuildItem observerRegistrationPhase, BeanInfo bean, AnnotationInstance startup) {
        ObserverConfigurator configurator = observerRegistrationPhase.getContext().configure().beanClass(bean.getBeanClass()).observedType(StartupEvent.class);
        if (startup.target().kind() == AnnotationTarget.Kind.METHOD) {
            configurator.id(startup.target().asMethod().toString());
        } else if (startup.target().kind() == AnnotationTarget.Kind.FIELD) {
            configurator.id(startup.target().asField().name());
        }
        AnnotationValue priority = startup.value();
        if (priority != null) {
            configurator.priority(priority.asInt());
        }
        configurator.notify(mc -> {
            ResultHandle containerHandle = mc.invokeStaticMethod(ARC_CONTAINER, new ResultHandle[0]);
            ResultHandle beanHandle = mc.invokeInterfaceMethod(ARC_CONTAINER_BEAN, containerHandle, new ResultHandle[]{mc.load(bean.getIdentifier())});
            if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
                ResultHandle contextHandle = mc.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{beanHandle});
                ResultHandle instanceHandle = mc.invokeInterfaceMethod(CONTEXTUAL_CREATE, beanHandle, new ResultHandle[]{contextHandle});
                mc.invokeInterfaceMethod(CONTEXTUAL_DESTROY, beanHandle, new ResultHandle[]{instanceHandle, contextHandle});
            } else {
                ResultHandle instanceHandle = mc.invokeInterfaceMethod(ARC_CONTAINER_INSTANCE, containerHandle, new ResultHandle[]{beanHandle});
                if (bean.getScope().isNormal()) {
                    ResultHandle proxyHandle = mc.checkCast(mc.invokeInterfaceMethod(INSTANCE_HANDLE_GET, instanceHandle, new ResultHandle[0]), ClientProxy.class);
                    mc.invokeInterfaceMethod(CLIENT_PROXY_CONTEXTUAL_INSTANCE, proxyHandle, new ResultHandle[0]);
                }
            }
            mc.returnValue(null);
        });
        configurator.done();
    }
}

