/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devconsole;

import io.quarkus.arc.deployment.CompletedApplicationClassPredicateBuildItem;
import io.quarkus.arc.deployment.devconsole.DevBeanKind;
import io.quarkus.arc.deployment.devconsole.Name;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class DevBeanInfo
implements Comparable<DevBeanInfo> {
    private final DevBeanKind kind;
    private final boolean isApplicationBean;
    private final Name providerType;
    private final String memberName;
    private final Set<Name> types;
    private final Set<Name> qualifiers;
    private final Name scope;
    private final Name declaringClass;

    public static DevBeanInfo from(BeanInfo bean, CompletedApplicationClassPredicateBuildItem predicate) {
        HashSet<Name> qualifiers = new HashSet<Name>();
        for (Object qualifier : bean.getQualifiers()) {
            qualifiers.add(Name.from((AnnotationInstance)qualifier));
        }
        HashSet<Name> types = new HashSet<Name>();
        for (Type beanType : bean.getTypes()) {
            types.add(Name.from(beanType));
        }
        Name scope = Name.from(bean.getScope().getDotName());
        Name providerType = Name.from(bean.getProviderType());
        if (bean.getTarget().isPresent()) {
            Name declaringClass;
            boolean isApplicationBean;
            DevBeanKind kind;
            String memberName;
            AnnotationTarget target = (AnnotationTarget)bean.getTarget().get();
            if (target.kind() == AnnotationTarget.Kind.METHOD) {
                MethodInfo method = target.asMethod();
                memberName = method.name();
                kind = DevBeanKind.METHOD;
                isApplicationBean = predicate.test(bean.getDeclaringBean().getBeanClass());
                declaringClass = Name.from(bean.getDeclaringBean().getBeanClass());
            } else if (target.kind() == AnnotationTarget.Kind.FIELD) {
                FieldInfo field = target.asField();
                memberName = field.name();
                kind = DevBeanKind.FIELD;
                isApplicationBean = predicate.test(bean.getDeclaringBean().getBeanClass());
                declaringClass = Name.from(bean.getDeclaringBean().getBeanClass());
            } else if (target.kind() == AnnotationTarget.Kind.CLASS) {
                ClassInfo clazz = target.asClass();
                kind = DevBeanKind.CLASS;
                memberName = null;
                isApplicationBean = predicate.test(clazz.name());
                declaringClass = null;
            } else {
                throw new IllegalArgumentException("Invalid annotation target: " + target);
            }
            return new DevBeanInfo(kind, isApplicationBean, providerType, memberName, types, qualifiers, scope, declaringClass);
        }
        return new DevBeanInfo(DevBeanKind.SYNTHETIC, false, providerType, null, types, qualifiers, scope, null);
    }

    public DevBeanInfo(DevBeanKind kind, boolean isApplicationBean, Name providerType, String memberName, Set<Name> types, Set<Name> qualifiers, Name scope, Name declaringClass) {
        this.kind = kind;
        this.isApplicationBean = isApplicationBean;
        this.providerType = providerType;
        this.memberName = memberName;
        this.types = types;
        this.qualifiers = qualifiers;
        this.scope = scope;
        this.declaringClass = declaringClass;
    }

    public DevBeanKind getKind() {
        return this.kind;
    }

    public Name getScope() {
        return this.scope;
    }

    public Set<Name> getQualifiers() {
        return this.qualifiers;
    }

    public Set<Name> getNonDefaultQualifiers() {
        HashSet<Name> nonDefault = new HashSet<Name>();
        String atDefault = DotNames.DEFAULT.toString();
        String atAny = DotNames.ANY.toString();
        for (Name qualifier : this.qualifiers) {
            if (qualifier.toString().endsWith(atDefault) || qualifier.toString().endsWith(atAny)) continue;
            nonDefault.add(qualifier);
        }
        return nonDefault;
    }

    public Set<Name> getTypes() {
        return this.types;
    }

    public Name getProviderType() {
        return this.providerType;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public boolean isApplicationBean() {
        return this.isApplicationBean;
    }

    public Name getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public int compareTo(DevBeanInfo o) {
        if (this.isApplicationBean == o.isApplicationBean) {
            return this.providerType.compareTo(o.providerType);
        }
        return this.isApplicationBean ? -1 : 1;
    }
}

