/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.UndertowMessages;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import io.undertow.predicate.PredicatesHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.JvmRouteHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.AccessControlListHandler;
import io.undertow.server.handlers.DateHandler;
import io.undertow.server.handlers.DisableCacheHandler;
import io.undertow.server.handlers.ExceptionHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.HttpContinueReadHandler;
import io.undertow.server.handlers.HttpTraceHandler;
import io.undertow.server.handlers.IPAddressAccessControlHandler;
import io.undertow.server.handlers.LearningPushHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.PathTemplateHandler;
import io.undertow.server.handlers.PredicateContextHandler;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.server.handlers.ProxyPeerAddressHandler;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.server.handlers.RequestDumpingHandler;
import io.undertow.server.handlers.RequestLimit;
import io.undertow.server.handlers.RequestLimitingHandler;
import io.undertow.server.handlers.ResponseRateLimitingHandler;
import io.undertow.server.handlers.SetAttributeHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.URLDecodingHandler;
import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Handlers {
    public static PathHandler path(HttpHandler defaultHandler) {
        return new PathHandler(defaultHandler);
    }

    public static PathHandler path() {
        return new PathHandler();
    }

    public static PathTemplateHandler pathTemplate() {
        return new PathTemplateHandler();
    }

    public static RoutingHandler routing(boolean rewriteQueryParams) {
        return new RoutingHandler(rewriteQueryParams);
    }

    public static RoutingHandler routing() {
        return new RoutingHandler();
    }

    public static PathTemplateHandler pathTemplate(boolean rewriteQueryParams) {
        return new PathTemplateHandler(rewriteQueryParams);
    }

    public static NameVirtualHostHandler virtualHost() {
        return new NameVirtualHostHandler();
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler defaultHandler) {
        return new NameVirtualHostHandler().setDefaultHandler(defaultHandler);
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler hostHandler, String ... hostnames) {
        NameVirtualHostHandler handler = new NameVirtualHostHandler();
        for (String host : hostnames) {
            handler.addHost(host, hostHandler);
        }
        return handler;
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler defaultHandler, HttpHandler hostHandler, String ... hostnames) {
        return Handlers.virtualHost(hostHandler, hostnames).setDefaultHandler(defaultHandler);
    }

    public static ResourceHandler resource(ResourceManager resourceManager) {
        return new ResourceHandler(resourceManager).setDirectoryListingEnabled(false);
    }

    public static RedirectHandler redirect(String location) {
        return new RedirectHandler(location);
    }

    public static HttpTraceHandler trace(HttpHandler next) {
        return new HttpTraceHandler(next);
    }

    @Deprecated
    public static DateHandler date(HttpHandler next) {
        return new DateHandler(next);
    }

    public static PredicateHandler predicate(Predicate predicate, HttpHandler trueHandler, HttpHandler falseHandler) {
        return new PredicateHandler(predicate, trueHandler, falseHandler);
    }

    public static HttpHandler predicateContext(HttpHandler next) {
        return new PredicateContextHandler(next);
    }

    public static PredicatesHandler predicates(List<PredicatedHandler> handlers, HttpHandler next) {
        PredicatesHandler predicatesHandler = new PredicatesHandler(next);
        for (PredicatedHandler handler : handlers) {
            predicatesHandler.addPredicatedHandler(handler);
        }
        return predicatesHandler;
    }

    public static SetHeaderHandler header(HttpHandler next, String headerName, String headerValue) {
        return new SetHeaderHandler(next, headerName, headerValue);
    }

    public static SetHeaderHandler header(HttpHandler next, String headerName, ExchangeAttribute headerValue) {
        return new SetHeaderHandler(next, headerName, headerValue);
    }

    public static IPAddressAccessControlHandler ipAccessControl(HttpHandler next, boolean defaultAllow) {
        return new IPAddressAccessControlHandler(next).setDefaultAllow(defaultAllow);
    }

    public static AccessControlListHandler acl(HttpHandler next, boolean defaultAllow, ExchangeAttribute attribute) {
        return new AccessControlListHandler(next, attribute).setDefaultAllow(defaultAllow);
    }

    public static HttpContinueReadHandler httpContinueRead(HttpHandler next) {
        return new HttpContinueReadHandler(next);
    }

    public static URLDecodingHandler urlDecoding(HttpHandler next, String charset) {
        return new URLDecodingHandler(next, charset);
    }

    public static SetAttributeHandler setAttribute(HttpHandler next, String attribute, String value, ClassLoader classLoader) {
        return new SetAttributeHandler(next, attribute, value, classLoader);
    }

    public static HttpHandler rewrite(String condition, String target, ClassLoader classLoader, HttpHandler next) {
        return Handlers.predicateContext(Handlers.predicate(PredicateParser.parse(condition, classLoader), Handlers.setAttribute(next, "%R", target, classLoader), next));
    }

    public static HttpHandler urlDecodingHandler(String charset, HttpHandler next) {
        return new URLDecodingHandler(next, charset);
    }

    public static GracefulShutdownHandler gracefulShutdown(HttpHandler next) {
        return new GracefulShutdownHandler(next);
    }

    public static ProxyPeerAddressHandler proxyPeerAddress(HttpHandler next) {
        return new ProxyPeerAddressHandler(next);
    }

    public static JvmRouteHandler jvmRoute(String sessionCookieName, String jvmRoute, HttpHandler next) {
        return new JvmRouteHandler(next, sessionCookieName, jvmRoute);
    }

    public static RequestLimitingHandler requestLimitingHandler(int maxRequest, int queueSize, HttpHandler next) {
        return new RequestLimitingHandler(maxRequest, queueSize, next);
    }

    public static RequestLimitingHandler requestLimitingHandler(RequestLimit requestLimit, HttpHandler next) {
        return new RequestLimitingHandler(requestLimit, next);
    }

    public static HttpHandler disableCache(HttpHandler next) {
        return new DisableCacheHandler(next);
    }

    public static HttpHandler requestDump(HttpHandler next) {
        return new RequestDumpingHandler(next);
    }

    public static ExceptionHandler exceptionHandler(HttpHandler next) {
        return new ExceptionHandler(next);
    }

    public static ResponseRateLimitingHandler responseRateLimitingHandler(HttpHandler next, int bytes, long time, TimeUnit timeUnit) {
        return new ResponseRateLimitingHandler(next, bytes, time, timeUnit);
    }

    public static LearningPushHandler learningPushHandler(int maxEntries, int maxAge, HttpHandler next) {
        return new LearningPushHandler(maxEntries, maxAge, next);
    }

    public static LearningPushHandler learningPushHandler(int maxEntries, HttpHandler next) {
        return new LearningPushHandler(maxEntries, -1, next);
    }

    private Handlers() {
    }

    public static void handlerNotNull(HttpHandler handler) {
        if (handler == null) {
            throw UndertowMessages.MESSAGES.handlerCannotBeNull();
        }
    }
}

