/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Opcode;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

final class Invoke
extends Item {
    private final ClassDesc owner;
    private final String name;
    private final MethodTypeDesc type;
    private final GenericType genericType;
    private final Item instance;
    private final List<Item> args;
    private final Opcode opcode;
    private final boolean isInterface;

    Invoke(Opcode opcode, MethodDesc desc, Expr instance, List<? extends Expr> args, GenericType genericType) {
        this(desc.owner(), desc.name(), (MethodTypeDesc)desc.type(), opcode, desc instanceof InterfaceMethodDesc, (Item)instance, Util.reinterpretCast(args), genericType);
    }

    Invoke(ConstructorDesc desc, Expr instance, List<? extends Expr> args, GenericType genericType) {
        this(desc.owner(), "<init>", desc.type(), Opcode.INVOKESPECIAL, false, (Item)instance, Util.reinterpretCast(args), genericType);
    }

    private Invoke(ClassDesc owner, String name, MethodTypeDesc type, Opcode opcode, boolean isInterface, Item instance, List<Item> args, GenericType genericType) {
        this.genericType = genericType;
        if (type.parameterCount() != args.size()) {
            String paramsStr = type.parameterCount() == 1 ? "1 parameter" : type.parameterCount() + " parameters";
            String argsStr = args.size() == 1 ? "1 argument was" : args.size() + " arguments were";
            throw new IllegalArgumentException("Method " + owner.displayName() + "." + name + "() takes " + paramsStr + ", but " + argsStr + " passed");
        }
        if (instance != null) {
            instance = Conversions.convert(instance, owner);
        }
        ArrayList<Item> newArgs = new ArrayList<Item>(args.size());
        for (int i = 0; i < args.size(); ++i) {
            try {
                newArgs.add(Conversions.convert(args.get(i), type.parameterType(i)));
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Parameter " + i + " of method " + owner.displayName() + "." + name + "() is of type '" + type.parameterType(i).displayName() + "', but given argument is '" + args.get(i).type().displayName() + "'");
            }
        }
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.opcode = opcode;
        this.isInterface = isInterface;
        this.instance = instance;
        this.args = newArgs;
    }

    @Override
    public String itemName() {
        return "Invoke:" + this.owner.displayName() + "." + this.name;
    }

    @Override
    public ClassDesc type() {
        return this.type.returnType();
    }

    @Override
    public GenericType genericType() {
        return this.genericType;
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        node = node.prev();
        int size = this.args.size();
        for (int i = size - 1; i >= 0; --i) {
            node = this.args.get(i).process(node, op);
        }
        if (this.instance != null) {
            node = this.instance.process(node, op);
        }
        return node;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        cb.invoke(this.opcode, this.owner, this.name, this.type, this.isInterface);
    }
}

