/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Grouping {
    public static <E, G> List<G> of(Collection<E> elements, int groupLimit, Builder<E, G> builder) {
        ArrayList<G> groups = new ArrayList<G>(elements.size() / groupLimit + 1);
        ArrayList<E> elementsInGroup = new ArrayList<E>(groupLimit);
        for (E element : elements) {
            elementsInGroup.add(element);
            if (elementsInGroup.size() != groupLimit) continue;
            groups.add(builder.apply(groups.size(), List.copyOf(elementsInGroup)));
            elementsInGroup.clear();
        }
        if (!elementsInGroup.isEmpty()) {
            groups.add(builder.apply(groups.size(), List.copyOf(elementsInGroup)));
        }
        return List.copyOf(groups);
    }

    @FunctionalInterface
    public static interface Builder<E, G> {
        public G apply(int var1, List<E> var2);
    }
}

