/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableObserverMethod;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.CurrentInjectionPointProvider;
import io.quarkus.arc.impl.Mockable;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Hashes;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.EventContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class ObserverGenerator
extends AbstractGenerator {
    static final String OBSERVER_SUFFIX = "_Observer";
    static final String OBSERVERVED_TYPE = "observedType";
    static final String QUALIFIERS = "qualifiers";
    static final String DECLARING_PROVIDER_SUPPLIER = "declaringProviderSupplier";
    private final AnnotationLiteralProcessor annotationLiterals;
    private final Predicate<DotName> applicationClassPredicate;
    private final BeanProcessor.PrivateMembersCollector privateMembers;
    private final ReflectionRegistration reflectionRegistration;
    private final Set<String> existingClasses;
    private final Map<ObserverInfo, String> observerToGeneratedName;
    private final Predicate<DotName> injectionPointAnnotationsPredicate;
    private final boolean mockable;

    public ObserverGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, BeanProcessor.PrivateMembersCollector privateMembers, boolean generateSources, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, Map<ObserverInfo, String> observerToGeneratedName, Predicate<DotName> injectionPointAnnotationsPredicate, boolean mockable) {
        super(generateSources);
        this.annotationLiterals = annotationLiterals;
        this.applicationClassPredicate = applicationClassPredicate;
        this.privateMembers = privateMembers;
        this.reflectionRegistration = reflectionRegistration;
        this.existingClasses = existingClasses;
        this.observerToGeneratedName = observerToGeneratedName;
        this.injectionPointAnnotationsPredicate = injectionPointAnnotationsPredicate;
        this.mockable = mockable;
    }

    Collection<ResourceOutput.Resource> generate(ObserverInfo observer) {
        ClassInfo declaringClass;
        String classBase = observer.isSynthetic() ? DotNames.simpleName(observer.getBeanClass()) : ((declaringClass = observer.getObserverMethod().declaringClass()).enclosingClass() != null ? DotNames.simpleName(declaringClass.enclosingClass()) + "_" + DotNames.simpleName(declaringClass) : DotNames.simpleName(declaringClass));
        StringBuilder sigBuilder = new StringBuilder();
        if (observer.isSynthetic()) {
            if (observer.getId() != null) {
                sigBuilder.append(observer.getId());
            }
            sigBuilder.append(observer.getObservedType().toString()).append(observer.getQualifiers().toString()).append(observer.isAsync()).append(observer.getPriority()).append(observer.getTransactionPhase());
        } else {
            sigBuilder.append(observer.getObserverMethod().name()).append("_").append(observer.getObserverMethod().returnType().name().toString());
            for (org.jboss.jandex.Type paramType : observer.getObserverMethod().parameters()) {
                sigBuilder.append(paramType.name().toString());
            }
        }
        StringBuilder baseName = new StringBuilder();
        baseName.append(classBase).append(OBSERVER_SUFFIX).append("_");
        if (observer.isSynthetic()) {
            baseName.append("Synthetic");
        } else {
            baseName.append(observer.getObserverMethod().name());
        }
        baseName.append("_").append(Hashes.sha1(sigBuilder.toString()));
        String targetPackage = observer.isSynthetic() ? DotNames.packageName(observer.getBeanClass()) : DotNames.packageName(observer.getObserverMethod().declaringClass().name());
        String generatedName = ObserverGenerator.generatedNameFromTarget(targetPackage, baseName.toString(), "");
        Optional<Map.Entry> generatedClass = this.observerToGeneratedName.entrySet().stream().filter(e -> ((String)e.getValue()).equals(generatedName)).findAny();
        this.observerToGeneratedName.put(observer, generatedName);
        if (generatedClass.isPresent()) {
            if (observer.isSynthetic()) {
                throw new IllegalStateException("A synthetic observer with the generated class name " + generatedName + " already exists for " + generatedClass.get().getKey());
            }
            return Collections.emptyList();
        }
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(observer.getBeanClass());
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.OBSERVER : null, this.generateSources);
        ArrayList<Class> interfaces = new ArrayList<Class>();
        interfaces.add(InjectableObserverMethod.class);
        if (this.mockable) {
            interfaces.add(Mockable.class);
        }
        ClassCreator observerCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(interfaces.toArray(new Class[0])).build();
        FieldCreator observedType = (FieldCreator)observerCreator.getFieldCreator(OBSERVERVED_TYPE, Type.class).setModifiers(18);
        FieldCreator observedQualifiers = null;
        if (!observer.getQualifiers().isEmpty()) {
            observedQualifiers = (FieldCreator)observerCreator.getFieldCreator(QUALIFIERS, Set.class).setModifiers(18);
        }
        if (this.mockable) {
            observerCreator.getFieldCreator("mock", Boolean.TYPE).setModifiers(66);
        }
        HashMap<InjectionPointInfo, String> injectionPointToProviderField = new HashMap<InjectionPointInfo, String>();
        this.initMaps(observer, injectionPointToProviderField);
        this.createProviderFields(observerCreator, observer, injectionPointToProviderField);
        this.createConstructor(classOutput, observerCreator, observer, baseName.toString(), injectionPointToProviderField, this.annotationLiterals, this.reflectionRegistration);
        this.implementGetObservedType(observerCreator, observedType.getFieldDescriptor());
        if (observedQualifiers != null) {
            this.implementGetObservedQualifiers(observerCreator, observedQualifiers.getFieldDescriptor());
        }
        if (!observer.getTransactionPhase().equals((Object)TransactionPhase.IN_PROGRESS)) {
            this.implementGetTransactionPhase(observerCreator, observer);
        }
        this.implementGetBeanClass(observerCreator, observer.getBeanClass());
        this.implementNotify(observer, observerCreator, injectionPointToProviderField, this.reflectionRegistration, isApplicationClass);
        if (observer.getPriority() != 2500) {
            this.implementGetPriority(observerCreator, observer);
        }
        if (observer.isAsync()) {
            this.implementIsAsync(observerCreator);
        }
        this.implementGetDeclaringBeanIdentifier(observerCreator, observer.getDeclaringBean());
        if (this.mockable) {
            this.implementMockMethods(observerCreator);
        }
        observerCreator.close();
        return classOutput.getResources();
    }

    protected void initMaps(ObserverInfo observer, Map<InjectionPointInfo, String> injectionPointToProvider) {
        if (observer.isSynthetic()) {
            return;
        }
        int providerIdx = 1;
        for (InjectionPointInfo injectionPoint : observer.getInjection().injectionPoints) {
            if (injectionPoint.getRequiredType().name().equals((Object)DotNames.EVENT_METADATA)) continue;
            injectionPointToProvider.put(injectionPoint, "observerProviderSupplier" + providerIdx++);
        }
    }

    protected void implementGetObservedType(ClassCreator observerCreator, FieldDescriptor observedTypeField) {
        MethodCreator getObservedType = (MethodCreator)observerCreator.getMethodCreator("getObservedType", Type.class, new Class[0]).setModifiers(1);
        getObservedType.returnValue(getObservedType.readInstanceField(observedTypeField, getObservedType.getThis()));
    }

    protected void implementGetObservedQualifiers(ClassCreator observerCreator, FieldDescriptor observedQualifiersField) {
        MethodCreator getObservedQualifiers = (MethodCreator)observerCreator.getMethodCreator("getObservedQualifiers", Set.class, new Class[0]).setModifiers(1);
        getObservedQualifiers.returnValue(getObservedQualifiers.readInstanceField(observedQualifiersField, getObservedQualifiers.getThis()));
    }

    protected void implementGetTransactionPhase(ClassCreator observerCreator, ObserverInfo observer) {
        MethodCreator getTransactionPhase = (MethodCreator)observerCreator.getMethodCreator("getTransactionPhase", TransactionPhase.class, new Class[0]).setModifiers(1);
        getTransactionPhase.returnValue(getTransactionPhase.load((Enum)observer.getTransactionPhase()));
    }

    protected void implementGetBeanClass(ClassCreator observerCreator, DotName beanClass) {
        MethodCreator getBeanClass = (MethodCreator)observerCreator.getMethodCreator("getBeanClass", Class.class, new Class[0]).setModifiers(1);
        getBeanClass.returnValue(getBeanClass.loadClass(beanClass.toString()));
    }

    protected void implementGetPriority(ClassCreator observerCreator, ObserverInfo observer) {
        MethodCreator getPriority = (MethodCreator)observerCreator.getMethodCreator("getPriority", Integer.TYPE, new Class[0]).setModifiers(1);
        getPriority.returnValue(getPriority.load(observer.getPriority()));
    }

    protected void implementIsAsync(ClassCreator observerCreator) {
        MethodCreator isAsync = (MethodCreator)observerCreator.getMethodCreator("isAsync", Boolean.TYPE, new Class[0]).setModifiers(1);
        isAsync.returnValue(isAsync.load(true));
    }

    protected void implementGetDeclaringBeanIdentifier(ClassCreator observerCreator, BeanInfo declaringBean) {
        MethodCreator getDeclaringBeanIdentifier = (MethodCreator)observerCreator.getMethodCreator("getDeclaringBeanIdentifier", String.class, new Class[0]).setModifiers(1);
        getDeclaringBeanIdentifier.returnValue(declaringBean != null ? getDeclaringBeanIdentifier.load(declaringBean.getIdentifier()) : getDeclaringBeanIdentifier.loadNull());
    }

    protected void implementNotify(ObserverInfo observer, ClassCreator observerCreator, Map<InjectionPointInfo, String> injectionPointToProviderField, ReflectionRegistration reflectionRegistration, boolean isApplicationClass) {
        BranchResult doesNotExist;
        ResultHandle context;
        ResultHandle scope;
        ResultHandle container;
        ResultHandle declaringProviderHandle;
        MethodCreator notify = (MethodCreator)observerCreator.getMethodCreator("notify", Void.TYPE, new Class[]{EventContext.class}).setModifiers(1);
        if (observer.isSynthetic()) {
            observer.getNotify().accept(notify);
            return;
        }
        if (this.mockable) {
            ResultHandle mock = notify.readInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)"mock", (String)Boolean.TYPE.getName()), notify.getThis());
            notify.ifTrue(mock).trueBranch().returnValue(null);
        }
        boolean isStatic = Modifier.isStatic(observer.getObserverMethod().flags());
        boolean skipRelease = observer.getInjection().injectionPoints.isEmpty();
        AssignableResultHandle declaringProviderInstanceHandle = notify.createVariable(Object.class);
        ResultHandle ctxHandle = skipRelease ? notify.loadNull() : notify.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{notify.loadNull()});
        AssignableResultHandle declaringProviderCtx = notify.createVariable(CreationalContextImpl.class);
        if (isStatic) {
            declaringProviderHandle = notify.loadNull();
        } else {
            ResultHandle declaringProviderSupplierHandle = notify.readInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)DECLARING_PROVIDER_SUPPLIER, (String)Supplier.class.getName()), notify.getThis());
            declaringProviderHandle = notify.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, declaringProviderSupplierHandle, new ResultHandle[0]);
        }
        if (isStatic) {
            notify.assign(declaringProviderInstanceHandle, notify.loadNull());
        } else if (Reception.IF_EXISTS == observer.getReception() && !BuiltinScope.DEPENDENT.is(observer.getDeclaringBean().getScope())) {
            container = notify.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]);
            scope = notify.loadClass(observer.getDeclaringBean().getScope().getDotName().toString());
            context = notify.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_GET_ACTIVE_CONTEXT, container, new ResultHandle[]{scope});
            notify.ifNull(context).trueBranch().returnValue(null);
            notify.assign(declaringProviderInstanceHandle, notify.invokeInterfaceMethod(MethodDescriptors.CONTEXT_GET_IF_PRESENT, context, new ResultHandle[]{declaringProviderHandle}));
            doesNotExist = notify.ifNull((ResultHandle)declaringProviderInstanceHandle);
            doesNotExist.trueBranch().returnValue(null);
        } else if (BuiltinScope.DEPENDENT.is(observer.getDeclaringBean().getScope())) {
            notify.assign(declaringProviderCtx, notify.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{declaringProviderHandle}));
            notify.assign(declaringProviderInstanceHandle, notify.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, declaringProviderHandle, new ResultHandle[]{declaringProviderCtx}));
        } else {
            container = notify.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]);
            scope = notify.loadClass(observer.getDeclaringBean().getScope().getDotName().toString());
            context = notify.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_GET_ACTIVE_CONTEXT, container, new ResultHandle[]{scope});
            notify.ifNull(context).trueBranch().throwException(ContextNotActiveException.class, "Context not active: " + observer.getDeclaringBean().getScope().getDotName());
            notify.assign(declaringProviderInstanceHandle, notify.invokeInterfaceMethod(MethodDescriptors.CONTEXT_GET_IF_PRESENT, context, new ResultHandle[]{declaringProviderHandle}));
            doesNotExist = notify.ifNull((ResultHandle)declaringProviderInstanceHandle).trueBranch();
            doesNotExist.assign(declaringProviderInstanceHandle, doesNotExist.invokeInterfaceMethod(MethodDescriptors.CONTEXT_GET, context, new ResultHandle[]{declaringProviderHandle, doesNotExist.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{declaringProviderHandle})}));
        }
        ResultHandle[] referenceHandles = new ResultHandle[observer.getObserverMethod().parameters().size()];
        short eventParamPosition = observer.getEventParameter().position();
        Iterator<InjectionPointInfo> injectionPointsIterator = observer.getInjection().injectionPoints.iterator();
        for (int i = 0; i < observer.getObserverMethod().parameters().size(); ++i) {
            ResultHandle referenceHandle;
            if (i == eventParamPosition) {
                referenceHandles[i] = notify.invokeInterfaceMethod(MethodDescriptors.EVENT_CONTEXT_GET_EVENT, notify.getMethodParam(0), new ResultHandle[0]);
                continue;
            }
            if (i == observer.getEventMetadataParameterPosition()) {
                referenceHandles[i] = notify.invokeInterfaceMethod(MethodDescriptors.EVENT_CONTEXT_GET_METADATA, notify.getMethodParam(0), new ResultHandle[0]);
                continue;
            }
            ResultHandle childCtxHandle = notify.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD, new ResultHandle[]{ctxHandle});
            ResultHandle providerSupplierHandle = notify.readInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPointsIterator.next()), (String)Supplier.class.getName()), notify.getThis());
            ResultHandle providerHandle = notify.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
            referenceHandles[i] = referenceHandle = notify.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtxHandle});
        }
        if (Modifier.isPrivate(observer.getObserverMethod().flags())) {
            this.privateMembers.add(isApplicationClass, String.format("Observer method %s#%s()", observer.getObserverMethod().declaringClass().name(), observer.getObserverMethod().name()));
            ResultHandle paramTypesArray = notify.newArray(Class.class, notify.load(referenceHandles.length));
            ResultHandle argsArray = notify.newArray(Object.class, notify.load(referenceHandles.length));
            for (int i = 0; i < referenceHandles.length; ++i) {
                notify.writeArrayValue(paramTypesArray, i, notify.loadClass(((org.jboss.jandex.Type)observer.getObserverMethod().parameters().get(i)).name().toString()));
                notify.writeArrayValue(argsArray, i, referenceHandles[i]);
            }
            reflectionRegistration.registerMethod(observer.getObserverMethod());
            notify.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{notify.loadClass(observer.getObserverMethod().declaringClass().name().toString()), notify.load(observer.getObserverMethod().name()), paramTypesArray, declaringProviderInstanceHandle, argsArray});
        } else if (isStatic) {
            notify.invokeStaticMethod(MethodDescriptor.of((MethodInfo)observer.getObserverMethod()), referenceHandles);
        } else {
            notify.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)observer.getObserverMethod()), (ResultHandle)declaringProviderInstanceHandle, referenceHandles);
        }
        if (!skipRelease) {
            notify.invokeInterfaceMethod(MethodDescriptors.CREATIONAL_CTX_RELEASE, ctxHandle, new ResultHandle[0]);
        }
        if (!isStatic && BuiltinScope.DEPENDENT.is(observer.getDeclaringBean().getScope())) {
            notify.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_BEAN_DESTROY, declaringProviderHandle, new ResultHandle[]{declaringProviderInstanceHandle, declaringProviderCtx});
        }
        notify.returnValue(null);
    }

    protected void createProviderFields(ClassCreator observerCreator, ObserverInfo observer, Map<InjectionPointInfo, String> injectionPointToProvider) {
        observerCreator.getFieldCreator(DECLARING_PROVIDER_SUPPLIER, Supplier.class).setModifiers(18);
        for (String provider : injectionPointToProvider.values()) {
            observerCreator.getFieldCreator(provider, Supplier.class).setModifiers(18);
        }
    }

    protected void createConstructor(ClassOutput classOutput, ClassCreator observerCreator, ObserverInfo observer, String baseName, Map<InjectionPointInfo, String> injectionPointToProviderField, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration) {
        MethodCreator constructor;
        if (observer.isSynthetic()) {
            constructor = observerCreator.getMethodCreator("<init>", "V", new String[0]);
            constructor.invokeSpecialMethod(MethodDescriptors.OBJECT_CONSTRUCTOR, constructor.getThis(), new ResultHandle[0]);
        } else {
            ArrayList<String> parameterTypes = new ArrayList<String>();
            parameterTypes.add(Supplier.class.getName());
            for (InjectionPointInfo injectionPointInfo : observer.getInjection().injectionPoints) {
                if (BuiltinBean.resolve(injectionPointInfo) != null) continue;
                parameterTypes.add(Supplier.class.getName());
            }
            constructor = observerCreator.getMethodCreator("<init>", "V", parameterTypes.toArray(new String[0]));
            constructor.invokeSpecialMethod(MethodDescriptors.OBJECT_CONSTRUCTOR, constructor.getThis(), new ResultHandle[0]);
            int paramIdx = 0;
            constructor.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)DECLARING_PROVIDER_SUPPLIER, (String)Supplier.class.getName()), constructor.getThis(), constructor.getMethodParam(0));
            ++paramIdx;
            for (InjectionPointInfo injectionPoint : observer.getInjection().injectionPoints) {
                BuiltinBean builtinBean = null;
                if (injectionPoint.getResolvedBean() == null) {
                    builtinBean = BuiltinBean.resolve(injectionPoint);
                }
                if (builtinBean != null) {
                    builtinBean.getGenerator().generate(new BuiltinBean.GeneratorContext(classOutput, observer.getDeclaringBean().getDeployment(), injectionPoint, observerCreator, constructor, injectionPointToProviderField.get(injectionPoint), annotationLiterals, observer, reflectionRegistration, this.injectionPointAnnotationsPredicate));
                    continue;
                }
                if (injectionPoint.getResolvedBean().getAllInjectionPoints().stream().anyMatch(ip -> BuiltinBean.INJECTION_POINT.hasRawTypeDotName(ip.getRequiredType().name()))) {
                    ResultHandle requiredQualifiersHandle = BeanGenerator.collectInjectionPointQualifiers(classOutput, observerCreator, observer.getDeclaringBean().getDeployment(), constructor, injectionPoint, annotationLiterals);
                    ResultHandle annotationsHandle = BeanGenerator.collectInjectionPointAnnotations(classOutput, observerCreator, observer.getDeclaringBean().getDeployment(), constructor, injectionPoint, annotationLiterals, this.injectionPointAnnotationsPredicate);
                    ResultHandle javaMemberHandle = BeanGenerator.getJavaMemberHandle(constructor, injectionPoint, reflectionRegistration);
                    ResultHandle delegateSupplier = constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{constructor.getMethodParam(paramIdx)});
                    ResultHandle wrapHandle = constructor.newInstance(MethodDescriptor.ofConstructor(CurrentInjectionPointProvider.class, (Class[])new Class[]{InjectableBean.class, Supplier.class, Type.class, Set.class, Set.class, Member.class, Integer.TYPE}), new ResultHandle[]{constructor.loadNull(), delegateSupplier, Types.getTypeHandle((BytecodeCreator)constructor, injectionPoint.getRequiredType()), requiredQualifiersHandle, annotationsHandle, javaMemberHandle, constructor.load(injectionPoint.getPosition())});
                    ResultHandle wrapSupplierHandle = constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{wrapHandle});
                    constructor.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPoint), (String)Supplier.class.getName()), constructor.getThis(), wrapSupplierHandle);
                } else {
                    constructor.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPoint), (String)Supplier.class.getName()), constructor.getThis(), constructor.getMethodParam(paramIdx));
                }
                ++paramIdx;
            }
        }
        constructor.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)OBSERVERVED_TYPE, (String)Type.class.getName()), constructor.getThis(), Types.getTypeHandle((BytecodeCreator)constructor, observer.getObservedType()));
        Set<AnnotationInstance> qualifiers = observer.getQualifiers();
        if (!qualifiers.isEmpty()) {
            ResultHandle qualifiersHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance qualifierAnnotation : qualifiers) {
                BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                if (qualifier != null) {
                    constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiersHandle, new ResultHandle[]{qualifier.getLiteralInstance((BytecodeCreator)constructor)});
                    continue;
                }
                ClassInfo qualifierClass = observer.getBeanDeployment().getQualifier(qualifierAnnotation.name());
                constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiersHandle, new ResultHandle[]{annotationLiterals.process((BytecodeCreator)constructor, classOutput, qualifierClass, qualifierAnnotation, Types.getPackageName(observerCreator.getClassName()))});
            }
            ResultHandle resultHandle = constructor.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"unmodifiableSet", Set.class, (Class[])new Class[]{Set.class}), new ResultHandle[]{qualifiersHandle});
            constructor.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)QUALIFIERS, (String)Set.class.getName()), constructor.getThis(), resultHandle);
        }
        if (this.mockable) {
            constructor.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)"mock", (String)Boolean.TYPE.getName()), constructor.getThis(), constructor.load(false));
        }
        constructor.returnValue(null);
    }

    private void implementMockMethods(ClassCreator observerCreator) {
        MethodCreator clear = observerCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)observerCreator.getClassName(), (String)"arc$clearMock", Void.TYPE, (Object[])new Object[0]));
        clear.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)"mock", Boolean.TYPE), clear.getThis(), clear.load(false));
        clear.returnValue(null);
        MethodCreator set = observerCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)observerCreator.getClassName(), (String)"arc$setMock", Void.TYPE, (Object[])new Object[]{Object.class}));
        set.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)"mock", Boolean.TYPE), set.getThis(), set.load(true));
        set.returnValue(null);
    }
}

