/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.AlternativePriority;
import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.impl.ComputingCache;
import java.lang.annotation.Repeatable;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Priority;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.control.ActivateRequestContext;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.TransientReference;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.Nonbinding;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InterceptorBinding;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public final class DotNames {
    private static final ComputingCache<String, DotName> NAMES = new ComputingCache(DotNames::create);
    public static final DotName OBJECT = DotNames.create(Object.class);
    public static final DotName OBSERVES = DotNames.create(Observes.class);
    public static final DotName OBSERVES_ASYNC = DotNames.create(ObservesAsync.class);
    public static final DotName PRODUCES = DotNames.create(Produces.class);
    public static final DotName DISPOSES = DotNames.create(Disposes.class);
    public static final DotName QUALIFIER = DotNames.create(Qualifier.class);
    public static final DotName REPEATABLE = DotNames.create(Repeatable.class);
    public static final DotName NONBINDING = DotNames.create(Nonbinding.class);
    public static final DotName INJECT = DotNames.create(Inject.class);
    public static final DotName POST_CONSTRUCT = DotNames.create(PostConstruct.class);
    public static final DotName PRE_DESTROY = DotNames.create(PreDestroy.class);
    public static final DotName INSTANCE = DotNames.create(Instance.class);
    public static final DotName INJECTABLE_INSTANCE = DotNames.create(InjectableInstance.class);
    public static final DotName PROVIDER = DotNames.create(Provider.class);
    public static final DotName INJECTION_POINT = DotNames.create(InjectionPoint.class);
    public static final DotName INTERCEPTOR = DotNames.create(Interceptor.class);
    public static final DotName INTERCEPTOR_BINDING = DotNames.create(InterceptorBinding.class);
    public static final DotName INTERCEPTED = DotNames.create(Intercepted.class);
    public static final DotName AROUND_INVOKE = DotNames.create(AroundInvoke.class);
    public static final DotName AROUND_CONSTRUCT = DotNames.create(AroundConstruct.class);
    public static final DotName PRIORITY = DotNames.create(Priority.class);
    public static final DotName DEFAULT = DotNames.create(Default.class);
    public static final DotName ANY = DotNames.create(Any.class);
    public static final DotName BEAN = DotNames.create(Bean.class);
    public static final DotName BEAN_MANAGER = DotNames.create(BeanManager.class);
    public static final DotName EVENT = DotNames.create(Event.class);
    public static final DotName EVENT_METADATA = DotNames.create(EventMetadata.class);
    public static final DotName ALTERNATIVE = DotNames.create(Alternative.class);
    public static final DotName ALTERNATIVE_PRIORITY = DotNames.create(AlternativePriority.class);
    public static final DotName DEFAULT_BEAN = DotNames.create(DefaultBean.class);
    public static final DotName SINGLETON = DotNames.create(Singleton.class);
    public static final DotName STEREOTYPE = DotNames.create(Stereotype.class);
    public static final DotName TYPED = DotNames.create(Typed.class);
    public static final DotName VETOED = DotNames.create(Vetoed.class);
    public static final DotName CLASS = DotNames.create(Class.class);
    public static final DotName ENUM = DotNames.create(Enum.class);
    public static final DotName EXTENSION = DotNames.create(Extension.class);
    public static final DotName OPTIONAL = DotNames.create(Optional.class);
    public static final DotName NAMED = DotNames.create(Named.class);
    public static final DotName ACTIVATE_REQUEST_CONTEXT = DotNames.create(ActivateRequestContext.class);
    public static final DotName TRANSACTION_PHASE = DotNames.create(TransactionPhase.class);
    public static final DotName INITIALIZED = DotNames.create(Initialized.class);
    public static final DotName TRANSIENT_REFERENCE = DotNames.create(TransientReference.class);
    public static final DotName BOOLEAN = DotNames.create(Boolean.class);
    public static final DotName BYTE = DotNames.create(Byte.class);
    public static final DotName CHARACTER = DotNames.create(Character.class);
    public static final DotName DOUBLE = DotNames.create(Double.class);
    public static final DotName FLOAT = DotNames.create(Float.class);
    public static final DotName INTEGER = DotNames.create(Integer.class);
    public static final DotName LONG = DotNames.create(Long.class);
    public static final DotName SHORT = DotNames.create(Short.class);
    public static final DotName STRING = DotNames.create(String.class);
    public static final DotName DEPRECATED = DotNames.create(Deprecated.class);

    private DotNames() {
    }

    static DotName create(Class<?> clazz) {
        return DotNames.create(clazz.getName());
    }

    static DotName create(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return DotName.createComponentized(null, (String)name);
        }
        String prefix = name.substring(0, lastDot);
        DotName prefixName = (DotName)NAMES.getValue((Object)prefix);
        String local = name.substring(lastDot + 1);
        return DotName.createComponentized((DotName)prefixName, (String)local);
    }

    public static String simpleName(ClassInfo clazz) {
        switch (clazz.nestingType()) {
            case TOP_LEVEL: {
                return DotNames.simpleName(clazz.name());
            }
            case INNER: {
                return clazz.simpleName();
            }
        }
        throw new IllegalStateException("Unsupported nesting type: " + clazz);
    }

    public static String simpleName(DotName dotName) {
        return DotNames.simpleName(dotName.toString());
    }

    public static String simpleName(String name) {
        return name.contains(".") ? name.substring(name.lastIndexOf(".") + 1, name.length()) : name;
    }

    public static String packageName(DotName dotName) {
        String name = dotName.toString();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(0, index);
    }
}

