/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.DisposerInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.Types;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.DeploymentException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

final class Beans {
    static final Logger LOGGER = Logger.getLogger(Beans.class);

    private Beans() {
    }

    static BeanInfo createClassBean(ClassInfo beanClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        ScopeInfo scope;
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>();
        Set<Type> types = Types.getClassBeanTypeClosure(beanClass, beanDeployment);
        Integer alternativePriority = null;
        boolean isAlternative = false;
        boolean isDefaultBean = false;
        ArrayList<StereotypeInfo> stereotypes = new ArrayList<StereotypeInfo>();
        String name = null;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)beanClass)) {
            if (DotNames.NAMED.equals((Object)annotation.name())) {
                AnnotationValue nameValue = annotation.value();
                name = nameValue != null ? nameValue.asString() : Beans.getDefaultName(beanClass);
            }
            Collection<AnnotationInstance> qualifierCollection = beanDeployment.extractQualifiers(annotation);
            for (AnnotationInstance qualifierAnnotation : qualifierCollection) {
                qualifiers.add(qualifierAnnotation);
            }
            StereotypeInfo stereotype = beanDeployment.getStereotype(annotation.name());
            if (stereotype != null) {
                stereotypes.add(stereotype);
                continue;
            }
            if (!qualifierCollection.isEmpty()) continue;
            if (annotation.name().equals((Object)DotNames.ALTERNATIVE)) {
                isAlternative = true;
                continue;
            }
            if (annotation.name().equals((Object)DotNames.ALTERNATIVE_PRIORITY)) {
                isAlternative = true;
                alternativePriority = annotation.value().asInt();
                continue;
            }
            if (DotNames.DEFAULT_BEAN.equals((Object)annotation.name())) {
                isDefaultBean = true;
                continue;
            }
            if (annotation.name().equals((Object)DotNames.PRIORITY) && alternativePriority == null) {
                alternativePriority = annotation.value().asInt();
                continue;
            }
            ScopeInfo scopeAnnotation = beanDeployment.getScope(annotation.name());
            if (scopeAnnotation == null) continue;
            scopes.add(scopeAnnotation);
        }
        if (scopes.size() > 1) {
            throw Beans.multipleScopesFound("Bean class " + beanClass, scopes);
        }
        if (scopes.isEmpty()) {
            scope = Beans.initStereotypeScope(stereotypes, (AnnotationTarget)beanClass);
            if (scope == null) {
                scope = Beans.inheritScope(beanClass, beanDeployment);
            }
        } else {
            scope = (ScopeInfo)scopes.get(0);
        }
        if (!isAlternative) {
            isAlternative = Beans.initStereotypeAlternative(stereotypes);
        }
        if (name == null) {
            name = Beans.initStereotypeName(stereotypes, (AnnotationTarget)beanClass);
        }
        if (isAlternative && (alternativePriority = Beans.initAlternativePriority((AnnotationTarget)beanClass, alternativePriority, stereotypes, beanDeployment)) == null) {
            LOGGER.infof("Ignoring bean defined via %s - declared as an @Alternative but not selected by @Priority, @AlernativePriority or quarkus.arc.selected-alternatives", (Object)beanClass.name());
            return null;
        }
        BeanInfo bean = new BeanInfo((AnnotationTarget)beanClass, beanDeployment, scope, types, qualifiers, Injection.forBean((AnnotationTarget)beanClass, null, beanDeployment, transformer), null, null, isAlternative ? alternativePriority : null, stereotypes, name, isDefaultBean);
        return bean;
    }

    private static ScopeInfo inheritScope(ClassInfo beanClass, BeanDeployment beanDeployment) {
        DotName superClassName = beanClass.superName();
        while (!superClassName.equals((Object)DotNames.OBJECT)) {
            ClassInfo classFromIndex = IndexClassLookupUtils.getClassByName(beanDeployment.getIndex(), superClassName);
            if (classFromIndex == null) {
                LOGGER.warnf("Unable to determine scope for bean %s using inheritance because its super class %s is not part of Jandex index. Dependent scope will be used instead.", (Object)beanClass, (Object)superClassName);
                return null;
            }
            for (AnnotationInstance annotation : beanDeployment.getAnnotationStore().getAnnotations((AnnotationTarget)classFromIndex)) {
                ScopeInfo scopeAnnotation = beanDeployment.getScope(annotation.name());
                if (scopeAnnotation == null || !scopeAnnotation.declaresInherited()) continue;
                return scopeAnnotation;
            }
            superClassName = classFromIndex.superName();
        }
        return null;
    }

    static BeanInfo createProducerMethod(MethodInfo producerMethod, BeanInfo declaringBean, BeanDeployment beanDeployment, DisposerInfo disposer, InjectionPointModifier transformer) {
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>();
        Set<Type> types = Types.getProducerMethodTypeClosure(producerMethod, beanDeployment);
        Integer alternativePriority = null;
        boolean isAlternative = false;
        boolean isDefaultBean = false;
        ArrayList<StereotypeInfo> stereotypes = new ArrayList<StereotypeInfo>();
        String name = null;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)producerMethod)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            if (DotNames.NAMED.equals((Object)annotation.name())) {
                AnnotationValue nameValue = annotation.value();
                name = nameValue != null ? nameValue.asString() : Beans.getDefaultName(producerMethod);
            }
            Collection<AnnotationInstance> qualifierCollection = beanDeployment.extractQualifiers(annotation);
            for (AnnotationInstance qualifierAnnotation : qualifierCollection) {
                qualifiers.add(qualifierAnnotation);
            }
            if (!qualifierCollection.isEmpty()) continue;
            if (DotNames.ALTERNATIVE.equals((Object)annotation.name())) {
                isAlternative = true;
                continue;
            }
            if (DotNames.ALTERNATIVE_PRIORITY.equals((Object)annotation.name())) {
                isAlternative = true;
                alternativePriority = annotation.value().asInt();
                continue;
            }
            if (DotNames.DEFAULT_BEAN.equals((Object)annotation.name())) {
                isDefaultBean = true;
                continue;
            }
            ScopeInfo scopeAnnotation = beanDeployment.getScope(annotation.name());
            if (scopeAnnotation != null) {
                scopes.add(scopeAnnotation);
                continue;
            }
            StereotypeInfo stereotype = beanDeployment.getStereotype(annotation.name());
            if (stereotype == null) continue;
            stereotypes.add(stereotype);
        }
        if (scopes.size() > 1) {
            throw Beans.multipleScopesFound("Producer method " + producerMethod, scopes);
        }
        ScopeInfo scope = scopes.isEmpty() ? Beans.initStereotypeScope(stereotypes, (AnnotationTarget)producerMethod) : (ScopeInfo)scopes.get(0);
        if (!isAlternative) {
            isAlternative = Beans.initStereotypeAlternative(stereotypes);
        }
        if (name == null) {
            name = Beans.initStereotypeName(stereotypes, (AnnotationTarget)producerMethod);
        }
        if (isAlternative) {
            if (alternativePriority == null) {
                alternativePriority = declaringBean.getAlternativePriority();
            }
            if ((alternativePriority = Beans.initAlternativePriority((AnnotationTarget)producerMethod, alternativePriority, stereotypes, beanDeployment)) == null) {
                LOGGER.infof("Ignoring producer method %s - declared as an @Alternative but not selected by @Priority, @AlternativePriority or quarkus.arc.selected-alternatives", (Object)(declaringBean.getTarget().get().asClass().name() + "#" + producerMethod.name()));
                return null;
            }
        }
        BeanInfo bean = new BeanInfo((AnnotationTarget)producerMethod, beanDeployment, scope, types, qualifiers, Injection.forBean((AnnotationTarget)producerMethod, declaringBean, beanDeployment, transformer), declaringBean, disposer, alternativePriority, stereotypes, name, isDefaultBean);
        return bean;
    }

    static BeanInfo createProducerField(FieldInfo producerField, BeanInfo declaringBean, BeanDeployment beanDeployment, DisposerInfo disposer) {
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>();
        Set<Type> types = Types.getProducerFieldTypeClosure(producerField, beanDeployment);
        Integer alternativePriority = null;
        boolean isAlternative = false;
        boolean isDefaultBean = false;
        ArrayList<StereotypeInfo> stereotypes = new ArrayList<StereotypeInfo>();
        String name = null;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)producerField)) {
            if (DotNames.NAMED.equals((Object)annotation.name())) {
                AnnotationValue nameValue = annotation.value();
                name = nameValue != null ? nameValue.asString() : producerField.name();
            }
            Collection<AnnotationInstance> qualifierCollection = beanDeployment.extractQualifiers(annotation);
            for (AnnotationInstance qualifierAnnotation : qualifierCollection) {
                qualifiers.add(qualifierAnnotation);
            }
            if (!qualifierCollection.isEmpty()) continue;
            if (DotNames.ALTERNATIVE.equals((Object)annotation.name())) {
                isAlternative = true;
                continue;
            }
            if (DotNames.ALTERNATIVE_PRIORITY.equals((Object)annotation.name())) {
                isAlternative = true;
                alternativePriority = annotation.value().asInt();
                continue;
            }
            ScopeInfo scopeAnnotation = beanDeployment.getScope(annotation.name());
            if (scopeAnnotation != null) {
                scopes.add(scopeAnnotation);
                continue;
            }
            StereotypeInfo stereotype = beanDeployment.getStereotype(annotation.name());
            if (stereotype != null) {
                stereotypes.add(stereotype);
                continue;
            }
            if (!DotNames.DEFAULT_BEAN.equals((Object)annotation.name())) continue;
            isDefaultBean = true;
        }
        if (scopes.size() > 1) {
            throw Beans.multipleScopesFound("Producer field " + producerField, scopes);
        }
        ScopeInfo scope = scopes.isEmpty() ? Beans.initStereotypeScope(stereotypes, (AnnotationTarget)producerField) : (ScopeInfo)scopes.get(0);
        if (!isAlternative) {
            isAlternative = Beans.initStereotypeAlternative(stereotypes);
        }
        if (name == null) {
            name = Beans.initStereotypeName(stereotypes, (AnnotationTarget)producerField);
        }
        if (isAlternative) {
            if (alternativePriority == null) {
                alternativePriority = declaringBean.getAlternativePriority();
            }
            if ((alternativePriority = Beans.initAlternativePriority((AnnotationTarget)producerField, alternativePriority, stereotypes, beanDeployment)) == null) {
                LOGGER.debugf("Ignoring producer field %s - declared as an @Alternative but not selected by @Priority, @AlternativePriority or quarkus.arc.selected-alternatives", (Object)producerField);
                return null;
            }
        }
        BeanInfo bean = new BeanInfo((AnnotationTarget)producerField, beanDeployment, scope, types, qualifiers, Collections.emptyList(), declaringBean, disposer, alternativePriority, stereotypes, name, isDefaultBean);
        return bean;
    }

    private static DefinitionException multipleScopesFound(String baseMessage, List<ScopeInfo> scopes) {
        return new DefinitionException(baseMessage + " declares multiple scope type annotations: " + scopes.stream().map(s -> s.getDotName().toString()).collect(Collectors.joining(", ")));
    }

    private static ScopeInfo initStereotypeScope(List<StereotypeInfo> stereotypes, AnnotationTarget target) {
        if (stereotypes.isEmpty()) {
            return null;
        }
        HashSet<ScopeInfo> stereotypeScopes = new HashSet<ScopeInfo>();
        HashSet<ScopeInfo> additionalBDAScopes = new HashSet<ScopeInfo>();
        for (StereotypeInfo stereotype : stereotypes) {
            if (!stereotype.isAdditionalBeanDefiningAnnotation()) {
                stereotypeScopes.add(stereotype.getDefaultScope());
                continue;
            }
            additionalBDAScopes.add(stereotype.getDefaultScope());
        }
        return BeanDeployment.getValidScope(stereotypeScopes.isEmpty() ? additionalBDAScopes : stereotypeScopes, target);
    }

    private static boolean initStereotypeAlternative(List<StereotypeInfo> stereotypes) {
        if (stereotypes.isEmpty()) {
            return false;
        }
        for (StereotypeInfo stereotype : stereotypes) {
            if (!stereotype.isAlternative()) continue;
            return true;
        }
        return false;
    }

    private static Integer initStereotypeAlternativePriority(List<StereotypeInfo> stereotypes) {
        if (stereotypes.isEmpty()) {
            return null;
        }
        for (StereotypeInfo stereotype : stereotypes) {
            if (stereotype.getAlternativePriority() == null) continue;
            return stereotype.getAlternativePriority();
        }
        return null;
    }

    private static String initStereotypeName(List<StereotypeInfo> stereotypes, AnnotationTarget target) {
        if (stereotypes.isEmpty()) {
            return null;
        }
        for (StereotypeInfo stereotype : stereotypes) {
            if (!stereotype.isNamed()) continue;
            switch (target.kind()) {
                case CLASS: {
                    return Beans.getDefaultName(target.asClass());
                }
                case FIELD: {
                    return target.asField().name();
                }
                case METHOD: {
                    return Beans.getDefaultName(target.asMethod());
                }
            }
        }
        return null;
    }

    static boolean matches(BeanInfo bean, InjectionPointInfo.TypeAndQualifiers typeAndQualifiers) {
        return Beans.hasQualifiers(bean, typeAndQualifiers.qualifiers) && Beans.matchesType(bean, typeAndQualifiers.type);
    }

    static boolean matchesType(BeanInfo bean, Type requiredType) {
        BeanResolver beanResolver = bean.getDeployment().getBeanResolver();
        for (Type beanType : bean.getTypes()) {
            if (!beanResolver.matches(requiredType, beanType)) continue;
            return true;
        }
        return false;
    }

    static void resolveInjectionPoint(BeanDeployment deployment, InjectionTargetInfo target, InjectionPointInfo injectionPoint, List<Throwable> errors) {
        BuiltinBean builtinBean = BuiltinBean.resolve(injectionPoint);
        if (builtinBean != null) {
            if (BuiltinBean.INJECTION_POINT.equals((Object)builtinBean) && (target.kind() != InjectionTargetInfo.TargetKind.BEAN || !BuiltinScope.DEPENDENT.is(target.asBean().getScope()))) {
                errors.add((Throwable)new DefinitionException("Only @Dependent beans can access metadata about an injection point: " + injectionPoint.getTargetInfo()));
            }
            if (BuiltinBean.EVENT_METADATA.equals((Object)builtinBean) && target.kind() != InjectionTargetInfo.TargetKind.OBSERVER) {
                errors.add((Throwable)new DefinitionException("EventMetadata can be only injected into an observer method: " + injectionPoint.getTargetInfo()));
            }
            return;
        }
        List<BeanInfo> resolved = deployment.getBeanResolver().resolve(injectionPoint.getTypeAndQualifiers());
        BeanInfo selected = null;
        if (resolved.isEmpty()) {
            StringBuilder message = new StringBuilder("Unsatisfied dependency for type ");
            message.append(injectionPoint.getRequiredType());
            message.append(" and qualifiers ");
            message.append(injectionPoint.getRequiredQualifiers());
            message.append("\n\t- java member: ");
            message.append(injectionPoint.getTargetInfo());
            message.append("\n\t- declared on ");
            message.append(target);
            errors.add((Throwable)new UnsatisfiedResolutionException(message.toString()));
        } else if (resolved.size() > 1) {
            selected = Beans.resolveAmbiguity(resolved);
            if (selected == null) {
                StringBuilder message = new StringBuilder("Ambiguous dependencies for type ");
                message.append(injectionPoint.getRequiredType());
                message.append(" and qualifiers ");
                message.append(injectionPoint.getRequiredQualifiers());
                message.append("\n\t- java member: ");
                message.append(injectionPoint.getTargetInfo());
                message.append("\n\t- declared on ");
                message.append(target);
                message.append("\n\t- available beans:\n\t\t- ");
                message.append(resolved.stream().map(Object::toString).collect(Collectors.joining("\n\t\t- ")));
                errors.add((Throwable)new AmbiguousResolutionException(message.toString()));
            }
        } else {
            selected = resolved.get(0);
        }
        if (selected != null) {
            injectionPoint.resolve(selected);
        }
    }

    static BeanInfo resolveAmbiguity(List<BeanInfo> resolved) {
        ArrayList<BeanInfo> resolvedAmbiguity = new ArrayList<BeanInfo>(resolved);
        Iterator iterator = resolvedAmbiguity.iterator();
        while (iterator.hasNext()) {
            BeanInfo beanInfo = (BeanInfo)iterator.next();
            if (!beanInfo.isDefaultBean()) continue;
            iterator.remove();
        }
        if (resolvedAmbiguity.size() == 1) {
            return (BeanInfo)resolvedAmbiguity.get(0);
        }
        BeanInfo selected = null;
        Iterator iterator2 = resolvedAmbiguity.iterator();
        while (iterator2.hasNext()) {
            BeanInfo beanInfo = (BeanInfo)iterator2.next();
            if (beanInfo.isAlternative() || beanInfo.getDeclaringBean() != null && beanInfo.getDeclaringBean().isAlternative()) continue;
            iterator2.remove();
        }
        if (resolvedAmbiguity.size() == 1) {
            selected = (BeanInfo)resolvedAmbiguity.get(0);
        } else if (resolvedAmbiguity.size() > 1) {
            resolvedAmbiguity.sort(Beans::compareAlternativeBeans);
            Integer highest = Beans.getAlternativePriority((BeanInfo)resolvedAmbiguity.get(0));
            Iterator iterator3 = resolvedAmbiguity.iterator();
            while (iterator3.hasNext()) {
                if (highest.equals(Beans.getAlternativePriority((BeanInfo)iterator3.next()))) continue;
                iterator3.remove();
            }
            if (resolvedAmbiguity.size() == 1) {
                selected = (BeanInfo)resolvedAmbiguity.get(0);
            }
        }
        return selected;
    }

    private static Integer getAlternativePriority(BeanInfo bean) {
        Integer beanPriority = bean.getAlternativePriority();
        if (beanPriority == null && bean.getDeclaringBean() != null) {
            beanPriority = bean.getDeclaringBean().getAlternativePriority();
        }
        return beanPriority;
    }

    private static int compareAlternativeBeans(BeanInfo bean1, BeanInfo bean2) {
        Integer priority1;
        Integer priority2 = bean2.getAlternativePriority();
        if (priority2 == null) {
            priority2 = bean2.getDeclaringBean().getAlternativePriority();
        }
        if ((priority1 = bean1.getAlternativePriority()) == null) {
            priority1 = bean1.getDeclaringBean().getAlternativePriority();
        }
        if (priority2 == null || priority1 == null) {
            throw new IllegalStateException(String.format("Alternative Bean priority should not be null. %s has priority %s; %s has priority %s", bean1.getBeanClass(), priority1, bean2.getBeanClass(), priority2));
        }
        return priority2.compareTo(priority1);
    }

    static boolean hasQualifiers(BeanInfo bean, Iterable<AnnotationInstance> required) {
        for (AnnotationInstance requiredQualifier : required) {
            if (Beans.hasQualifier(bean, requiredQualifier)) continue;
            return false;
        }
        return true;
    }

    static boolean hasQualifier(BeanInfo bean, AnnotationInstance required) {
        return Beans.hasQualifier(bean.getDeployment().getQualifier(required.name()), required, bean.getQualifiers());
    }

    static boolean hasQualifier(ClassInfo requiredInfo, AnnotationInstance required, Collection<AnnotationInstance> qualifiers) {
        ArrayList<AnnotationValue> binding = new ArrayList<AnnotationValue>();
        for (AnnotationValue val : required.values()) {
            if (requiredInfo.method(val.name(), new Type[0]).hasAnnotation(DotNames.NONBINDING)) continue;
            binding.add(val);
        }
        for (AnnotationInstance qualifier : qualifiers) {
            if (!required.name().equals((Object)qualifier.name())) continue;
            boolean matches = true;
            for (AnnotationValue value : binding) {
                if (value.equals((Object)qualifier.value(value.name()))) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    static List<MethodInfo> getCallbacks(ClassInfo beanClass, DotName annotation, IndexView index) {
        ArrayList<MethodInfo> callbacks = new ArrayList<MethodInfo>();
        Beans.collectCallbacks(beanClass, callbacks, annotation, index);
        Collections.reverse(callbacks);
        return callbacks;
    }

    static void analyzeType(Type type, BeanDeployment beanDeployment) {
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            for (Type argument : type.asParameterizedType().arguments()) {
                Beans.fetchType(argument, beanDeployment);
            }
        } else if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            for (Type bound : type.asTypeVariable().bounds()) {
                Beans.fetchType(bound, beanDeployment);
            }
        } else if (type.kind() == Type.Kind.WILDCARD_TYPE) {
            Beans.fetchType(type.asWildcardType().extendsBound(), beanDeployment);
            Beans.fetchType(type.asWildcardType().superBound(), beanDeployment);
        }
    }

    static void validateBean(BeanInfo bean, List<Throwable> errors, List<BeanDeploymentValidator> validators, Consumer<BytecodeTransformer> bytecodeTransformerConsumer) {
        ClassInfo returnTypeClass;
        if (bean.isClassBean()) {
            String classifier;
            ClassInfo beanClass = bean.getTarget().get().asClass();
            String string = classifier = bean.getScope().isNormal() ? "Normal scoped" : null;
            if (classifier == null && bean.isSubclassRequired()) {
                classifier = "Intercepted";
            }
            if (Modifier.isFinal(beanClass.flags()) && classifier != null) {
                if (bean.getDeployment().transformUnproxyableClasses) {
                    bytecodeTransformerConsumer.accept(new BytecodeTransformer(beanClass.name().toString(), new FinalClassTransformFunction()));
                } else {
                    errors.add((Throwable)new DeploymentException(String.format("%s bean must not be final: %s", classifier, bean)));
                }
            }
            MethodInfo noArgsConstructor = beanClass.method("<init>", new Type[0]);
            if (bean.getScope().isNormal() && noArgsConstructor == null) {
                if (bean.getDeployment().transformUnproxyableClasses) {
                    ClassInfo superClass;
                    DotName superName = beanClass.superName();
                    if (!(DotNames.OBJECT.equals((Object)superName) || (superClass = bean.getDeployment().getIndex().getClassByName(beanClass.superName())) != null && superClass.hasNoArgsConstructor())) {
                        superName = null;
                    }
                    if (superName != null) {
                        String superClassName = superName.toString().replace('.', '/');
                        bytecodeTransformerConsumer.accept(new BytecodeTransformer(beanClass.name().toString(), new NoArgConstructorTransformFunction(superClassName)));
                    } else {
                        errors.add((Throwable)new DeploymentException("It's not possible to add a synthetic constructor with no parameters to the unproxyable bean class: " + beanClass));
                    }
                } else {
                    errors.add((Throwable)new DeploymentException(String.format("Normal scoped beans must declare a non-private constructor with no parameters: %s", bean)));
                }
            }
            if (noArgsConstructor != null && Modifier.isPrivate(noArgsConstructor.flags()) && classifier != null) {
                if (bean.getDeployment().transformUnproxyableClasses) {
                    bytecodeTransformerConsumer.accept(new BytecodeTransformer(beanClass.name().toString(), new PrivateNoArgsConstructorTransformFunction()));
                } else {
                    errors.add((Throwable)new DeploymentException(String.format("%s bean is not proxyable because it has a private no-args constructor: %s. To fix this problem, change the constructor to be package-private", classifier, bean)));
                }
            }
        } else if ((bean.isProducerField() || bean.isProducerMethod()) && (returnTypeClass = IndexClassLookupUtils.getClassByName(bean.getDeployment().getIndex(), bean.isProducerMethod() ? bean.getTarget().get().asMethod().returnType() : bean.getTarget().get().asField().type())) != null && bean.getScope().isNormal() && !Modifier.isInterface(returnTypeClass.flags())) {
            MethodInfo noArgsConstructor;
            String methodOrField = bean.isProducerMethod() ? "method" : "field";
            String classifier = "Producer " + methodOrField + " for a normal scoped bean";
            if (Modifier.isFinal(returnTypeClass.flags())) {
                if (bean.getDeployment().transformUnproxyableClasses) {
                    bytecodeTransformerConsumer.accept(new BytecodeTransformer(returnTypeClass.name().toString(), new FinalClassTransformFunction()));
                } else {
                    errors.add((Throwable)new DeploymentException(String.format("%s must not have a return type that is final: %s", classifier, bean)));
                }
            }
            if ((noArgsConstructor = returnTypeClass.method("<init>", new Type[0])) == null) {
                if (bean.getDeployment().transformUnproxyableClasses) {
                    ClassInfo superClass;
                    DotName superName = returnTypeClass.superName();
                    if (!(DotNames.OBJECT.equals((Object)superName) || (superClass = bean.getDeployment().getIndex().getClassByName(returnTypeClass.superName())) != null && superClass.hasNoArgsConstructor())) {
                        superName = null;
                    }
                    if (superName != null) {
                        String superClassName = superName.toString().replace('.', '/');
                        bytecodeTransformerConsumer.accept(new BytecodeTransformer(returnTypeClass.name().toString(), new NoArgConstructorTransformFunction(superClassName)));
                    } else {
                        errors.add((Throwable)new DeploymentException(String.format("It's not possible to add a synthetic constructor with no parameters to the unproxyable return type of " + bean, new Object[0])));
                    }
                } else {
                    errors.add((Throwable)new DefinitionException(String.format("Return type of a producer %s for normal scoped beans must declare a non-private constructor with no parameters: %s", methodOrField, bean)));
                }
            } else if (Modifier.isPrivate(noArgsConstructor.flags())) {
                if (bean.getDeployment().transformUnproxyableClasses) {
                    bytecodeTransformerConsumer.accept(new BytecodeTransformer(returnTypeClass.name().toString(), new PrivateNoArgsConstructorTransformFunction()));
                } else {
                    errors.add((Throwable)new DeploymentException(String.format("%s is not proxyable because it has a private no-args constructor: %s.", classifier, bean)));
                }
            }
        }
    }

    private static void fetchType(Type type, BeanDeployment beanDeployment) {
        if (type == null) {
            return;
        }
        if (type.kind() == Type.Kind.CLASS) {
            IndexClassLookupUtils.getClassByName(beanDeployment.getIndex(), type.name());
        } else {
            Beans.analyzeType(type, beanDeployment);
        }
    }

    private static void collectCallbacks(ClassInfo clazz, List<MethodInfo> callbacks, DotName annotation, IndexView index) {
        ClassInfo superClass;
        for (MethodInfo method : clazz.methods()) {
            if (!method.hasAnnotation(annotation) || method.returnType().kind() != Type.Kind.VOID || !method.parameters().isEmpty()) continue;
            callbacks.add(method);
        }
        if (clazz.superName() != null && (superClass = IndexClassLookupUtils.getClassByName(index, clazz.superName())) != null) {
            Beans.collectCallbacks(superClass, callbacks, annotation, index);
        }
    }

    private static String getPropertyName(String methodName) {
        String get = "get";
        String is = "is";
        if (methodName.startsWith("get")) {
            return Beans.decapitalize(methodName.substring("get".length()));
        }
        if (methodName.startsWith("is")) {
            return Beans.decapitalize(methodName.substring("is".length()));
        }
        return null;
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        StringBuilder decapitalized = new StringBuilder(name);
        decapitalized.setCharAt(0, Character.toLowerCase(decapitalized.charAt(0)));
        return decapitalized.toString();
    }

    private static String getDefaultName(ClassInfo beanClass) {
        StringBuilder defaultName = new StringBuilder();
        defaultName.append(DotNames.simpleName(beanClass));
        defaultName.setCharAt(0, Character.toLowerCase(defaultName.charAt(0)));
        return defaultName.toString();
    }

    private static String getDefaultName(MethodInfo producerMethod) {
        String propertyName = Beans.getPropertyName(producerMethod.name());
        if (propertyName != null) {
            return propertyName;
        }
        return producerMethod.name();
    }

    private static Integer initAlternativePriority(AnnotationTarget target, Integer alternativePriority, List<StereotypeInfo> stereotypes, BeanDeployment deployment) {
        Integer computedPriority;
        if (alternativePriority == null) {
            alternativePriority = Beans.initStereotypeAlternativePriority(stereotypes);
        }
        if ((computedPriority = deployment.computeAlternativePriority(target, stereotypes)) != null) {
            if (alternativePriority != null) {
                LOGGER.infof("Computed priority [%s] overrides the priority [%s] declared via @Priority or @AlernativePriority", (Object)computedPriority, (Object)alternativePriority);
            }
            alternativePriority = computedPriority;
        }
        return alternativePriority;
    }

    static class PrivateNoArgsConstructorTransformFunction
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        PrivateNoArgsConstructorTransformFunction() {
        }

        @Override
        public ClassVisitor apply(final String className, ClassVisitor classVisitor) {
            return new ClassVisitor(524288, classVisitor){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    if (name.equals("<init>")) {
                        access &= 0xFFFFFFFD;
                        LOGGER.debugf("Changed visibility of a private no-args constructor to package-private: ", (Object)className);
                    }
                    return super.visitMethod(access, name, descriptor, signature, exceptions);
                }
            };
        }
    }

    static class NoArgConstructorTransformFunction
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        private final String superClassName;

        public NoArgConstructorTransformFunction(String superClassName) {
            this.superClassName = superClassName;
        }

        @Override
        public ClassVisitor apply(final String className, ClassVisitor classVisitor) {
            return new ClassVisitor(524288, classVisitor){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    super.visit(version, access, name, signature, superName, interfaces);
                    MethodVisitor mv = this.visitMethod(1, "<init>", "()V", null, null);
                    mv.visitCode();
                    mv.visitVarInsn(25, 0);
                    mv.visitMethodInsn(183, superClassName, "<init>", "()V", false);
                    mv.visitInsn(177);
                    mv.visitMaxs(1, 1);
                    mv.visitEnd();
                    LOGGER.debugf("Added a no-args constructor to bean class: ", (Object)className);
                }
            };
        }
    }

    static class FinalClassTransformFunction
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        FinalClassTransformFunction() {
        }

        @Override
        public ClassVisitor apply(final String className, ClassVisitor classVisitor) {
            return new ClassVisitor(524288, classVisitor){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    LOGGER.debugf("Final flag removed from bean class %s", (Object)className);
                    super.visit(version, access &= 0xFFFFFFEF, name, signature, superName, interfaces);
                }
            };
        }
    }
}

