/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.Annotation;
import io.protostuff.parser.AnnotationContainer;
import io.protostuff.parser.ConfiguredReference;
import io.protostuff.parser.DefaultProtoLoader;
import io.protostuff.parser.EnumGroup;
import io.protostuff.parser.ErrorMap;
import io.protostuff.parser.Extension;
import io.protostuff.parser.Field;
import io.protostuff.parser.HasName;
import io.protostuff.parser.HasOptions;
import io.protostuff.parser.Message;
import io.protostuff.parser.Mutable;
import io.protostuff.parser.Service;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Proto
extends AnnotationContainer
implements HasOptions {
    final File file;
    final URL url;
    final Loader loader;
    final Proto importer;
    Mutable<String> packageName;
    Mutable<String> javaPackageName;
    final LinkedHashMap<String, Proto> importedProtos = new LinkedHashMap();
    final LinkedHashMap<String, Object> standardOptions = new LinkedHashMap();
    final LinkedHashMap<String, Object> extraOptions = new LinkedHashMap();
    final LinkedHashMap<String, Message> messages = new LinkedHashMap();
    final LinkedHashMap<String, EnumGroup> enumGroups = new LinkedHashMap();
    final LinkedHashMap<String, Service> services = new LinkedHashMap();
    final ArrayList<Extension> extensions = new ArrayList();
    final LinkedHashMap<String, Message> fullyQualifiedMessages = new LinkedHashMap();
    final LinkedHashMap<String, EnumGroup> fullyQualifiedEnumGroups = new LinkedHashMap();
    final ArrayList<ConfiguredReference> references = new ArrayList();
    int refOffset;
    private String sourcePath;

    public Proto() {
        this((File)null, (Loader)DefaultProtoLoader.DEFAULT_INSTANCE, null);
    }

    public Proto(File file) {
        this(file, (Loader)DefaultProtoLoader.DEFAULT_INSTANCE, null);
    }

    public Proto(Loader loader) {
        this((File)null, loader, null);
    }

    public Proto(File file, Loader loader) {
        this(file, loader, null);
    }

    public Proto(File file, Loader loader, Proto importer) {
        this.url = null;
        this.file = file;
        this.loader = loader;
        this.importer = importer;
    }

    public Proto(URL url, Loader loader, Proto importer) {
        this.file = null;
        this.url = url;
        this.loader = loader;
        this.importer = importer;
    }

    @Override
    public Proto getProto() {
        return this;
    }

    public ErrorMap getError() {
        return ErrorMap.INSTANCE;
    }

    public File getFile() {
        return this.file;
    }

    public String getSourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = this.file == null ? String.valueOf(this.url) : this.file.toString();
        }
        return this.sourcePath;
    }

    public Mutable<String> getMutablePackageName() {
        return this.packageName;
    }

    public String getPackageName() {
        return this.packageName == null ? null : this.packageName.getValue();
    }

    public String getOriginalPackageName() {
        if (this.packageName == null) {
            return null;
        }
        String original = this.packageName.getLast();
        return original != null ? original : this.packageName.getValue();
    }

    public Mutable<String> getMutableJavaPackageName() {
        return this.javaPackageName;
    }

    public String getJavaPackageName() {
        return this.javaPackageName.getValue();
    }

    public String getOriginalJavaPackageName() {
        if (this.javaPackageName == null) {
            return null;
        }
        String original = this.javaPackageName.getLast();
        return original != null ? original : this.javaPackageName.getValue();
    }

    void setPackageName(String packageName) {
        if (this.packageName == null) {
            this.packageName = new Mutable<String>(packageName);
        }
    }

    public LinkedHashMap<String, Object> getStandardOptions() {
        return this.standardOptions;
    }

    public Object getStandardOption(String name) {
        return this.standardOptions.get(name);
    }

    public LinkedHashMap<String, Object> getExtraOptions() {
        return this.extraOptions;
    }

    public LinkedHashMap<String, Object> getO() {
        return this.getOptions();
    }

    public LinkedHashMap<String, Object> getOptions() {
        return this.extraOptions;
    }

    @Override
    public void putStandardOption(String key, Object value) {
        this.putExtraOption(key, value);
        this.standardOptions.put(key, value);
    }

    @Override
    public void putExtraOption(String key, Object value) {
        if (this.extraOptions.put(key, value) != null) {
            throw Proto.err("Duplicate proto option: " + key, this);
        }
    }

    public <V> V getExtraOption(String key) {
        return (V)this.extraOptions.get(key);
    }

    public Map<String, Message> getMessageMap() {
        return this.messages;
    }

    public Collection<Message> getMessages() {
        return this.messages.values();
    }

    public Message getMessage(String name) {
        return this.messages.get(name);
    }

    void addMessage(Message message) {
        if (this.messages.put(message.name, message) != null) {
            throw Proto.err("Duplicate message: " + message.name, this);
        }
    }

    public Map<String, EnumGroup> getEnumGroupMap() {
        return this.enumGroups;
    }

    public Collection<EnumGroup> getEnumGroups() {
        return this.enumGroups.values();
    }

    public EnumGroup getEnumGroup(String name) {
        return this.enumGroups.get(name);
    }

    void addEnumGroup(EnumGroup enumGroup) {
        if (this.enumGroups.put(enumGroup.name, enumGroup) != null) {
            throw Proto.err("Duplicate enum: " + enumGroup.name, this);
        }
    }

    public Map<String, Service> getServiceMap() {
        return this.services;
    }

    public Collection<Service> getServices() {
        return this.services.values();
    }

    public Service getService(String name) {
        return this.services.get(name);
    }

    void addService(Service service) {
        if (this.services.put(service.name, service) != null) {
            throw Proto.err("Duplicate service: " + service.name, this);
        }
    }

    public void addExtension(Extension extension) {
        this.extensions.add(extension);
    }

    public Collection<Extension> getExtensions() {
        return this.extensions;
    }

    public Collection<Proto> getImportedProtos() {
        return this.importedProtos.values();
    }

    public Proto getImportedProto(File file) {
        return this.importedProtos.get(file.toURI().toString());
    }

    public Proto getImportedProto(URL url) {
        return this.importedProtos.get(url.toString());
    }

    public Proto getImportedProto(String url) {
        return this.importedProtos.get(url);
    }

    void importProto(String path) {
        try {
            this.addImportedProto(this.loader.load(path, this));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void addImportedProto(Proto proto) {
        if (proto.url == null) {
            this.importedProtos.put(proto.file.toURI().toString(), proto);
        } else {
            this.importedProtos.put(proto.url.toString(), proto);
        }
    }

    void postParse() {
        String javaPkg;
        if (this.packageName == null) {
            this.setPackageName("");
        }
        String javaPackageName = (javaPkg = (String)this.extraOptions.get("java_package")) == null || javaPkg.length() == 0 ? this.packageName.getValue() : javaPkg;
        this.javaPackageName = new Mutable<String>(javaPackageName);
        for (Message m : this.getMessages()) {
            m.cacheFullyQualifiedNames();
        }
        for (EnumGroup eg : this.getEnumGroups()) {
            eg.cacheFullyQualifiedName();
        }
        for (Message m : this.getMessages()) {
            m.resolveReferences(m);
        }
        for (Service s : this.getServices()) {
            s.resolveReferences();
        }
        for (Extension e : this.getExtensions()) {
            e.resolveReferences();
        }
        for (ConfiguredReference r : this.references) {
            r.resolve(this);
        }
        if (!this.standardOptions.isEmpty()) {
            ConfiguredReference.resolve(this, this.standardOptions, this.extraOptions, this.getPackageName());
        }
    }

    @Override
    public void add(Annotation annotation) {
        super.add(annotation);
        if (!annotation.refs.isEmpty()) {
            this.references.add(new ConfiguredReference(annotation.refs, annotation.params, null));
        }
    }

    void addAnnotationsTo(Message target) {
        if (target.addAnnotations(this.annotations, true) && this.refOffset != this.references.size()) {
            String enclosingNamespace = target.getFullName();
            int size = this.references.size();
            while (this.refOffset < size) {
                ++this.refOffset;
                this.references.get((int)this.refOffset).enclosingNamespace = enclosingNamespace;
            }
        }
        if (!this.docs.isEmpty()) {
            target.docs.addAll(this.docs);
            this.docs.clear();
        }
    }

    void addAnnotationsTo(EnumGroup target) {
        if (target.addAnnotations(this.annotations, true) && this.refOffset != this.references.size()) {
            String enclosingNamespace = target.getFullName();
            int size = this.references.size();
            while (this.refOffset < size) {
                ++this.refOffset;
                this.references.get((int)this.refOffset).enclosingNamespace = enclosingNamespace;
            }
        }
        if (!this.docs.isEmpty()) {
            target.docs.addAll(this.docs);
            this.docs.clear();
        }
    }

    void addAnnotationsTo(EnumGroup.Value target) {
        if (target.addAnnotations(this.annotations, true) && this.refOffset != this.references.size()) {
            String enclosingNamespace = target.getEnumGroup().getFullName();
            int size = this.references.size();
            while (this.refOffset < size) {
                ++this.refOffset;
                this.references.get((int)this.refOffset).enclosingNamespace = enclosingNamespace;
            }
        }
        if (!this.docs.isEmpty()) {
            target.docs.addAll(this.docs);
            this.docs.clear();
        }
    }

    void addAnnotationsTo(Field<?> target, String enclosingNamespace) {
        if (target.addAnnotations(this.annotations, true) && this.refOffset != this.references.size()) {
            int size = this.references.size();
            while (this.refOffset < size) {
                ++this.refOffset;
                this.references.get((int)this.refOffset).enclosingNamespace = enclosingNamespace;
            }
        }
        if (!this.docs.isEmpty()) {
            target.docs.addAll(this.docs);
            this.docs.clear();
        }
    }

    void addAnnotationsTo(Service target) {
        if (target.addAnnotations(this.annotations, true)) {
            this.refOffset = this.references.size();
        }
        if (!this.docs.isEmpty()) {
            target.docs.addAll(this.docs);
            this.docs.clear();
        }
    }

    void addAnnotationsTo(Service.RpcMethod target) {
        if (target.addAnnotations(this.annotations, true)) {
            this.refOffset = this.references.size();
        }
        if (!this.docs.isEmpty()) {
            target.docs.addAll(this.docs);
            this.docs.clear();
        }
    }

    void addAnnotationsTo(Extension target) {
        if (target.addAnnotations(this.annotations, true) && this.refOffset != this.references.size()) {
            String enclosingNamespace = target.getEnclosingNamespace();
            int size = this.references.size();
            while (this.refOffset < size) {
                ++this.refOffset;
                this.references.get((int)this.refOffset).enclosingNamespace = enclosingNamespace;
            }
        }
        if (!this.docs.isEmpty()) {
            target.docs.addAll(this.docs);
            this.docs.clear();
        }
    }

    HasName findReference(String fullRefName, String enclosingNamespace) {
        boolean doneSearch = false;
        if (fullRefName.charAt(0) == '.') {
            return this.findFullyQualifiedObject(fullRefName.substring(1));
        }
        while (!doneSearch) {
            String searchName = enclosingNamespace == null ? fullRefName : enclosingNamespace + '.' + fullRefName;
            HasName obj = this.findFullyQualifiedObject(searchName);
            if (obj != null) {
                return obj;
            }
            if (enclosingNamespace != null) {
                int dotIndex = enclosingNamespace.lastIndexOf(46);
                if (dotIndex < 0) {
                    enclosingNamespace = null;
                    continue;
                }
                enclosingNamespace = enclosingNamespace.substring(0, dotIndex);
                continue;
            }
            doneSearch = true;
        }
        Iterator<Proto> iterator = this.getImportedProtos().iterator();
        while (iterator.hasNext()) {
            Proto proto;
            String searchName = (proto = iterator.next()).getPackageName() == null ? fullRefName : proto.getPackageName() + '.' + fullRefName;
            HasName result = proto.findFullyQualifiedObject(searchName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    Message findMessageReference(String fullRefName, String enclosingNamespace) {
        HasName refObj = this.findReference(fullRefName, enclosingNamespace);
        if (refObj instanceof Message) {
            return (Message)refObj;
        }
        return null;
    }

    EnumGroup findEnumGroupReference(String fullRefName, String enclosingNamespace) {
        HasName refObj = this.findReference(fullRefName, enclosingNamespace);
        if (refObj instanceof EnumGroup) {
            return (EnumGroup)refObj;
        }
        return null;
    }

    HasName findFullyQualifiedObject(String fullyQualifiedName) {
        Message m = this.fullyQualifiedMessages.get(fullyQualifiedName);
        if (m != null) {
            return m;
        }
        EnumGroup eg = this.fullyQualifiedEnumGroups.get(fullyQualifiedName);
        if (eg != null) {
            return eg;
        }
        for (Proto proto : this.getImportedProtos()) {
            HasName importedObj = proto.findFullyQualifiedObject(fullyQualifiedName);
            if (importedObj == null) continue;
            return importedObj;
        }
        return null;
    }

    public String toString() {
        return '{' + "packageName:" + this.packageName + ',' + "standardOptions:" + this.standardOptions + ',' + "extraOptions:" + this.extraOptions + ',' + "messages:" + this.getMessages() + '}';
    }

    public static interface Loader {
        public Proto load(String var1, Proto var2) throws Exception;
    }
}

