/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler;

import io.protostuff.parser.DefaultProtoLoader;
import io.protostuff.parser.Proto;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CachingProtoLoader
extends DefaultProtoLoader {
    public final Map<String, Proto> loadedProtos;

    public CachingProtoLoader() {
        this(new HashMap<String, Proto>());
    }

    public CachingProtoLoader(Map<String, Proto> loadedProtos) {
        this.loadedProtos = loadedProtos;
    }

    public Collection<Proto> getCachedProtos() {
        return this.loadedProtos.values();
    }

    public Proto loadFrom(File file, Proto importer) throws Exception {
        String key = file.getCanonicalPath();
        Proto proto = this.loadedProtos.get(key);
        if (proto == null) {
            proto = super.loadFrom(file, null);
            this.loadedProtos.put(key, proto);
        }
        return proto;
    }

    public Proto loadFrom(URL resource, Proto importer) throws Exception {
        String key = resource.toExternalForm();
        Proto proto = this.loadedProtos.get(key);
        if (proto == null) {
            proto = super.loadFrom(resource, null);
            this.loadedProtos.put(key, proto);
        }
        return proto;
    }
}

