/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.hotspot;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;

public class ThreadExports
extends Collector {
    private final ThreadMXBean threadBean;

    public ThreadExports() {
        this(ManagementFactory.getThreadMXBean());
    }

    public ThreadExports(ThreadMXBean threadBean) {
        this.threadBean = threadBean;
    }

    void addThreadMetrics(List<Collector.MetricFamilySamples> sampleFamilies) {
        sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily("jvm_threads_current", "Current thread count of a JVM", (double)this.threadBean.getThreadCount()));
        sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily("jvm_threads_daemon", "Daemon thread count of a JVM", (double)this.threadBean.getDaemonThreadCount()));
        sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily("jvm_threads_peak", "Peak thread count of a JVM", (double)this.threadBean.getPeakThreadCount()));
        sampleFamilies.add((Collector.MetricFamilySamples)new CounterMetricFamily("jvm_threads_started_total", "Started thread count of a JVM", (double)this.threadBean.getTotalStartedThreadCount()));
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addThreadMetrics(mfs);
        return mfs;
    }
}

