/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.ExemplarFilter;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.EmptyMetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilterInternal;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.ObjectPool;
import io.opentelemetry.sdk.metrics.internal.state.PooledHashMap;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AsynchronousMetricStorage<T extends PointData>
implements MetricStorage {
    private static final Logger logger = Logger.getLogger(AsynchronousMetricStorage.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final RegisteredReader registeredReader;
    private final MetricDescriptor metricDescriptor;
    private final AggregationTemporality aggregationTemporality;
    private final Aggregator<T> aggregator;
    private final AttributesProcessor attributesProcessor;
    private final MemoryMode memoryMode;
    private final int maxCardinality;
    private final Map<Attributes, AggregatorHandle<T>> aggregatorHandles;
    private Map<Attributes, T> lastPoints;
    private final ObjectPool<T> reusablePointsPool;
    private final ObjectPool<AggregatorHandle<T>> reusableHandlesPool;
    private final Function<Attributes, AggregatorHandle<T>> handleBuilder;
    private final BiConsumer<Attributes, AggregatorHandle<T>> handleReleaser;
    private final BiConsumer<Attributes, T> pointReleaser;
    private final List<T> reusablePointsList = new ArrayList<T>();
    private Map<Attributes, T> reusablePointsMap = new PooledHashMap<Attributes, T>();
    private long startEpochNanos;
    private long epochNanos;
    private volatile boolean enabled;

    private AsynchronousMetricStorage(RegisteredReader registeredReader, MetricDescriptor metricDescriptor, Aggregator<T> aggregator, AttributesProcessor attributesProcessor, int maxCardinality, boolean enabled) {
        this.registeredReader = registeredReader;
        this.metricDescriptor = metricDescriptor;
        this.aggregationTemporality = registeredReader.getReader().getAggregationTemporality(metricDescriptor.getSourceInstrument().getType());
        this.memoryMode = registeredReader.getReader().getMemoryMode();
        this.aggregator = aggregator;
        this.attributesProcessor = attributesProcessor;
        this.maxCardinality = maxCardinality - 1;
        this.enabled = enabled;
        this.reusablePointsPool = new ObjectPool<PointData>(aggregator::createReusablePoint);
        this.reusableHandlesPool = new ObjectPool<AggregatorHandle>(aggregator::createHandle);
        this.handleBuilder = ignored -> this.reusableHandlesPool.borrowObject();
        this.handleReleaser = (ignored, handle) -> this.reusableHandlesPool.returnObject((AggregatorHandle<AggregatorHandle>)handle);
        this.pointReleaser = (ignored, point) -> this.reusablePointsPool.returnObject((PointData)point);
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.lastPoints = new PooledHashMap<Attributes, T>();
            this.aggregatorHandles = new PooledHashMap<Attributes, AggregatorHandle<T>>();
        } else {
            this.lastPoints = new HashMap<Attributes, T>();
            this.aggregatorHandles = new HashMap<Attributes, AggregatorHandle<T>>();
        }
    }

    public static <T extends PointData> AsynchronousMetricStorage<T> create(RegisteredReader registeredReader, RegisteredView registeredView, InstrumentDescriptor instrumentDescriptor, boolean enabled) {
        View view = registeredView.getView();
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, registeredView.getViewSourceInfo(), instrumentDescriptor);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrumentDescriptor, ExemplarFilterInternal.asExemplarFilterInternal(ExemplarFilter.alwaysOff()), registeredReader.getReader().getMemoryMode());
        return new AsynchronousMetricStorage(registeredReader, metricDescriptor, aggregator, registeredView.getViewAttributesProcessor(), registeredView.getCardinalityLimit(), enabled);
    }

    void record(Attributes attributes, long value) {
        attributes = this.validateAndProcessAttributes(attributes);
        AggregatorHandle<T> handle = this.aggregatorHandles.computeIfAbsent(attributes, this.handleBuilder);
        handle.recordLong(value, attributes, Context.current());
    }

    void record(Attributes attributes, double value) {
        attributes = this.validateAndProcessAttributes(attributes);
        AggregatorHandle<T> handle = this.aggregatorHandles.computeIfAbsent(attributes, this.handleBuilder);
        handle.recordDouble(value, attributes, Context.current());
    }

    void setEpochInformation(long startEpochNanos, long epochNanos) {
        this.startEpochNanos = this.aggregationTemporality == AggregationTemporality.DELTA ? this.registeredReader.getLastCollectEpochNanos() : startEpochNanos;
        this.epochNanos = epochNanos;
    }

    private Attributes validateAndProcessAttributes(Attributes attributes) {
        if (this.aggregatorHandles.size() >= this.maxCardinality) {
            this.throttlingLogger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has exceeded the maximum allowed cardinality (" + this.maxCardinality + ").");
            return MetricStorage.CARDINALITY_OVERFLOW;
        }
        Context context = Context.current();
        attributes = this.attributesProcessor.process(attributes, context);
        return attributes;
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    public RegisteredReader getRegisteredReader() {
        return this.registeredReader;
    }

    @Override
    public MetricData collect(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long startEpochNanos, long epochNanos) {
        Collection<T> result = this.aggregationTemporality == AggregationTemporality.DELTA ? this.collectWithDeltaAggregationTemporality() : this.collectWithCumulativeAggregationTemporality();
        this.aggregatorHandles.forEach(this.handleReleaser);
        this.aggregatorHandles.clear();
        return this.enabled ? this.aggregator.toMetricData(resource, instrumentationScopeInfo, this.metricDescriptor, result, this.aggregationTemporality) : EmptyMetricData.getInstance();
    }

    private Collection<T> collectWithDeltaAggregationTemporality() {
        Map<Object, Object> currentPoints;
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.reusablePointsList.forEach(this.reusablePointsPool::returnObject);
            this.reusablePointsList.clear();
            currentPoints = this.reusablePointsMap;
        } else {
            currentPoints = new HashMap();
        }
        this.aggregatorHandles.forEach((attributes, handle) -> {
            Object pointForCurrentPoints;
            Object point = handle.aggregateThenMaybeReset(this.startEpochNanos, this.epochNanos, (Attributes)attributes, true);
            if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
                pointForCurrentPoints = (PointData)this.reusablePointsPool.borrowObject();
                this.aggregator.copyPoint(point, pointForCurrentPoints);
            } else {
                pointForCurrentPoints = point;
            }
            currentPoints.put(attributes, pointForCurrentPoints);
        });
        ArrayList deltaPoints = this.memoryMode == MemoryMode.REUSABLE_DATA ? this.reusablePointsList : new ArrayList();
        currentPoints.forEach((attributes, currentPoint) -> {
            PointData deltaPoint;
            PointData lastPoint = (PointData)this.lastPoints.remove(attributes);
            if (lastPoint == null) {
                if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
                    deltaPoint = (PointData)this.reusablePointsPool.borrowObject();
                    this.aggregator.copyPoint((PointData)currentPoint, deltaPoint);
                } else {
                    deltaPoint = currentPoint;
                }
            } else if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
                this.aggregator.diffInPlace(lastPoint, (PointData)currentPoint);
                deltaPoint = lastPoint;
            } else {
                deltaPoint = this.aggregator.diff(lastPoint, (PointData)currentPoint);
            }
            deltaPoints.add(deltaPoint);
        });
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.lastPoints.forEach(this.pointReleaser);
            this.lastPoints.clear();
            Map<Attributes, T> tmp = this.lastPoints;
            this.lastPoints = this.reusablePointsMap;
            this.reusablePointsMap = tmp;
        } else {
            this.lastPoints = currentPoints;
        }
        return deltaPoints;
    }

    private Collection<T> collectWithCumulativeAggregationTemporality() {
        List<Object> currentPoints;
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.reusablePointsList.clear();
            currentPoints = this.reusablePointsList;
        } else {
            currentPoints = new ArrayList();
        }
        this.aggregatorHandles.forEach((attributes, handle) -> {
            Object value = handle.aggregateThenMaybeReset(this.startEpochNanos, this.epochNanos, (Attributes)attributes, true);
            currentPoints.add(value);
        });
        return currentPoints;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

