/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.timeout;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOperationHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.timeout.WriteTimeoutException;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class WriteTimeoutHandler
extends ChannelOperationHandlerAdapter {
    private final long timeoutMillis;
    private boolean closed;

    public WriteTimeoutHandler(int timeoutSeconds) {
        this(timeoutSeconds, TimeUnit.SECONDS);
    }

    public WriteTimeoutHandler(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.timeoutMillis = timeout <= 0L ? 0L : Math.max(unit.toMillis(timeout), 1L);
    }

    public void flush(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.scheduleTimeout(ctx, promise);
        ctx.flush(promise);
    }

    public void sendFile(ChannelHandlerContext ctx, FileRegion region, ChannelPromise promise) throws Exception {
        this.scheduleTimeout(ctx, promise);
        super.sendFile(ctx, region, promise);
    }

    private void scheduleTimeout(final ChannelHandlerContext ctx, final ChannelPromise future) {
        if (this.timeoutMillis > 0L) {
            io.netty.util.concurrent.ScheduledFuture sf = ctx.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    if (future.tryFailure((Throwable)((Object)WriteTimeoutException.INSTANCE))) {
                        try {
                            WriteTimeoutHandler.this.writeTimedOut(ctx);
                        }
                        catch (Throwable t) {
                            ctx.fireExceptionCaught(t);
                        }
                    }
                }
            }, this.timeoutMillis, TimeUnit.MILLISECONDS);
            future.addListener((GenericFutureListener)new ChannelFutureListener((ScheduledFuture)sf){
                final /* synthetic */ ScheduledFuture val$sf;
                {
                    this.val$sf = scheduledFuture;
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    this.val$sf.cancel(false);
                }
            });
        }
    }

    protected void writeTimedOut(ChannelHandlerContext ctx) throws Exception {
        if (!this.closed) {
            ctx.fireExceptionCaught((Throwable)((Object)WriteTimeoutException.INSTANCE));
            ctx.close();
            this.closed = true;
        }
    }
}

