/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.jsonrpc.internal;

import java.util.concurrent.atomic.AtomicLong;

public class SnowflakeId {
    private static final long EPOCH = 1640995200000L;
    private static final long MACHINE_ID = 1L;
    private static final long MACHINE_ID_BITS = 10L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_ID_SHIFT = 12L;
    private static final long TIMESTAMP_SHIFT = 22L;
    private static final AtomicLong lastTimestamp = new AtomicLong(-1L);
    private static final AtomicLong sequence = new AtomicLong(0L);
    private static final String BASE62_ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    private SnowflakeId() {
    }

    public static synchronized String generateId() {
        long currentTimestamp = System.currentTimeMillis() - 1640995200000L;
        if (currentTimestamp == lastTimestamp.get()) {
            long seq = sequence.incrementAndGet() & 0xFFFL;
            if (seq == 0L) {
                while (currentTimestamp <= lastTimestamp.get()) {
                    currentTimestamp = System.currentTimeMillis() - 1640995200000L;
                }
            }
        } else {
            sequence.set(0L);
        }
        lastTimestamp.set(currentTimestamp);
        return SnowflakeId.encodeBase62(currentTimestamp << 22 | 0x1000L | sequence.get());
    }

    private static String encodeBase62(long value) {
        StringBuilder sb = new StringBuilder();
        while (value > 0L) {
            sb.append(BASE62_ALPHABET.charAt((int)(value % 62L)));
            value /= 62L;
        }
        return sb.reverse().toString();
    }
}

