/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheusmetrics;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.prometheusmetrics.ExemplarSamplerFactory;
import io.micrometer.prometheusmetrics.PrometheusHistogram;
import io.prometheus.metrics.core.exemplars.ExemplarSampler;
import io.prometheus.metrics.model.snapshots.Exemplars;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class PrometheusDistributionSummary
extends AbstractDistributionSummary {
    private static final CountAtBucket[] EMPTY_HISTOGRAM = new CountAtBucket[0];
    private final LongAdder count = new LongAdder();
    private final DoubleAdder amount = new DoubleAdder();
    private final TimeWindowMax max;
    @Nullable
    private final Histogram histogram;
    @Nullable
    private final ExemplarSampler exemplarSampler;

    PrometheusDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, @Nullable ExemplarSamplerFactory exemplarSamplerFactory) {
        super(id, clock, DistributionStatisticConfig.builder().percentilesHistogram(Boolean.valueOf(false)).serviceLevelObjectives(new double[0]).build().merge(distributionStatisticConfig), scale, false);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
        if (distributionStatisticConfig.isPublishingHistogram()) {
            this.histogram = new PrometheusHistogram(clock, distributionStatisticConfig, exemplarSamplerFactory);
            this.exemplarSampler = null;
        } else {
            this.histogram = null;
            this.exemplarSampler = exemplarSamplerFactory != null ? exemplarSamplerFactory.createExemplarSampler(1) : null;
        }
    }

    protected void recordNonNegative(double amount) {
        this.count.increment();
        this.amount.add(amount);
        this.max.record(amount);
        if (this.histogram != null) {
            this.histogram.recordDouble(amount);
        } else if (this.exemplarSampler != null) {
            this.exemplarSampler.observe(amount);
        }
    }

    Exemplars exemplars() {
        if (this.histogram != null) {
            return ((PrometheusHistogram)this.histogram).exemplars();
        }
        return this.exemplarSampler != null ? this.exemplarSampler.collect() : Exemplars.EMPTY;
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalAmount() {
        return this.amount.doubleValue();
    }

    public double max() {
        return this.max.poll();
    }

    public CountAtBucket[] histogramCounts() {
        return this.histogram == null ? EMPTY_HISTOGRAM : this.histogram.takeSnapshot(0L, 0.0, 0.0).histogramCounts();
    }

    public HistogramSnapshot takeSnapshot() {
        HistogramSnapshot snapshot = super.takeSnapshot();
        if (this.histogram == null) {
            return snapshot;
        }
        return new HistogramSnapshot(snapshot.count(), snapshot.total(), snapshot.max(), snapshot.percentileValues(), this.histogramCounts(), (arg_0, arg_1) -> ((HistogramSnapshot)snapshot).outputSummary(arg_0, arg_1));
    }
}

