/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.jooby.Body;
import io.jooby.Context;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.MessageEncoder;
import io.jooby.ServiceRegistry;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class JacksonModule
implements Extension,
MessageDecoder,
MessageEncoder {
    private final ObjectMapper mapper;
    private final Set<Class<? extends Module>> modules = new HashSet<Class<? extends Module>>();

    public JacksonModule(@Nonnull ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public JacksonModule() {
        this(JacksonModule.create());
    }

    public JacksonModule module(Class<? extends Module> module) {
        this.modules.add(module);
        return this;
    }

    public void install(@Nonnull Jooby application) {
        application.decoder(MediaType.json, (MessageDecoder)this);
        application.encoder(MediaType.json, (MessageEncoder)this);
        ServiceRegistry services = application.getServices();
        services.put(ObjectMapper.class, (Object)this.mapper);
        application.onStarted(() -> {
            for (Class<? extends Module> type : this.modules) {
                Module module = (Module)application.require(type);
                this.mapper.registerModule(module);
            }
        });
    }

    public byte[] encode(@Nonnull Context ctx, @Nonnull Object value) throws Exception {
        ctx.setDefaultResponseType(MediaType.json);
        return this.mapper.writeValueAsBytes(value);
    }

    public <T> T decode(Context ctx, Type type) throws Exception {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        Body body = ctx.body();
        if (body.isInMemory()) {
            return (T)this.mapper.readValue(body.bytes(), javaType);
        }
        try (InputStream stream = body.stream();){
            Object object = this.mapper.readValue(stream, javaType);
            return (T)object;
        }
    }

    @Nonnull
    public static final ObjectMapper create() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new ParameterNamesModule());
        objectMapper.registerModule((Module)new AfterburnerModule());
        return objectMapper;
    }
}

