/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.hikari;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.sql.DataSource;

public class HikariModule
implements Extension {
    private static final Object MYSQL5_STT_CACHE_SIZE;
    private static final Object MYSQL5_STT_CACHE_SQL_LIMIT;
    private static final String DATASOURCE_CLASS_NAME = "dataSourceClassName";
    private static final String DRIVER_CLASS_NAME = "driverClassName";
    private static final int MINIMUM_SIZE = 10;
    private static final Set<String> SKIP_TOKENS;
    public static final ServiceKey<DataSource> KEY;
    private HikariConfig hikari;
    private String database;

    public HikariModule(@Nonnull String database) {
        this.database = database;
    }

    public HikariModule() {
        this("db");
    }

    public HikariModule(@Nonnull HikariConfig hikari) {
        this(hikari.getPoolName());
        this.hikari = hikari;
    }

    public void install(@Nonnull Jooby application) {
        if (this.hikari == null) {
            this.hikari = HikariModule.build(application.getEnvironment(), this.database);
        }
        HikariDataSource dataSource = new HikariDataSource(this.hikari);
        ServiceRegistry registry = application.getServices();
        ServiceKey key = ServiceKey.key(DataSource.class, (String)this.database);
        registry.putIfAbsent(KEY, (Object)dataSource);
        registry.put(key, (Object)dataSource);
        application.onStop(() -> ((HikariDataSource)dataSource).close());
    }

    @Nonnull
    public static String databaseType(@Nonnull String url) {
        String type = Arrays.stream(url.toLowerCase().split(":")).filter(token -> !SKIP_TOKENS.contains(token)).findFirst().orElse(url);
        return type;
    }

    @Nonnull
    public static String databaseName(@Nonnull String url) {
        int pstart;
        int c;
        int len = url.length();
        int q = url.indexOf(63);
        if (q == -1) {
            q = len;
        }
        if ((c = url.indexOf(59)) == -1) {
            c = len;
        }
        int end = Math.min(q, c);
        String clean = url.substring(0, end);
        int start = Math.max(clean.lastIndexOf(58), clean.lastIndexOf(47));
        String dbname = clean.substring(start + 1);
        int pnameStart = pstart = end + 1;
        int pnameEnd = pstart;
        for (int i = pstart; i < len; ++i) {
            char ch = url.charAt(i);
            if (ch == ';' || ch == '&') {
                String key = url.substring(pnameStart, pnameEnd).trim();
                if (key.equalsIgnoreCase("databaseName") || key.equalsIgnoreCase("database")) {
                    dbname = url.substring(pnameEnd + 1, i).trim();
                    break;
                }
                pnameStart = i + 1;
                continue;
            }
            if (ch != '=') continue;
            pnameEnd = i;
        }
        return dbname;
    }

    private static Map<String, Object> defaults(String database, Environment env) {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("maximumPoolSize", Math.max(10, Runtime.getRuntime().availableProcessors() * 2 + 1));
        if ("derby".equals(database)) {
            defaults.put(DATASOURCE_CLASS_NAME, "org.apache.derby.jdbc.ClientDataSource");
        } else if ("db2".equals(database)) {
            defaults.put(DATASOURCE_CLASS_NAME, "com.ibm.db2.jcc.DB2SimpleDataSource");
        } else if ("h2".equals(database)) {
            defaults.put(DATASOURCE_CLASS_NAME, "org.h2.jdbcx.JdbcDataSource");
            defaults.put("dataSource.user", "sa");
            defaults.put("dataSource.password", "");
        } else if ("hsqldb".equals(database)) {
            defaults.put(DATASOURCE_CLASS_NAME, "org.hsqldb.jdbc.JDBCDataSource");
        } else if ("mariadb".equals(database)) {
            defaults.put(DATASOURCE_CLASS_NAME, "org.mariadb.jdbc.MySQLDataSource");
        } else if ("mysql".equals(database)) {
            env.loadClass("com.mysql.cj.jdbc.MysqlDataSource").ifPresent(klass -> defaults.put(DATASOURCE_CLASS_NAME, klass.getName()));
            if (!defaults.containsKey(DATASOURCE_CLASS_NAME)) {
                env.loadClass("com.mysql.jdbc.jdbc2.optional.MysqlDataSource").ifPresent(klass -> {
                    defaults.put(DATASOURCE_CLASS_NAME, klass.getName());
                    defaults.put("dataSource.encoding", env.getConfig().getString("application.charset"));
                    defaults.put("dataSource.cachePrepStmts", true);
                    defaults.put("dataSource.prepStmtCacheSize", MYSQL5_STT_CACHE_SIZE);
                    defaults.put("dataSource.prepStmtCacheSqlLimit", MYSQL5_STT_CACHE_SQL_LIMIT);
                    defaults.put("dataSource.useServerPrepStmts", true);
                });
            }
        } else if ("sqlserver".equals(database)) {
            defaults.put(DATASOURCE_CLASS_NAME, "com.microsoft.sqlserver.jdbc.SQLServerDataSource");
        } else if ("oracle".equals(database)) {
            defaults.put(DATASOURCE_CLASS_NAME, "oracle.jdbc.pool.OracleDataSource");
        } else if ("pgsql".equals(database)) {
            defaults.put(DATASOURCE_CLASS_NAME, "com.impossibl.postgres.jdbc.PGDataSource");
        } else if ("postgresql".equals(database)) {
            defaults.put(DATASOURCE_CLASS_NAME, "org.postgresql.ds.PGSimpleDataSource");
        } else if ("sybase".equals(database)) {
            defaults.put(DATASOURCE_CLASS_NAME, "com.sybase.jdbcx.SybDataSource");
        } else if ("firebirdsql".equals(database)) {
            defaults.put(DATASOURCE_CLASS_NAME, "org.firebirdsql.pool.FBSimpleDataSource");
        } else if ("sqlite".equals(database)) {
            defaults.put(DATASOURCE_CLASS_NAME, "org.sqlite.SQLiteDataSource");
        } else if ("log4jdbc".equals(database)) {
            defaults.put(DRIVER_CLASS_NAME, "net.sf.log4jdbc.DriverSpy");
        }
        return defaults;
    }

    static HikariConfig build(Environment env, String database) {
        String dbname;
        String dbtype;
        Config config = env.getConfig();
        boolean isProperty = HikariModule.isProperty(config, database);
        String dbkey = database;
        Properties properties = isProperty ? HikariModule.properties(config, database) : HikariModule.jdbcUrl(config, database);
        String dburl = (String)properties.get("dataSource.url");
        if (dburl != null) {
            dbtype = HikariModule.databaseType(dburl);
            dbname = HikariModule.databaseName(dburl);
        } else {
            dbtype = null;
            dbname = null;
        }
        if (dbname != null && !dbkey.equals(dbname)) {
            HikariModule.dumpProperties(config, dbname, "dataSource.", properties::setProperty);
        }
        Stream.of(dbkey, dbname).filter(Objects::nonNull).distinct().forEach(key -> HikariModule.dumpProperties(config, "hikari", "", properties::setProperty));
        Stream.of(dbkey, dbname).filter(Objects::nonNull).distinct().forEach(key -> {
            HikariModule.dumpProperties(config, key + ".dataSource", "dataSource.", properties::setProperty);
            HikariModule.dumpProperties(config, key + ".hikari", "", properties::setProperty);
        });
        Map<String, Object> defaults = HikariModule.defaults(dbtype, env);
        Properties configuration = new Properties();
        configuration.putAll(defaults);
        configuration.putAll((Map<?, ?>)properties);
        if (configuration.containsKey(DRIVER_CLASS_NAME)) {
            configuration.remove(DATASOURCE_CLASS_NAME);
            configuration.remove("dataSource.url");
            configuration.setProperty("jdbcUrl", dburl);
        }
        if (dbtype == null) {
            String poolName = Stream.of(configuration.getProperty(DATASOURCE_CLASS_NAME), configuration.getProperty(DRIVER_CLASS_NAME), configuration.getProperty("dataSource.database"), configuration.getProperty("dataSource.databaseName")).filter(Objects::nonNull).map(n -> n.replace("DataSource", "").replace("Driver", "")).map(n -> {
                int i = n.lastIndexOf(46);
                return i != -1 ? n.substring(i + 1).toLowerCase() : n;
            }).collect(Collectors.joining("."));
            configuration.put("poolName", poolName);
        } else {
            configuration.put("poolName", dbtype + "." + dbname);
        }
        Optional.ofNullable(configuration.remove("dataSource.user")).ifPresent(user -> configuration.setProperty("username", user.toString()));
        Optional.ofNullable(configuration.remove("dataSource.password")).ifPresent(password -> configuration.setProperty("password", password.toString()));
        return new HikariConfig(configuration);
    }

    private static void dumpProperties(Config config, String key, String prefix, BiConsumer<String, String> consumer) {
        Object anyRef;
        if (HikariModule.isProperty(config, key) && (anyRef = config.getAnyRef(key)) instanceof Map) {
            Set entries = ((Map)anyRef).entrySet();
            for (Map.Entry e : entries) {
                Object value = e.getValue();
                if (value instanceof Map) continue;
                String k = prefix + e.getKey();
                consumer.accept(k, value.toString());
            }
        }
    }

    private static Properties properties(Config config, String database) {
        Properties hikari;
        ConfigValue dbvalue = config.getValue(database);
        if (dbvalue.valueType() == ConfigValueType.OBJECT) {
            hikari = new Properties();
            HikariModule.dumpProperties(config, database, "dataSource.", hikari::setProperty);
        } else {
            hikari = HikariModule.jdbcUrl(config, (String)dbvalue.unwrapped());
        }
        Stream.of(DATASOURCE_CLASS_NAME, DRIVER_CLASS_NAME).forEach(k -> {
            String value = (String)hikari.remove("dataSource." + k);
            if (value != null) {
                hikari.setProperty((String)k, value);
            }
        });
        return hikari;
    }

    private static boolean isProperty(Config config, String key) {
        try {
            return config.hasPath(key);
        }
        catch (ConfigException x) {
            return false;
        }
    }

    private static Properties jdbcUrl(Config conf, String database) {
        Properties hikari = new Properties();
        if ("mem".equals(database)) {
            hikari.setProperty("dataSource.url", "jdbc:h2:mem:@mem" + HikariModule.rnd() + ";DB_CLOSE_DELAY=-1");
            hikari.setProperty("dataSource.user", "sa");
            hikari.setProperty("dataSource.password", "");
        } else if ("local".equals(database) || "tmp".equals(database)) {
            String name;
            Path basedir;
            if ("local".equals(database)) {
                basedir = Paths.get(System.getProperty("user.dir"), new String[0]);
                name = basedir.getFileName().toString();
            } else {
                name = "tmp" + HikariModule.rnd();
                basedir = Paths.get(conf.getString("application.tmpdir"), new String[0]);
            }
            Path path = basedir.resolve(name);
            hikari.setProperty("dataSource.url", "jdbc:h2:" + path.toAbsolutePath());
            hikari.setProperty("dataSource.user", "sa");
            hikari.setProperty("dataSource.password", "");
        } else {
            hikari.setProperty("dataSource.url", database);
        }
        return hikari;
    }

    private static String rnd() {
        return Long.toHexString(UUID.randomUUID().getMostSignificantBits());
    }

    static {
        System.setProperty("log4jdbc.auto.load.popular.drivers", "false");
        MYSQL5_STT_CACHE_SIZE = 250;
        MYSQL5_STT_CACHE_SQL_LIMIT = 2048;
        SKIP_TOKENS = Stream.of("jdbc", "jtds").collect(Collectors.toSet());
        KEY = ServiceKey.key(DataSource.class);
    }
}

