/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.id;

import io.hypersistence.tsid.TSID;
import io.hypersistence.utils.common.ReflectionUtils;
import io.hypersistence.utils.hibernate.id.Tsid;
import java.lang.reflect.Member;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.spi.CustomIdGeneratorCreationContext;

public class TsidGenerator
implements IdentifierGenerator {
    private final TSID.Factory tsidFactory;
    private AttributeType idType;

    public TsidGenerator(Tsid config, Member idMember, CustomIdGeneratorCreationContext creationContext) {
        this.idType = AttributeType.valueOf(ReflectionUtils.getMemberType(idMember));
        Class<? extends Supplier<TSID.Factory>> tsidSupplierClass = config.value();
        if (tsidSupplierClass.equals(Tsid.FactorySupplier.class)) {
            this.tsidFactory = Tsid.FactorySupplier.INSTANCE.get();
        } else {
            Supplier factorySupplier = (Supplier)ReflectionUtils.newInstance(tsidSupplierClass);
            this.tsidFactory = (TSID.Factory)factorySupplier.get();
        }
    }

    public Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        return this.idType.cast(this.tsidFactory.generate());
    }

    static enum AttributeType {
        LONG{

            @Override
            public Object cast(TSID tsid) {
                return tsid.toLong();
            }
        }
        ,
        STRING{

            @Override
            public Object cast(TSID tsid) {
                return tsid.toString();
            }
        }
        ,
        TSID{

            @Override
            public Object cast(TSID tsid) {
                return tsid;
            }
        };


        public abstract Object cast(TSID var1);

        static AttributeType valueOf(Class clazz) {
            if (Long.class.isAssignableFrom(clazz)) {
                return LONG;
            }
            if (String.class.isAssignableFrom(clazz)) {
                return STRING;
            }
            if (TSID.class.isAssignableFrom(clazz)) {
                return TSID;
            }
            throw new HibernateException(String.format("The @Tsid annotation on [%s] can only be placed on a Long, String, or TSID entity attribute!", clazz));
        }
    }
}

