// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/config/rbac/v3/rbac.proto

// Protobuf Java Version: 3.25.1
package io.envoyproxy.envoy.config.rbac.v3;

/**
 * <pre>
 * Role Based Access Control (RBAC) provides service-level and method-level access control for a
 * service. Requests are allowed or denied based on the ``action`` and whether a matching policy is
 * found. For instance, if the action is ALLOW and a matching policy is found the request should be
 * allowed.
 *
 * RBAC can also be used to make access logging decisions by communicating with access loggers
 * through dynamic metadata. When the action is LOG and at least one policy matches, the
 * ``access_log_hint`` value in the shared key namespace 'envoy.common' is set to ``true`` indicating
 * the request should be logged.
 *
 * Here is an example of RBAC configuration. It has two policies:
 *
 * * Service account ``cluster.local/ns/default/sa/admin`` has full access to the service, and so
 *   does "cluster.local/ns/default/sa/superuser".
 *
 * * Any user can read (``GET``) the service at paths with prefix ``/products``, so long as the
 *   destination port is either 80 or 443.
 *
 *  .. code-block:: yaml
 *
 *   action: ALLOW
 *   policies:
 *     "service-admin":
 *       permissions:
 *         - any: true
 *       principals:
 *         - authenticated:
 *             principal_name:
 *               exact: "cluster.local/ns/default/sa/admin"
 *         - authenticated:
 *             principal_name:
 *               exact: "cluster.local/ns/default/sa/superuser"
 *     "product-viewer":
 *       permissions:
 *           - and_rules:
 *               rules:
 *                 - header:
 *                     name: ":method"
 *                     string_match:
 *                       exact: "GET"
 *                 - url_path:
 *                     path: { prefix: "/products" }
 *                 - or_rules:
 *                     rules:
 *                       - destination_port: 80
 *                       - destination_port: 443
 *       principals:
 *         - any: true
 * </pre>
 *
 * Protobuf type {@code envoy.config.rbac.v3.RBAC}
 */
public final class RBAC extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.config.rbac.v3.RBAC)
    RBACOrBuilder {
private static final long serialVersionUID = 0L;
  // Use RBAC.newBuilder() to construct.
  private RBAC(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private RBAC() {
    action_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new RBAC();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetPolicies();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.config.rbac.v3.RBAC.class, io.envoyproxy.envoy.config.rbac.v3.RBAC.Builder.class);
  }

  /**
   * <pre>
   * Should we do safe-list or block-list style access control?
   * </pre>
   *
   * Protobuf enum {@code envoy.config.rbac.v3.RBAC.Action}
   */
  public enum Action
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The policies grant access to principals. The rest are denied. This is safe-list style
     * access control. This is the default type.
     * </pre>
     *
     * <code>ALLOW = 0;</code>
     */
    ALLOW(0),
    /**
     * <pre>
     * The policies deny access to principals. The rest are allowed. This is block-list style
     * access control.
     * </pre>
     *
     * <code>DENY = 1;</code>
     */
    DENY(1),
    /**
     * <pre>
     * The policies set the ``access_log_hint`` dynamic metadata key based on if requests match.
     * All requests are allowed.
     * </pre>
     *
     * <code>LOG = 2;</code>
     */
    LOG(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The policies grant access to principals. The rest are denied. This is safe-list style
     * access control. This is the default type.
     * </pre>
     *
     * <code>ALLOW = 0;</code>
     */
    public static final int ALLOW_VALUE = 0;
    /**
     * <pre>
     * The policies deny access to principals. The rest are allowed. This is block-list style
     * access control.
     * </pre>
     *
     * <code>DENY = 1;</code>
     */
    public static final int DENY_VALUE = 1;
    /**
     * <pre>
     * The policies set the ``access_log_hint`` dynamic metadata key based on if requests match.
     * All requests are allowed.
     * </pre>
     *
     * <code>LOG = 2;</code>
     */
    public static final int LOG_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Action valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Action forNumber(int value) {
      switch (value) {
        case 0: return ALLOW;
        case 1: return DENY;
        case 2: return LOG;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Action>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Action> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Action>() {
            public Action findValueByNumber(int number) {
              return Action.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.rbac.v3.RBAC.getDescriptor().getEnumTypes().get(0);
    }

    private static final Action[] VALUES = values();

    public static Action valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Action(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:envoy.config.rbac.v3.RBAC.Action)
  }

  public interface AuditLoggingOptionsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:envoy.config.rbac.v3.RBAC.AuditLoggingOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Condition for the audit logging to happen.
     * If this condition is met, all the audit loggers configured here will be invoked.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition audit_condition = 1 [(.validate.rules) = { ... }</code>
     * @return The enum numeric value on the wire for auditCondition.
     */
    int getAuditConditionValue();
    /**
     * <pre>
     * Condition for the audit logging to happen.
     * If this condition is met, all the audit loggers configured here will be invoked.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition audit_condition = 1 [(.validate.rules) = { ... }</code>
     * @return The auditCondition.
     */
    io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition getAuditCondition();

    /**
     * <pre>
     * Configurations for RBAC-based authorization audit loggers.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
     */
    java.util.List<io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig> 
        getLoggerConfigsList();
    /**
     * <pre>
     * Configurations for RBAC-based authorization audit loggers.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
     */
    io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig getLoggerConfigs(int index);
    /**
     * <pre>
     * Configurations for RBAC-based authorization audit loggers.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
     */
    int getLoggerConfigsCount();
    /**
     * <pre>
     * Configurations for RBAC-based authorization audit loggers.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
     */
    java.util.List<? extends io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfigOrBuilder> 
        getLoggerConfigsOrBuilderList();
    /**
     * <pre>
     * Configurations for RBAC-based authorization audit loggers.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
     */
    io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfigOrBuilder getLoggerConfigsOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code envoy.config.rbac.v3.RBAC.AuditLoggingOptions}
   */
  public static final class AuditLoggingOptions extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:envoy.config.rbac.v3.RBAC.AuditLoggingOptions)
      AuditLoggingOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use AuditLoggingOptions.newBuilder() to construct.
    private AuditLoggingOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private AuditLoggingOptions() {
      auditCondition_ = 0;
      loggerConfigs_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new AuditLoggingOptions();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_AuditLoggingOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_AuditLoggingOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.class, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.Builder.class);
    }

    /**
     * <pre>
     * Deny and allow here refer to RBAC decisions, not actions.
     * </pre>
     *
     * Protobuf enum {@code envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition}
     */
    public enum AuditCondition
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       * Never audit.
       * </pre>
       *
       * <code>NONE = 0;</code>
       */
      NONE(0),
      /**
       * <pre>
       * Audit when RBAC denies the request.
       * </pre>
       *
       * <code>ON_DENY = 1;</code>
       */
      ON_DENY(1),
      /**
       * <pre>
       * Audit when RBAC allows the request.
       * </pre>
       *
       * <code>ON_ALLOW = 2;</code>
       */
      ON_ALLOW(2),
      /**
       * <pre>
       * Audit whether RBAC allows or denies the request.
       * </pre>
       *
       * <code>ON_DENY_AND_ALLOW = 3;</code>
       */
      ON_DENY_AND_ALLOW(3),
      UNRECOGNIZED(-1),
      ;

      /**
       * <pre>
       * Never audit.
       * </pre>
       *
       * <code>NONE = 0;</code>
       */
      public static final int NONE_VALUE = 0;
      /**
       * <pre>
       * Audit when RBAC denies the request.
       * </pre>
       *
       * <code>ON_DENY = 1;</code>
       */
      public static final int ON_DENY_VALUE = 1;
      /**
       * <pre>
       * Audit when RBAC allows the request.
       * </pre>
       *
       * <code>ON_ALLOW = 2;</code>
       */
      public static final int ON_ALLOW_VALUE = 2;
      /**
       * <pre>
       * Audit whether RBAC allows or denies the request.
       * </pre>
       *
       * <code>ON_DENY_AND_ALLOW = 3;</code>
       */
      public static final int ON_DENY_AND_ALLOW_VALUE = 3;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AuditCondition valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static AuditCondition forNumber(int value) {
        switch (value) {
          case 0: return NONE;
          case 1: return ON_DENY;
          case 2: return ON_ALLOW;
          case 3: return ON_DENY_AND_ALLOW;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<AuditCondition>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          AuditCondition> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AuditCondition>() {
              public AuditCondition findValueByNumber(int number) {
                return AuditCondition.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.getDescriptor().getEnumTypes().get(0);
      }

      private static final AuditCondition[] VALUES = values();

      public static AuditCondition valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private AuditCondition(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition)
    }

    public interface AuditLoggerConfigOrBuilder extends
        // @@protoc_insertion_point(interface_extends:envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Typed logger configuration.
       *
       * [#extension-category: envoy.rbac.audit_loggers]
       * </pre>
       *
       * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
       * @return Whether the auditLogger field is set.
       */
      boolean hasAuditLogger();
      /**
       * <pre>
       * Typed logger configuration.
       *
       * [#extension-category: envoy.rbac.audit_loggers]
       * </pre>
       *
       * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
       * @return The auditLogger.
       */
      io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig getAuditLogger();
      /**
       * <pre>
       * Typed logger configuration.
       *
       * [#extension-category: envoy.rbac.audit_loggers]
       * </pre>
       *
       * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
       */
      io.envoyproxy.envoy.config.core.v3.TypedExtensionConfigOrBuilder getAuditLoggerOrBuilder();

      /**
       * <pre>
       * If true, when the logger is not supported, the data plane will not NACK but simply ignore it.
       * </pre>
       *
       * <code>bool is_optional = 2;</code>
       * @return The isOptional.
       */
      boolean getIsOptional();
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * Protobuf type {@code envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig}
     */
    public static final class AuditLoggerConfig extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig)
        AuditLoggerConfigOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use AuditLoggerConfig.newBuilder() to construct.
      private AuditLoggerConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private AuditLoggerConfig() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new AuditLoggerConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_AuditLoggingOptions_AuditLoggerConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_AuditLoggingOptions_AuditLoggerConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.class, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.Builder.class);
      }

      private int bitField0_;
      public static final int AUDIT_LOGGER_FIELD_NUMBER = 1;
      private io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig auditLogger_;
      /**
       * <pre>
       * Typed logger configuration.
       *
       * [#extension-category: envoy.rbac.audit_loggers]
       * </pre>
       *
       * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
       * @return Whether the auditLogger field is set.
       */
      @java.lang.Override
      public boolean hasAuditLogger() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Typed logger configuration.
       *
       * [#extension-category: envoy.rbac.audit_loggers]
       * </pre>
       *
       * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
       * @return The auditLogger.
       */
      @java.lang.Override
      public io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig getAuditLogger() {
        return auditLogger_ == null ? io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig.getDefaultInstance() : auditLogger_;
      }
      /**
       * <pre>
       * Typed logger configuration.
       *
       * [#extension-category: envoy.rbac.audit_loggers]
       * </pre>
       *
       * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
       */
      @java.lang.Override
      public io.envoyproxy.envoy.config.core.v3.TypedExtensionConfigOrBuilder getAuditLoggerOrBuilder() {
        return auditLogger_ == null ? io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig.getDefaultInstance() : auditLogger_;
      }

      public static final int IS_OPTIONAL_FIELD_NUMBER = 2;
      private boolean isOptional_ = false;
      /**
       * <pre>
       * If true, when the logger is not supported, the data plane will not NACK but simply ignore it.
       * </pre>
       *
       * <code>bool is_optional = 2;</code>
       * @return The isOptional.
       */
      @java.lang.Override
      public boolean getIsOptional() {
        return isOptional_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getAuditLogger());
        }
        if (isOptional_ != false) {
          output.writeBool(2, isOptional_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, getAuditLogger());
        }
        if (isOptional_ != false) {
          size += com.google.protobuf.CodedOutputStream
            .computeBoolSize(2, isOptional_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig)) {
          return super.equals(obj);
        }
        io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig other = (io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig) obj;

        if (hasAuditLogger() != other.hasAuditLogger()) return false;
        if (hasAuditLogger()) {
          if (!getAuditLogger()
              .equals(other.getAuditLogger())) return false;
        }
        if (getIsOptional()
            != other.getIsOptional()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasAuditLogger()) {
          hash = (37 * hash) + AUDIT_LOGGER_FIELD_NUMBER;
          hash = (53 * hash) + getAuditLogger().hashCode();
        }
        hash = (37 * hash) + IS_OPTIONAL_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getIsOptional());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * [#not-implemented-hide:]
       * </pre>
       *
       * Protobuf type {@code envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig)
          io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_AuditLoggingOptions_AuditLoggerConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_AuditLoggingOptions_AuditLoggerConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.class, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.Builder.class);
        }

        // Construct using io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getAuditLoggerFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          auditLogger_ = null;
          if (auditLoggerBuilder_ != null) {
            auditLoggerBuilder_.dispose();
            auditLoggerBuilder_ = null;
          }
          isOptional_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_AuditLoggingOptions_AuditLoggerConfig_descriptor;
        }

        @java.lang.Override
        public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig getDefaultInstanceForType() {
          return io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.getDefaultInstance();
        }

        @java.lang.Override
        public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig build() {
          io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig buildPartial() {
          io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig result = new io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.auditLogger_ = auditLoggerBuilder_ == null
                ? auditLogger_
                : auditLoggerBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.isOptional_ = isOptional_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig) {
            return mergeFrom((io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig other) {
          if (other == io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.getDefaultInstance()) return this;
          if (other.hasAuditLogger()) {
            mergeAuditLogger(other.getAuditLogger());
          }
          if (other.getIsOptional() != false) {
            setIsOptional(other.getIsOptional());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  input.readMessage(
                      getAuditLoggerFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 16: {
                  isOptional_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig auditLogger_;
        private com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig, io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig.Builder, io.envoyproxy.envoy.config.core.v3.TypedExtensionConfigOrBuilder> auditLoggerBuilder_;
        /**
         * <pre>
         * Typed logger configuration.
         *
         * [#extension-category: envoy.rbac.audit_loggers]
         * </pre>
         *
         * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
         * @return Whether the auditLogger field is set.
         */
        public boolean hasAuditLogger() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * Typed logger configuration.
         *
         * [#extension-category: envoy.rbac.audit_loggers]
         * </pre>
         *
         * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
         * @return The auditLogger.
         */
        public io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig getAuditLogger() {
          if (auditLoggerBuilder_ == null) {
            return auditLogger_ == null ? io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig.getDefaultInstance() : auditLogger_;
          } else {
            return auditLoggerBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Typed logger configuration.
         *
         * [#extension-category: envoy.rbac.audit_loggers]
         * </pre>
         *
         * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
         */
        public Builder setAuditLogger(io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig value) {
          if (auditLoggerBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            auditLogger_ = value;
          } else {
            auditLoggerBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Typed logger configuration.
         *
         * [#extension-category: envoy.rbac.audit_loggers]
         * </pre>
         *
         * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
         */
        public Builder setAuditLogger(
            io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig.Builder builderForValue) {
          if (auditLoggerBuilder_ == null) {
            auditLogger_ = builderForValue.build();
          } else {
            auditLoggerBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Typed logger configuration.
         *
         * [#extension-category: envoy.rbac.audit_loggers]
         * </pre>
         *
         * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
         */
        public Builder mergeAuditLogger(io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig value) {
          if (auditLoggerBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0) &&
              auditLogger_ != null &&
              auditLogger_ != io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig.getDefaultInstance()) {
              getAuditLoggerBuilder().mergeFrom(value);
            } else {
              auditLogger_ = value;
            }
          } else {
            auditLoggerBuilder_.mergeFrom(value);
          }
          if (auditLogger_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         * <pre>
         * Typed logger configuration.
         *
         * [#extension-category: envoy.rbac.audit_loggers]
         * </pre>
         *
         * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
         */
        public Builder clearAuditLogger() {
          bitField0_ = (bitField0_ & ~0x00000001);
          auditLogger_ = null;
          if (auditLoggerBuilder_ != null) {
            auditLoggerBuilder_.dispose();
            auditLoggerBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Typed logger configuration.
         *
         * [#extension-category: envoy.rbac.audit_loggers]
         * </pre>
         *
         * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
         */
        public io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig.Builder getAuditLoggerBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getAuditLoggerFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Typed logger configuration.
         *
         * [#extension-category: envoy.rbac.audit_loggers]
         * </pre>
         *
         * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
         */
        public io.envoyproxy.envoy.config.core.v3.TypedExtensionConfigOrBuilder getAuditLoggerOrBuilder() {
          if (auditLoggerBuilder_ != null) {
            return auditLoggerBuilder_.getMessageOrBuilder();
          } else {
            return auditLogger_ == null ?
                io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig.getDefaultInstance() : auditLogger_;
          }
        }
        /**
         * <pre>
         * Typed logger configuration.
         *
         * [#extension-category: envoy.rbac.audit_loggers]
         * </pre>
         *
         * <code>.envoy.config.core.v3.TypedExtensionConfig audit_logger = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig, io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig.Builder, io.envoyproxy.envoy.config.core.v3.TypedExtensionConfigOrBuilder> 
            getAuditLoggerFieldBuilder() {
          if (auditLoggerBuilder_ == null) {
            auditLoggerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig, io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig.Builder, io.envoyproxy.envoy.config.core.v3.TypedExtensionConfigOrBuilder>(
                    getAuditLogger(),
                    getParentForChildren(),
                    isClean());
            auditLogger_ = null;
          }
          return auditLoggerBuilder_;
        }

        private boolean isOptional_ ;
        /**
         * <pre>
         * If true, when the logger is not supported, the data plane will not NACK but simply ignore it.
         * </pre>
         *
         * <code>bool is_optional = 2;</code>
         * @return The isOptional.
         */
        @java.lang.Override
        public boolean getIsOptional() {
          return isOptional_;
        }
        /**
         * <pre>
         * If true, when the logger is not supported, the data plane will not NACK but simply ignore it.
         * </pre>
         *
         * <code>bool is_optional = 2;</code>
         * @param value The isOptional to set.
         * @return This builder for chaining.
         */
        public Builder setIsOptional(boolean value) {

          isOptional_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * If true, when the logger is not supported, the data plane will not NACK but simply ignore it.
         * </pre>
         *
         * <code>bool is_optional = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearIsOptional() {
          bitField0_ = (bitField0_ & ~0x00000002);
          isOptional_ = false;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig)
      }

      // @@protoc_insertion_point(class_scope:envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig)
      private static final io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig();
      }

      public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AuditLoggerConfig>
          PARSER = new com.google.protobuf.AbstractParser<AuditLoggerConfig>() {
        @java.lang.Override
        public AuditLoggerConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static com.google.protobuf.Parser<AuditLoggerConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AuditLoggerConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int AUDIT_CONDITION_FIELD_NUMBER = 1;
    private int auditCondition_ = 0;
    /**
     * <pre>
     * Condition for the audit logging to happen.
     * If this condition is met, all the audit loggers configured here will be invoked.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition audit_condition = 1 [(.validate.rules) = { ... }</code>
     * @return The enum numeric value on the wire for auditCondition.
     */
    @java.lang.Override public int getAuditConditionValue() {
      return auditCondition_;
    }
    /**
     * <pre>
     * Condition for the audit logging to happen.
     * If this condition is met, all the audit loggers configured here will be invoked.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition audit_condition = 1 [(.validate.rules) = { ... }</code>
     * @return The auditCondition.
     */
    @java.lang.Override public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition getAuditCondition() {
      io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition result = io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition.forNumber(auditCondition_);
      return result == null ? io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition.UNRECOGNIZED : result;
    }

    public static final int LOGGER_CONFIGS_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig> loggerConfigs_;
    /**
     * <pre>
     * Configurations for RBAC-based authorization audit loggers.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
     */
    @java.lang.Override
    public java.util.List<io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig> getLoggerConfigsList() {
      return loggerConfigs_;
    }
    /**
     * <pre>
     * Configurations for RBAC-based authorization audit loggers.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfigOrBuilder> 
        getLoggerConfigsOrBuilderList() {
      return loggerConfigs_;
    }
    /**
     * <pre>
     * Configurations for RBAC-based authorization audit loggers.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
     */
    @java.lang.Override
    public int getLoggerConfigsCount() {
      return loggerConfigs_.size();
    }
    /**
     * <pre>
     * Configurations for RBAC-based authorization audit loggers.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig getLoggerConfigs(int index) {
      return loggerConfigs_.get(index);
    }
    /**
     * <pre>
     * Configurations for RBAC-based authorization audit loggers.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfigOrBuilder getLoggerConfigsOrBuilder(
        int index) {
      return loggerConfigs_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (auditCondition_ != io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition.NONE.getNumber()) {
        output.writeEnum(1, auditCondition_);
      }
      for (int i = 0; i < loggerConfigs_.size(); i++) {
        output.writeMessage(2, loggerConfigs_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (auditCondition_ != io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition.NONE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, auditCondition_);
      }
      for (int i = 0; i < loggerConfigs_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, loggerConfigs_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions)) {
        return super.equals(obj);
      }
      io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions other = (io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions) obj;

      if (auditCondition_ != other.auditCondition_) return false;
      if (!getLoggerConfigsList()
          .equals(other.getLoggerConfigsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + AUDIT_CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + auditCondition_;
      if (getLoggerConfigsCount() > 0) {
        hash = (37 * hash) + LOGGER_CONFIGS_FIELD_NUMBER;
        hash = (53 * hash) + getLoggerConfigsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code envoy.config.rbac.v3.RBAC.AuditLoggingOptions}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:envoy.config.rbac.v3.RBAC.AuditLoggingOptions)
        io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_AuditLoggingOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_AuditLoggingOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.class, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.Builder.class);
      }

      // Construct using io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        auditCondition_ = 0;
        if (loggerConfigsBuilder_ == null) {
          loggerConfigs_ = java.util.Collections.emptyList();
        } else {
          loggerConfigs_ = null;
          loggerConfigsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_AuditLoggingOptions_descriptor;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions getDefaultInstanceForType() {
        return io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.getDefaultInstance();
      }

      @java.lang.Override
      public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions build() {
        io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions buildPartial() {
        io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions result = new io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions result) {
        if (loggerConfigsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            loggerConfigs_ = java.util.Collections.unmodifiableList(loggerConfigs_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.loggerConfigs_ = loggerConfigs_;
        } else {
          result.loggerConfigs_ = loggerConfigsBuilder_.build();
        }
      }

      private void buildPartial0(io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.auditCondition_ = auditCondition_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions) {
          return mergeFrom((io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions other) {
        if (other == io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.getDefaultInstance()) return this;
        if (other.auditCondition_ != 0) {
          setAuditConditionValue(other.getAuditConditionValue());
        }
        if (loggerConfigsBuilder_ == null) {
          if (!other.loggerConfigs_.isEmpty()) {
            if (loggerConfigs_.isEmpty()) {
              loggerConfigs_ = other.loggerConfigs_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureLoggerConfigsIsMutable();
              loggerConfigs_.addAll(other.loggerConfigs_);
            }
            onChanged();
          }
        } else {
          if (!other.loggerConfigs_.isEmpty()) {
            if (loggerConfigsBuilder_.isEmpty()) {
              loggerConfigsBuilder_.dispose();
              loggerConfigsBuilder_ = null;
              loggerConfigs_ = other.loggerConfigs_;
              bitField0_ = (bitField0_ & ~0x00000002);
              loggerConfigsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getLoggerConfigsFieldBuilder() : null;
            } else {
              loggerConfigsBuilder_.addAllMessages(other.loggerConfigs_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                auditCondition_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 18: {
                io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig m =
                    input.readMessage(
                        io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.parser(),
                        extensionRegistry);
                if (loggerConfigsBuilder_ == null) {
                  ensureLoggerConfigsIsMutable();
                  loggerConfigs_.add(m);
                } else {
                  loggerConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int auditCondition_ = 0;
      /**
       * <pre>
       * Condition for the audit logging to happen.
       * If this condition is met, all the audit loggers configured here will be invoked.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition audit_condition = 1 [(.validate.rules) = { ... }</code>
       * @return The enum numeric value on the wire for auditCondition.
       */
      @java.lang.Override public int getAuditConditionValue() {
        return auditCondition_;
      }
      /**
       * <pre>
       * Condition for the audit logging to happen.
       * If this condition is met, all the audit loggers configured here will be invoked.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition audit_condition = 1 [(.validate.rules) = { ... }</code>
       * @param value The enum numeric value on the wire for auditCondition to set.
       * @return This builder for chaining.
       */
      public Builder setAuditConditionValue(int value) {
        auditCondition_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Condition for the audit logging to happen.
       * If this condition is met, all the audit loggers configured here will be invoked.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition audit_condition = 1 [(.validate.rules) = { ... }</code>
       * @return The auditCondition.
       */
      @java.lang.Override
      public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition getAuditCondition() {
        io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition result = io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition.forNumber(auditCondition_);
        return result == null ? io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Condition for the audit logging to happen.
       * If this condition is met, all the audit loggers configured here will be invoked.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition audit_condition = 1 [(.validate.rules) = { ... }</code>
       * @param value The auditCondition to set.
       * @return This builder for chaining.
       */
      public Builder setAuditCondition(io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        auditCondition_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Condition for the audit logging to happen.
       * If this condition is met, all the audit loggers configured here will be invoked.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditCondition audit_condition = 1 [(.validate.rules) = { ... }</code>
       * @return This builder for chaining.
       */
      public Builder clearAuditCondition() {
        bitField0_ = (bitField0_ & ~0x00000001);
        auditCondition_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig> loggerConfigs_ =
        java.util.Collections.emptyList();
      private void ensureLoggerConfigsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          loggerConfigs_ = new java.util.ArrayList<io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig>(loggerConfigs_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.Builder, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfigOrBuilder> loggerConfigsBuilder_;

      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public java.util.List<io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig> getLoggerConfigsList() {
        if (loggerConfigsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(loggerConfigs_);
        } else {
          return loggerConfigsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public int getLoggerConfigsCount() {
        if (loggerConfigsBuilder_ == null) {
          return loggerConfigs_.size();
        } else {
          return loggerConfigsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig getLoggerConfigs(int index) {
        if (loggerConfigsBuilder_ == null) {
          return loggerConfigs_.get(index);
        } else {
          return loggerConfigsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public Builder setLoggerConfigs(
          int index, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig value) {
        if (loggerConfigsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLoggerConfigsIsMutable();
          loggerConfigs_.set(index, value);
          onChanged();
        } else {
          loggerConfigsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public Builder setLoggerConfigs(
          int index, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.Builder builderForValue) {
        if (loggerConfigsBuilder_ == null) {
          ensureLoggerConfigsIsMutable();
          loggerConfigs_.set(index, builderForValue.build());
          onChanged();
        } else {
          loggerConfigsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public Builder addLoggerConfigs(io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig value) {
        if (loggerConfigsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLoggerConfigsIsMutable();
          loggerConfigs_.add(value);
          onChanged();
        } else {
          loggerConfigsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public Builder addLoggerConfigs(
          int index, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig value) {
        if (loggerConfigsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLoggerConfigsIsMutable();
          loggerConfigs_.add(index, value);
          onChanged();
        } else {
          loggerConfigsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public Builder addLoggerConfigs(
          io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.Builder builderForValue) {
        if (loggerConfigsBuilder_ == null) {
          ensureLoggerConfigsIsMutable();
          loggerConfigs_.add(builderForValue.build());
          onChanged();
        } else {
          loggerConfigsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public Builder addLoggerConfigs(
          int index, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.Builder builderForValue) {
        if (loggerConfigsBuilder_ == null) {
          ensureLoggerConfigsIsMutable();
          loggerConfigs_.add(index, builderForValue.build());
          onChanged();
        } else {
          loggerConfigsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public Builder addAllLoggerConfigs(
          java.lang.Iterable<? extends io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig> values) {
        if (loggerConfigsBuilder_ == null) {
          ensureLoggerConfigsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, loggerConfigs_);
          onChanged();
        } else {
          loggerConfigsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public Builder clearLoggerConfigs() {
        if (loggerConfigsBuilder_ == null) {
          loggerConfigs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          loggerConfigsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public Builder removeLoggerConfigs(int index) {
        if (loggerConfigsBuilder_ == null) {
          ensureLoggerConfigsIsMutable();
          loggerConfigs_.remove(index);
          onChanged();
        } else {
          loggerConfigsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.Builder getLoggerConfigsBuilder(
          int index) {
        return getLoggerConfigsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfigOrBuilder getLoggerConfigsOrBuilder(
          int index) {
        if (loggerConfigsBuilder_ == null) {
          return loggerConfigs_.get(index);  } else {
          return loggerConfigsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public java.util.List<? extends io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfigOrBuilder> 
           getLoggerConfigsOrBuilderList() {
        if (loggerConfigsBuilder_ != null) {
          return loggerConfigsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(loggerConfigs_);
        }
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.Builder addLoggerConfigsBuilder() {
        return getLoggerConfigsFieldBuilder().addBuilder(
            io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.getDefaultInstance());
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.Builder addLoggerConfigsBuilder(
          int index) {
        return getLoggerConfigsFieldBuilder().addBuilder(
            index, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.getDefaultInstance());
      }
      /**
       * <pre>
       * Configurations for RBAC-based authorization audit loggers.
       *
       * [#not-implemented-hide:]
       * </pre>
       *
       * <code>repeated .envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig logger_configs = 2;</code>
       */
      public java.util.List<io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.Builder> 
           getLoggerConfigsBuilderList() {
        return getLoggerConfigsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.Builder, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfigOrBuilder> 
          getLoggerConfigsFieldBuilder() {
        if (loggerConfigsBuilder_ == null) {
          loggerConfigsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfig.Builder, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.AuditLoggerConfigOrBuilder>(
                  loggerConfigs_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          loggerConfigs_ = null;
        }
        return loggerConfigsBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:envoy.config.rbac.v3.RBAC.AuditLoggingOptions)
    }

    // @@protoc_insertion_point(class_scope:envoy.config.rbac.v3.RBAC.AuditLoggingOptions)
    private static final io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions();
    }

    public static io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AuditLoggingOptions>
        PARSER = new com.google.protobuf.AbstractParser<AuditLoggingOptions>() {
      @java.lang.Override
      public AuditLoggingOptions parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<AuditLoggingOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AuditLoggingOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private int bitField0_;
  public static final int ACTION_FIELD_NUMBER = 1;
  private int action_ = 0;
  /**
   * <pre>
   * The action to take if a policy matches. Every action either allows or denies a request,
   * and can also carry out action-specific operations.
   *
   * Actions:
   *
   *  * ``ALLOW``: Allows the request if and only if there is a policy that matches
   *    the request.
   *  * ``DENY``: Allows the request if and only if there are no policies that
   *    match the request.
   *  * ``LOG``: Allows all requests. If at least one policy matches, the dynamic
   *    metadata key ``access_log_hint`` is set to the value ``true`` under the shared
   *    key namespace ``envoy.common``. If no policies match, it is set to ``false``.
   *    Other actions do not modify this key.
   * </pre>
   *
   * <code>.envoy.config.rbac.v3.RBAC.Action action = 1 [(.validate.rules) = { ... }</code>
   * @return The enum numeric value on the wire for action.
   */
  @java.lang.Override public int getActionValue() {
    return action_;
  }
  /**
   * <pre>
   * The action to take if a policy matches. Every action either allows or denies a request,
   * and can also carry out action-specific operations.
   *
   * Actions:
   *
   *  * ``ALLOW``: Allows the request if and only if there is a policy that matches
   *    the request.
   *  * ``DENY``: Allows the request if and only if there are no policies that
   *    match the request.
   *  * ``LOG``: Allows all requests. If at least one policy matches, the dynamic
   *    metadata key ``access_log_hint`` is set to the value ``true`` under the shared
   *    key namespace ``envoy.common``. If no policies match, it is set to ``false``.
   *    Other actions do not modify this key.
   * </pre>
   *
   * <code>.envoy.config.rbac.v3.RBAC.Action action = 1 [(.validate.rules) = { ... }</code>
   * @return The action.
   */
  @java.lang.Override public io.envoyproxy.envoy.config.rbac.v3.RBAC.Action getAction() {
    io.envoyproxy.envoy.config.rbac.v3.RBAC.Action result = io.envoyproxy.envoy.config.rbac.v3.RBAC.Action.forNumber(action_);
    return result == null ? io.envoyproxy.envoy.config.rbac.v3.RBAC.Action.UNRECOGNIZED : result;
  }

  public static final int POLICIES_FIELD_NUMBER = 2;
  private static final class PoliciesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy>newDefaultInstance(
                io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_PoliciesEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.envoyproxy.envoy.config.rbac.v3.Policy.getDefaultInstance());
  }
  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
      java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy> policies_;
  private com.google.protobuf.MapField<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy>
  internalGetPolicies() {
    if (policies_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          PoliciesDefaultEntryHolder.defaultEntry);
    }
    return policies_;
  }
  public int getPoliciesCount() {
    return internalGetPolicies().getMap().size();
  }
  /**
   * <pre>
   * Maps from policy name to policy. A match occurs when at least one policy matches the request.
   * The policies are evaluated in lexicographic order of the policy name.
   * </pre>
   *
   * <code>map&lt;string, .envoy.config.rbac.v3.Policy&gt; policies = 2;</code>
   */
  @java.lang.Override
  public boolean containsPolicies(
      java.lang.String key) {
    if (key == null) { throw new NullPointerException("map key"); }
    return internalGetPolicies().getMap().containsKey(key);
  }
  /**
   * Use {@link #getPoliciesMap()} instead.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy> getPolicies() {
    return getPoliciesMap();
  }
  /**
   * <pre>
   * Maps from policy name to policy. A match occurs when at least one policy matches the request.
   * The policies are evaluated in lexicographic order of the policy name.
   * </pre>
   *
   * <code>map&lt;string, .envoy.config.rbac.v3.Policy&gt; policies = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy> getPoliciesMap() {
    return internalGetPolicies().getMap();
  }
  /**
   * <pre>
   * Maps from policy name to policy. A match occurs when at least one policy matches the request.
   * The policies are evaluated in lexicographic order of the policy name.
   * </pre>
   *
   * <code>map&lt;string, .envoy.config.rbac.v3.Policy&gt; policies = 2;</code>
   */
  @java.lang.Override
  public /* nullable */
io.envoyproxy.envoy.config.rbac.v3.Policy getPoliciesOrDefault(
      java.lang.String key,
      /* nullable */
io.envoyproxy.envoy.config.rbac.v3.Policy defaultValue) {
    if (key == null) { throw new NullPointerException("map key"); }
    java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy> map =
        internalGetPolicies().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Maps from policy name to policy. A match occurs when at least one policy matches the request.
   * The policies are evaluated in lexicographic order of the policy name.
   * </pre>
   *
   * <code>map&lt;string, .envoy.config.rbac.v3.Policy&gt; policies = 2;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.rbac.v3.Policy getPoliciesOrThrow(
      java.lang.String key) {
    if (key == null) { throw new NullPointerException("map key"); }
    java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy> map =
        internalGetPolicies().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int AUDIT_LOGGING_OPTIONS_FIELD_NUMBER = 3;
  private io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions auditLoggingOptions_;
  /**
   * <pre>
   * Audit logging options that include the condition for audit logging to happen
   * and audit logger configurations.
   *
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions audit_logging_options = 3;</code>
   * @return Whether the auditLoggingOptions field is set.
   */
  @java.lang.Override
  public boolean hasAuditLoggingOptions() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Audit logging options that include the condition for audit logging to happen
   * and audit logger configurations.
   *
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions audit_logging_options = 3;</code>
   * @return The auditLoggingOptions.
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions getAuditLoggingOptions() {
    return auditLoggingOptions_ == null ? io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.getDefaultInstance() : auditLoggingOptions_;
  }
  /**
   * <pre>
   * Audit logging options that include the condition for audit logging to happen
   * and audit logger configurations.
   *
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions audit_logging_options = 3;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptionsOrBuilder getAuditLoggingOptionsOrBuilder() {
    return auditLoggingOptions_ == null ? io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.getDefaultInstance() : auditLoggingOptions_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (action_ != io.envoyproxy.envoy.config.rbac.v3.RBAC.Action.ALLOW.getNumber()) {
      output.writeEnum(1, action_);
    }
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetPolicies(),
        PoliciesDefaultEntryHolder.defaultEntry,
        2);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getAuditLoggingOptions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (action_ != io.envoyproxy.envoy.config.rbac.v3.RBAC.Action.ALLOW.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, action_);
    }
    for (java.util.Map.Entry<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy> entry
         : internalGetPolicies().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy>
      policies__ = PoliciesDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, policies__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getAuditLoggingOptions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.config.rbac.v3.RBAC)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.config.rbac.v3.RBAC other = (io.envoyproxy.envoy.config.rbac.v3.RBAC) obj;

    if (action_ != other.action_) return false;
    if (!internalGetPolicies().equals(
        other.internalGetPolicies())) return false;
    if (hasAuditLoggingOptions() != other.hasAuditLoggingOptions()) return false;
    if (hasAuditLoggingOptions()) {
      if (!getAuditLoggingOptions()
          .equals(other.getAuditLoggingOptions())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ACTION_FIELD_NUMBER;
    hash = (53 * hash) + action_;
    if (!internalGetPolicies().getMap().isEmpty()) {
      hash = (37 * hash) + POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPolicies().hashCode();
    }
    if (hasAuditLoggingOptions()) {
      hash = (37 * hash) + AUDIT_LOGGING_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAuditLoggingOptions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.config.rbac.v3.RBAC parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.rbac.v3.RBAC parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.rbac.v3.RBAC parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.rbac.v3.RBAC parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.rbac.v3.RBAC parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.rbac.v3.RBAC parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.rbac.v3.RBAC parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.rbac.v3.RBAC parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static io.envoyproxy.envoy.config.rbac.v3.RBAC parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static io.envoyproxy.envoy.config.rbac.v3.RBAC parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.rbac.v3.RBAC parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.rbac.v3.RBAC parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.config.rbac.v3.RBAC prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Role Based Access Control (RBAC) provides service-level and method-level access control for a
   * service. Requests are allowed or denied based on the ``action`` and whether a matching policy is
   * found. For instance, if the action is ALLOW and a matching policy is found the request should be
   * allowed.
   *
   * RBAC can also be used to make access logging decisions by communicating with access loggers
   * through dynamic metadata. When the action is LOG and at least one policy matches, the
   * ``access_log_hint`` value in the shared key namespace 'envoy.common' is set to ``true`` indicating
   * the request should be logged.
   *
   * Here is an example of RBAC configuration. It has two policies:
   *
   * * Service account ``cluster.local/ns/default/sa/admin`` has full access to the service, and so
   *   does "cluster.local/ns/default/sa/superuser".
   *
   * * Any user can read (``GET``) the service at paths with prefix ``/products``, so long as the
   *   destination port is either 80 or 443.
   *
   *  .. code-block:: yaml
   *
   *   action: ALLOW
   *   policies:
   *     "service-admin":
   *       permissions:
   *         - any: true
   *       principals:
   *         - authenticated:
   *             principal_name:
   *               exact: "cluster.local/ns/default/sa/admin"
   *         - authenticated:
   *             principal_name:
   *               exact: "cluster.local/ns/default/sa/superuser"
   *     "product-viewer":
   *       permissions:
   *           - and_rules:
   *               rules:
   *                 - header:
   *                     name: ":method"
   *                     string_match:
   *                       exact: "GET"
   *                 - url_path:
   *                     path: { prefix: "/products" }
   *                 - or_rules:
   *                     rules:
   *                       - destination_port: 80
   *                       - destination_port: 443
   *       principals:
   *         - any: true
   * </pre>
   *
   * Protobuf type {@code envoy.config.rbac.v3.RBAC}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.config.rbac.v3.RBAC)
      io.envoyproxy.envoy.config.rbac.v3.RBACOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetPolicies();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutablePolicies();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.config.rbac.v3.RBAC.class, io.envoyproxy.envoy.config.rbac.v3.RBAC.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.config.rbac.v3.RBAC.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getAuditLoggingOptionsFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      action_ = 0;
      internalGetMutablePolicies().clear();
      auditLoggingOptions_ = null;
      if (auditLoggingOptionsBuilder_ != null) {
        auditLoggingOptionsBuilder_.dispose();
        auditLoggingOptionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.config.rbac.v3.RbacProto.internal_static_envoy_config_rbac_v3_RBAC_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.rbac.v3.RBAC getDefaultInstanceForType() {
      return io.envoyproxy.envoy.config.rbac.v3.RBAC.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.rbac.v3.RBAC build() {
      io.envoyproxy.envoy.config.rbac.v3.RBAC result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.rbac.v3.RBAC buildPartial() {
      io.envoyproxy.envoy.config.rbac.v3.RBAC result = new io.envoyproxy.envoy.config.rbac.v3.RBAC(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(io.envoyproxy.envoy.config.rbac.v3.RBAC result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.action_ = action_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.policies_ = internalGetPolicies().build(PoliciesDefaultEntryHolder.defaultEntry);
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.auditLoggingOptions_ = auditLoggingOptionsBuilder_ == null
            ? auditLoggingOptions_
            : auditLoggingOptionsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.config.rbac.v3.RBAC) {
        return mergeFrom((io.envoyproxy.envoy.config.rbac.v3.RBAC)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.config.rbac.v3.RBAC other) {
      if (other == io.envoyproxy.envoy.config.rbac.v3.RBAC.getDefaultInstance()) return this;
      if (other.action_ != 0) {
        setActionValue(other.getActionValue());
      }
      internalGetMutablePolicies().mergeFrom(
          other.internalGetPolicies());
      bitField0_ |= 0x00000002;
      if (other.hasAuditLoggingOptions()) {
        mergeAuditLoggingOptions(other.getAuditLoggingOptions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              action_ = input.readEnum();
              bitField0_ |= 0x00000001;
              break;
            } // case 8
            case 18: {
              com.google.protobuf.MapEntry<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy>
              policies__ = input.readMessage(
                  PoliciesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              internalGetMutablePolicies().ensureBuilderMap().put(
                  policies__.getKey(), policies__.getValue());
              bitField0_ |= 0x00000002;
              break;
            } // case 18
            case 26: {
              input.readMessage(
                  getAuditLoggingOptionsFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000004;
              break;
            } // case 26
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private int action_ = 0;
    /**
     * <pre>
     * The action to take if a policy matches. Every action either allows or denies a request,
     * and can also carry out action-specific operations.
     *
     * Actions:
     *
     *  * ``ALLOW``: Allows the request if and only if there is a policy that matches
     *    the request.
     *  * ``DENY``: Allows the request if and only if there are no policies that
     *    match the request.
     *  * ``LOG``: Allows all requests. If at least one policy matches, the dynamic
     *    metadata key ``access_log_hint`` is set to the value ``true`` under the shared
     *    key namespace ``envoy.common``. If no policies match, it is set to ``false``.
     *    Other actions do not modify this key.
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.Action action = 1 [(.validate.rules) = { ... }</code>
     * @return The enum numeric value on the wire for action.
     */
    @java.lang.Override public int getActionValue() {
      return action_;
    }
    /**
     * <pre>
     * The action to take if a policy matches. Every action either allows or denies a request,
     * and can also carry out action-specific operations.
     *
     * Actions:
     *
     *  * ``ALLOW``: Allows the request if and only if there is a policy that matches
     *    the request.
     *  * ``DENY``: Allows the request if and only if there are no policies that
     *    match the request.
     *  * ``LOG``: Allows all requests. If at least one policy matches, the dynamic
     *    metadata key ``access_log_hint`` is set to the value ``true`` under the shared
     *    key namespace ``envoy.common``. If no policies match, it is set to ``false``.
     *    Other actions do not modify this key.
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.Action action = 1 [(.validate.rules) = { ... }</code>
     * @param value The enum numeric value on the wire for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionValue(int value) {
      action_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The action to take if a policy matches. Every action either allows or denies a request,
     * and can also carry out action-specific operations.
     *
     * Actions:
     *
     *  * ``ALLOW``: Allows the request if and only if there is a policy that matches
     *    the request.
     *  * ``DENY``: Allows the request if and only if there are no policies that
     *    match the request.
     *  * ``LOG``: Allows all requests. If at least one policy matches, the dynamic
     *    metadata key ``access_log_hint`` is set to the value ``true`` under the shared
     *    key namespace ``envoy.common``. If no policies match, it is set to ``false``.
     *    Other actions do not modify this key.
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.Action action = 1 [(.validate.rules) = { ... }</code>
     * @return The action.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.rbac.v3.RBAC.Action getAction() {
      io.envoyproxy.envoy.config.rbac.v3.RBAC.Action result = io.envoyproxy.envoy.config.rbac.v3.RBAC.Action.forNumber(action_);
      return result == null ? io.envoyproxy.envoy.config.rbac.v3.RBAC.Action.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The action to take if a policy matches. Every action either allows or denies a request,
     * and can also carry out action-specific operations.
     *
     * Actions:
     *
     *  * ``ALLOW``: Allows the request if and only if there is a policy that matches
     *    the request.
     *  * ``DENY``: Allows the request if and only if there are no policies that
     *    match the request.
     *  * ``LOG``: Allows all requests. If at least one policy matches, the dynamic
     *    metadata key ``access_log_hint`` is set to the value ``true`` under the shared
     *    key namespace ``envoy.common``. If no policies match, it is set to ``false``.
     *    Other actions do not modify this key.
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.Action action = 1 [(.validate.rules) = { ... }</code>
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(io.envoyproxy.envoy.config.rbac.v3.RBAC.Action value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      action_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The action to take if a policy matches. Every action either allows or denies a request,
     * and can also carry out action-specific operations.
     *
     * Actions:
     *
     *  * ``ALLOW``: Allows the request if and only if there is a policy that matches
     *    the request.
     *  * ``DENY``: Allows the request if and only if there are no policies that
     *    match the request.
     *  * ``LOG``: Allows all requests. If at least one policy matches, the dynamic
     *    metadata key ``access_log_hint`` is set to the value ``true`` under the shared
     *    key namespace ``envoy.common``. If no policies match, it is set to ``false``.
     *    Other actions do not modify this key.
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.Action action = 1 [(.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      bitField0_ = (bitField0_ & ~0x00000001);
      action_ = 0;
      onChanged();
      return this;
    }

    private static final class PoliciesConverter implements com.google.protobuf.MapFieldBuilder.Converter<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.PolicyOrBuilder, io.envoyproxy.envoy.config.rbac.v3.Policy> {
      @java.lang.Override
      public io.envoyproxy.envoy.config.rbac.v3.Policy build(io.envoyproxy.envoy.config.rbac.v3.PolicyOrBuilder val) {
        if (val instanceof io.envoyproxy.envoy.config.rbac.v3.Policy) { return (io.envoyproxy.envoy.config.rbac.v3.Policy) val; }
        return ((io.envoyproxy.envoy.config.rbac.v3.Policy.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy> defaultEntry() {
        return PoliciesDefaultEntryHolder.defaultEntry;
      }
    };
    private static final PoliciesConverter policiesConverter = new PoliciesConverter();

    private com.google.protobuf.MapFieldBuilder<
        java.lang.String, io.envoyproxy.envoy.config.rbac.v3.PolicyOrBuilder, io.envoyproxy.envoy.config.rbac.v3.Policy, io.envoyproxy.envoy.config.rbac.v3.Policy.Builder> policies_;
    private com.google.protobuf.MapFieldBuilder<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.PolicyOrBuilder, io.envoyproxy.envoy.config.rbac.v3.Policy, io.envoyproxy.envoy.config.rbac.v3.Policy.Builder>
        internalGetPolicies() {
      if (policies_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(policiesConverter);
      }
      return policies_;
    }
    private com.google.protobuf.MapFieldBuilder<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.PolicyOrBuilder, io.envoyproxy.envoy.config.rbac.v3.Policy, io.envoyproxy.envoy.config.rbac.v3.Policy.Builder>
        internalGetMutablePolicies() {
      if (policies_ == null) {
        policies_ = new com.google.protobuf.MapFieldBuilder<>(policiesConverter);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return policies_;
    }
    public int getPoliciesCount() {
      return internalGetPolicies().ensureBuilderMap().size();
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * The policies are evaluated in lexicographic order of the policy name.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v3.Policy&gt; policies = 2;</code>
     */
    @java.lang.Override
    public boolean containsPolicies(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      return internalGetPolicies().ensureBuilderMap().containsKey(key);
    }
    /**
     * Use {@link #getPoliciesMap()} instead.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy> getPolicies() {
      return getPoliciesMap();
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * The policies are evaluated in lexicographic order of the policy name.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v3.Policy&gt; policies = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy> getPoliciesMap() {
      return internalGetPolicies().getImmutableMap();
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * The policies are evaluated in lexicographic order of the policy name.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v3.Policy&gt; policies = 2;</code>
     */
    @java.lang.Override
    public /* nullable */
io.envoyproxy.envoy.config.rbac.v3.Policy getPoliciesOrDefault(
        java.lang.String key,
        /* nullable */
io.envoyproxy.envoy.config.rbac.v3.Policy defaultValue) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.PolicyOrBuilder> map = internalGetMutablePolicies().ensureBuilderMap();
      return map.containsKey(key) ? policiesConverter.build(map.get(key)) : defaultValue;
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * The policies are evaluated in lexicographic order of the policy name.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v3.Policy&gt; policies = 2;</code>
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.rbac.v3.Policy getPoliciesOrThrow(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.PolicyOrBuilder> map = internalGetMutablePolicies().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return policiesConverter.build(map.get(key));
    }
    public Builder clearPolicies() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutablePolicies().clear();
      return this;
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * The policies are evaluated in lexicographic order of the policy name.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v3.Policy&gt; policies = 2;</code>
     */
    public Builder removePolicies(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      internalGetMutablePolicies().ensureBuilderMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy>
        getMutablePolicies() {
      bitField0_ |= 0x00000002;
      return internalGetMutablePolicies().ensureMessageMap();
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * The policies are evaluated in lexicographic order of the policy name.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v3.Policy&gt; policies = 2;</code>
     */
    public Builder putPolicies(
        java.lang.String key,
        io.envoyproxy.envoy.config.rbac.v3.Policy value) {
      if (key == null) { throw new NullPointerException("map key"); }
      if (value == null) { throw new NullPointerException("map value"); }
      internalGetMutablePolicies().ensureBuilderMap()
          .put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * The policies are evaluated in lexicographic order of the policy name.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v3.Policy&gt; policies = 2;</code>
     */
    public Builder putAllPolicies(
        java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy> values) {
      for (java.util.Map.Entry<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.Policy> e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutablePolicies().ensureBuilderMap()
          .putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * The policies are evaluated in lexicographic order of the policy name.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v3.Policy&gt; policies = 2;</code>
     */
    public io.envoyproxy.envoy.config.rbac.v3.Policy.Builder putPoliciesBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v3.PolicyOrBuilder> builderMap = internalGetMutablePolicies().ensureBuilderMap();
      io.envoyproxy.envoy.config.rbac.v3.PolicyOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = io.envoyproxy.envoy.config.rbac.v3.Policy.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof io.envoyproxy.envoy.config.rbac.v3.Policy) {
        entry = ((io.envoyproxy.envoy.config.rbac.v3.Policy) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (io.envoyproxy.envoy.config.rbac.v3.Policy.Builder) entry;
    }

    private io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions auditLoggingOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.Builder, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptionsOrBuilder> auditLoggingOptionsBuilder_;
    /**
     * <pre>
     * Audit logging options that include the condition for audit logging to happen
     * and audit logger configurations.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions audit_logging_options = 3;</code>
     * @return Whether the auditLoggingOptions field is set.
     */
    public boolean hasAuditLoggingOptions() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Audit logging options that include the condition for audit logging to happen
     * and audit logger configurations.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions audit_logging_options = 3;</code>
     * @return The auditLoggingOptions.
     */
    public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions getAuditLoggingOptions() {
      if (auditLoggingOptionsBuilder_ == null) {
        return auditLoggingOptions_ == null ? io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.getDefaultInstance() : auditLoggingOptions_;
      } else {
        return auditLoggingOptionsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Audit logging options that include the condition for audit logging to happen
     * and audit logger configurations.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions audit_logging_options = 3;</code>
     */
    public Builder setAuditLoggingOptions(io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions value) {
      if (auditLoggingOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        auditLoggingOptions_ = value;
      } else {
        auditLoggingOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Audit logging options that include the condition for audit logging to happen
     * and audit logger configurations.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions audit_logging_options = 3;</code>
     */
    public Builder setAuditLoggingOptions(
        io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.Builder builderForValue) {
      if (auditLoggingOptionsBuilder_ == null) {
        auditLoggingOptions_ = builderForValue.build();
      } else {
        auditLoggingOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Audit logging options that include the condition for audit logging to happen
     * and audit logger configurations.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions audit_logging_options = 3;</code>
     */
    public Builder mergeAuditLoggingOptions(io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions value) {
      if (auditLoggingOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0) &&
          auditLoggingOptions_ != null &&
          auditLoggingOptions_ != io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.getDefaultInstance()) {
          getAuditLoggingOptionsBuilder().mergeFrom(value);
        } else {
          auditLoggingOptions_ = value;
        }
      } else {
        auditLoggingOptionsBuilder_.mergeFrom(value);
      }
      if (auditLoggingOptions_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Audit logging options that include the condition for audit logging to happen
     * and audit logger configurations.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions audit_logging_options = 3;</code>
     */
    public Builder clearAuditLoggingOptions() {
      bitField0_ = (bitField0_ & ~0x00000004);
      auditLoggingOptions_ = null;
      if (auditLoggingOptionsBuilder_ != null) {
        auditLoggingOptionsBuilder_.dispose();
        auditLoggingOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Audit logging options that include the condition for audit logging to happen
     * and audit logger configurations.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions audit_logging_options = 3;</code>
     */
    public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.Builder getAuditLoggingOptionsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAuditLoggingOptionsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Audit logging options that include the condition for audit logging to happen
     * and audit logger configurations.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions audit_logging_options = 3;</code>
     */
    public io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptionsOrBuilder getAuditLoggingOptionsOrBuilder() {
      if (auditLoggingOptionsBuilder_ != null) {
        return auditLoggingOptionsBuilder_.getMessageOrBuilder();
      } else {
        return auditLoggingOptions_ == null ?
            io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.getDefaultInstance() : auditLoggingOptions_;
      }
    }
    /**
     * <pre>
     * Audit logging options that include the condition for audit logging to happen
     * and audit logger configurations.
     *
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.envoy.config.rbac.v3.RBAC.AuditLoggingOptions audit_logging_options = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.Builder, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptionsOrBuilder> 
        getAuditLoggingOptionsFieldBuilder() {
      if (auditLoggingOptionsBuilder_ == null) {
        auditLoggingOptionsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptions.Builder, io.envoyproxy.envoy.config.rbac.v3.RBAC.AuditLoggingOptionsOrBuilder>(
                getAuditLoggingOptions(),
                getParentForChildren(),
                isClean());
        auditLoggingOptions_ = null;
      }
      return auditLoggingOptionsBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.config.rbac.v3.RBAC)
  }

  // @@protoc_insertion_point(class_scope:envoy.config.rbac.v3.RBAC)
  private static final io.envoyproxy.envoy.config.rbac.v3.RBAC DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.config.rbac.v3.RBAC();
  }

  public static io.envoyproxy.envoy.config.rbac.v3.RBAC getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RBAC>
      PARSER = new com.google.protobuf.AbstractParser<RBAC>() {
    @java.lang.Override
    public RBAC parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<RBAC> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RBAC> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.config.rbac.v3.RBAC getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

