/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.netcdf;

import io.github.msdk.MSDKException;
import io.github.msdk.MSDKMethod;
import io.github.msdk.datamodel.FileType;
import io.github.msdk.datamodel.MsScan;
import io.github.msdk.datamodel.RawDataFile;
import io.github.msdk.datamodel.SimpleRawDataFile;
import io.github.msdk.io.netcdf.NetCDFMsScan;
import io.github.msdk.io.netcdf.NetCDFRawDataFile;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NetCDFFileImportMethod
implements MSDKMethod<RawDataFile> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int parsedScans;
    private int totalScans = 0;
    private int[] scanStartPositions;
    private float[] scanRetentionTimes;
    @Nonnull
    private final File sourceFile;
    private NetcdfFile inputNetcdfFile;
    private SimpleRawDataFile newRawFile;
    private boolean canceled = false;
    private Variable massValueVariable;
    private Variable intensityValueVariable;
    private Predicate<MsScan> msScanPredicate;
    private double massValueScaleFactor = 1.0;
    private double intensityValueScaleFactor = 1.0;

    public NetCDFFileImportMethod(@Nonnull File sourceFile) {
        this(sourceFile, s -> true);
    }

    public NetCDFFileImportMethod(@Nonnull File sourceFile, Predicate<MsScan> msScanPredicate) {
        this.sourceFile = sourceFile;
        this.msScanPredicate = msScanPredicate;
    }

    public RawDataFile execute() throws MSDKException {
        this.logger.info("Started parsing file " + this.sourceFile);
        if (!this.sourceFile.canRead()) {
            throw new MSDKException("Cannot read file " + this.sourceFile);
        }
        try {
            this.inputNetcdfFile = NetcdfFile.open((String)this.sourceFile.getPath());
            String fileName = this.sourceFile.getName();
            this.newRawFile = new NetCDFRawDataFile(fileName, Optional.of(this.sourceFile), FileType.NETCDF, this.inputNetcdfFile);
            this.readVariables();
            for (int scanIndex = 0; scanIndex < this.totalScans; ++scanIndex) {
                if (this.canceled) {
                    return null;
                }
                NetCDFMsScan buildingScan = new NetCDFMsScan(scanIndex + 1, this.scanStartPositions, this.scanRetentionTimes, this.massValueVariable, this.intensityValueVariable, this.massValueScaleFactor, this.intensityValueScaleFactor);
                if (this.msScanPredicate.test((MsScan)buildingScan)) {
                    buildingScan.parseScan();
                }
                this.newRawFile.addScan((MsScan)buildingScan);
                ++this.parsedScans;
            }
        }
        catch (Exception e) {
            throw new MSDKException((Throwable)e);
        }
        this.logger.info("Finished parsing " + this.sourceFile + ", parsed " + this.parsedScans + " scans");
        return this.newRawFile;
    }

    private void readVariables() throws MSDKException, IOException {
        Variable scanIndexVariable;
        this.massValueVariable = this.inputNetcdfFile.findVariable("mass_values");
        if (this.massValueVariable == null) {
            this.logger.error("Could not find variable mass_values");
            throw new MSDKException("Could not find variable mass_values");
        }
        assert (this.massValueVariable.getRank() == 1);
        Attribute massScaleFacAttr = this.massValueVariable.findAttribute("scale_factor");
        if (massScaleFacAttr != null) {
            this.massValueScaleFactor = massScaleFacAttr.getNumericValue().doubleValue();
        }
        this.intensityValueVariable = this.inputNetcdfFile.findVariable("intensity_values");
        if (this.intensityValueVariable == null) {
            this.logger.error("Could not find variable intensity_values");
            throw new MSDKException("Could not find variable intensity_values");
        }
        assert (this.intensityValueVariable.getRank() == 1);
        Attribute intScaleFacAttr = this.intensityValueVariable.findAttribute("scale_factor");
        if (intScaleFacAttr != null) {
            this.intensityValueScaleFactor = intScaleFacAttr.getNumericValue().doubleValue();
        }
        if ((scanIndexVariable = this.inputNetcdfFile.findVariable("scan_index")) == null) {
            throw new MSDKException("Could not find variable scan_index");
        }
        this.totalScans = scanIndexVariable.getShape()[0];
        this.logger.debug("Found " + this.totalScans + " scans");
        this.scanStartPositions = new int[this.totalScans + 1];
        Array scanIndexArray = scanIndexVariable.read();
        IndexIterator scanIndexIterator = scanIndexArray.getIndexIterator();
        int ind = 0;
        while (scanIndexIterator.hasNext()) {
            this.scanStartPositions[ind] = (Integer)scanIndexIterator.next();
            ++ind;
        }
        this.scanStartPositions[this.totalScans] = (int)this.massValueVariable.getSize();
        this.scanRetentionTimes = new float[this.totalScans];
        Variable scanTimeVariable = this.inputNetcdfFile.findVariable("scan_acquisition_time");
        if (scanTimeVariable == null) {
            throw new IOException("Could not find variable scan_acquisition_time from file " + this.sourceFile);
        }
        Array scanTimeArray = null;
        scanTimeArray = scanTimeVariable.read();
        IndexIterator scanTimeIterator = scanTimeArray.getIndexIterator();
        ind = 0;
        while (scanTimeIterator.hasNext()) {
            if (scanTimeVariable.getDataType().getPrimitiveClassType() == Float.TYPE) {
                this.scanRetentionTimes[ind] = ((Float)scanTimeIterator.next()).floatValue();
            }
            if (scanTimeVariable.getDataType().getPrimitiveClassType() == Double.TYPE) {
                this.scanRetentionTimes[ind] = ((Double)scanTimeIterator.next()).floatValue();
            }
            ++ind;
        }
        int numberOfGoodScans = 0;
        for (int i = 0; i < this.totalScans; ++i) {
            if (this.scanStartPositions[i] < 0) continue;
            ++numberOfGoodScans;
        }
        if (numberOfGoodScans < this.totalScans) {
            int i;
            double sumDelta = 0.0;
            int n = 0;
            block3: for (int i2 = 0; i2 < this.totalScans; ++i2) {
                if (this.scanStartPositions[i2] < 0) continue;
                for (int j = i2 + 1; j < this.totalScans; ++j) {
                    if (this.scanStartPositions[j] < 0) continue;
                    sumDelta += (double)(this.scanRetentionTimes[j] - this.scanRetentionTimes[i2]) / (double)(j - i2);
                    ++n;
                    continue block3;
                }
            }
            double avgDelta = sumDelta / (double)n;
            for (i = 0; i < this.totalScans; ++i) {
                if (this.scanStartPositions[i] >= 0) continue;
                int nearestI = Integer.MAX_VALUE;
                int j = 1;
                while (true) {
                    if (i + j < this.totalScans && this.scanStartPositions[i + j] >= 0) {
                        nearestI = i + j;
                        break;
                    }
                    if (i - j >= 0 && this.scanStartPositions[i - j] >= 0) {
                        nearestI = i + j;
                        break;
                    }
                    if (i + j >= this.totalScans && i - j < 0) break;
                    ++j;
                }
                if (nearestI != Integer.MAX_VALUE) {
                    this.scanRetentionTimes[i] = (float)((double)this.scanRetentionTimes[nearestI] + (double)(i - nearestI) * avgDelta);
                    continue;
                }
                this.scanRetentionTimes[i] = i > 0 ? this.scanRetentionTimes[i - 1] : 0.0f;
                this.logger.error("ERROR: Could not fix incorrect QStar scan times.");
            }
            block7: for (i = 0; i < this.totalScans; ++i) {
                if (this.scanStartPositions[i] >= 0) continue;
                for (int j = i + 1; j < this.totalScans + 1; ++j) {
                    if (this.scanStartPositions[j] < 0) continue;
                    this.scanStartPositions[i] = this.scanStartPositions[j];
                    continue block7;
                }
            }
        }
    }

    @Nullable
    public RawDataFile getResult() {
        return this.newRawFile;
    }

    public Float getFinishedPercentage() {
        return this.totalScans == 0 ? null : Float.valueOf((float)this.parsedScans / (float)this.totalScans);
    }

    public void cancel() {
        this.canceled = true;
    }
}

