/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.datamodel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.github.msdk.datamodel.FeatureTable;
import io.github.msdk.datamodel.FeatureTableRow;
import io.github.msdk.datamodel.Sample;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class SimpleFeatureTable
implements FeatureTable {
    @Nonnull
    private final ArrayList<FeatureTableRow> featureTableRows = new ArrayList();
    @Nonnull
    private final ArrayList<Sample> featureTableSamples = new ArrayList();

    @Override
    @Nonnull
    public List<FeatureTableRow> getRows() {
        return ImmutableList.copyOf(this.featureTableRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(@Nonnull FeatureTableRow row) {
        Preconditions.checkNotNull((Object)row);
        ArrayList<FeatureTableRow> arrayList = this.featureTableRows;
        synchronized (arrayList) {
            this.featureTableRows.add(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRow(@Nonnull FeatureTableRow row) {
        Preconditions.checkNotNull((Object)row);
        ArrayList<FeatureTableRow> arrayList = this.featureTableRows;
        synchronized (arrayList) {
            this.featureTableRows.remove(row);
        }
    }

    @Override
    @Nonnull
    public List<Sample> getSamples() {
        return ImmutableList.copyOf(this.featureTableSamples);
    }

    @Nonnull
    public void setSamples(List<Sample> samples) {
        this.featureTableSamples.clear();
        this.featureTableSamples.addAll(samples);
    }

    @Override
    public void dispose() {
    }
}

