/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import io.github.jeremylong.openvulnerability.client.nvd.NvdApiException;
import io.github.jeremylong.openvulnerability.client.nvd.RateLimitedCall;
import io.github.jeremylong.openvulnerability.client.nvd.RateMeter;
import java.net.ProxySelector;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RateLimitedClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleFutureResponse.class);
    private final CloseableHttpAsyncClient client;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private long lastRequest = 0L;
    private long delay;
    private final RateMeter meter;

    RateLimitedClient() {
        this(0L, 0, 0L);
    }

    RateLimitedClient(long minimumDelay, int requestsCount, long requestWindowMilliseconds) {
        this(minimumDelay, requestsCount > 0 && requestWindowMilliseconds > 0L ? new RateMeter(requestsCount, requestWindowMilliseconds) : new RateMeter(100, 5L));
    }

    RateLimitedClient(long minimumDelay, RateMeter meter) {
        this.meter = meter;
        this.delay = minimumDelay;
        LOG.debug("rate limited call delay: {}", (Object)this.delay);
        SystemDefaultRoutePlanner planner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        this.client = HttpAsyncClients.custom().setRoutePlanner((HttpRoutePlanner)planner).build();
        this.client.start();
    }

    @Override
    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
    }

    public long getDelay() {
        return this.delay;
    }

    void setDelay(long milliseconds) {
        this.delay = milliseconds;
        LOG.debug("rate limited call delay: {}", (Object)this.delay);
    }

    Future<RateLimitedCall> execute(SimpleHttpRequest request, int clientIndex, int startIndex) {
        return this.executor.submit(() -> this.delayedExecute(request, clientIndex, startIndex));
    }

    private RateLimitedCall delayedExecute(SimpleHttpRequest request, int clientIndex, int startIndex) throws ExecutionException, InterruptedException {
        RateLimitedCall rateLimitedCall;
        block12: {
            long now;
            long wait;
            if (this.lastRequest > 0L && this.delay > 0L && (wait = this.delay - ((now = ZonedDateTime.now().toInstant().toEpochMilli()) - this.lastRequest)) > 0L) {
                LOG.debug("Rate Limited API call - waiting for {}ms", (Object)wait);
                Thread.sleep(wait);
            }
            RateMeter.Ticket t = this.meter.getTicket();
            try {
                if (LOG.isDebugEnabled()) {
                    LocalTime time = LocalTime.now();
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
                    LOG.debug("Requested At: {}; URI: {}", (Object)time.format(formatter), (Object)request.getRequestUri());
                }
                Future f = this.client.execute(request, (FutureCallback)new SimpleFutureResponse());
                this.lastRequest = ZonedDateTime.now().toInstant().toEpochMilli();
                rateLimitedCall = new RateLimitedCall((SimpleHttpResponse)f.get(), clientIndex, startIndex);
                if (t == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        throw (InterruptedException)e;
                    }
                    if (e instanceof ExecutionException) {
                        throw (ExecutionException)e;
                    }
                    throw new NvdApiException(e);
                }
            }
            t.close();
        }
        return rateLimitedCall;
    }

    static class SimpleFutureResponse
    implements FutureCallback<SimpleHttpResponse> {
        private final Logger log = LoggerFactory.getLogger(SimpleFutureResponse.class);

        SimpleFutureResponse() {
        }

        public void completed(SimpleHttpResponse result) {
        }

        public void failed(Exception ex) {
            this.log.debug("request failed", (Throwable)ex);
        }

        public void cancelled() {
        }
    }
}

